/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.core.diagnostics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.utils.DirectBufferHelper;
import com.ibm.ws.zos.core.utils.DoubleGutter;
import com.ibm.wsspi.logging.IntrospectableService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NativeIntrospection
implements IntrospectableService {
    protected NativeMethodManager nativeMethodManager = null;
    private DirectBufferHelper bufferHelper;
    private DoubleGutter doubleGutter;
    static final long serialVersionUID = 950179712764487170L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(Map<String, Object> properties) throws Exception {
        this.nativeMethodManager.registerNatives(NativeIntrospection.class);
    }

    protected void deactivate(int reason) {
    }

    protected void setNativeMethodManager(NativeMethodManager nativeMethodManager) {
        this.nativeMethodManager = nativeMethodManager;
    }

    protected void unsetNativeMethodManager(NativeMethodManager nativeMethodManager) {
        if (this.nativeMethodManager == nativeMethodManager) {
            this.nativeMethodManager = null;
        }
    }

    protected void setDoubleGutter(DoubleGutter doubleGutter) {
        this.doubleGutter = doubleGutter;
    }

    protected void unsetDoubleGutter(DoubleGutter doubleGutter) {
        if (this.doubleGutter == doubleGutter) {
            this.doubleGutter = null;
        }
    }

    protected void setBufferHelper(DirectBufferHelper bufferHelper) {
        this.bufferHelper = bufferHelper;
    }

    protected void unsetBufferHelper(DirectBufferHelper bufferHelper) {
        if (this.bufferHelper == bufferHelper) {
            this.bufferHelper = null;
        }
    }

    public String getDescription() {
        return "z/OS Native Constructs";
    }

    public String getName() {
        return "zosNativeIntrospection";
    }

    public void introspect(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out, true);
        writer.println("Native Process-level Information");
        writer.println("--------------------------------");
        writer.print("\n");
        this.formatPGOO(writer);
        writer.flush();
    }

    void formatPGOO(PrintWriter writer) {
        int PGOO_VERSION1_LENGTH = 512;
        long nativePGOO_Address = 0L;
        writer.println("server_process_data (PGOO)");
        writer.println("--------------------------");
        nativePGOO_Address = this.ntv_getPGOO();
        if (nativePGOO_Address != 0L) {
            byte[] rawData = new byte[512];
            this.bufferHelper.get(nativePGOO_Address, rawData);
            writer.println(this.doubleGutter.asDoubleGutter(nativePGOO_Address, rawData));
        } else {
            writer.println("*** Address returned from Native call was zero ***");
        }
    }

    protected native long ntv_getPGOO();

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(NativeIntrospection.class);
    }
}

