/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.core.WSX509KeyManager;
import com.ibm.ws.ssl.core.WSX509TrustManager;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractJSSEProvider
implements JSSEProvider {
    private static final TraceComponent tc = Tr.register(AbstractJSSEProvider.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static final WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private static final Map<SSLConfig, SSLContext> sslContextCacheJAVAX = new HashMap<SSLConfig, SSLContext>();
    private static final String PKGNAME_DELIMITER = "|";
    private static boolean handlersInitialized = false;
    private static Object _lockObj = new Object();
    private String keyManager = null;
    private String trustManager = null;
    private String contextProvider = null;
    private String keyStoreProvider = null;
    private String socketFactory = null;
    private final String protocolPackageHandler;
    private String defaultProtocol = null;
    private static final PrivilegedAction<ClassLoader> getCtxClassLoader = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public AbstractJSSEProvider() {
        this.protocolPackageHandler = null;
    }

    protected void initialize(String keyMgr, String trustMgr, String cxtProvider, String keyProvider, String factory, String packageHandler, String protocolType) {
        this.keyManager = keyMgr;
        this.trustManager = trustMgr;
        this.contextProvider = cxtProvider;
        this.keyStoreProvider = keyProvider;
        this.socketFactory = factory;
        this.defaultProtocol = protocolType;
        if (!handlersInitialized && System.getProperty("os.name").equalsIgnoreCase("z/OS")) {
            AbstractJSSEProvider.addHandlers();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handlers already initialized ", (Object[])new Object[0]);
        }
    }

    @Override
    public String getSSLProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    @Override
    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    @Override
    public String getKeyManager() {
        return this.keyManager;
    }

    @Override
    public String getTrustManager() {
        return this.trustManager;
    }

    @Override
    public String getContextProvider() {
        return this.contextProvider;
    }

    @Override
    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    @Override
    public String getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public String[] getCiphersForSecurityLevel(boolean isClient, String securityLevel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCiphersForSecurityLevel: ", (Object[])new Object[]{isClient, securityLevel});
        }
        String[] supportedCiphers = null;
        if (isClient) {
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            supportedCiphers = factory.getSupportedCipherSuites();
        } else {
            SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            supportedCiphers = factory.getSupportedCipherSuites();
        }
        return Constants.adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
    }

    @Override
    public SSLContext getSSLContext(Map<String, Object> connectionInfo, SSLConfig sslConfig) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContext", (Object[])new Object[]{connectionInfo});
        }
        SSLContext sslContext = sslContextCacheJAVAX.get(sslConfig);
        this.setOutboundConnectionInfoInternal(connectionInfo);
        if (sslContext != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSSLContext -> (from cache)");
            }
            return sslContext;
        }
        sslContext = this.getSSLContextInstance(sslConfig);
        ArrayList<KeyManager> keyMgrs = new ArrayList<KeyManager>();
        ArrayList<TrustManager> trustMgrs = new ArrayList<TrustManager>();
        this.getKeyTrustManagers(connectionInfo, sslConfig, keyMgrs, trustMgrs);
        if (!keyMgrs.isEmpty() && !trustMgrs.isEmpty()) {
            KeyManager[] keyManagers = keyMgrs.toArray(new KeyManager[keyMgrs.size()]);
            TrustManager[] trustManagers = trustMgrs.toArray(new TrustManager[trustMgrs.size()]);
            sslContext.init(keyManagers, trustManagers, null);
        } else if (keyMgrs.isEmpty() && !trustMgrs.isEmpty()) {
            TrustManager[] trustManagers = trustMgrs.toArray(new TrustManager[trustMgrs.size()]);
            sslContext.init(null, trustManagers, null);
        } else {
            throw new SSLException("Null trust and key managers.");
        }
        if (sslContextCacheJAVAX.size() > 100) {
            SSLConfig[] victims;
            Iterator<SSLConfig> keys = sslContextCacheJAVAX.keySet().iterator();
            for (SSLConfig victim : victims = new SSLConfig[]{keys.next(), keys.next(), keys.next(), keys.next(), keys.next()}) {
                sslContextCacheJAVAX.remove(victim);
            }
        }
        sslContextCacheJAVAX.put(sslConfig, sslContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SSLContext cache size: " + sslContextCacheJAVAX.size()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLContext -> (new)");
        }
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getKeyTrustManagers(Map<String, Object> connectionInfo, SSLConfig sslConfig, List<KeyManager> kmHolder, List<TrustManager> tmHolder) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyTrustManagers", (Object[])new Object[]{connectionInfo, sslConfig});
        }
        TrustManagerFactory trustManagerFactory = null;
        KeyManagerFactory keyManagerFactory = null;
        KeyStore keyStore = null;
        KeyStore trustStore = null;
        boolean createKeyMgr = true;
        String direction = "unknown";
        if (connectionInfo != null) {
            direction = (String)connectionInfo.get("com.ibm.ssl.direction");
        }
        try {
            char[] passPhrase;
            String tokenSlot;
            String serverAliasName;
            String clientAliasName;
            WSKeyStore wsts;
            String trustFileName;
            block51: {
                WSPKCSInKeyStore pKS;
                trustFileName = this.getSSLContextProperty("com.ibm.ssl.trustStoreName", sslConfig);
                wsts = null;
                if (trustFileName != null) {
                    wsts = KeyStoreManager.getInstance().getKeyStore(trustFileName);
                }
                if (wsts != null) {
                    trustStore = wsts.getKeyStore(false, false);
                }
                String keyFileName = this.getSSLContextProperty("com.ibm.ssl.keyStoreName", sslConfig);
                WSKeyStore wsks = null;
                if (keyFileName != null) {
                    wsks = KeyStoreManager.getInstance().getKeyStore(keyFileName);
                }
                if (wsks != null) {
                    keyStore = wsks.getKeyStore(false, false);
                }
                boolean usingHwCryptoTrustStore = false;
                boolean usingHwCryptoKeyStore = false;
                String ctxtProvider = this.getSSLContextProperty("com.ibm.ssl.contextProvider", sslConfig);
                String keyMgr = this.getSSLContextProperty("com.ibm.ssl.keyManager", sslConfig);
                String trustMgr = this.getSSLContextProperty("com.ibm.ssl.trustManager", sslConfig);
                String clientAuthentication = this.getSSLContextProperty("com.ibm.ssl.clientAuthentication", sslConfig);
                clientAliasName = this.getSSLContextProperty("com.ibm.ssl.keyStoreClientAlias", sslConfig);
                serverAliasName = this.getSSLContextProperty("com.ibm.ssl.keyStoreServerAlias", sslConfig);
                String tokenLibraryFile = this.getSSLContextProperty("com.ibm.ssl.tokenLibraryFile", sslConfig);
                String tokenPassword = this.getSSLContextProperty("com.ibm.ssl.tokenPassword", sslConfig);
                String tokenType = this.getSSLContextProperty("com.ibm.ssl.tokenType", sslConfig);
                tokenSlot = this.getSSLContextProperty("com.ibm.ssl.tokenSlot", sslConfig);
                passPhrase = null;
                if (trustStore != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using trust store: " + wsts.getLocation()), (Object[])new Object[0]);
                    }
                } else if (tokenLibraryFile != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No trust store specified, but found hardware crypto", (Object[])new Object[0]);
                    }
                    if ((pKS = pkcsStoreList.insert(tokenType, tokenLibraryFile, tokenPassword, false, ctxtProvider)) != null) {
                        trustStore = pKS.getTS();
                        trustManagerFactory = pKS.getTMF();
                        usingHwCryptoTrustStore = true;
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No trust store specified and no hardware crypto defined", (Object[])new Object[0]);
                    }
                    if (direction.equals("inbound") && clientAuthentication.equals("false")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"trust store permitted to be null since this is inbound and client auth is false", (Object[])new Object[0]);
                        }
                    } else {
                        throw new IllegalArgumentException("Invalid trust file name of null");
                    }
                }
                if (!usingHwCryptoTrustStore) {
                    int ldapCertstorePort;
                    trustManagerFactory = this.getTrustManagerFactoryInstance(trustMgr, ctxtProvider);
                    String ldapCertstoreHost = System.getProperty("com.ibm.security.ldap.certstore.host");
                    String ldapCertstorePortS = System.getProperty("com.ibm.security.ldap.certstore.port");
                    int n = ldapCertstorePort = ldapCertstorePortS == null ? 389 : Integer.parseInt(ldapCertstorePortS);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("certStoreHost: " + ldapCertstoreHost), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("certStorePort: " + ldapCertstorePort), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("trustManagerAlgorithm: " + trustManagerFactory.getAlgorithm()), (Object[])new Object[0]);
                    }
                    if (ldapCertstoreHost != null && trustManagerFactory != null && trustManagerFactory.getAlgorithm().equals("IbmPKIX")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding ldap cert store " + ldapCertstoreHost + ":" + ldapCertstorePort + " "), (Object[])new Object[0]);
                        }
                        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                        LDAPCertStoreParameters LDAPParms = new LDAPCertStoreParameters(ldapCertstoreHost, ldapCertstorePort);
                        pkixParams.addCertStore(CertStore.getInstance("LDAP", LDAPParms));
                        pkixParams.setRevocationEnabled(true);
                        CertPathTrustManagerParameters trustParams = new CertPathTrustManagerParameters(pkixParams);
                        trustManagerFactory.init(trustParams);
                    } else if (null != trustManagerFactory) {
                        trustManagerFactory.init(trustStore);
                    }
                }
                if (keyStore != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using software keystore: " + wsks.getLocation()), (Object[])new Object[0]);
                    }
                } else if (tokenLibraryFile != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No key store specified, but found hardware crypto", (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reusing key store from Trust Manager", (Object[])new Object[0]);
                    }
                    if ((pKS = pkcsStoreList.insert(tokenType, tokenLibraryFile, tokenPassword, true, ctxtProvider)) != null) {
                        keyStore = pKS.getKS();
                        keyManagerFactory = pKS.getKMF();
                        usingHwCryptoKeyStore = true;
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No key store specified and no hardware crypto defined", (Object[])new Object[0]);
                    }
                    throw new IllegalArgumentException("No key store specified and no hardware crypto defined");
                }
                if (!usingHwCryptoKeyStore) {
                    keyManagerFactory = this.getKeyManagerFactoryInstance(keyMgr, ctxtProvider);
                    String kspass = wsks.getPassword();
                    if (!kspass.isEmpty()) {
                        try {
                            SerializableProtectedString keypass = wsks.getKeyPassword();
                            String decodedPass = WSKeyStore.decodePassword(new String(keypass.getChars()));
                            Object object = _lockObj;
                            synchronized (object) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Entering synchronized block around key manager factory init.", (Object[])new Object[0]);
                                }
                                keyManagerFactory.init(keyStore, decodedPass.toCharArray());
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exiting synchronized block around key manager factory init.", (Object[])new Object[0]);
                                }
                                break block51;
                            }
                        }
                        catch (UnrecoverableKeyException exc) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Error initializing key manager, the password can not be used to recover all keys", (Object[])new Object[0]);
                            }
                            Tr.error((TraceComponent)tc, (String)"ssl.unrecoverablekey.error.CWPKI0813E", (Object[])new Object[]{wsks.getLocation(), exc.getMessage()});
                            throw new UnrecoverableKeyException(exc.getMessage() + ": invalid password for key in file '" + wsks.getLocation() + "'");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No password provide so do not create a keymanager", (Object[])new Object[0]);
                    }
                    createKeyMgr = false;
                }
            }
            if (createKeyMgr) {
                WSX509KeyManager wsKeyManager = new WSX509KeyManager(keyStore, passPhrase, keyManagerFactory, sslConfig, null);
                if (serverAliasName != null && serverAliasName.length() > 0) {
                    wsKeyManager.setServerAlias(serverAliasName);
                }
                if (clientAliasName != null && clientAliasName.length() > 0) {
                    wsKeyManager.setClientAlias(clientAliasName);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initializing WSX509KeyManager.", (Object[])new Object[]{serverAliasName, clientAliasName, tokenSlot});
                }
                kmHolder.add(wsKeyManager);
            }
            TrustManager[] defaultTMArray = trustManagerFactory.getTrustManagers();
            WSX509TrustManager wsTrustManager = new WSX509TrustManager(defaultTMArray, connectionInfo, sslConfig, trustFileName, wsts.getLocation());
            tmHolder.add(wsTrustManager);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught during init, " + e), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getKeyTrustManagers", (Object)this);
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKeyTrustManagers");
        }
    }

    private String getSSLContextProperty(String propertyName, Properties prop) {
        String value = null;
        if (prop != null) {
            value = prop.getProperty(propertyName);
        } else {
            value = System.getProperty(propertyName);
            if (value == null) {
                value = SSLConfigManager.getInstance().getGlobalProperty(propertyName);
            }
        }
        return value;
    }

    @Override
    public URLStreamHandler getURLStreamHandler(SSLConfig config) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getURLStreamHandler", (Object[])new Object[0]);
        }
        URLStreamHandler urlStreamHandler = null;
        Properties existingProps = null;
        try {
            existingProps = ThreadManager.getInstance().getPropertiesOnThread();
            ThreadManager.getInstance().setPropertiesOnThread(config);
            urlStreamHandler = this.getHandler();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getURLStreamHandler");
            }
            URLStreamHandler uRLStreamHandler = urlStreamHandler;
            return uRLStreamHandler;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getURLStreamHandler", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getURLStreamHandler().", (Object)new Object[]{e});
            }
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        finally {
            ThreadManager.getInstance().setPropertiesOnThread(existingProps);
        }
    }

    @Override
    public SSLServerSocketFactory getSSLServerSocketFactory(SSLConfig config) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLServerSocketFactory", (Object[])new Object[0]);
        }
        try {
            SSLContext context = this.getSSLContext(null, config);
            if (context != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSSLServerSocketFactory");
                }
                return context.getServerSocketFactory();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLServerSocketFactory", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getSSLServerSocketFactory().", (Object)new Object[]{e});
            }
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        throw new SSLException("SSLContext could not be created to return an SSLServerSocketFactory.");
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(Map<String, Object> connectionInfo, SSLConfig config) throws Exception {
        SSLContext context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLSocketFactory", (Object[])new Object[]{connectionInfo});
        }
        if ((context = this.getSSLContext(connectionInfo, config)) != null) {
            SSLSocketFactory factory = context.getSocketFactory();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getSSLSocketFactory -> " + factory.getClass().getName()));
            }
            return factory;
        }
        throw new SSLException("SSLContext could not be created to return an SSLSocketFactory.");
    }

    @Override
    public SSLContext getSSLContextInstance(SSLConfig config) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContextInstance", (Object[])new Object[0]);
        }
        final String ctxtProvider = config.getProperty("com.ibm.ssl.contextProvider");
        final String protocol = config.getProperty("com.ibm.ssl.protocol");
        String alias = config.getProperty("com.ibm.ssl.alias");
        String configURL = config.getProperty("com.ibm.ssl.configURLLoadedFrom");
        SSLContext sslContext = null;
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol is not specified.");
        }
        try {
            sslContext = AccessController.doPrivileged(new PrivilegedExceptionAction<SSLContext>(){

                @Override
                public SSLContext run() throws NoSuchAlgorithmException, NoSuchProviderException {
                    if (ctxtProvider != null) {
                        return SSLContext.getInstance(protocol, ctxtProvider);
                    }
                    return SSLContext.getInstance(protocol);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting SSL context.", (Object[])new Object[]{ex});
            }
            if (ex instanceof NoSuchAlgorithmException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.no.such.algorithm.CWPKI0028E", new Object[]{protocol, alias, configURL, ex.getMessage()}, "CWPKI0028E: SSL handshake protocol " + protocol + " is not valid.  This protocol is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error((TraceComponent)tc, (String)"ssl.no.such.algorithm.CWPKI0028E", (Object[])new Object[]{protocol, alias, configURL, ex.getMessage()});
                throw new SSLException(message, ex);
            }
            if (ex instanceof NoSuchProviderException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.invalid.context.provider.CWPKI0029E", new Object[]{"IBMJSSE2", alias, configURL, ex.getMessage()}, "CWPKI0029E: SSL context provider IBMJSSE2 is not valid.  This provider is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error((TraceComponent)tc, (String)"ssl.invalid.context.provider.CWPKI0029E", (Object[])new Object[]{"IBMJSSE2", alias, configURL, ex.getMessage()});
                throw new SSLException(message, ex);
            }
            throw new SSLException(ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLContextInstance");
        }
        return sslContext;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.getTrustManagerFactoryInstance(this.getTrustManager(), this.getContextProvider());
    }

    public TrustManagerFactory getTrustManagerFactoryInstance(String trustMgr, String ctxtProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] trustManagerArray;
        String mgr = trustMgr;
        String provider = ctxtProvider;
        if (mgr.indexOf(124) != -1 && (trustManagerArray = mgr.split("\\|")) != null && trustManagerArray.length == 2) {
            mgr = trustManagerArray[0];
            provider = trustManagerArray[1];
        }
        TrustManagerFactory rc = TrustManagerFactory.getInstance(mgr, provider);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTrustManagerFactory.getInstance(" + mgr + ", " + provider + ")" + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.getKeyManagerFactoryInstance(this.getKeyManager(), this.getContextProvider());
    }

    public KeyManagerFactory getKeyManagerFactoryInstance(String keyMgr, String ctxtProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] keyManagerArray;
        String mgr = keyMgr;
        String provider = ctxtProvider;
        if (mgr.indexOf(124) != -1 && (keyManagerArray = mgr.split("\\|")) != null && keyManagerArray.length == 2) {
            mgr = keyManagerArray[0];
            provider = keyManagerArray[1];
        }
        KeyManagerFactory rc = KeyManagerFactory.getInstance(mgr, provider);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getKeyManagerFactory.getInstance(" + mgr + ", " + provider + ") " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public KeyStore getKeyStoreInstance(String type, String ksProvider) throws KeyStoreException, NoSuchProviderException {
        String provider;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyStore.getInstance(" + type + ", " + ksProvider + ")"), (Object[])new Object[0]);
        }
        if (null == (provider = ksProvider)) {
            provider = this.getKeyStoreProvider();
        }
        if (null == provider) {
            return KeyStore.getInstance(type);
        }
        return KeyStore.getInstance(type, provider);
    }

    @Override
    public void setServerDefaultSSLContext(SSLConfig defaultSSLConfig) throws Exception {
        SSLContext context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServerDefaultSSLContext", (Object[])new Object[0]);
        }
        if ((context = this.getSSLContext(null, defaultSSLConfig)) != null) {
            SSLContext.setDefault(context);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServerDefaultSSLContext");
        }
    }

    public URLStreamHandler getHandler() throws Exception {
        String handlerString = this.getSSLProtocolPackageHandler() + ".https.Handler";
        URLStreamHandler streamHandler = null;
        try {
            ClassLoader cl = AccessController.doPrivileged(getCtxClassLoader);
            streamHandler = cl != null ? (URLStreamHandler)cl.loadClass(handlerString).newInstance() : (URLStreamHandler)Class.forName(handlerString).newInstance();
            return streamHandler;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getHandler", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception loading https stream handler.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"ssl.load.https.stream.handler.CWPKI0025E", (Object[])new Object[]{handlerString, e.getMessage()});
            throw e;
        }
    }

    protected static void addHandlers() {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"addHandlers", (Object[])new Object[0]);
            }
            if (!handlersInitialized) {
                AbstractJSSEProvider.setDefaultSocketFactories();
                try {
                    StreamHandlerUtils.create();
                    if (!AbstractJSSEProvider.queryProvider("safkeyring")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding handler:  com.ibm.crypto.provider.safkeyring.Handler", (Object[])new Object[0]);
                        }
                        AbstractJSSEProvider.addProvider("safkeyring", "com.ibm.crypto.provider.safkeyring.Handler");
                    }
                    if (!AbstractJSSEProvider.queryProvider("safkeyringhw")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding handler: com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler", (Object[])new Object[0]);
                        }
                        AbstractJSSEProvider.addProvider("safkeyringhw", "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
                    }
                    if (!AbstractJSSEProvider.queryProvider("safkeyringhybrid")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding handler: com.ibm.crypto.ibmjcehybrid.provider.safkeyring.Handler", (Object[])new Object[0]);
                        }
                        AbstractJSSEProvider.addProvider("safkeyringhybrid", "com.ibm.crypto.ibmjcehybrid.provider.safkeyring.Handler");
                    }
                    handlersInitialized = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)AbstractJSSEProvider.class.getName(), (String)"addHandlers");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)"Unable to set safkeyring stream handler", (Object[])new Object[]{t});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addHandlers");
        }
    }

    protected static void setDefaultSocketFactories() {
    }

    private X509KeyManager loadCustomKeyManager(String kmClass) throws Exception {
        X509KeyManager km = null;
        try {
            ClassLoader cl = AccessController.doPrivileged(getCtxClassLoader);
            if (cl != null) {
                try {
                    km = (X509KeyManager)cl.loadClass(kmClass).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (km == null) {
                km = (X509KeyManager)Class.forName(kmClass).newInstance();
            }
            return km;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"loadCustomKeyManager", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception loading custom KeyManager.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"ssl.load.keymanager.error.CWPKI0021E", (Object[])new Object[]{kmClass, e.getMessage()});
            throw e;
        }
    }

    private X509TrustManager loadCustomTrustManager(String tmClass) throws Exception {
        X509TrustManager tm = null;
        try {
            ClassLoader cl = AccessController.doPrivileged(getCtxClassLoader);
            if (cl != null) {
                try {
                    tm = (X509TrustManager)cl.loadClass(tmClass).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tm == null) {
                tm = (X509TrustManager)Class.forName(tmClass).newInstance();
            }
            return tm;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"loadCustomTrustManager", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception loading custom TrustManager.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"ssl.load.trustmanager.error.CWPKI0020E", (Object[])new Object[]{tmClass, e.getMessage()});
            throw e;
        }
    }

    private static boolean queryProvider(String provider) {
        return StreamHandlerUtils.queryProvider(provider);
    }

    private static void addProvider(String provider, String handler) {
        block2: {
            try {
                StreamHandlerUtils.addProvider(provider, handler);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)AbstractJSSEProvider.class.getName(), (String)"addProvider");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception: " + e), (Object[])new Object[0]);
            }
        }
    }

    public static void clearSSLContextCache() {
        if (sslContextCacheJAVAX != null && sslContextCacheJAVAX.size() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clearing standard javax.net.ssl.SSLContext cache.", (Object[])new Object[0]);
            }
            sslContextCacheJAVAX.clear();
        }
    }

    private void setOutboundConnectionInfoInternal(Map<String, Object> connectionInfo) {
        String direction;
        Map<String, Object> outbound = null;
        if (connectionInfo != null && (direction = (String)connectionInfo.get("com.ibm.ssl.direction")) != null && direction.length() > 0 && direction.equalsIgnoreCase("outbound")) {
            outbound = connectionInfo;
        }
        ThreadManager.getInstance().setOutboundConnectionInfoInternal(outbound);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("outboundConnectionInfo: " + outbound), (Object[])new Object[0]);
        }
    }
}

