/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.ws.security.filemonitor.SecurityFileMonitor;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.internal.KeystoreConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ManagedServiceFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.ssl.keystore"})
public class KeystoreConfigurationFactory
implements ManagedServiceFactory,
FileBasedActionable {
    private static final TraceComponent tc = Tr.register(KeystoreConfigurationFactory.class);
    private final AtomicServiceReference<WsLocationAdmin> locSvc = new AtomicServiceReference("LocMgr");
    private final ConcurrentHashMap<String, KeystoreConfig> keyConfigs = new ConcurrentHashMap();
    private ServiceRegistration<FileMonitor> keyStoreFileMonitorRegistration;
    private SecurityFileMonitor keyStoreFileMonitor;
    private BundleContext bContext = null;
    private volatile ComponentContext cc = null;

    @FFDCIgnore(value={IllegalArgumentException.class})
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (FrameworkState.isStopping()) {
            return;
        }
        String id = (String)properties.get("id");
        if (id == null) {
            id = "defaultKeyStore";
            properties.put("id", "defaultKeyStore");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("updated " + pid), (Object[])new Object[]{properties});
        }
        KeystoreConfig svc = null;
        KeystoreConfig old = this.keyConfigs.get(pid);
        if (old == null) {
            svc = new KeystoreConfig(pid, id, this.locSvc);
            old = this.keyConfigs.putIfAbsent(pid, svc);
        }
        if (old != null) {
            svc = old;
        }
        try {
            if (svc.updateKeystoreConfig(properties)) {
                svc.updateRegistration(this.bContext);
                String trigger = svc.getKeyStore().getTrigger();
                Boolean fileBased = svc.getKeyStore().getFileBased();
                if (!trigger.equalsIgnoreCase("disabled") && fileBased.booleanValue()) {
                    this.createFileMonitor(svc.getKeyStore().getLocation(), trigger, svc.getKeyStore().getPollingRate());
                }
            } else {
                svc.unregister();
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    public void deleted(String pid) {
        KeystoreConfig old = this.keyConfigs.remove(pid);
        if (old != null) {
            old.unregister();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("deleted " + pid), (Object[])new Object[]{old == null ? "not found" : old.getId()});
        }
    }

    public String getName() {
        return "Keystore configuration";
    }

    protected void activate(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{ctx.getProperties()});
        }
        this.cc = ctx;
        this.locSvc.activate(ctx);
        this.bContext = ctx.getBundleContext();
    }

    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("deactivate, reason=" + reason), (Object[])new Object[0]);
        }
        this.locSvc.deactivate(ctx);
        this.unsetFileMonitorRegistration();
    }

    @Reference(service=WsLocationAdmin.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLocMgr(ServiceReference<WsLocationAdmin> locSvc) {
        this.locSvc.setReference(locSvc);
    }

    protected void unsetLocMgr(ServiceReference<WsLocationAdmin> ref) {
    }

    public void performFileBasedAction(Collection<File> modifiedFiles) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"performFileBasedAction", (Object[])new Object[]{modifiedFiles});
            }
            try {
                AbstractJSSEProvider.clearSSLContextCache();
                KeyStoreManager.getInstance().clearJavaKeyStoresFromKeyStoreMap();
                SSLConfigManager.getInstance().resetDefaultSSLContextIfNeeded(modifiedFiles);
                Tr.audit((TraceComponent)tc, (String)"ssl.keystore.modified.CWPKI0811I", (Object[])modifiedFiles.toArray());
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception while trying to reload keystore file, exception is: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performFileBasedAction");
        }
    }

    public BundleContext getBundleContext() {
        if (this.cc != null) {
            return this.cc.getBundleContext();
        }
        return null;
    }

    protected void unsetFileMonitorRegistration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"unsetFileMonitorRegistration", (Object[])new Object[0]);
        }
        if (this.keyStoreFileMonitorRegistration != null) {
            this.keyStoreFileMonitorRegistration.unregister();
            this.keyStoreFileMonitorRegistration = null;
        }
    }

    protected void setFileMonitorRegistration(ServiceRegistration<FileMonitor> keyStoreFileMonitorRegistration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"setFileMonitorRegistration", (Object[])new Object[0]);
        }
        this.keyStoreFileMonitorRegistration = keyStoreFileMonitorRegistration;
    }

    private void createFileMonitor(String keyStoreLocation, String trigger, long interval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFileMonitor", (Object[])new Object[]{keyStoreLocation, trigger, interval});
        }
        try {
            this.keyStoreFileMonitor = new SecurityFileMonitor((FileBasedActionable)this);
            this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.keyStoreFileMonitor.monitorFiles(Arrays.asList(keyStoreLocation), interval, trigger));
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating the keystore file monitor.", (Object[])new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createFileMonitor", (Object)this, (Object[])new Object[]{keyStoreLocation, interval});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFileMonitor");
        }
    }
}

