/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.db;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.store.common.LoggingUtil;
import com.ibm.ws.session.store.db.DatabaseHandler;
import com.ibm.ws.session.store.db.DatabaseHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class MySQLHandler
extends DatabaseHandler {
    private static final String methodClassName = "MySQLHandler";
    private static final String indexQuery = "select COLUMN_NAME from INFORMATION_SCHEMA.STATISTICS where INDEX_NAME = ? and TABLE_NAME = ?";

    @Override
    public int getSmallColumnSize() {
        return 65536;
    }

    @Override
    public int getMediumColumnSize() {
        return 0x1000000;
    }

    @Override
    public int getLargeColumnSize() {
        return 1;
    }

    @Override
    public void createTable(Statement s, String tableName) throws SQLException {
        s.executeUpdate("create table " + tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(255), small blob, medium mediumblob, large longblob)");
    }

    @Override
    public void createIndex(Connection con, Statement s, String tableName) throws SQLException {
        String methodName = "createIndex";
        if (this.doesIndexExists(con, "sess_index", tableName)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodName, "Skip index creation");
        } else {
            s.executeUpdate("create unique index sess_index on " + tableName + " (id, propid, appname)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesIndexExists(Connection con, String indexName, String tableName) {
        PreparedStatement ps;
        boolean indexExists;
        String methodName;
        block11: {
            methodName = "doesIndexExists";
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodName);
            }
            indexExists = false;
            ps = null;
            ResultSet rs = null;
            try {
                ps = con.prepareStatement(indexQuery);
                ps.setString(1, indexName);
                ps.setString(2, tableName);
                rs = ps.executeQuery();
                if (rs.next()) {
                    indexExists = true;
                }
                if (rs == null) break block11;
            }
            catch (Throwable th) {
                try {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodName, "CommonMessage.exception", th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        DatabaseHashMap.closeResultSet(rs);
                    }
                    if (ps != null) {
                        DatabaseHashMap.closeStatement(ps);
                    }
                }
            }
            DatabaseHashMap.closeResultSet(rs);
        }
        if (ps != null) {
            DatabaseHashMap.closeStatement(ps);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodName, indexExists);
        }
        return indexExists;
    }
}

