/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.db;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.store.common.BackedHashMap;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.ws.session.store.common.BackedStore;
import com.ibm.ws.session.store.common.LoggingUtil;
import com.ibm.ws.session.store.db.DatabaseHashMap;
import com.ibm.ws.session.store.db.DatabaseHashMapMR;
import com.ibm.ws.session.store.db.DatabaseSession;
import com.ibm.ws.session.store.db.DatabaseStoreService;
import com.ibm.wsspi.session.IStore;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletContext;

public class DatabaseStore
extends BackedStore {
    private static boolean _loggedVersion = false;
    private static final String methodClassName = "DatabaseStore";
    private static final int REMOTE_INVALIDATE = 0;
    private static final String[] methodNames = new String[]{"remoteInvalidate"};

    public DatabaseStore(SessionManagerConfig smc, String storeId, ServletContext sc, MemoryStoreHelper storeHelper, DatabaseStoreService databaseStoreService) {
        super(smc, storeId, sc, storeHelper);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "", "CMVC Version 1.5 3/12/08 09:22:18");
            _loggedVersion = true;
        }
        this._sessions = this._smc.isUsingMultirow() ? new DatabaseHashMapMR((IStore)this, smc, databaseStoreService) : new DatabaseHashMap((IStore)this, smc, databaseStoreService);
    }

    public DatabaseStore(SessionManagerConfig smc, String storeId, ServletContext sc, MemoryStoreHelper storeHelper, boolean isApplicationSessionStore, DatabaseStoreService databaseStoreService) {
        this(smc, storeId, sc, storeHelper, databaseStoreService);
        this._isApplicationSessionStore = isApplicationSessionStore;
        ((BackedHashMap)((Object)this._sessions)).setIsApplicationSessionHashMap(isApplicationSessionStore);
    }

    @Override
    public void remoteInvalidate(String sessionId, boolean backendUpdate) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[0], "for app " + this.getId() + " id " + sessionId + " backendUpdate " + backendUpdate);
        }
        this.remoteInvalReceived = true;
        if (backendUpdate) {
            ((DatabaseHashMap)((Object)this._sessions)).setMaxInactToZero(sessionId, this.getId());
        }
        Vector<String> v = new Vector<String>(1);
        v.add(sessionId);
        ((BackedHashMap)((Object)this._sessions)).handleDiscardedCacheItems(v.elements());
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[0], "for app " + this.getId() + " id " + sessionId);
        }
    }

    @Override
    public BackedSession createSessionObject(String sessionId) {
        return new DatabaseSession((DatabaseHashMap)((Object)this._sessions), sessionId, this._storeCallback);
    }
}

