/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.common;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.store.common.BackedHashMap;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.ws.session.store.common.LoggingUtil;
import com.ibm.ws.session.store.db.DatabaseStoreService;
import com.ibm.ws.session.store.memory.MemoryStore;
import com.ibm.wsspi.session.ILoader;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStoreCallback;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletContext;

public abstract class BackedStore
extends MemoryStore {
    private ILoader _loader;
    protected boolean remoteInvalReceived = false;
    private static final String methodClassName = "BackedStore";
    private static final int GET_SESSION = 0;
    private static final int STOP = 1;
    private static final int CREATE_SESSION = 2;
    private static final int REMOVE_FROM_MEMORY = 3;
    private static final String[] methodNames = new String[]{"getSession", "stop", "createSession", "removeFromMemory"};

    public BackedStore(SessionManagerConfig smc, String storeId, ServletContext sc, MemoryStoreHelper storeHelper) {
        super(smc, storeId, sc, storeHelper);
    }

    public ISession getSession(String id, int version, boolean isSessionAccess) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[0], "id = " + id);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[0], "Store = " + (Object)((Object)this));
        }
        if (this.inProcessOfStopping) {
            this.throwException("SessionContext.accessWhenStop");
        }
        BackedSession session = ((BackedHashMap)((Object)this._sessions)).getSession(id, version, isSessionAccess);
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[0], "session = " + (Object)((Object)session));
        }
        return session;
    }

    public boolean isPresentInExternalStore(String id) {
        if (this._sessions != null) {
            return ((BackedHashMap)((Object)this._sessions)).isPresent(id);
        }
        return false;
    }

    public void setLoader(ILoader loader) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            String s = loader + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setLoader", s);
        }
        this._loader = loader;
    }

    public ILoader getLoader() {
        return this._loader;
    }

    public void setStoreCallback(IStoreCallback callback) {
        super.setStoreCallback(callback);
        ((BackedHashMap)((Object)this._sessions)).setStoreCallback(callback);
    }

    public void removeSession(String id) {
        ((BackedHashMap)((Object)this._sessions)).removePersistedSession(id);
    }

    public void runTimeBasedWrites() {
        ((BackedHashMap)((Object)this._sessions)).doTimeBasedWrites(false);
    }

    public void runInvalidation() {
        ((BackedHashMap)((Object)this._sessions)).cleanUpCache(System.currentTimeMillis());
        ((BackedHashMap)((Object)this._sessions)).performInvalidation();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# BackedStore # \n { ").append("\n _storeId=").append(this._storeId);
        if (this._sessions != null) {
            sb.append("\n _sessions=").append(this._sessions.size());
        } else {
            sb.append("\n _sessions=null");
        }
        sb.append("\n } \n");
        return sb.toString();
    }

    public BackedHashMap getSessions() {
        return (BackedHashMap)((Object)this._sessions);
    }

    public Object getFromMemory(Object key) {
        return ((BackedHashMap)((Object)this._sessions)).superGet(key);
    }

    public synchronized void stop() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[1]);
        }
        this.inProcessOfStopping = true;
        DatabaseStoreService.setCompletedPassivation(false);
        if (this._smc.getEnableTimeBasedWrite()) {
            ((BackedHashMap)((Object)this._sessions)).doTimeBasedWrites(true);
        }
        Enumeration vEnum = this.tableKeys();
        while (vEnum.hasMoreElements()) {
            String id = (String)vEnum.nextElement();
            BackedSession s = (BackedSession)((Object)((BackedHashMap)((Object)this._sessions)).superGet(id));
            this._storeCallback.sessionWillPassivate((ISession)s);
            if (!this._smc.getPersistSessionAfterPassivation()) continue;
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "Persisting the session after it was passivated. " + s.getAppNameAndID());
            }
            s.removingSessionFromCache = true;
            s.sync();
            s.removingSessionFromCache = false;
        }
        DatabaseStoreService.setCompletedPassivation(true);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1]);
        }
    }

    public ISession createSession(String sessionId, boolean newId) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("id = ").append(sessionId).append(this.appNameForLogging);
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[2], sb.toString());
        }
        if (this.inProcessOfStopping) {
            this.throwException("SessionContext.createWhenStop");
        }
        BackedSession session = null;
        session = this.createSessionObject(sessionId);
        session.updateLastAccessTime(session.getCreationTime());
        session.setInsert();
        session.setMaxInactiveInterval((int)this._smc.getSessionInvalidationTime());
        session.setUserName("anonymous");
        this._sessions.put(sessionId, session);
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[2], "session = " + (Object)((Object)session));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMemory(String id) {
        BackedSession sess;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[3], id);
        }
        if ((sess = (BackedSession)((Object)((BackedHashMap)((Object)this._sessions)).superGet(id))) != null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "removing from memory");
            }
            BackedSession backedSession = sess;
            synchronized (backedSession) {
                Object removedEntry;
                BackedSession sess1 = (BackedSession)((Object)((BackedHashMap)((Object)this._sessions)).accessObject(id));
                if (sess == sess1 && (removedEntry = ((BackedHashMap)((Object)this._sessions)).superRemove(id)) != null && TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "successfully removed from memory");
                }
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[3]);
        }
    }

    public abstract void remoteInvalidate(String var1, boolean var2);

    public abstract BackedSession createSessionObject(String var1);
}

