/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.common;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.store.common.BackedHashMap;
import com.ibm.ws.session.store.common.BackedStore;
import com.ibm.ws.session.store.common.J2EEObjectWrapper;
import com.ibm.ws.session.store.common.LoggingUtil;
import com.ibm.ws.session.store.memory.MemorySession;
import com.ibm.ws.session.store.memory.MemoryStore;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.IStoreCallback;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.transaction.UserTransaction;

public abstract class BackedSession
extends MemorySession {
    protected static final int initialCacheId = 1;
    protected Hashtable mSwappableData = null;
    protected Hashtable mNonswappableData = null;
    private static final String methodClassName = "BackedSession";
    private static boolean _loggedVersion = false;
    protected BackedHashMap _sessions;
    public boolean needToInsert = false;
    public boolean listenCntHit;
    public boolean userWriteHit;
    public boolean maxInactWriteHit;
    public Hashtable appDataChanges;
    public Hashtable appDataRemovals;
    public StringBuffer update;
    public short listenerFlag;
    public boolean cacheLastAccessedTime;
    public boolean nukedByInvalidator;
    private long mLastWriteTime;
    int deferWriteUntilNextTick;
    boolean removingSessionFromCache;
    private long lastWriteLastaccessTime;
    public static final short HTTP_SESSION_NO_LISTENER = 0;
    public static final short HTTP_SESSION_BINDING_LISTENER = 1;
    public static final short HTTP_SESSION_ACTIVATION_LISTENER = 2;
    public static final short HTTP_SESSION_BINDING_AND_ACTIVATION_LISTENER = 3;
    private static final String USER_TRANSACTION_J2EE = "COM_IBM_WS_J2EE_USER_TRANSACTION";
    protected boolean appDataTablesPerThread;
    protected boolean sessionAttributeListener = false;
    static final short EJB_LOCAL_OBJECT = 1;
    static final short EJB_LOCAL_HOME = 2;
    private static final long serialVersionUID = -6456396236183348328L;
    private static final int FLUSH = 0;
    private static final int SET_MAX_INACTIVE_INTERVAL = 1;
    private static final int SET_CREATION_TIME = 2;
    private static final int GET_ATTRIBUTE = 3;
    private static final int SET_ATTRIBUTE = 4;
    private static final int REMOVE_ATTRIBUTE = 5;
    private static final int GET_LAST_WRITE_TIME = 6;
    private static final int SET_LAST_WRITE_TIME = 7;
    private static final int REFILL_ATTR_NAMES = 8;
    private static final int CONVERT_OBJECT = 9;
    private static final int PUT_VALUE_GUTS = 10;
    private static final int GET_VALUE_GUTS = 11;
    private static final int REMOVE_VALUE_GUTS = 12;
    private static final int GET_LISTENER_FLAG = 13;
    private static final int SYNC = 14;
    private static final int INVALIDATE = 15;
    private static final String[] methodNames = new String[]{"flush", "setMaxInactiveInterval", "setCreationTime", "getAttribute", "setAttribute", "removeAttribute", "getLastWriteTime", "setLastWriteTime", "refillAttrNames", "convertObject", "putValueGuts", "getValueGuts", "removeValueGuts", "getListenerFlag", "sync", "invalidate"};

    public BackedSession() {
        this.commonInit();
    }

    public BackedSession(BackedHashMap sessions, String id, IStoreCallback storeCallback) {
        super(sessions.getIStore(), id, storeCallback);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "", "CMVC Version 1.15 8/30/10 10:39:20");
            _loggedVersion = true;
        }
        this.commonInit();
        this._sessions = sessions;
        this.appDataTablesPerThread = this._sessions.getAppDataTablesPerThread();
    }

    private void commonInit() {
        this.listenerFlag = 0;
        this.nukedByInvalidator = false;
        this.deferWriteUntilNextTick = 0;
        this.mLastWriteTime = -1L;
        this.removingSessionFromCache = false;
        this._refCount = 0;
        this._version = 1;
    }

    public void initSession(IStore is) {
        this._store = is;
        this._storeCallback = is.getStoreCallback();
        this._sessions = ((BackedStore)is).getSessions();
        this._smc = ((MemoryStore)this._store).getSessionManagerConfig();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            this.appNameAndIdString = this.getAppNameAndID();
        }
        this._sessions.setStoreCallback(this._storeCallback);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public String getId() {
        return this._sessionId;
    }

    public void setId(String s) {
        this._sessionId = s;
    }

    public synchronized void flush() {
        this.flush(false);
    }

    public synchronized void flush(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[0], "(" + b + ") session = " + (Object)((Object)this));
        }
        this.cacheLastAccessedTime = b;
        this._sessions.put(this.getId(), (Object)this);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[0]);
        }
    }

    public synchronized void setUserName(String userName) {
        if (userName != null && !userName.equals(this._userName)) {
            this._userName = userName;
            this.userWriteHit = true;
        }
    }

    public void internalSetUser(String name) {
        this._userName = name;
    }

    public synchronized void setMaxInactiveInterval(int interval) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[1], "interval= " + interval);
        }
        if (this._maxInactiveInterval != interval) {
            this._maxInactiveInterval = interval;
            this.maxInactWriteHit = true;
        }
    }

    public void internalSetMaxInactive(int interval) {
        this._maxInactiveInterval = interval;
    }

    public void setCreationTime(long ct) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[2], "creationTime= " + ct);
        }
        this._creationTime = ct;
    }

    public Object getAttribute(Object name) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[3], "name= " + name);
        }
        Object value = this.getValueGuts(name.toString());
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            if (!SessionManagerConfig.isHideSessionValues()) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[3], "value= " + value);
            } else {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[3]);
            }
        }
        return value;
    }

    public Object setAttribute(Object name, Object value, Boolean newIsListener) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            if (!SessionManagerConfig.isHideSessionValues()) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[4], "name= " + name + " value=" + value);
            } else {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[4], "name= " + name);
            }
        }
        this._attributes.put(name, value);
        Object oldValue = this.getValueGuts((String)name);
        this.putValueGuts((String)name, value);
        Boolean oldIsListener = this._attributeNames.put(name, newIsListener);
        this._storeCallback.sessionAttributeSet((ISession)this, name, oldValue, oldIsListener, value, newIsListener);
        return oldValue;
    }

    public Object removeAttribute(Object name) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[5], "name= " + name);
        }
        this._attributes.remove(name);
        Object oldValue = this.removeValueGuts((String)name);
        Boolean oldIsBindingListener = (Boolean)this._attributeNames.get(name);
        this._attributeNames.remove(name);
        this._storeCallback.sessionAttributeRemoved((ISession)this, name, oldValue, oldIsBindingListener);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            if (!SessionManagerConfig.isHideSessionValues()) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[5], "oldAttributeValue =  " + oldValue);
            } else {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[5]);
            }
        }
        return oldValue;
    }

    public long getLastWriteLastaccessTime() {
        return this.lastWriteLastaccessTime;
    }

    public void setLastWriteLastAccessTime(long val) {
        this.lastWriteLastaccessTime = val;
    }

    public long getLastWriteTime() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[6], "");
        }
        return this.mLastWriteTime;
    }

    public void setLastWriteTime(long pLastWriteTime) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[7], "" + pLastWriteTime);
        }
        this.mLastWriteTime = pLastWriteTime;
    }

    protected void refillAttrNames(Hashtable swappable) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[8]);
        }
        if (swappable != null && swappable.size() > 0) {
            Hashtable tempAttributeNames = new Hashtable();
            for (Object key : swappable.keySet()) {
                Object val = swappable.get(key);
                if (val instanceof HttpSessionBindingListener) {
                    tempAttributeNames.put(key, Boolean.TRUE);
                } else {
                    tempAttributeNames.put(key, Boolean.FALSE);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) continue;
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[8], "added " + key + " with listener value " + tempAttributeNames.get(key));
            }
            this._attributeNames = tempAttributeNames;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[8]);
        }
    }

    public void setSwappableData(Hashtable ht) {
        this.mSwappableData = ht;
    }

    protected abstract SerializationService getSerializationService();

    private Object replaceObjectForSerialization(Object object) {
        if (object instanceof UserTransaction) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, "replaceObjectForSerialization", "replacing UserTransaction");
            }
            return new J2EEObjectWrapper(USER_TRANSACTION_J2EE);
        }
        return this.getSerializationService().replaceObjectForSerialization(object);
    }

    protected abstract UserTransaction getUserTransaction();

    private Object resolveObject(Object object) {
        Object serObj;
        if (object instanceof J2EEObjectWrapper && USER_TRANSACTION_J2EE.equals(serObj = ((J2EEObjectWrapper)object).getSerializableObject())) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, "replaceObjectForSerialization", "converting UserTransaction");
            }
            return this.getUserTransaction();
        }
        return this.getSerializationService().resolveObject(object);
    }

    synchronized void putValueGuts(String pName, Object pValue) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[10], "pName = " + pName);
        }
        if (pName == null || pValue == null) {
            return;
        }
        boolean distributableWebApp = this.getIStore().isDistributable();
        boolean swappable = true;
        Object convObj = this.replaceObjectForSerialization(pValue);
        if (convObj == null) {
            swappable = false;
            convObj = pValue;
        }
        if (!swappable) {
            if (distributableWebApp) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "IllegalArgumentException");
                }
                throw new IllegalArgumentException("Attribute with name " + pName + " is not java.io.Serializable. All attributes stored in session must be Serializable when web module is marked as distributable");
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "Attribute with name " + pName + " is not Serializable. This may cause a problem on a failover.");
            }
        }
        if (this.appDataChanges == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "init appDataChanges");
            }
            this.appDataChanges = new Hashtable();
        }
        if (swappable) {
            if (this.appDataTablesPerThread) {
                Thread t = Thread.currentThread();
                Hashtable<String, Object> sht = (Hashtable<String, Object>)this.appDataChanges.get(t);
                if (sht == null) {
                    sht = new Hashtable<String, Object>();
                    this.appDataChanges.put(t, sht);
                }
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    if (!SessionManagerConfig.isHideSessionValues()) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "storing for " + this.getId() + " prop " + pName + " with value " + pValue + " via thread " + t);
                    } else {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "storing for " + this.getId() + " prop " + pName + " via thread " + t);
                    }
                }
                sht.put(pName, convObj);
            } else {
                this.appDataChanges.put(pName, convObj);
            }
            boolean listenerFlagSetInMethod = false;
            if (pValue instanceof HttpSessionBindingListener) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "Property is a binding listener: " + pName);
                }
                if (!this.isNew()) {
                    this.listenerFlag = this.getListenerFlag();
                    listenerFlagSetInMethod = true;
                }
                switch (this.listenerFlag) {
                    case 0: {
                        this.listenerFlag = 1;
                        this.listenCntHit = true;
                        break;
                    }
                    case 2: {
                        this.listenerFlag = (short)3;
                        this.listenCntHit = true;
                        break;
                    }
                }
            }
            if (pValue instanceof HttpSessionActivationListener) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "Property is an Activation listener: " + pName);
                }
                if (!this.isNew() && !listenerFlagSetInMethod) {
                    this.listenerFlag = this.getListenerFlag();
                }
                switch (this.listenerFlag) {
                    case 0: {
                        this.listenerFlag = (short)2;
                        this.listenCntHit = true;
                        break;
                    }
                    case 1: {
                        this.listenerFlag = (short)3;
                        this.listenCntHit = true;
                        break;
                    }
                }
            }
            if (this.appDataRemovals != null) {
                if (this.appDataTablesPerThread) {
                    Thread t = Thread.currentThread();
                    Hashtable sht2 = (Hashtable)this.appDataRemovals.get(t);
                    if (sht2 != null) {
                        sht2.remove(pName);
                        if (sht2.isEmpty()) {
                            this.appDataRemovals.remove(t);
                        }
                    }
                } else {
                    this.appDataRemovals.remove(pName);
                }
            }
        }
        if (swappable) {
            if (this.mNonswappableData != null) {
                this.getNonswappableData().remove(pName);
            }
            this.getSwappableData().put(pName, convObj);
        } else {
            this.getSwappableData().remove(pName);
            this.getNonswappableData().put(pName, convObj);
        }
    }

    synchronized Object getValueGuts(String id) {
        Object returnValue;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[11]);
        }
        Object object = returnValue = this.mNonswappableData == null ? null : (Object)this.getNonswappableData().get(id);
        if (returnValue == null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[11], "Value from non-swappable is null for id " + id);
            }
            returnValue = this.getSwappableData().get(id);
        }
        if (returnValue != null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[11], "Retrieved cached object for " + id);
            }
            returnValue = this.resolveObject(returnValue);
        } else {
            if (!this.isNew()) {
                Thread t = Thread.currentThread();
                if (this.appDataRemovals != null) {
                    if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[11], "appDataRemovals is not null");
                    }
                    if (this.appDataTablesPerThread ? this.appDataRemovals.get(t) != null && ((Hashtable)this.appDataRemovals.get(t)).get(id) != null : this.appDataRemovals.get(id) != null) {
                        return returnValue;
                    }
                }
                if (this._sessions != null) {
                    returnValue = this._sessions.loadOneValue(id, this);
                }
                if (returnValue != null) {
                    if ((returnValue = this.resolveObject(returnValue)) instanceof HttpSessionBindingListener) {
                        this._attributeNames.put(id, Boolean.TRUE);
                    } else {
                        this._attributeNames.put(id, Boolean.FALSE);
                    }
                    this.getSwappableData().put(id, returnValue);
                }
            }
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                String s = returnValue == null ? "null" : "not null";
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[11], "Value from db is " + s + " for id " + id);
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[11]);
        }
        return returnValue;
    }

    synchronized Object removeValueGuts(String pName) {
        Object ret;
        Object tmp;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[12], "session " + this.getId() + " prop id " + pName);
        }
        if ((tmp = this.getValueGuts(pName)) == null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[12], "prop id " + pName + " not in " + this.getId());
            }
            return null;
        }
        if (this.appDataRemovals == null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "init appDataRemovals " + this.getId());
            }
            this.appDataRemovals = new Hashtable();
        }
        if (this.appDataTablesPerThread) {
            Thread t;
            Hashtable<String, String> sht;
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "appDataTablesPerThread");
            }
            if ((sht = (Hashtable<String, String>)this.appDataRemovals.get(t = Thread.currentThread())) == null) {
                sht = new Hashtable<String, String>();
                this.appDataRemovals.put(t, sht);
            }
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "remove value for " + this.getId() + " and prop " + pName + " via thread " + t);
            }
            sht.put(pName, pName);
        } else {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "appDataTablesPerSession");
            }
            this.appDataRemovals.put(pName, pName);
        }
        Object v0 = ret = this.mNonswappableData == null ? null : this.mNonswappableData.remove(pName);
        if (ret == null) {
            ret = this.getSwappableData().remove(pName);
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[12]);
        }
        return ret;
    }

    Hashtable getNonswappableData() {
        if (this.mNonswappableData == null) {
            this.mNonswappableData = new Hashtable(5);
        }
        return this.mNonswappableData;
    }

    public void setOverflow() {
    }

    public boolean isOverflow() {
        return false;
    }

    public synchronized short getListenerFlag() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[13], "" + this.listenerFlag);
        }
        return this.listenerFlag;
    }

    public void setListenerFlag(short flag) {
        this.listenerFlag = flag;
    }

    public void setInsert() {
        this.needToInsert = true;
    }

    public BackedHashMap getSessions() {
        return this._sessions;
    }

    public void setSessions(BackedHashMap _sessions) {
        this._sessions = _sessions;
    }

    public synchronized void sync() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[14]);
        }
        this.flush();
    }

    public synchronized String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n").append("app data changes : ");
        if (!SessionManagerConfig.isHideSessionValues()) {
            strbuf.append(this.appDataChanges != null ? this.appDataChanges.toString() : null).append("\n").append("app data removals : ").append(this.appDataRemovals != null ? this.appDataRemovals.toString() : null).append("\n");
        } else {
            strbuf.append(this.appDataChanges != null ? this.appDataChanges.keySet().toString() : null).append("\n").append("app data removals : ").append(this.appDataRemovals != null ? this.appDataRemovals.keySet().toString() : null).append("\n");
        }
        strbuf.append("user write hit : ").append(this.userWriteHit).append("\n").append("max inact write hit : ").append(this.maxInactWriteHit).append("\n").append("listener count hit : ").append(this.listenCntHit).append("\n").append("update : ").append(this.update != null ? this.update.toString() : null).append("\n").append("listener flag : ").append(this.listenerFlag).append("\n").append("version : ").append(this._version).append("\n").append("\n");
        return strbuf.toString();
    }

    public synchronized void invalidate(boolean appInvoked) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[15], appInvoked);
        }
        this.getSwappableListeners((short)1);
        if (appInvoked && !this.invalInProgress && this.isValid()) {
            this._storeCallback.sessionCacheDiscard((Object)this);
        }
        super.invalidate();
        if (this.appDataChanges != null) {
            this.appDataChanges.clear();
        }
        if (this.appDataRemovals != null) {
            this.appDataRemovals.clear();
        }
        this.update = null;
        this.userWriteHit = false;
        this.maxInactWriteHit = false;
        this.listenCntHit = false;
        this.mSwappableData = null;
        this.mNonswappableData = null;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[15]);
        }
    }

    protected void callInvalidateFromInternalInvalidate() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "callInvalidateFromInternalInvalidate", "calling this.invalidate( false )");
        }
        this.invalidate(false);
    }

    public abstract Hashtable getSwappableData();

    public abstract boolean getSwappableListeners(short var1);
}

