/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.common;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.ws.session.store.common.BackedStore;
import com.ibm.ws.session.store.common.LoggingUtil;
import com.ibm.ws.session.utils.LRUHashMap;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStore;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public abstract class BackedHashMap
extends LRUHashMap {
    protected IStore _iStore;
    public Hashtable cachedLastAccessedTimes = null;
    protected SessionManagerConfig _smc = null;
    protected boolean appDataTablesPerThread = false;
    private static final long serialVersionUID = -4653089886686024589L;
    private static final String methodClassName = "BackedHashMap";
    Map recentInvalidIds = null;
    protected boolean _isApplicationSessionHashMap = false;
    private static final int GET_SESSION = 0;
    private static final int RETRIEVE_SESSION = 1;
    private static final int GET = 2;
    private static final int UPDATE_SESSION = 3;
    private static final int UPDATE_CACHE_ID = 4;
    private static final int PUT = 5;
    private static final int PUT_NO_REPLACE = 6;
    private static final int SUPER_REMOVE = 7;
    private static final int SUPER_GET = 8;
    private static final int SUPER_PUT = 9;
    private static final int PASSIVATE_SESSION = 10;
    private static final int DO_SCHEDULED_INVALIDATION = 11;
    private static final int HANDLE_DISCARDED_CACHE_ITEMS = 12;
    private static final int CLEAN_UP_CACHE = 13;
    private static final int DO_TIME_BASED_WRITES = 14;
    private static final String[] methodNames = new String[]{"getSession", "retrieveSession", "get", "updateSession", "updateCacheId", "put", "putNoReplace", "superRemove", "superGet", "superPut", "passivateSession", "doScheduledInvalidation", "handleDiscardedCacheItems", "cleanUpCache", "doTimeBasedWrites"};

    public BackedHashMap(IStore store, SessionManagerConfig smc) {
        super(smc.getInMemorySize());
        this._smc = smc;
        this._iStore = store;
        this.setStoreCallback(this._iStore.getStoreCallback());
        if (!this._smc.getEnableEOSWrite()) {
            this.cachedLastAccessedTimes = new Hashtable(smc.getInMemorySize());
        }
        if (this._smc.getCheckRecentlyInvalidList()) {
            this.setRecentInvalTable();
        }
    }

    public BackedSession getSessionRetrievalTrue(String id, int versionId, boolean isSessionAccess) {
        return this.getSession(id, versionId, isSessionAccess, true);
    }

    BackedSession getSession(String id, int versionId, boolean isSessionAccess) {
        return this.getSession(id, versionId, isSessionAccess, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackedSession getSession(String id, int versionId, boolean isSessionAccess, boolean retrieval) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("{").append(id).append(",").append(versionId).append("}");
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[0], sb.toString());
        }
        BackedSession sess = null;
        if (!this._smc.useSSLId() && id.length() != SessionManagerConfig.getSessionIDLength()) {
            return null;
        }
        sess = (BackedSession)((Object)this.accessObject(id));
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            if (sess == null) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[0], "session not found in cache " + id);
            } else {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[0], "requested version: " + versionId + "; object's version: " + sess.getVersion());
            }
        }
        long lastAccessTimeOnLocalCopy = 0L;
        if (sess != null) {
            long nowTime = System.currentTimeMillis();
            boolean isValid = this.isValidCopy(sess, nowTime, versionId);
            if (isValid) {
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[0], "valid cache copy " + id);
                }
                if (isSessionAccess) {
                    if (this._smc.getEnableEOSWrite() && !this._smc.getScheduledInvalidation()) {
                        int rowsRet = this.overQualLastAccessTimeUpdate(sess, nowTime);
                        if (rowsRet == 0 && !sess.needToInsert) {
                            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[0], "session may be invalid in cache " + id);
                            }
                            BackedSession backedSession = sess;
                            synchronized (backedSession) {
                                BackedSession sess1 = (BackedSession)((Object)this.accessObject(id));
                                if (sess == sess1) {
                                    this.superRemove(id);
                                }
                            }
                            sess = null;
                        }
                    } else {
                        BackedSession backedSession = sess;
                        synchronized (backedSession) {
                            sess.updateLastAccessTime(nowTime);
                        }
                    }
                }
                if (sess != null) {
                    if (retrieval) {
                        BackedSession backedSession = sess;
                        synchronized (backedSession) {
                            BackedSession sess1 = (BackedSession)((Object)this.accessObject(sess.getId()));
                            if (sess == sess1) {
                                this.superRemove(sess.getId());
                            }
                        }
                    }
                    return sess;
                }
            } else {
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[0], "Cache copy is out of date or invalid " + id);
                }
                BackedSession backedSession = sess;
                synchronized (backedSession) {
                    BackedSession sess1 = (BackedSession)((Object)this.accessObject(sess.getId()));
                    if (sess == sess1) {
                        this.superRemove(sess.getId());
                    }
                }
            }
        }
        sess = this.retrieveSession(id, versionId, sess);
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidCopy(BackedSession sess, long nowTime, int versionId) {
        BackedSession backedSession = sess;
        synchronized (backedSession) {
            if (!sess.isValid()) {
                return false;
            }
            int maxTime = sess.getMaxInactiveInterval();
            boolean accBeforeTO = sess.getCurrentAccessTime() >= nowTime - 1000L * (long)maxTime;
            boolean cacheIdMatch = sess.getVersion() >= versionId;
            return cacheIdMatch && (accBeforeTO || maxTime == -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackedSession retrieveSession(String id, int versionId, BackedSession inMemSess) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        boolean useTheInMemSess = false;
        long lastAccessedTimeOnLocalCopy = 0L;
        if (inMemSess != null && inMemSess.isValid()) {
            lastAccessedTimeOnLocalCopy = inMemSess.getCurrentAccessTime();
        }
        long lastAccessTimeOnBackendCopy = 0L;
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("{").append(id).append(",").append(versionId).append(",").append(lastAccessedTimeOnLocalCopy).append("}");
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[1], sb.toString());
        }
        BackedSession sess = null;
        sess = (BackedSession)((Object)this.superGet(id));
        if (sess != null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1], "Found session in local cache.");
            }
            return sess;
        }
        if (this.isPresentInRecentlyInvalidatedList(id)) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1], "null - Id present in recently invalidated list.");
            }
            return null;
        }
        sess = this.readFromExternal(id);
        boolean cacheIdUpdate = false;
        if (sess != null) {
            lastAccessTimeOnBackendCopy = sess.getCurrentAccessTime();
            BackedSession thrownOutSess = null;
            BackedHashMap backedHashMap = this;
            synchronized (backedHashMap) {
                BackedSession ds = (BackedSession)((Object)this.superGet(id));
                if (ds == null) {
                    if (!this._isApplicationSessionHashMap) {
                        cacheIdUpdate = true;
                    }
                    if ((this._smc.getEnableEOSWrite() || this._smc.getOptimizeCacheIdIncrements()) && (lastAccessedTimeOnLocalCopy == lastAccessTimeOnBackendCopy || lastAccessedTimeOnLocalCopy > lastAccessTimeOnBackendCopy && this._smc.getOptimizeCacheIdIncrements())) {
                        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "Using in-memory session instead of retrieved.");
                        }
                        cacheIdUpdate = false;
                        sess = inMemSess;
                        useTheInMemSess = true;
                    }
                    thrownOutSess = (BackedSession)((Object)this.superPut(id, (Object)sess));
                    sess.setVersion(versionId);
                    sess.setIsNew(false);
                } else {
                    sess = ds;
                }
            }
            if (thrownOutSess != null && !useTheInMemSess) {
                this.passivateSession(thrownOutSess);
            }
        } else {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1], "Session is not found on backend");
            }
            return null;
        }
        BackedSession backedSession = sess;
        synchronized (backedSession) {
            long nowTime = System.currentTimeMillis();
            long prevLastAccess = sess.getCurrentAccessTime();
            int rowCount = -1;
            if (prevLastAccess < nowTime) {
                rowCount = this.updateLastAccessTime(sess, nowTime);
            } else {
                nowTime = prevLastAccess;
            }
            if (rowCount == 0) {
                this.superRemove(sess.getId());
                sess = null;
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                    LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1], "null - updateLastAccessTime failed.");
                }
                return sess;
            }
            sess.updateLastAccessTime(nowTime);
            sess.setLastWriteLastAccessTime(nowTime);
            sess.initSession(this._iStore);
            if (!useTheInMemSess && (sess.getSwappableListeners((short)2) || SessionManagerConfig.is_zOS())) {
                this.getStoreCallback().sessionDidActivate((ISession)sess);
            }
        }
        if (cacheIdUpdate) {
            this.updateCacheId(sess);
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1], "session found");
        }
        return sess;
    }

    public Object get(Object key, int version) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[2], key + " " + version);
        }
        String id = (String)key;
        BackedSession obj = this.getSession(id, version, true);
        return obj;
    }

    public void updateSession(BackedSession backedSess) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[3]);
        }
        if (!backedSess.isValid()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "session " + backedSess.getId() + " has been invalidated since last access, clean up and return ");
            }
            if (backedSess.appDataChanges != null) {
                backedSess.appDataChanges.clear();
            }
            if (backedSess.appDataRemovals != null) {
                backedSess.appDataRemovals.clear();
            }
            return;
        }
        if (this.cachedLastAccessedTimes != null) {
            if (backedSess.cacheLastAccessedTime) {
                this.cachedLastAccessedTimes.put(backedSess.getId(), new Long(backedSess.getCurrentAccessTime()));
                return;
            }
            this.cachedLastAccessedTimes.remove(backedSess.getId());
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "Do the write!");
        }
        boolean propHit = false;
        if (this._smc.writeAllProperties()) {
            propHit = true;
        }
        if (!propHit && backedSess.appDataChanges != null) {
            boolean bl = propHit = !backedSess.appDataChanges.isEmpty();
        }
        if (!propHit && backedSess.appDataRemovals != null) {
            boolean bl = propHit = !backedSess.appDataRemovals.isEmpty();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "propHit is: " + propHit);
            if (propHit) {
                String changes = backedSess.appDataChanges == null ? "null" : backedSess.appDataChanges.keySet().toString();
                String removals = backedSess.appDataRemovals == null ? "null" : backedSess.appDataRemovals.keySet().toString();
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "prop hit " + propHit + " app changes " + changes + " app removals " + removals);
            }
        }
        boolean writeSucc = this.persistSession(backedSess, propHit);
        backedSess.update = null;
        if (writeSucc) {
            backedSess.userWriteHit = false;
            backedSess.maxInactWriteHit = false;
            backedSess.listenCntHit = false;
            if (!this._smc.isUsingMultirow()) {
                if (backedSess.appDataChanges != null) {
                    backedSess.appDataChanges.clear();
                }
                if (backedSess.appDataRemovals != null) {
                    backedSess.appDataRemovals.clear();
                }
            }
        }
    }

    void updateCacheId(BackedSession backedSess) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[4]);
        }
        backedSess.getStoreCallback().sessionAffinityBroke((ISession)backedSess);
        int i = backedSess.getVersion();
        if (i == 9999) {
            backedSess.setVersion(1);
        } else {
            backedSess.setVersion(++i);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[4]);
        }
    }

    public Object put(Object key, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[5], "key = " + key);
        }
        String id = (String)key;
        BackedSession backedSess = (BackedSession)((Object)value);
        if (!backedSess.isValid()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[5], "Session is not valid.  Returning null");
            }
            return null;
        }
        if (backedSess.needToInsert) {
            this.insertSession(backedSess);
            if (backedSess.isNew()) {
                BackedSession thrownOutSess;
                if (!backedSess.removingSessionFromCache && (thrownOutSess = (BackedSession)((Object)this.superPut(id, (Object)backedSess))) != null) {
                    this.passivateSession(thrownOutSess);
                }
            } else {
                this.updateSession(backedSess);
            }
        } else {
            this.updateSession(backedSess);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[5]);
        }
        return null;
    }

    public Object superRemove(Object id) {
        Object o;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[7]);
        }
        if ((o = super.remove(id)) != null) {
            this.removeFromRecentlyInvalidatedList((String)id);
        }
        return o;
    }

    public Object superGet(Object id) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[8], "id = " + id);
        }
        Object sess = super.get(id);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            if (sess == null) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[8], "returned NULL");
            } else {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[8], "returned a SESSION: ");
            }
        }
        return sess;
    }

    public Object superPut(Object key, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[9], "" + key);
        }
        BackedSession sess = (BackedSession)((Object)super.put(key, value));
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToRecentlyInvalidatedList(String id) {
        if (!this._smc.getCheckRecentlyInvalidList()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "addToRecentlyInvalidatedList", "Adding to recently InvalidatedList");
        }
        Map map = this.recentInvalidIds;
        synchronized (map) {
            this.recentInvalidIds.put(id, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRecentlyInvalidatedList(String id) {
        if (!this._smc.getCheckRecentlyInvalidList()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "removeFromRecentlyInvalidatedList", "Removing From recently InvalidatedList");
        }
        Map map = this.recentInvalidIds;
        synchronized (map) {
            this.recentInvalidIds.remove(id);
        }
    }

    protected boolean isPresentInRecentlyInvalidatedList(String id) {
        if (!this._smc.getCheckRecentlyInvalidList()) {
            return false;
        }
        return this.recentInvalidIds.containsKey(id);
    }

    void setRecentInvalTable() {
        int tableSize = this._smc.getInMemorySize();
        if (tableSize > 1) {
            this.recentInvalidIds = new LRUHashMap(tableSize / 2);
        } else {
            this._smc.setCheckRecentlyInvalidList(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passivateSession(BackedSession sess) {
        BackedSession backedSession = sess;
        synchronized (backedSession) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "check for Passivation Listener for session");
            }
            this.getStoreCallback().sessionWillPassivate((ISession)sess);
            if (this._smc.getEnableTimeBasedWrite() || this._smc.getPersistSessionAfterPassivation()) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    if (this._smc.getEnableTimeBasedWrite()) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "Removing oldest entry from cache with TimeBasedWrits. Write it! " + sess.getId() + " " + this.getAppName());
                    } else {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[10], "Persisting the session after it was passivated. " + sess.getId() + " " + this.getAppName());
                    }
                }
                sess.removingSessionFromCache = true;
                sess.sync();
                sess.removingSessionFromCache = false;
            }
        }
    }

    public void listenerFlagUpdate(BackedSession d2) {
        if (this._iStore.isHttpSessionListener()) {
            switch (d2.listenerFlag) {
                case 0: {
                    d2.listenerFlag = 1;
                    break;
                }
                case 2: {
                    d2.listenerFlag = (short)3;
                    break;
                }
            }
        }
    }

    protected boolean doScheduledInvalidation() {
        boolean scheduledInvalidationEnabled = this._smc.getScheduledInvalidation();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[11], "scheduledInvalidationEnabled is " + scheduledInvalidationEnabled);
        }
        if (!scheduledInvalidationEnabled || ((BackedStore)this.getIStore()).remoteInvalReceived && SessionManagerConfig.isDoRemoteInvalidations()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[11], "returning true because scheduled invalidation is not enabled");
            }
            return true;
        }
        Calendar current = Calendar.getInstance();
        int currentHour = current.get(11);
        int scheduledHour1 = this._smc.getInvalTime1();
        int scheduledHour2 = this._smc.getInvalTime2();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[11], "currentHour:" + currentHour);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[11], "scheduled hours are " + scheduledHour1 + " and " + scheduledHour2);
        }
        if (currentHour == scheduledHour1 || currentHour == scheduledHour2) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[11], "returning true because current hour matches scheduled hour");
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[11], "returning false because it is not currently one of the scheduled hours");
        }
        return false;
    }

    public String getAppName() {
        return this._iStore.getId();
    }

    Enumeration tableKeys() {
        Set keys = this.keySet();
        final Iterator iter = keys.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public void handleDiscardedCacheItems(Enumeration vEnum) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[12]);
        }
        while (vEnum.hasMoreElements()) {
            Object id = vEnum.nextElement();
            Object o = this.superRemove(id);
            if (o == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "removed session " + id + " for app " + this.getAppName());
            }
            this.getStoreCallback().sessionCacheDiscard(o);
        }
    }

    private boolean hasTimedOut(BackedSession d, long now) {
        long invalidLastTouch;
        long lastTouch;
        boolean timedOut = false;
        int timeout = d.getMaxInactiveInterval();
        if (timeout > 0 && (lastTouch = d.getCurrentAccessTime()) <= (invalidLastTouch = now - 1000L * (long)timeout)) {
            timedOut = true;
        }
        return timedOut;
    }

    protected Enumeration cleanUpCache(long now) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[13]);
        }
        Vector<String> timedOutSessions = new Vector<String>();
        Enumeration sessionIds = this.tableKeys();
        while (sessionIds.hasMoreElements()) {
            String id = (String)sessionIds.nextElement();
            BackedSession backedSess = (BackedSession)((Object)this.superGet(id));
            if (backedSess == null) continue;
            try {
                if (!this.hasTimedOut(backedSess, now)) continue;
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[13], "adding to inval list " + backedSess.getId());
                }
                timedOutSessions.addElement(backedSess.getId());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.store.common.BackedHashMap.cleanUpCache", (String)"951", (Object)((Object)backedSess));
                timedOutSessions.addElement(backedSess.getId());
            }
        }
        Enumeration timedOutEnum = timedOutSessions.elements();
        this.handleDiscardedCacheItems(timedOutEnum);
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[13], timedOutSessions.elements());
        }
        return timedOutSessions.elements();
    }

    public boolean getAppDataTablesPerThread() {
        return this.appDataTablesPerThread;
    }

    public IStore getIStore() {
        return this._iStore;
    }

    public void setIsApplicationSessionHashMap(boolean b) {
        this._isApplicationSessionHashMap = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTimeBasedWrites(boolean forceWrite) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[14]);
        }
        if (forceWrite && isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "Entered for forceWrite request");
        }
        long now = System.currentTimeMillis();
        long writeInterval = this._smc.getPropertyWriterInterval() * 1000L;
        Enumeration vEnum = this.tableKeys();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "!!!!!!!!!!PropertyWriteThread Loop STARTS Here!!!!!!!!!!!!! ");
        }
        while (vEnum.hasMoreElements()) {
            Object currentKey = vEnum.nextElement();
            BackedSession cachedSession = (BackedSession)((Object)super.get(currentKey));
            if (cachedSession != null) {
                long lastWrite = cachedSession.getLastWriteTime();
                long lastAccess = cachedSession.getCurrentAccessTime();
                if (lastWrite != -1L && (now - lastWrite <= writeInterval && !forceWrite || lastAccess <= lastWrite)) continue;
                BackedSession backedSession = cachedSession;
                synchronized (backedSession) {
                    if (cachedSession.isValid()) {
                        String id = cachedSession.getId();
                        if (cachedSession.getRefCount() != 0) {
                            ++cachedSession.deferWriteUntilNextTick;
                            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "Defer write until next time since session is in the service method " + cachedSession.deferWriteUntilNextTick + " " + id);
                            }
                            if (cachedSession.deferWriteUntilNextTick > 5) {
                                if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "Failed to write on 5 tries. Force the write to database!!  " + id);
                                }
                                cachedSession.setLastWriteTime(now);
                                cachedSession.flush();
                                cachedSession.deferWriteUntilNextTick = 0;
                            }
                        } else {
                            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "Do the session Write and update lastWriteTime " + id);
                            }
                            cachedSession.setLastWriteTime(now);
                            cachedSession.flush();
                            cachedSession.deferWriteUntilNextTick = 0;
                        }
                    } else if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "Session no longer in Cache!");
                    }
                    continue;
                }
            }
            if (!isTraceOn || !LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) continue;
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "The Cache element is NULL");
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "!!!!!!!!!! PropertyWriteThread Loop ENDS Here!!!!!!!!!!!!!");
        }
    }

    protected abstract void removePersistedSession(String var1);

    protected abstract int updateLastAccessTime(BackedSession var1, long var2);

    protected abstract int overQualLastAccessTimeUpdate(BackedSession var1, long var2);

    protected abstract BackedSession readFromExternal(String var1);

    protected abstract Object loadOneValue(String var1, BackedSession var2);

    protected abstract void insertSession(BackedSession var1);

    protected abstract boolean persistSession(BackedSession var1, boolean var2);

    protected abstract boolean isPresent(String var1);

    protected abstract void performInvalidation();
}

