/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.SimpleSync;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPRequestContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class TCPBaseRequestContext
implements TCPRequestContext,
FFDCSelfIntrospectable {
    private boolean requestTypeRead;
    private boolean aborted = false;
    protected boolean blockedThread = false;
    protected SimpleSync blockWait = null;
    protected IOException blockingIOError = null;
    private WsByteBuffer[] buffers;
    private boolean forceQueue = false;
    private long ioAmount;
    private long ioDoneAmt = 0L;
    private long lastIOAmt = 0L;
    private long ioCompleteAmt = 0L;
    protected static final long maxReadSize = Integer.MAX_VALUE;
    protected static final long maxWriteSize = Integer.MAX_VALUE;
    protected TCPConnLink oTCPConnLink;
    protected TCPChannelConfiguration config;
    protected long timeoutTime;
    private int timeoutInterval;
    private WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private ByteBuffer[] byteBufferArray = null;
    private ByteBuffer[] byteBufferArrayDirect = null;
    private boolean missedSet = false;
    private ByteBuffer[] byteBufferArrayOf1 = null;
    private ByteBuffer[] byteBufferArrayOf2 = null;
    private ByteBuffer[] byteBufferArrayOf3 = null;
    private ByteBuffer[] byteBufferArrayOf4 = null;
    private ByteBuffer[] byteBufferArrayOf1Direct = null;
    private ByteBuffer[] byteBufferArrayOf2Direct = null;
    private ByteBuffer[] byteBufferArrayOf3Direct = null;
    private ByteBuffer[] byteBufferArrayOf4Direct = null;
    private static final TraceComponent tc = Tr.register(TCPBaseRequestContext.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    protected TCPBaseRequestContext(TCPConnLink link) {
        this.oTCPConnLink = link;
        this.config = link.getConfig();
    }

    protected void abort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Aborting connection", (Object[])new Object[0]);
        }
        this.aborted = true;
    }

    protected boolean isAborted() {
        return this.aborted;
    }

    public TCPConnLink getTCPConnLink() {
        return this.oTCPConnLink;
    }

    protected TCPChannelConfiguration getConfig() {
        return this.config;
    }

    @Override
    public TCPConnectionContext getInterface() {
        return this.oTCPConnLink;
    }

    @Override
    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    @Override
    public void setBuffers(WsByteBuffer[] bufs) {
        int i;
        this.missedSet = false;
        this.buffers = bufs;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        if (bufs != null) {
            int numBufs;
            for (numBufs = 0; numBufs < bufs.length && bufs[numBufs] != null; ++numBufs) {
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBuffers number of buffers is " + numBufs), (Object[])new Object[0]);
            }
            if (numBufs == 1) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
            } else if (numBufs == 2) {
                if (this.byteBufferArrayOf2 == null) {
                    this.byteBufferArrayOf2 = new ByteBuffer[2];
                }
                this.byteBufferArray = this.byteBufferArrayOf2;
            } else if (numBufs == 3) {
                if (this.byteBufferArrayOf3 == null) {
                    this.byteBufferArrayOf3 = new ByteBuffer[3];
                }
                this.byteBufferArray = this.byteBufferArrayOf3;
            } else if (numBufs == 4) {
                if (this.byteBufferArrayOf4 == null) {
                    this.byteBufferArrayOf4 = new ByteBuffer[4];
                }
                this.byteBufferArray = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArray = new ByteBuffer[numBufs];
            }
            if (numBufs > 1) {
                for (int i2 = 0; i2 < numBufs; ++i2) {
                    this.byteBufferArray[i2] = bufs[i2].getWrappedByteBufferNonSafe();
                }
            } else if (numBufs == 1) {
                if ((bufs[0].getStatus() & 2) == 0) {
                    this.byteBufferArray[0] = bufs[0].getWrappedByteBufferNonSafe();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setBuffers has FC buffer", (Object[])new Object[0]);
                    }
                    this.missedSet = true;
                }
            }
        } else {
            this.byteBufferArray = null;
        }
    }

    protected void setBuffersToDirect(WsByteBuffer[] bufs) {
        this.buffers = bufs;
        if (bufs != null) {
            int numBufs;
            for (numBufs = 0; numBufs < bufs.length && bufs[numBufs] != null; ++numBufs) {
            }
            if (numBufs == 1) {
                if (this.byteBufferArrayOf1Direct == null) {
                    this.byteBufferArrayOf1Direct = new ByteBuffer[1];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf1Direct;
            } else if (numBufs == 2) {
                if (this.byteBufferArrayOf2Direct == null) {
                    this.byteBufferArrayOf2Direct = new ByteBuffer[2];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf2Direct;
            } else if (numBufs == 3) {
                if (this.byteBufferArrayOf3Direct == null) {
                    this.byteBufferArrayOf3Direct = new ByteBuffer[3];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf3;
            } else if (numBufs == 4) {
                if (this.byteBufferArrayOf4Direct == null) {
                    this.byteBufferArrayOf4Direct = new ByteBuffer[4];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArrayDirect = new ByteBuffer[numBufs];
            }
            for (int i = 0; i < numBufs; ++i) {
                this.byteBufferArrayDirect[i] = ((WsByteBufferImpl)bufs[i]).oWsBBDirect;
            }
        } else {
            this.byteBufferArrayDirect = null;
        }
    }

    @Override
    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    @Override
    public void setBuffer(WsByteBuffer buf) {
        int i;
        this.missedSet = false;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        this.defaultBuffers[0] = null;
        if (buf != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = buf;
            if ((buf.getStatus() & 2) == 0) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
                this.byteBufferArray[0] = buf.getWrappedByteBufferNonSafe();
            } else {
                this.missedSet = true;
            }
        } else {
            this.buffers = null;
            this.byteBufferArray = null;
        }
    }

    @Override
    public void clearBuffers() {
        if (null != this.buffers) {
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i].clear();
            }
        }
    }

    protected void setForceQueue(boolean forceQue) {
        this.forceQueue = forceQue;
    }

    protected boolean isForceQueue() {
        return this.forceQueue;
    }

    public long getIOAmount() {
        return this.ioAmount;
    }

    public long getIODoneAmount() {
        return this.ioDoneAmt;
    }

    protected long getLastIOAmt() {
        return this.lastIOAmt;
    }

    protected void setLastIOAmt(long bytes) {
        this.lastIOAmt = bytes;
    }

    protected void setIOAmount(long b) {
        this.ioAmount = b;
    }

    protected void setIODoneAmount(long b) {
        this.ioDoneAmt = b;
    }

    protected void setIOCompleteAmount(long b) {
        this.ioCompleteAmt = b;
    }

    protected long getIOCompleteAmount() {
        return this.ioCompleteAmt;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    protected void setTimeoutTime(int time) {
        int timeout = time;
        if (timeout == -1) {
            this.timeoutTime = -1L;
            this.timeoutInterval = 0;
        } else {
            if (timeout == 0) {
                timeout = this.getConfig().getInactivityTimeout();
            }
            if (timeout != 0) {
                this.timeoutTime = System.currentTimeMillis() + (long)timeout;
                this.timeoutInterval = timeout;
            } else {
                this.timeoutTime = -1L;
                this.timeoutInterval = 0;
            }
        }
    }

    protected boolean hasTimeout() {
        return this.timeoutTime != -1L;
    }

    public int getTimeoutInterval() {
        return this.timeoutInterval;
    }

    public List<String> introspect() {
        LinkedList<String> rc = new LinkedList<String>();
        String prefix = this.getClass().getSimpleName() + "@" + this.hashCode() + ": ";
        rc.add(prefix + "aborted=" + this.aborted);
        rc.add(prefix + "forceQueue=" + this.forceQueue);
        rc.add(prefix + "ioAmount=" + this.ioAmount);
        rc.add(prefix + "ioCompleteAmt=" + this.ioCompleteAmt);
        rc.add(prefix + "ioDoneAmt=" + this.ioDoneAmt);
        rc.add(prefix + "lastIOAmt=" + this.lastIOAmt);
        rc.add(prefix + "isRead=" + this.requestTypeRead);
        rc.add(prefix + "timeoutInterval=" + this.timeoutInterval);
        rc.add(prefix + "timeoutTime=" + this.timeoutTime);
        rc.add(prefix + "link=" + this.oTCPConnLink);
        if (null != this.oTCPConnLink) {
            rc.addAll(this.oTCPConnLink.introspect());
        }
        return rc;
    }

    public String[] introspectSelf() {
        List<String> rc = this.introspect();
        return rc.toArray(new String[rc.size()]);
    }

    protected boolean isRequestTypeRead() {
        return this.requestTypeRead;
    }

    protected void setRequestTypeRead(boolean b) {
        this.requestTypeRead = b;
    }

    protected ByteBuffer[] getByteBufferArray() {
        if (!this.missedSet) {
            return this.byteBufferArray;
        }
        if (this.byteBufferArrayOf1 == null) {
            this.byteBufferArrayOf1 = new ByteBuffer[1];
        }
        this.byteBufferArray = this.byteBufferArrayOf1;
        this.byteBufferArray[0] = this.buffers[0].getWrappedByteBufferNonSafe();
        this.missedSet = false;
        return this.byteBufferArray;
    }

    protected ByteBuffer[] getByteBufferArrayDirect() {
        return this.byteBufferArrayDirect;
    }

    public boolean updateIOCounts(long byteCount, int type) {
        boolean rc;
        this.setLastIOAmt(byteCount);
        this.setIODoneAmount(this.getIODoneAmount() + byteCount);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            String dbString = null;
            dbString = type == 0 ? "Read " : "Wrote ";
            SocketIOChannel channel = this.getTCPConnLink().getSocketIOChannel();
            Tr.event((TraceComponent)tc, (String)(dbString + byteCount + "(" + this.getIODoneAmount() + ")" + " bytes, " + this.getIOAmount() + " requested on local: " + channel.getSocket().getLocalSocketAddress() + " remote: " + channel.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        if (this.getIODoneAmount() >= this.getIOAmount()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (type == 0) {
                    Tr.debug((TraceComponent)tc, (String)"read complete, at least minimum amount of data read", (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)"write complete, at least minimum amount of data written", (Object[])new Object[0]);
                }
            }
            rc = true;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (type == 0) {
                    Tr.debug((TraceComponent)tc, (String)"read not complete, more data needed", (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)"write not complete, more data needs to be written", (Object[])new Object[0]);
                }
            }
            rc = false;
        }
        return rc;
    }
}

