/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.tcpchannel.internal.CancelRequest;
import com.ibm.ws.tcpchannel.internal.ChannelSelector;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPBaseRequestContext;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

public class NioSocketIOChannel
extends SocketIOChannel {
    private static final TraceComponent tc = Tr.register(NioSocketIOChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private ChannelSelector channelSelectorRead = null;
    private ChannelSelector channelSelectorWrite = null;

    protected NioSocketIOChannel(Socket socket, TCPChannel _tcpChannel) {
        super(socket, _tcpChannel);
        this.checkCancel = TCPFactoryConfiguration.getCancelKeyOnClose();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Created NioSocketIOChannel", (Object[])new Object[0]);
        }
    }

    protected static SocketIOChannel createIOChannel(Socket _socket, TCPChannel _tcpChannel) {
        return new NioSocketIOChannel(_socket, _tcpChannel);
    }

    protected SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        return this.channel.register(sel, ops, att);
    }

    protected void setChannelSelectorRead(ChannelSelector sr) {
        this.channelSelectorRead = sr;
    }

    protected void setChannelSelectorWrite(ChannelSelector sr) {
        this.channelSelectorWrite = sr;
    }

    protected ChannelSelector getChannelSelectorRead() {
        return this.channelSelectorRead;
    }

    protected ChannelSelector getChannelSelectorWrite() {
        return this.channelSelectorWrite;
    }

    @Override
    protected long attemptReadFromSocketUsingNIO(TCPReadRequestContextImpl req, WsByteBuffer[] wsBuffArray) throws IOException {
        long dataRead = 0L;
        if (wsBuffArray.length == 1) {
            if (!wsBuffArray[0].isDirect() && wsBuffArray[0].hasArray()) {
                try {
                    WsByteBufferImpl wsBuffImpl = (WsByteBufferImpl)wsBuffArray[0];
                    wsBuffImpl.setParmsToDirectBuffer();
                    dataRead = this.read(wsBuffImpl.oWsBBDirect);
                    wsBuffImpl.copyFromDirectBuffer((int)dataRead);
                }
                catch (ClassCastException cce) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Reading with a non-WsByteBufferImpl, may hurt performance", (Object[])new Object[0]);
                    }
                    dataRead = this.read(wsBuffArray[0].getWrappedByteBufferNonSafe());
                }
            } else {
                dataRead = this.read(wsBuffArray[0].getWrappedByteBufferNonSafe());
            }
        } else {
            ByteBuffer[] readBuffArray = req.preProcessReadBuffers();
            dataRead = this.read(readBuffArray);
            req.postProcessReadBuffers(dataRead);
        }
        return dataRead;
    }

    @Override
    protected long attemptWriteToSocketUsingNIO(TCPBaseRequestContext req, WsByteBuffer[] wsBuffArray) throws IOException {
        long bytesWritten = 0L;
        if (wsBuffArray.length == 1) {
            if (!wsBuffArray[0].isDirect() && wsBuffArray[0].hasArray()) {
                WsByteBufferImpl wsBuffImpl = null;
                try {
                    wsBuffImpl = (WsByteBufferImpl)wsBuffArray[0];
                    wsBuffImpl.copyToDirectBuffer();
                    bytesWritten = this.write(wsBuffImpl.oWsBBDirect);
                    wsBuffImpl.setParmsFromDirectBuffer();
                }
                catch (ClassCastException cce) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Writing with a non-WsByteBufferImpl, may hurt performance", (Object[])new Object[0]);
                    }
                    bytesWritten = this.write(wsBuffArray[0].getWrappedByteBufferNonSafe());
                }
            } else {
                bytesWritten = this.write(wsBuffArray[0].getWrappedByteBufferNonSafe());
            }
        } else {
            int i;
            boolean containsNonDirect = false;
            for (i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
                if (wsBuffArray[i].isDirect() || !wsBuffArray[i].hasArray()) continue;
                containsNonDirect = true;
                break;
            }
            if (!containsNonDirect) {
                bytesWritten = this.write(req.getByteBufferArray());
            } else {
                try {
                    for (i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
                        ((WsByteBufferImpl)wsBuffArray[i]).copyToDirectBuffer();
                    }
                    req.setBuffersToDirect(wsBuffArray);
                    bytesWritten = this.write(req.getByteBufferArrayDirect());
                    for (i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
                        ((WsByteBufferImpl)wsBuffArray[i]).setParmsFromDirectBuffer();
                    }
                }
                catch (ClassCastException cce) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Writing with non-WsByteBufferImpl, may hurt performance", (Object[])new Object[0]);
                    }
                    bytesWritten = this.write(req.getByteBufferArray());
                }
            }
        }
        return bytesWritten;
    }

    protected int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    protected long read(ByteBuffer[] dst) throws IOException {
        return this.channel.read(dst);
    }

    protected int write(ByteBuffer dst) throws IOException {
        return this.channel.write(dst);
    }

    protected long write(ByteBuffer[] dst) throws IOException {
        return this.channel.write(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block28: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object[])new Object[0]);
            }
            super.close();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("SocketChannel closing, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress()), (Object[])new Object[0]);
            }
            NioSocketIOChannel nioSocketIOChannel = this;
            synchronized (nioSocketIOChannel) {
                if (this.closed) {
                    this.processClose = false;
                }
                this.closed = true;
            }
            if (this.processClose) {
                if (this.checkCancel) {
                    CancelRequest cancelRequest;
                    CancelRequest cr;
                    SelectionKey k;
                    if (this.channelSelectorRead != null && (k = this.channelSelectorRead.getKey(this.channel)) != null) {
                        cancelRequest = cr = new CancelRequest(k);
                        synchronized (cancelRequest) {
                            this.channelSelectorRead.addCancelRequest(cr);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("waiting for read key to be canceled, key is " + k), (Object[])new Object[0]);
                            }
                            try {
                                cr.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.channelSelectorWrite != null && (k = this.channelSelectorWrite.getKey(this.channel)) != null) {
                        cancelRequest = cr = new CancelRequest(k);
                        synchronized (cancelRequest) {
                            this.channelSelectorWrite.addCancelRequest(cr);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("waiting for write key to be canceled, key is " + k), (Object[])new Object[0]);
                            }
                            try {
                                cr.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                try {
                    if (this.channel != null) {
                        this.channel.close();
                    }
                    if (this.channelSelectorRead != null) {
                        this.channelSelectorRead.wakeup();
                        this.channelSelectorRead = null;
                    }
                    if (this.channelSelectorWrite != null) {
                        this.channelSelectorWrite.wakeup();
                        this.channelSelectorWrite = null;
                    }
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block28;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error closing channel: " + t), (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }
}

