/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.chains;

import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class EndPointMgrImpl
implements EndPointMgr {
    private static final TraceComponent tc = Tr.register(EndPointMgrImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private static final String MBEAN_OBJECT_NAME_PREFIX = "WebSphere:feature=channelfw,type=endpoint,name=";
    private final BundleContext bundleContext;
    private final Map<String, EndPointInfo> endpoints;
    private final ConcurrentMap<String, ServiceRegistration<DynamicMBean>> endpointMBeans;

    public EndPointMgrImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.endpoints = new HashMap<String, EndPointInfo>();
        this.endpointMBeans = new ConcurrentHashMap<String, ServiceRegistration<DynamicMBean>>();
    }

    public static EndPointMgr getRef() {
        return EndpointManagerHolder.singleton;
    }

    public static void setRef(EndPointMgr singleton) {
        EndpointManagerHolder.singleton = singleton;
    }

    private String getMBeanObjectName(String name) {
        return MBEAN_OBJECT_NAME_PREFIX + name;
    }

    private Hashtable<String, String> createMBeanServiceProperties(String name, EndPointInfo endpoint) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.vendor", "IBM");
        properties.put("jmx.objectname", this.getMBeanObjectName(name));
        properties.put("type", "endpoint");
        return properties;
    }

    private ServiceRegistration<DynamicMBean> registerMBeanAsService(String name, EndPointInfo endpoint) {
        return this.bundleContext.registerService(DynamicMBean.class, (Object)endpoint, this.createMBeanServiceProperties(name, endpoint));
    }

    private void registerEndpointMBean(String name, EndPointInfo ep) {
        this.endpointMBeans.put(name, this.registerMBeanAsService(name, ep));
    }

    private void updateEndpointMBean(String name, EndPointInfo ep) {
        ServiceRegistration reg = (ServiceRegistration)this.endpointMBeans.get(name);
        if (reg != null) {
            reg.setProperties(this.createMBeanServiceProperties(name, ep));
        }
    }

    private void destroyEndpointMBeans() {
        for (Map.Entry mbean : this.endpointMBeans.entrySet()) {
            String mbeanName = (String)mbean.getKey();
            this.endpointMBeans.remove(mbeanName);
            ((ServiceRegistration)mbean.getValue()).unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyEndpoints() {
        EndPointMgrImpl _this = (EndPointMgrImpl)EndPointMgrImpl.getRef();
        Map<String, EndPointInfo> map = _this.endpoints;
        synchronized (map) {
            _this.destroyEndpointMBeans();
            _this.endpoints.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndPointInfo defineEndPoint(String name, String host, int port) {
        try {
            EndPointInfo ep = new EndPointInfo(name, host, port);
            Map<String, EndPointInfo> map = this.endpoints;
            synchronized (map) {
                if (this.endpoints.containsKey(name)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("The new endpoint " + name + "already exists. Update the properties of the registered service"), (Object[])new Object[0]);
                    }
                    this.updateEndpointMBean(name, ep);
                } else {
                    this.registerEndpointMBean(name, ep);
                    this.endpoints.put(name, ep);
                }
            }
            return ep;
        }
        catch (NotCompliantMBeanException ex) {
            throw new IllegalStateException("Encountered a situation that should never occur. The EndPointInfo resulted in NotCompliantMBeanException", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndPointInfo getEndPoint(String name) {
        Map<String, EndPointInfo> map = this.endpoints;
        synchronized (map) {
            return this.endpoints.get(name);
        }
    }

    private void unregisterMBeanInService(String name) {
        if (this.endpointMBeans.containsKey(name)) {
            ServiceRegistration existingMBean = (ServiceRegistration)this.endpointMBeans.get(name);
            existingMBean.unregister();
            this.endpointMBeans.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEndPoint(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deleting endpoint: " + name), (Object[])new Object[0]);
        }
        Map<String, EndPointInfo> map = this.endpoints;
        synchronized (map) {
            if (this.endpoints.remove(name) != null) {
                this.unregisterMBeanInService(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EndPointInfo> getEndPoints(String address, int port) {
        LinkedList<EndPointInfo> rc = new LinkedList<EndPointInfo>();
        if (null == address) {
            return rc;
        }
        boolean isAddrWild = "*".equals(address);
        Map<String, EndPointInfo> map = this.endpoints;
        synchronized (map) {
            for (EndPointInfo ep : this.endpoints.values()) {
                if ((!isAddrWild && !"*".equals(ep.getHost()) && !address.equals(ep.getHost()) || 0 != port && 0 != ep.getPort()) && port != ep.getPort()) continue;
                rc.add(ep);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EndPointInfo> getEndsPoints() {
        Map<String, EndPointInfo> map = this.endpoints;
        synchronized (map) {
            return new ArrayList<EndPointInfo>(this.endpoints.values());
        }
    }

    private static class EndpointManagerHolder {
        private static EndPointMgr singleton;

        private EndpointManagerHolder() {
        }

        static {
            BundleContext bundleContext = null;
            Bundle b = FrameworkUtil.getBundle(EndpointManagerHolder.class);
            if (b != null) {
                bundleContext = b.getBundleContext();
            }
            singleton = new EndPointMgrImpl(bundleContext);
        }
    }
}

