/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.channelfw.osgi;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelUtils;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.event.ScheduledEventService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.ByteBufferConfiguration;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.channelfw.internal.chains.EndPointMgrImpl;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.tcpchannel.internal.TCPChannelFactory;
import com.ibm.ws.udpchannel.internal.UDPChannelFactory;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.timer.ApproximateTime;
import com.ibm.wsspi.timer.QuickApproxTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={CHFWBundle.class, ServerQuiesceListener.class}, name="com.ibm.ws.channelfw", configurationPid={"com.ibm.ws.channelfw"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"service.vendor=IBM"})
public class CHFWBundle
implements ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(CHFWBundle.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private static final AtomicReference<CHFWBundle> instance = new AtomicReference();
    private ChannelFrameworkImpl chfw = ChannelFrameworkImpl.getRef();
    private ByteBufferConfiguration wsbbmgr = null;
    private EventEngine eventService = null;
    private ScheduledEventService scheduler = null;
    private ExecutorService executorService = null;
    private static boolean serverCompletelyStarted = false;
    private static Object syncStarted = new Object(){};

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating ", (Object[])new Object[]{config});
        }
        this.modified(config);
        this.chfw.registerFactory("TCPChannel", TCPChannelFactory.class);
        this.chfw.registerFactory("UDPChannel", UDPChannelFactory.class);
        instance.set(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivating", (Object[])new Object[0]);
            }
            instance.compareAndSet(this, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Destroying all endpoints", (Object[])new Object[0]);
            }
            EndPointMgrImpl.destroyEndpoints();
            try {
                this.chfw.destroy();
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error destroying framework: " + t), (Object[])new Object[0]);
            }
        }
        this.chfw.deregisterFactory("TCPChannel");
        this.chfw.deregisterFactory("UDPChannel");
    }

    @Modified
    protected synchronized void modified(Map<String, Object> cfwConfiguration) {
        if (null == cfwConfiguration) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Processing config", (Object[])new Object[]{cfwConfiguration});
        }
        this.chfw.updateConfig(cfwConfiguration);
    }

    @Reference(service=NativeMethodManager.class, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setNativeMethodManager(NativeMethodManager nativeMethodManager) {
        this.chfw.setNativeMethodManager(nativeMethodManager);
    }

    protected void unsetNativeMethodManager(NativeMethodManager nativeMethodManager) {
        this.chfw.setNativeMethodManager(null);
    }

    public void serverStopping() {
        long timeout = this.chfw.getDefaultChainQuiesceTimeout();
        if (timeout > 0L) {
            ChainData[] runningChains = this.chfw.getRunningChains();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < runningChains.length; ++i) {
                if (!FlowType.INBOUND.equals(runningChains[i].getType())) continue;
                names.add(runningChains[i].getName());
            }
            ChannelUtils.stopChains(names, -1L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=ServerStarted.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServerStarted(ServiceReference<ServerStarted> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Server Completely Started signal received", (Object[])new Object[0]);
        }
        Object object = syncStarted;
        synchronized (object) {
            serverCompletelyStarted = true;
            syncStarted.notifyAll();
        }
    }

    protected synchronized void unsetServerStarted(ServiceReference<ServerStarted> ref) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class})
    public static void waitServerCompletelyStarted() {
        Object object = syncStarted;
        synchronized (object) {
            if (!serverCompletelyStarted) {
                try {
                    syncStarted.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class})
    public static boolean isServerCompletelyStarted() {
        Object object = syncStarted;
        synchronized (object) {
            return serverCompletelyStarted;
            {
            }
        }
    }

    @Reference(service=ByteBufferConfiguration.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setByteBufferConfig(ByteBufferConfiguration bbConfig) {
        this.wsbbmgr = bbConfig;
    }

    protected void unsetByteBufferConfig(ByteBufferConfiguration bbConfig) {
    }

    public static EventEngine getEventService() {
        CHFWBundle c = instance.get();
        if (null != c) {
            return c.eventService;
        }
        return null;
    }

    @Reference(service=EventEngine.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setEventService(EventEngine service) {
        this.eventService = service;
    }

    protected void unsetEventService(EventEngine service) {
    }

    public static ExecutorService getExecutorService() {
        CHFWBundle c = instance.get();
        if (null != c) {
            return c.executorService;
        }
        return null;
    }

    @Reference(service=ExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
    }

    public static ScheduledEventService getScheduleService() {
        CHFWBundle c = instance.get();
        if (null != c) {
            return c.scheduler;
        }
        return null;
    }

    @Reference(service=ScheduledEventService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setScheduledEventService(ScheduledEventService ref) {
        this.scheduler = ref;
    }

    protected void unsetScheduledEventService(ScheduledEventService ref) {
    }

    @Reference(service=ChannelFactoryProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setFactoryProvider(ChannelFactoryProvider provider) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Add factory provider; " + provider), (Object[])new Object[0]);
        }
        this.chfw.registerFactories(provider);
    }

    protected void unsetFactoryProvider(ChannelFactoryProvider provider) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Remove factory provider; " + provider), (Object[])new Object[0]);
        }
        this.chfw.deregisterFactories(provider);
    }

    public static long getApproxTime() {
        return QuickApproxTime.getApproxTime();
    }

    @Reference(service=ApproximateTime.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setApproxTimeService(ApproximateTime ref) {
    }

    protected void unsetApproxTimeService(ApproximateTime ref) {
    }

    public ChannelFramework getFramework() {
        return this.chfw;
    }

    public WsByteBufferPoolManager getBufferManager() {
        ByteBufferConfiguration bbMgr = this.wsbbmgr;
        WsByteBufferPoolManager result = bbMgr == null ? null : bbMgr.getBufferManager();
        return result != null ? result : ChannelFrameworkFactory.getBufferManager();
    }

    public EndPointMgr getEndpointManager() {
        return EndPointMgrImpl.getRef();
    }
}

