/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AsyncChannelFuture;
import com.ibm.io.async.AsyncChannelGroup;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncFuture;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.CompletionKey;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.io.async.LookupTable;
import com.ibm.io.async.ResultHandler;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class AbstractAsyncChannel
implements Channel {
    private static final TraceComponent tc = Tr.register(AbstractAsyncChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private static IAsyncProvider provider = AsyncLibrary.getInstance();
    private boolean closed = false;
    private static LookupTable<AbstractAsyncChannel> channelTable = new LookupTable(2000);
    protected final int channelIndex;
    protected AsyncFuture readFuture = new AsyncFuture(this);
    protected AsyncFuture writeFuture = new AsyncFuture(this);
    static final int defaultBufferCount = 10;
    protected CompletionKey readIOCB = null;
    protected CompletionKey writeIOCB = null;
    protected VirtualConnection channelVCI = null;
    protected static final int READ_FUTURE_INDEX = -1;
    protected static final long READ_INDEX = -4294967296L;
    protected static final int WRITE_FUTURE_INDEX = -2;
    protected static final long WRITE_INDEX = -8589934592L;
    protected static final int SYNC_READ_FUTURE_INDEX = -3;
    protected static final long SYNC_READ_INDEX = -12884901888L;
    protected static final int SYNC_WRITE_FUTURE_INDEX = -4;
    protected static final long SYNC_WRITE_INDEX = -17179869184L;
    protected static Field addrField;
    long channelIdentifier;
    protected ResultHandler resultHandler;
    protected AsyncChannelGroup asyncChannelGroup;

    static long getBufAddress(ByteBuffer theBuffer) {
        if (!theBuffer.isDirect()) {
            throw new IllegalArgumentException("Only direct buffers allowed");
        }
        try {
            return addrField.getLong(theBuffer);
        }
        catch (IllegalAccessException exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error getting async provider instance, exception: " + exception.getMessage()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.io.async.AbstractAsyncChannel", (String)"149");
            throw new RuntimeException(exception.getMessage());
        }
    }

    protected AbstractAsyncChannel(AsyncChannelGroup asyncChannelGroup) {
        this.channelIndex = channelTable.addElement(this);
        this.asyncChannelGroup = asyncChannelGroup;
        this.resultHandler = asyncChannelGroup.getResultHandler();
        this.readFuture.setRead(true);
        this.writeFuture.setRead(false);
    }

    public static AbstractAsyncChannel getChannelFromIndex(int theIndex) {
        return channelTable.lookupElement(theIndex);
    }

    public AsyncFuture getFutureFromIndex(int theIndex) {
        if (theIndex == -1 || theIndex == -3) {
            return this.readFuture;
        }
        if (theIndex == -2 || theIndex == -4) {
            return this.writeFuture;
        }
        return null;
    }

    void cancel(AsyncChannelFuture future, Exception reason) throws ClosedChannelException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancel", (Object[])new Object[0]);
        }
        if (!this.isOpen()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cancel request on closed connection", (Object[])new Object[0]);
            }
            future.setCancelInProgress(0);
            throw new ClosedChannelException();
        }
        if (future.isCompleted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cancel request on completed future", (Object[])new Object[0]);
            }
            future.setCancelInProgress(0);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancel");
            }
            return;
        }
        long callid = ((AsyncFuture)future).isRead() ? this.readIOCB.getCallIdentifier() : this.writeIOCB.getCallIdentifier();
        int rc = provider.cancel2(this.channelIdentifier, callid);
        if (rc == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cancel Successful, resetting CancelInProgress state to 0", (Object[])new Object[0]);
            }
            future.setCancelInProgress(0);
            future.completed(reason);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cancel could not be completed", (Object[])new Object[0]);
            }
            future.setCancelInProgress(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancel");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        channelTable.removeElement(this.channelIndex);
        this.closed = true;
    }

    protected AsyncChannelGroup getAsyncChannelGroup() {
        return this.asyncChannelGroup;
    }

    final boolean isCapable(int capability) {
        return provider.hasCapability(capability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IAsyncFuture multiIO(ByteBuffer[] buffers, long position, boolean isRead, boolean forceQueue, long bytesRequested, boolean useJITBuffer, VirtualConnection vci, boolean asyncIO) {
        AsyncFuture theFuture;
        block36: {
            int i;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("multiIO(.," + position + "," + isRead + "," + forceQueue + "," + bytesRequested + "," + useJITBuffer + ",.," + asyncIO), (Object[])new Object[0]);
            }
            if (buffers == null) {
                throw new IllegalArgumentException();
            }
            theFuture = null;
            CompletionKey iocb = null;
            this.channelVCI = vci;
            if (isRead) {
                theFuture = this.readFuture;
                iocb = this.readIOCB;
                if (asyncIO) {
                    iocb.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFF00000000L);
                } else {
                    iocb.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFD00000000L);
                }
            } else {
                theFuture = this.writeFuture;
                iocb = this.writeIOCB;
                if (asyncIO) {
                    iocb.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFE00000000L);
                } else {
                    iocb.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFC00000000L);
                }
            }
            theFuture.resetFuture();
            theFuture.setBuffers(buffers);
            if (!this.isOpen()) {
                theFuture.completed(new ClosedChannelException());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"multiIO", (Object)theFuture);
                }
                return theFuture;
            }
            int count = 0;
            for (i = 0; i < buffers.length && buffers[i] != null; ++i) {
                ++count;
            }
            if (count == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no buffers passed on I/O call", (Object[])new Object[0]);
                }
                AsyncException exception = new AsyncException("no buffers passed on I/O call");
                FFDCFilter.processException((Throwable)exception, (String)this.getClass().getName(), (String)"384", (Object)this);
                theFuture.completed(exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"multiIO", (Object)theFuture);
                }
                return theFuture;
            }
            if (count > iocb.getBufferCount()) {
                iocb.expandBuffers(count);
            }
            for (i = 0; i < count; ++i) {
                iocb.setBuffer(AbstractAsyncChannel.getBufAddress(buffers[i]) + (long)buffers[i].position(), buffers[i].remaining(), i);
            }
            boolean pending = false;
            iocb.setBytesAffected(0);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Requesting IO from native for  call id: " + Long.toHexString(iocb.getCallIdentifier()) + " channel id: " + iocb.getChannelIdentifier()), (Object[])new Object[0]);
                }
                iocb.preNativePrep();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CompleteKey in AbstractAsyncChannel.multiIO before preNativePrep() call", (Object[])new Object[]{iocb});
                }
                pending = provider.multiIO3(iocb.getAddress(), position, count, isRead, forceQueue, bytesRequested, useJITBuffer);
                iocb.postNativePrep();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CompleteKey in AbstractAsyncChannel.multiIO after postNativePrep() call", (Object[])new Object[]{iocb});
                }
                if (pending) {
                    if (!vci.isInputStateTrackingOperational()) break block36;
                    Object object = vci.getLockObject();
                    synchronized (object) {
                        if (asyncIO) {
                            if (isRead) {
                                vci.setReadStatetoCloseAllowedNoSync();
                            } else {
                                vci.setWriteStatetoCloseAllowedNoSync();
                            }
                        }
                        if (vci.getCloseWaiting()) {
                            vci.getLockObject().notify();
                        }
                        break block36;
                    }
                }
                int rc = iocb.getReturnCode();
                if (rc == 0) {
                    if (iocb.getBytesAffected() == 0L && bytesRequested > 0L) {
                        IOException ioe = new IOException("Async IO operation failed, internal error");
                        FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"453");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Error processing multiIO request, exception: " + ioe.getMessage()), (Object[])new Object[0]);
                        }
                        theFuture.completed(ioe);
                    } else {
                        theFuture.completed(iocb.getBytesAffected());
                    }
                } else {
                    theFuture.completed(AsyncLibrary.getIOException("Async IO operation failed (1), reason: ", rc));
                }
            }
            catch (AsyncException exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error processing multiIO request, exception: " + exception.getMessage()), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)exception, (String)this.getClass().getName(), (String)"420", (Object)this);
                theFuture.completed(exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"multiIO", (Object)theFuture);
        }
        return theFuture;
    }

    static {
        StartPrivilegedThread privThread = new StartPrivilegedThread();
        AccessController.doPrivileged(privThread);
    }

    static class StartPrivilegedThread
    implements PrivilegedAction<Object> {
        @Override
        public Object run() {
            try {
                Class<?> bufClass = Class.forName("java.nio.Buffer");
                addrField = bufClass.getDeclaredField("address");
                addrField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

