/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.statemachine;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.internal.statemachine.Action;
import com.ibm.ws.app.manager.internal.statemachine.ResourceCallback;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class DownloadFileAction
implements Runnable,
Action {
    private static final TraceComponent _tc = Tr.register(DownloadFileAction.class);
    private final WsLocationAdmin _locAdmin;
    private final String _servicePid;
    private final String _location;
    private final ResourceCallback _callback;
    private final AtomicBoolean _active = new AtomicBoolean(true);
    private final AtomicReference<ApplicationHandler<?>> _handler;
    static final long serialVersionUID = -5256197962600157589L;

    public DownloadFileAction(WsLocationAdmin locAdmin, String servicePid, String location, ResourceCallback callback, AtomicReference<ApplicationHandler<?>> handler) {
        this._locAdmin = locAdmin;
        this._servicePid = servicePid;
        this._location = location;
        this._callback = callback;
        this._handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={MalformedURLException.class, IOException.class})
    public void run() {
        block15: {
            BufferedOutputStream output = null;
            InputStream input = null;
            DataOutputStream dOut = null;
            DataInputStream dIn = null;
            URLConnection urlConection = null;
            try {
                URL Url = new URL(this._location);
                int byteRead = 0;
                File downloadDir = this._locAdmin.getBundleFile((Object)this, this._servicePid);
                if (!FileUtils.ensureDirExists((File)downloadDir)) {
                    AppMessageHelper.get(this._handler.get()).error("CANNOT_CREATE_DIRECTORY", downloadDir, this._location);
                    this._callback.failedCompletion(null);
                    return;
                }
                String fileName = this.getFileName();
                boolean doDownload = true;
                File downloadedFile = new File(downloadDir, fileName);
                File lastModifiedFile = new File(downloadDir, fileName + ".lastModified");
                urlConection = Url.openConnection();
                long lastModified = urlConection.getLastModified();
                if (downloadedFile.exists() && lastModified > 0L && lastModifiedFile.exists() && lastModified == (dIn = new DataInputStream(new FileInputStream(lastModifiedFile))).readLong()) {
                    doDownload = false;
                }
                output = new BufferedOutputStream(new FileOutputStream(downloadedFile));
                input = urlConection.getInputStream();
                byte[] buf = new byte[1024];
                while (this._active.get() && (byteRead = input.read(buf)) != -1) {
                    ((OutputStream)output).write(buf, 0, byteRead);
                }
                ((OutputStream)output).flush();
                if (this._active.get()) {
                    if (doDownload && lastModified > 0L) {
                        try {
                            dOut = new DataOutputStream(new FileOutputStream(lastModifiedFile));
                            dOut.writeLong(lastModified);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    Container c = this._callback.setupContainer(this._servicePid, downloadedFile);
                    WsResource r = this._locAdmin.resolveResource(downloadedFile.getAbsolutePath());
                    this._callback.successfulCompletion(c, r);
                }
                DownloadFileAction.close(input);
            }
            catch (MalformedURLException urlException) {
                this._callback.failedCompletion(urlException);
                break block15;
            }
            catch (Exception urlException) {
                void exception;
                FFDCFilter.processException((Throwable)urlException, (String)"com.ibm.ws.app.manager.internal.statemachine.DownloadFileAction", (String)"129", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exception, (String)DownloadFileAction.class.getName(), (String)"downloadFail");
                Tr.warning((TraceComponent)_tc, (String)"DOWNLOAD_EXCEPTION_ENCOUNTERED", (Object[])new Object[]{this._location, exception.toString()});
                this._callback.failedCompletion((Throwable)exception);
                break block15;
            }
            finally {
                DownloadFileAction.close(input);
                DownloadFileAction.close(output);
                DownloadFileAction.close(dIn);
                DownloadFileAction.close(dOut);
            }
            DownloadFileAction.close(output);
            DownloadFileAction.close(dIn);
            DownloadFileAction.close(dOut);
        }
    }

    @FFDCIgnore(value={IOException.class})
    private static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getFileName() {
        int index = this._location.lastIndexOf(47);
        if (index != -1) {
            return this._location.substring(index + 1);
        }
        return this._servicePid;
    }

    @Override
    public void execute(ExecutorService executor) {
        executor.execute(this);
    }

    @Override
    public void cancel() {
        this._active.set(false);
    }
}

