/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

@Trivial
public final class ApplicationDependency
implements CompletionListener<Boolean> {
    private final FutureMonitor futureMonitor;
    private final Future<Boolean> future;
    private final String desc;
    private final int seqNo;
    private static final AtomicInteger _appDepCounter = new AtomicInteger();

    public ApplicationDependency(FutureMonitor futureMonitor, String desc) {
        this(futureMonitor, futureMonitor.createFuture(Boolean.class), desc);
    }

    public ApplicationDependency(FutureMonitor futureMonitor, Future<Boolean> future, String desc) {
        this.futureMonitor = futureMonitor;
        this.future = future;
        this.desc = desc;
        this.seqNo = _appDepCounter.getAndIncrement();
    }

    public Future<Boolean> getFuture() {
        return this.future;
    }

    public void setResult(boolean result) {
        this.futureMonitor.setResult(this.future, (Object)result);
    }

    public void setResult(Throwable t) {
        this.futureMonitor.setResult(this.future, t);
    }

    public void onCompletion(CompletionListener<Boolean> completionListener) {
        this.futureMonitor.onCompletion(this.future, completionListener);
    }

    public String toString() {
        return "AppDep[" + this.seqNo + "]: desc=\"" + this.desc + "\", future=" + this.future;
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public void successfulCompletion(Future<Boolean> future, Boolean result) {
        this.setResult(result);
    }

    public void failedCompletion(Future<Boolean> future, Throwable t) {
        this.setResult(t);
    }
}

