/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.data.AuthData;
import com.ibm.websphere.security.auth.data.AuthDataProvider;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.intfc.SubjectManagerService;
import com.ibm.ws.security.jca.AuthDataService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.auth.callback.WSMappingCallbackHandler;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthDataServiceImpl
implements AuthDataService {
    protected static final String CFG_KEY_ID = "id";
    protected static final String CFG_KEY_DISPLAY_ID = "config.displayId";
    protected static final String CFG_KEY_USER = "user";
    protected static final String CFG_KEY_PASSWORD = "password";
    protected static final String KEY_SECURITY_SERVICE = "securityService";
    private static final String KEY_AUTH_DATA_ALIAS = "com.ibm.mapping.authDataAlias";
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    private final AtomicServiceReference<AuthDataProvider> authDataProviderRef = new AtomicServiceReference("authDataProvider");
    private final AtomicServiceReference<SubjectManagerService> smServiceRef = new AtomicServiceReference("subjectManagerService");
    static final long serialVersionUID = -9052984373888328488L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(service=SecurityService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    protected void setAuthDataProvider(ServiceReference<AuthDataProvider> reference) {
        this.authDataProviderRef.setReference(reference);
    }

    protected void unsetAuthDataProvider(ServiceReference<AuthDataProvider> reference) {
        this.authDataProviderRef.unsetReference(reference);
    }

    protected void setSubjectManagerService(ServiceReference<SubjectManagerService> reference) {
        this.smServiceRef.setReference(reference);
    }

    protected void unsetSubjectManagerService(ServiceReference<SubjectManagerService> reference) {
        this.smServiceRef.unsetReference(reference);
    }

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.authDataProviderRef.activate(cc);
        this.securityServiceRef.activate(cc);
        this.smServiceRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.authDataProviderRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
        this.smServiceRef.deactivate(cc);
    }

    @Override
    public Subject getSubject(ManagedConnectionFactory managedConnectionFactory, String jaasEntryName, Map<String, Object> loginData) throws LoginException {
        if (jaasEntryName != null) {
            return this.createSubjectUsingJAAS(jaasEntryName, managedConnectionFactory, loginData);
        }
        return this.createSubjectUsingAuthData(managedConnectionFactory, loginData);
    }

    private Subject createSubjectUsingJAAS(String jaasEntryName, ManagedConnectionFactory managedConnectionFactory, Map<String, Object> loginData) throws LoginException {
        WSMappingCallbackHandler callbackHandler = new WSMappingCallbackHandler(loginData, managedConnectionFactory);
        LoginContext loginContext = new LoginContext(jaasEntryName, (CallbackHandler)callbackHandler);
        loginContext.login();
        Subject subject = loginContext.getSubject();
        this.addInvocationSubjectPrincipal(subject);
        return subject;
    }

    private Subject createSubjectUsingAuthData(ManagedConnectionFactory managedConnectionFactory, Map<String, Object> loginData) throws LoginException {
        String authDataAlias = this.getAuthDataAlias(loginData);
        AuthData authData = this.getAuthData(authDataAlias);
        return this.obtainSubject(managedConnectionFactory, authData);
    }

    private String getAuthDataAlias(Map<String, Object> loginData) {
        return loginData != null ? (String)loginData.get(KEY_AUTH_DATA_ALIAS) : null;
    }

    private AuthData getAuthData(String authDataAlias) throws LoginException {
        AuthDataProvider authDataProvider = (AuthDataProvider)this.authDataProviderRef.getService();
        return AuthDataProvider.getAuthData((String)authDataAlias);
    }

    private Subject obtainSubject(ManagedConnectionFactory managedConnectionFactory, AuthData authData) {
        Subject subject = this.createSubject(managedConnectionFactory, authData);
        this.addInvocationSubjectPrincipal(subject);
        this.optimize(subject);
        return subject;
    }

    private Subject createSubject(ManagedConnectionFactory managedConnectionFactory, AuthData authData) {
        Subject subject = new Subject();
        String userName = authData.getUserName();
        char[] password = authData.getPassword();
        PasswordCredential passwordCredential = new PasswordCredential(userName, password);
        passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
        subject.getPrivateCredentials().add(passwordCredential);
        return subject;
    }

    private void addInvocationSubjectPrincipal(Subject subject) {
        WSPrincipal principal = this.getInvocationSubjectPrincipal();
        if (principal != null) {
            subject.getPrincipals().add((Principal)principal);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private WSPrincipal getInvocationSubjectPrincipal() {
        Subject finalInvocationSubject;
        WSPrincipal principal = null;
        SubjectManagerService sms = (SubjectManagerService)this.smServiceRef.getService();
        if (sms != null && (finalInvocationSubject = sms.getInvocationSubject()) != null) {
            try {
                principal = AccessController.doPrivileged(new PrivilegedAction<WSPrincipal>(){
                    static final long serialVersionUID = 7266691294050415803L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public WSPrincipal run() {
                        WSPrincipal invocationSubjectPrincipal = finalInvocationSubject.getPrincipals(WSPrincipal.class).iterator().next();
                        return new WSPrincipal(invocationSubjectPrincipal.getName(), invocationSubjectPrincipal.getAccessId(), invocationSubjectPrincipal.getAuthenticationMethod());
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return principal;
    }

    private void optimize(Subject subject) {
        subject.setReadOnly();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AuthDataServiceImpl.class);
    }
}

