/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.web.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.config.CacheHandler;
import com.ibm.ws.cache.config.CacheInstance;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigErrorHandler;
import com.ibm.ws.cache.config.ElementHandler;
import com.ibm.ws.cache.config.RuleHandler;
import com.ibm.ws.cache.servlet.ServletCacheEngine;
import com.ibm.ws.cache.web.config.ConfigFileEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@Component(service={ConfigManager.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ConfigManager {
    private static TraceComponent tc = Tr.register(ConfigManager.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    static final String CACHE_SPEC = "cachespec.xml";
    static final String CACHE_SPEC_DTD = "cachespec.dtd";
    static final String CACHE_SPEC_XSD = "cachespec.xsd";
    static final String WEB_INF_CACHESPEC_XML = "/WEB-INF/cachespec.xml";
    static final String META_INF_CACHESPEC_XML = "/META-INF/cachespec.xml";
    public static final String SIMPLE_FILE_SERVLET = "com.ibm.ws.webcontainer.servlet.SimpleFileServlet.class";
    public static final String DEFAULT_EXTENSION_PROCESSOR_IMPL = "com.ibm.ws.webcontainer.osgi.extension.DefaultExtensionProcessor.class";
    private static StringBuilder cachespecDTDContents = new StringBuilder();
    private static StringBuilder cachespecXSDContents = new StringBuilder();
    private List<CacheInstance> globalCacheInstances = new ArrayList<CacheInstance>();
    private List<ConfigEntry> globalCacheEntries = new ArrayList<ConfigEntry>();
    private HashMap<String, ConfigEntry> entryCache = new HashMap();
    private HashMap<String, ConfigEntry> servletConfigEntries = new HashMap();
    private MultiProcessorPool processorPool = new MultiProcessorPool();
    private static ConfigManager instance;

    public static ConfigManager getInstance() {
        return instance;
    }

    @Activate
    protected void activate(BundleContext bc) {
        BufferedReader in = null;
        InputStreamReader isr = null;
        in = null;
        if (cachespecDTDContents.length() == 0) {
            try {
                URL u = bc.getBundle().getEntry("/META-INF/cachespec.dtd");
                if (u != null) {
                    String inputLine;
                    isr = new InputStreamReader(u.openStream(), "UTF-8");
                    in = new BufferedReader(isr);
                    while ((inputLine = in.readLine()) != null) {
                        cachespecDTDContents.append(inputLine);
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                try {
                    if (isr != null) {
                        isr.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e1) {
                    FFDCFilter.processException((Throwable)e1, (String)(this.getClass().getName() + ".activated()"), (String)"93");
                }
            }
        }
        instance = this;
    }

    @Deactivate
    protected void deactivate() {
        this.globalCacheEntries.clear();
        this.globalCacheInstances.clear();
        this.entryCache.clear();
        this.servletConfigEntries.clear();
        this.processorPool.removePools();
        instance = null;
    }

    public ConfigEntry getServletConfigEntry(Object s, String uri, String contextRoot) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getServletCacheEntry() uri=" + uri + " contextRoot=" + contextRoot), (Object[])new Object[0]);
        }
        Class<?> sClazz = s.getClass();
        String clazzName = sClazz.getName() + ".class";
        ConfigEntry ce = null;
        if (uri != null) {
            ce = this.servletConfigEntries.get(uri);
        }
        if (ce == null) {
            String key = contextRoot == null ? clazzName : contextRoot + "/" + clazzName;
            ce = this.servletConfigEntries.get(key);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("using config entry: " + ce), (Object[])new Object[0]);
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry getConfigEntry(Object s, String name, String contextRoot) {
        Class<?> sClazz;
        String entryCacheKey;
        ConfigEntry ce;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheEntry() name=" + name + " contextRoot=" + contextRoot), (Object[])new Object[0]);
        }
        if ((ce = this.entryCache.get(entryCacheKey = (sClazz = s.getClass()).getName() + (name != null ? name : "null") + (contextRoot != null ? contextRoot : "null"))) == null) {
            String prefixedClazzName;
            String clazzName = sClazz.getName() + ".class";
            String string = prefixedClazzName = contextRoot == null ? clazzName : contextRoot + "/" + clazzName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Searching config entries for 1of2 " + name), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Searching config entries for 2of2 " + prefixedClazzName), (Object[])new Object[0]);
            }
            List<ConfigEntry> list = this.globalCacheEntries;
            synchronized (list) {
                for (int i = 0; i < this.globalCacheEntries.size() && ce == null; ++i) {
                    ConfigEntry te = this.globalCacheEntries.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checking " + te.className + " " + te.name + ": " + te.allNames), (Object[])new Object[0]);
                    }
                    if (!te.allNames.contains(name) && !te.allNames.contains(prefixedClazzName)) continue;
                    ce = (ConfigEntry)te.clone();
                    HashMap<String, ConfigEntry> hashMap = this.entryCache;
                    synchronized (hashMap) {
                        this.entryCache.put(entryCacheKey, ce);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getCacheEntry: entryCacheKey=" + entryCacheKey + " cacheEntry=" + ce.toString()), (Object[])new Object[0]);
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Config Entry cached using key " + entryCacheKey), (Object[])new Object[0]);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("using config entry: " + ce), (Object[])new Object[0]);
            }
        }
        return ce;
    }

    public ConfigEntry getConfigEntry(Object s, String name) {
        return this.getConfigEntry(s, name, null);
    }

    public CacheProcessor getCacheProcessor(ConfigEntry ce) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCacheProcessor", (Object[])new Object[0]);
        }
        if (ce == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("iClassName=" + ce.iClassName), (Object[])new Object[0]);
        }
        CacheProcessor cp = ce.iClassName == 5 || ce.iClassName == 6 ? (CacheProcessor)this.processorPool.pools[1].remove() : (CacheProcessor)this.processorPool.pools[ce.iClassName].remove();
        cp.reset(ce);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCacheProcessor: " + cp));
        }
        return cp;
    }

    public void returnCacheProcessor(CacheProcessor cp) {
        ConfigEntry configEntry = cp.getConfigEntry();
        if (configEntry.iClassName == 5 || configEntry.iClassName == 6) {
            this.processorPool.pools[1].add(cp);
        } else {
            this.processorPool.pools[configEntry.iClassName].add(cp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfig(ServletContext sc, String appName, HashMap appContext) {
        URL u;
        block34: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"loadConfig()", (Object[])new Object[]{sc, appName, appContext});
            }
            u = null;
            try {
                u = sc.getResource(WEB_INF_CACHESPEC_XML);
                if (null == u) {
                    u = sc.getResource(META_INF_CACHESPEC_XML);
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block34;
                Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object[])new Object[]{ex});
            }
        }
        if (null != u) {
            ConfigFileEntry cf = new ConfigFileEntry();
            cf.appContext = appContext;
            cf.appName = appName;
            CacheHandler cacheHandler = new CacheHandler(appName, appContext);
            String configFileName = u.toString();
            String fileName = u.toString();
            InputStream in = null;
            try {
                XMLReader xmlreader = null;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                xmlreader = saxParser.getXMLReader();
                RuleHandler ruleHandler = new RuleHandler();
                ruleHandler.addRule("cache", (ElementHandler)cacheHandler);
                xmlreader.setContentHandler((ContentHandler)ruleHandler);
                xmlreader.setErrorHandler((ErrorHandler)new ConfigErrorHandler(u));
                if (!this.determineCachespecXSD(u)) {
                    xmlreader.setFeature("http://apache.org/xml/features/validation/schema", true);
                    xmlreader.setEntityResolver(new CacheSpecEntityResolver());
                }
                cacheHandler.setFilename(configFileName);
                in = u.openStream();
                InputSource is = new InputSource(in);
                xmlreader.parse(is);
                this.updateCacheInstances(cf, cacheHandler, configFileName);
                this.updateEntries(cf, cacheHandler, configFileName);
            }
            catch (SAXParseException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cache.config.ConfigManager.loadConfig", (String)"295", (Object)this);
                String msg = exception.getMessage();
                String line = Integer.toString(exception.getLineNumber());
                String col = Integer.toString(exception.getColumnNumber());
                Tr.error((TraceComponent)tc, (String)"DYNA0045E", (Object[])new Object[]{msg, fileName, line, col});
                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object[])new Object[]{fileName + " (" + configFileName + ")"});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object[])new Object[]{exception});
                }
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.ConfigManager.loadConfig", (String)"303", (Object)this);
                FFDCFilter.processException((Throwable)ConfigManager.unwindException(ex), (String)"com.ibm.ws.cache.config.ConfigManager.loadConfig", (String)"304", (Object)this);
                Tr.error((TraceComponent)tc, (String)"DYNA0046E", (Object[])new Object[]{ex.getMessage(), fileName});
                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object[])new Object[]{fileName + " (" + configFileName + ")"});
                ArrayList configEntries = cacheHandler.getEntries();
                if (configEntries != null) {
                    for (ConfigEntry cEntry : configEntries) {
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object[])new Object[]{ex});
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.ConfigManager.loadConfig", (String)"308", (Object)this);
                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object[])new Object[]{fileName + " (" + configFileName + ")"});
                ArrayList configEntries = cacheHandler.getEntries();
                if (configEntries != null) {
                    for (ConfigEntry cEntry : configEntries) {
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object[])new Object[]{ex});
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".loadConfig()"), (String)"294");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadConfig()", (Object)true);
        }
        return true;
    }

    private boolean determineCachespecXSD(URL u) {
        BufferedReader in = null;
        InputStreamReader isr = null;
        in = null;
        boolean schema = false;
        try {
            if (u != null) {
                String inputLine;
                isr = new InputStreamReader(u.openStream(), "UTF-8");
                in = new BufferedReader(isr);
                while ((inputLine = in.readLine()) != null) {
                    if (inputLine.contains(CACHE_SPEC_XSD)) {
                        schema = true;
                        break;
                    }
                    if (!inputLine.contains(CACHE_SPEC_DTD)) continue;
                    schema = false;
                    break;
                }
                in.close();
                if (schema) {
                    cachespecDTDContents = cachespecXSDContents;
                }
            }
        }
        catch (IOException e) {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e1) {
                FFDCFilter.processException((Throwable)e1, (String)(this.getClass().getName() + ".determineCachespec()"), (String)"93");
            }
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries(ConfigFileEntry configFileEntry, CacheHandler cacheHandler, String configFileName) {
        configFileEntry.configEntries = cacheHandler.getEntries();
        WebAppConfig webAppConfig = null;
        if (configFileEntry.appContext != null) {
            webAppConfig = (WebAppConfig)configFileEntry.appContext.get("webAppConfiguration");
        }
        Set servletMappingEntries = null;
        if (null != webAppConfig) {
            servletMappingEntries = webAppConfig.getServletMappings().entrySet();
        }
        Iterator<ConfigEntry> it = configFileEntry.configEntries.iterator();
        while (it.hasNext()) {
            ConfigEntry cEntry = it.next();
            if (null != servletMappingEntries && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Servlet caching enabled for " + webAppConfig.getContextRoot()), (Object[])new Object[0]);
            }
            ServletCacheEngine.contextRootsWithCachespecXMLs.add(webAppConfig.getContextRoot());
            if (!this.preProcessEntry(cEntry)) {
                it.remove();
                continue;
            }
            cEntry.appName = configFileEntry.appName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cache policy:" + cEntry), (Object[])new Object[0]);
            }
            try {
                if (!cEntry.className.equalsIgnoreCase("static") && !cEntry.name.endsWith(SIMPLE_FILE_SERVLET)) continue;
                String contextRoot = null;
                if (configFileEntry.appContext != null) {
                    contextRoot = (String)configFileEntry.appContext.get("servlet");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateEntries: contextRoot:" + contextRoot), (Object[])new Object[0]);
                    }
                    if (contextRoot != null) {
                        if (contextRoot.endsWith("/") && contextRoot.length() > 2) {
                            contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("updateEntries: invoking addStaticContentPolicy:" + contextRoot), (Object[])new Object[0]);
                            }
                        }
                        ServletCacheEngine.addStaticContentPolicy(contextRoot);
                    }
                }
                if (contextRoot == null) {
                    int pos = cEntry.name.indexOf("/", 1);
                    if (pos == -1) {
                        ServletCacheEngine.addStaticContentPolicy("/");
                    } else {
                        contextRoot = cEntry.name.substring(0, pos);
                        if (!contextRoot.startsWith("/")) {
                            contextRoot = "/" + contextRoot;
                        }
                        ServletCacheEngine.addStaticContentPolicy(contextRoot);
                    }
                }
                String altCEName = String.copyValueOf(cEntry.name.toCharArray());
                String alternateName = altCEName.replace(SIMPLE_FILE_SERVLET, DEFAULT_EXTENSION_PROCESSOR_IMPL);
                cEntry.allNames.add(alternateName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Added " + alternateName + " to " + cEntry.name + " alternative names list: "), (Object[])new Object[0]);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.ConfigManager.checkConfig", (String)"110", (Object)this);
            }
        }
        this.globalCacheEntries.addAll(configFileEntry.configEntries);
        HashMap<String, ConfigEntry> newServletConfigEntries = null;
        for (int i = 0; i < this.globalCacheEntries.size(); ++i) {
            ConfigEntry tmpConfigEntry = this.globalCacheEntries.get(i);
            if (tmpConfigEntry.iClassName != 1 && tmpConfigEntry.iClassName != 3 && tmpConfigEntry.iClassName != 5) continue;
            if (newServletConfigEntries == null) {
                newServletConfigEntries = new HashMap<String, ConfigEntry>();
            }
            if (tmpConfigEntry == null) continue;
            Iterator ite = tmpConfigEntry.allNames.iterator();
            while (ite.hasNext()) {
                String name;
                ConfigEntry cloneConfigEntry = (ConfigEntry)tmpConfigEntry.clone();
                cloneConfigEntry.name = name = (String)ite.next();
                newServletConfigEntries.put(name, cloneConfigEntry);
                if (tmpConfigEntry.iClassName != 5) continue;
                Tr.debug((TraceComponent)tc, (String)("ServletConfigEntry " + name), (Object[])new Object[0]);
            }
        }
        if (newServletConfigEntries == null) {
            this.servletConfigEntries.clear();
        } else {
            this.servletConfigEntries = newServletConfigEntries;
        }
        Tr.debug((TraceComponent)tc, (String)("servletConfigEntries: \n" + this.servletConfigEntries.toString()), (Object[])new Object[0]);
        HashMap<String, ConfigEntry> hashMap = this.entryCache;
        synchronized (hashMap) {
            this.entryCache.clear();
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"updateEntries entryCache cleared", (Object[])new Object[0]);
            }
        }
        configFileEntry.appContext.remove("webAppConfiguration");
        Tr.info((TraceComponent)tc, (String)"DYNA0047I", (Object[])new Object[]{configFileName});
    }

    private void updateCacheInstances(ConfigFileEntry cf, CacheHandler cacheHandler, String configFileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateCacheInstance", (Object[])new Object[0]);
        }
        cf.cacheInstances = cacheHandler.getInstances();
        for (CacheInstance cInstance : cf.cacheInstances) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("cache instance:" + cInstance), (Object[])new Object[0]);
        }
        this.globalCacheInstances.addAll(cf.cacheInstances);
        Tr.info((TraceComponent)tc, (String)"DYNA0062I", (Object[])new Object[]{configFileName});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateCacheInstance");
        }
    }

    public List<CacheInstance> getCacheInstances() {
        return this.globalCacheInstances;
    }

    public List<ConfigEntry> getEntries() {
        return this.globalCacheEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigEntry> getCacheEntries(String instanceName) {
        ArrayList<ConfigEntry> cacheEntries = new ArrayList<ConfigEntry>();
        List<ConfigEntry> list = this.globalCacheEntries;
        synchronized (list) {
            Iterator<ConfigEntry> it = this.globalCacheEntries.iterator();
            if (instanceName == null) {
                while (it.hasNext()) {
                    ConfigEntry ce = it.next();
                    if (ce.instanceName != null) continue;
                    cacheEntries.add(ce);
                }
            } else {
                while (it.hasNext()) {
                    ConfigEntry ce = it.next();
                    if (ce.instanceName == null || !ce.instanceName.equals(instanceName)) continue;
                    cacheEntries.add(ce);
                }
            }
        }
        return cacheEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppNameCacheEntries(String appName) {
        Iterator<Object> it;
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("deleteAppNameCacheEntries appName=" + appName), (Object[])new Object[0]);
        }
        int i = 0;
        Object object = this.globalCacheEntries;
        synchronized (object) {
            it = this.globalCacheEntries.iterator();
            while (it.hasNext()) {
                ConfigEntry ce = it.next();
                if (ce.appName == null || !ce.appName.equals(appName)) continue;
                it.remove();
                ++i;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deleted " + i + " cache entries"), (Object[])new Object[0]);
        }
        object = this.entryCache;
        synchronized (object) {
            it = this.entryCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pairs = (Map.Entry)it.next();
                String key = (String)pairs.getKey();
                ConfigEntry ce = (ConfigEntry)pairs.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("deleteAppNameCacheEntries() " + key + "=" + ce.toString()), (Object[])new Object[0]);
                }
                if (ce.appName == null || !ce.appName.equals(appName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("deleteAppNameCacheEntries() removing cacheEntry=" + ce.name + " appName=" + appName + " key=" + key), (Object[])new Object[0]);
                }
                it.remove();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("deleteAppNameCacheEntries " + appName));
        }
    }

    protected boolean preProcessEntry(ConfigEntry configEntry) {
        boolean valid = true;
        if (configEntry.className.equalsIgnoreCase("servlet")) {
            configEntry.iClassName = 1;
        } else if (configEntry.className.equalsIgnoreCase("command")) {
            configEntry.iClassName = 2;
        } else if (configEntry.className.equalsIgnoreCase("webservice")) {
            configEntry.iClassName = 3;
        } else if (configEntry.className.equalsIgnoreCase("static")) {
            configEntry.iClassName = 5;
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA0050E", (Object[])new Object[]{configEntry.className, "class"});
            valid = false;
        }
        if (valid) {
            CacheProcessor cp = this.getCacheProcessor(configEntry);
            valid = cp.preProcess(configEntry);
            this.returnCacheProcessor(cp);
        }
        return valid;
    }

    public static Throwable unwindException(Throwable th) {
        if (th.getCause() != null) {
            return ConfigManager.unwindException(th.getCause());
        }
        return th;
    }

    static class MultiProcessorPool {
        CacheProcessorPool[] pools = new CacheProcessorPool[16];

        MultiProcessorPool() {
            this.addPool(1, "com.ibm.ws.cache.servlet.FragmentCacheProcessor");
            this.addPool(3, "com.ibm.ws.cache.servlet.WebServicesCacheProcessor");
            this.addPool(2, "com.ibm.ws.cache.command.CommandCacheProcessor");
        }

        public void removePools() {
            this.pools[1] = null;
            this.pools[3] = null;
            this.pools[2] = null;
        }

        public void addPool(int index, String className) {
            try {
                this.pools[index] = new CacheProcessorPool(100, className);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.ConfigManager.MultiProcessorPool", (String)"402", (Object)this);
            }
        }
    }

    static class CacheProcessorPool
    extends ObjectPool {
        Class myClass;

        public CacheProcessorPool(int size, String className) {
            super("CommandCacheProcessorPool", size);
            try {
                this.myClass = ConfigManager.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", (String)"378", (Object)((Object)this));
            }
        }

        protected Object createObject() {
            try {
                return this.myClass.newInstance();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", (String)"382", (Object)((Object)this));
                return null;
            }
        }

        public boolean add(CacheProcessor cp) {
            cp.reset(null);
            return super.add((Object)cp);
        }
    }

    static class CacheSpecEntityResolverXSD
    implements EntityResolver {
        CacheSpecEntityResolverXSD() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CacheSpecEntityResolver: ", (Object[])new Object[]{cachespecXSDContents.toString()});
            }
            return new InputSource(new StringReader(cachespecXSDContents.toString()));
        }
    }

    static class CacheSpecEntityResolver
    implements EntityResolver {
        CacheSpecEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CacheSpecEntityResolver: ", (Object[])new Object[]{cachespecDTDContents.toString()});
            }
            return new InputSource(new StringReader(cachespecDTDContents.toString()));
        }
    }
}

