/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.utils.UriEncoder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.servlet.BaseUrlHelper;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class HttpUtils {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(HttpUtils.class);
    private static final Logger LOG = LogUtils.getL7dLogger(HttpUtils.class);
    private static final String REQUEST_PATH_TO_MATCH = "path_to_match";
    private static final String REQUEST_PATH_TO_MATCH_SLASH = "path_to_match_slash";
    private static final String HTTP_SCHEME = "http";
    private static final String LOCAL_HOST_IP_ADDRESS = "127.0.0.1";
    private static final String ANY_IP_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final Pattern ENCODE_PATTERN = Pattern.compile("%[0-9a-fA-F][0-9a-fA-F]");
    private static final String CHARSET_PARAMETER = "charset";
    private static final String PATH_RESERVED_CHARACTERS = "=@/:!$&'(),;~";
    private static final String QUERY_RESERVED_CHARACTERS = "?/,";
    static final long serialVersionUID = -6003083994159694401L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String urlDecode(String value, String enc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "urlDecode", new Object[]{value, enc});
        }
        String string = UrlUtils.urlDecode((String)value, (String)enc);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "urlDecode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String urlDecode(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "urlDecode", new Object[]{value});
        }
        String string = UrlUtils.urlDecode((String)value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "urlDecode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String pathDecode(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "pathDecode", new Object[]{value});
        }
        String string = UrlUtils.pathDecode((String)value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "pathDecode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String componentEncode(String reservedChars, String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "componentEncode", new Object[]{reservedChars, value});
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder bufferToEncode = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (reservedChars.indexOf(currentChar) != -1) {
                if (bufferToEncode.length() > 0) {
                    buffer.append(HttpUtils.urlEncode(bufferToEncode.toString()));
                    bufferToEncode.setLength(0);
                }
                buffer.append(currentChar);
                continue;
            }
            bufferToEncode.append(currentChar);
        }
        if (bufferToEncode.length() > 0) {
            buffer.append(HttpUtils.urlEncode(bufferToEncode.toString()));
        }
        String string = buffer.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "componentEncode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String queryEncode(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "queryEncode", new Object[]{value});
        }
        String string = HttpUtils.componentEncode(QUERY_RESERVED_CHARACTERS, value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "queryEncode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String urlEncode(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "urlEncode", new Object[]{value});
        }
        String string = HttpUtils.urlEncode(value, "UTF-8");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "urlEncode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String urlEncode(String value, String enc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "urlEncode", new Object[]{value, enc});
        }
        String string = UrlUtils.urlEncode((String)value, (String)enc);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "urlEncode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String pathEncode(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "pathEncode", new Object[]{value});
        }
        String result = HttpUtils.componentEncode(PATH_RESERVED_CHARACTERS, value);
        if (result.indexOf(43) != -1) {
            result = result.replace("+", "%20");
        }
        if (result.indexOf("%2B") != -1) {
            result = result.replace("%2B", "+");
        }
        String string = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "pathEncode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPartiallyEncoded(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "isPartiallyEncoded", new Object[]{value});
        }
        boolean bl = ENCODE_PATTERN.matcher(value).find();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "isPartiallyEncoded", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String encodePartiallyEncoded(String encoded, boolean query) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "encodePartiallyEncoded", new Object[]{encoded, query});
        }
        if (encoded.length() == 0) {
            String string = encoded;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "encodePartiallyEncoded", string);
            }
            return string;
        }
        Matcher m = ENCODE_PATTERN.matcher(encoded);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (m.find()) {
            String before = encoded.substring(i, m.start());
            sb.append(query ? HttpUtils.queryEncode(before) : HttpUtils.pathEncode(before));
            sb.append(m.group());
            i = m.end();
        }
        String tail = encoded.substring(i, encoded.length());
        sb.append(query ? HttpUtils.queryEncode(tail) : HttpUtils.pathEncode(tail));
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "encodePartiallyEncoded", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SimpleDateFormat getHttpDateFormat() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getHttpDateFormat", new Object[0]);
        }
        SimpleDateFormat simpleDateFormat = Headers.getHttpDateFormat();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            simpleDateFormat = simpleDateFormat;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHttpDateFormat", simpleDateFormat);
        }
        return simpleDateFormat;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toHttpDate(Date date) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "toHttpDate", new Object[]{date});
        }
        String string = Headers.toHttpDate((Date)date);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "toHttpDate", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static RuntimeDelegate getOtherRuntimeDelegate() {
        RuntimeDelegate runtimeDelegate;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getOtherRuntimeDelegate", new Object[0]);
            }
            try {
                RuntimeDelegate rd = RuntimeDelegate.getInstance();
                runtimeDelegate = rd instanceof RuntimeDelegateImpl ? null : rd;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable rd) {
                FFDCFilter.processException((Throwable)rd, (String)"org.apache.cxf.jaxrs.utils.HttpUtils", (String)"196", null, (Object[])new Object[0]);
                RuntimeDelegate runtimeDelegate2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    runtimeDelegate2 = runtimeDelegate2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getOtherRuntimeDelegate", runtimeDelegate2);
                }
                return runtimeDelegate2;
            }
            runtimeDelegate = runtimeDelegate;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getOtherRuntimeDelegate", runtimeDelegate);
        }
        return runtimeDelegate;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static RuntimeDelegate.HeaderDelegate<Object> getHeaderDelegate(Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getHeaderDelegate", new Object[]{o});
        }
        RuntimeDelegate.HeaderDelegate<Object> headerDelegate = HttpUtils.getHeaderDelegate(HttpUtils.getOtherRuntimeDelegate(), o);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            headerDelegate = headerDelegate;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHeaderDelegate", headerDelegate);
        }
        return headerDelegate;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static RuntimeDelegate.HeaderDelegate<Object> getHeaderDelegate(RuntimeDelegate rd, Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getHeaderDelegate", new Object[]{rd, o});
        }
        RuntimeDelegate.HeaderDelegate headerDelegate = rd == null ? null : rd.createHeaderDelegate(o.getClass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            headerDelegate = headerDelegate;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHeaderDelegate", headerDelegate);
        }
        return headerDelegate;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static <T> MultivaluedMap<String, T> getModifiableStringHeaders(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getModifiableStringHeaders", new Object[]{m});
        }
        MultivaluedMap<String, Object> headers = HttpUtils.getModifiableHeaders(m);
        HttpUtils.convertHeaderValuesToString(headers, false);
        MultivaluedMap<String, Object> multivaluedMap = headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multivaluedMap = multivaluedMap;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getModifiableStringHeaders", multivaluedMap);
        }
        return multivaluedMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static MultivaluedMap<String, Object> getModifiableHeaders(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getModifiableHeaders", new Object[]{m});
        }
        Map headers = CastUtils.cast((Map)((Map)m.get((Object)Message.PROTOCOL_HEADERS)));
        MetadataMap metadataMap = new MetadataMap(headers, false, false, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getModifiableHeaders", metadataMap);
        }
        return metadataMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void convertHeaderValuesToString(Map<String, List<Object>> headers, boolean delegateOnly) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "convertHeaderValuesToString", new Object[]{headers, delegateOnly});
        }
        if (headers == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "convertHeaderValuesToString");
            }
            return;
        }
        RuntimeDelegate rd = HttpUtils.getOtherRuntimeDelegate();
        if (rd == null && delegateOnly) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "convertHeaderValuesToString");
            }
            return;
        }
        for (Map.Entry<String, List<Object>> entry : headers.entrySet()) {
            List<Object> values = entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                if (value == null || value instanceof String) continue;
                RuntimeDelegate.HeaderDelegate<Object> hd = HttpUtils.getHeaderDelegate(rd, value);
                if (hd != null) {
                    value = hd.toString(value);
                } else if (!delegateOnly) {
                    value = value.toString();
                }
                try {
                    values.set(i, value);
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    FFDCFilter.processException((Throwable)unsupportedOperationException, (String)"org.apache.cxf.jaxrs.utils.HttpUtils", (String)"247", null, (Object[])new Object[]{headers, delegateOnly});
                    ArrayList<Object> newList = new ArrayList<Object>(values);
                    newList.set(i, value);
                    headers.put(entry.getKey(), newList);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "convertHeaderValuesToString");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Date getHttpDate(String value) {
        Date date;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getHttpDate", new Object[]{value});
            }
            if (value == null) {
                Date date2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    date2 = date2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHttpDate", date2);
                }
                return date2;
            }
            try {
                date = Headers.getHttpDateFormat().parse(value);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (ParseException parseException) {
                FFDCFilter.processException((Throwable)parseException, (String)"org.apache.cxf.jaxrs.utils.HttpUtils", (String)"268", null, (Object[])new Object[]{value});
                Date date3 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    date3 = date3;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHttpDate", date3);
                }
                return date3;
            }
            date = date;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHttpDate", date);
        }
        return date;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Locale getLocale(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getLocale", new Object[]{value});
        }
        if (value == null) {
            Locale locale = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                locale = locale;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getLocale", locale);
            }
            return locale;
        }
        String[] values = StringUtils.split((String)value, (String)"-");
        if (values.length == 0 || values.length > 2) {
            throw new IllegalArgumentException("Illegal locale value : " + value);
        }
        if (values.length == 1) {
            Locale locale = new Locale(values[0]);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                locale = locale;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getLocale", locale);
            }
            return locale;
        }
        Locale locale = new Locale(values[0], values[1]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            locale = locale;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getLocale", locale);
        }
        return locale;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static int getContentLength(String value) {
        int n;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getContentLength", new Object[]{value});
            }
            if (value == null) {
                int n2 = -1;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n2 = n2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getContentLength", n2);
                }
                return n2;
            }
            try {
                int len = Integer.valueOf(value);
                n = len >= 0 ? len : -1;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (Exception len) {
                FFDCFilter.processException((Throwable)len, (String)"org.apache.cxf.jaxrs.utils.HttpUtils", (String)"297", null, (Object[])new Object[]{value});
                int n3 = -1;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n3 = n3;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getContentLength", n3);
                }
                return n3;
            }
            n = n;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getContentLength", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getHeaderString(List<String> values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getHeaderString", new Object[]{values});
        }
        if (values == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHeaderString", string);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            if (StringUtils.isEmpty((String)value)) continue;
            sb.append(value);
            if (i + 1 >= values.size()) continue;
            sb.append(",");
        }
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getHeaderString", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isDateRelatedHeader(String headerName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "isDateRelatedHeader", new Object[]{headerName});
        }
        boolean bl = "Date".equalsIgnoreCase(headerName) || "If-Modified-Since".equalsIgnoreCase(headerName) || "If-Unmodified-Since".equalsIgnoreCase(headerName) || "Expires".equalsIgnoreCase(headerName) || "Last-Modified".equalsIgnoreCase(headerName);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "isDateRelatedHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isHttpRequest(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "isHttpRequest", new Object[]{message});
        }
        boolean bl = message.get((Object)"HTTP.REQUEST") != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "isHttpRequest", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URI toAbsoluteUri(String relativePath, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "toAbsoluteUri", new Object[]{relativePath, message});
        }
        String base = BaseUrlHelper.getBaseURL((HttpServletRequest)((HttpServletRequest)message.get((Object)"HTTP.REQUEST")));
        URI uRI = URI.create(base + relativePath);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "toAbsoluteUri", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URI toAbsoluteUri(URI u, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "toAbsoluteUri", new Object[]{u, message});
        }
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        boolean absolute = u.isAbsolute();
        if (request != null && (!absolute || HttpUtils.isLocalHostOrAnyIpAddress(u))) {
            int port;
            String serverAndPort = request.getServerName();
            boolean localAddressUsed = false;
            if (absolute) {
                if (ANY_IP_ADDRESS.equals(serverAndPort)) {
                    serverAndPort = request.getLocalAddr();
                    localAddressUsed = true;
                }
                if (LOCAL_HOST_IP_ADDRESS.equals(serverAndPort)) {
                    serverAndPort = "localhost";
                    localAddressUsed = true;
                }
            }
            int n = port = localAddressUsed ? request.getLocalPort() : request.getServerPort();
            if (port != 80) {
                serverAndPort = serverAndPort + ":" + port;
            }
            String base = request.getScheme() + "://" + serverAndPort;
            if (!absolute) {
                u = URI.create(base + u.toString());
            } else {
                int originalPort = u.getPort();
                String hostValue = u.getHost().equals(ANY_IP_ADDRESS) ? ANY_IP_ADDRESS : LOCAL_HOST_IP_ADDRESS;
                String replaceValue = originalPort == -1 ? hostValue : hostValue + ":" + originalPort;
                u = URI.create(u.toString().replace(replaceValue, serverAndPort));
            }
        }
        URI uRI = u;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "toAbsoluteUri", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isLocalHostOrAnyIpAddress(URI u) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "isLocalHostOrAnyIpAddress", new Object[]{u});
        }
        String host = u.getHost();
        boolean bl = host != null && LOCAL_HOST_IP_ADDRESS.equals(host) || ANY_IP_ADDRESS.equals(host);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "isLocalHostOrAnyIpAddress", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void resetRequestURI(Message m, String requestURI) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "resetRequestURI", new Object[]{m, requestURI});
        }
        m.remove((Object)REQUEST_PATH_TO_MATCH_SLASH);
        m.remove((Object)REQUEST_PATH_TO_MATCH);
        m.put((Object)"org.apache.cxf.request.uri", (Object)requestURI);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "resetRequestURI");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getPathToMatch(Message m, boolean addSlash) {
        int index;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getPathToMatch", new Object[]{m, addSlash});
        }
        String var = addSlash ? REQUEST_PATH_TO_MATCH_SLASH : REQUEST_PATH_TO_MATCH;
        String pathToMatch = (String)m.get((Object)var);
        if (pathToMatch != null) {
            String string = pathToMatch;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getPathToMatch", string);
            }
            return string;
        }
        String requestAddress = HttpUtils.getProtocolHeader(m, "org.apache.cxf.request.uri", "/");
        if (m.get((Object)Message.QUERY_STRING) == null && (index = requestAddress.lastIndexOf(63)) > 0 && index < requestAddress.length()) {
            m.put((Object)Message.QUERY_STRING, (Object)requestAddress.substring(index + 1));
            requestAddress = requestAddress.substring(0, index);
        }
        String baseAddress = HttpUtils.getBaseAddress(m);
        pathToMatch = HttpUtils.getPathToMatch(requestAddress, baseAddress, addSlash);
        m.put((Object)var, (Object)pathToMatch);
        String string = pathToMatch;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getPathToMatch", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getProtocolHeader(Message m, String name, String defaultValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getProtocolHeader", new Object[]{m, name, defaultValue});
        }
        String string = HttpUtils.getProtocolHeader(m, name, defaultValue, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getProtocolHeader", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getProtocolHeader(Message m, String name, String defaultValue, boolean setOnMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getProtocolHeader", new Object[]{m, name, defaultValue, setOnMessage});
        }
        String value = (String)m.get((Object)name);
        if (value == null && (value = (String)new HttpHeadersImpl(m).getRequestHeaders().getFirst((Object)name)) != null && setOnMessage) {
            m.put((Object)name, (Object)value);
        }
        String string = value == null ? defaultValue : value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getProtocolHeader", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getBaseAddress(Message m) {
        String string;
        block5: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getBaseAddress", new Object[]{m});
            }
            String endpointAddress = HttpUtils.getEndpointAddress(m);
            try {
                URI uri = new URI(endpointAddress);
                String path = uri.getRawPath();
                String scheme = uri.getScheme();
                if (scheme != null && !scheme.startsWith(HTTP_SCHEME) && HttpUtils.isHttpRequest(m)) {
                    path = HttpUtils.toAbsoluteUri(path, m).getRawPath();
                }
                string = path == null || path.length() == 0 ? "/" : path;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
            }
            catch (URISyntaxException uri) {
                FFDCFilter.processException((Throwable)uri, (String)"org.apache.cxf.jaxrs.utils.HttpUtils", (String)"432", null, (Object[])new Object[]{m});
                String string2 = endpointAddress == null ? "/" : endpointAddress;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string2 = string2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getBaseAddress", string2);
                }
                return string2;
            }
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getBaseAddress", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getEndpointAddress(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getEndpointAddress", new Object[]{m});
        }
        String address = null;
        Destination d = m.getExchange().getDestination();
        if (d != null) {
            if (d instanceof AbstractHTTPDestination) {
                EndpointInfo ei = ((AbstractHTTPDestination)d).getEndpointInfo();
                HttpServletRequest request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
                Object property = request != null ? request.getAttribute("org.apache.cxf.transport.endpoint.address") : null;
                address = property != null ? property.toString() : ei.getAddress();
            } else {
                address = m.containsKey((Object)Message.BASE_PATH) ? (String)m.get((Object)Message.BASE_PATH) : d.getAddress().getAddress().getValue();
            }
        } else {
            address = (String)m.get((Object)Message.ENDPOINT_ADDRESS);
        }
        if (address.startsWith(HTTP_SCHEME) && address.endsWith("//")) {
            address = address.substring(0, address.length() - 1);
        }
        String string = address;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getEndpointAddress", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void updatePath(Message m, String path) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "updatePath", new Object[]{m, path});
        }
        String baseAddress = HttpUtils.getBaseAddress(m);
        boolean pathSlash = path.startsWith("/");
        boolean baseSlash = baseAddress.endsWith("/");
        if (pathSlash && baseSlash) {
            path = path.substring(1);
        } else if (!pathSlash && !baseSlash) {
            path = "/" + path;
        }
        m.put((Object)"org.apache.cxf.request.uri", (Object)(baseAddress + path));
        m.remove((Object)REQUEST_PATH_TO_MATCH);
        m.remove((Object)REQUEST_PATH_TO_MATCH_SLASH);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "updatePath");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getPathToMatch(String path, String address, boolean addSlash) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getPathToMatch", new Object[]{path, address, addSlash});
        }
        String origPath = path;
        int ind = path.indexOf(address);
        if (ind == -1 && address.equals(path + "/")) {
            path = path + "/";
            ind = 0;
        }
        if (ind == 0) {
            path = path.substring(ind + address.length());
        }
        if (addSlash && !path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.equals(origPath) && origPath.contains("%")) {
            path = origPath;
            ind = path.indexOf(address = UriEncoder.encodeString(address).replace("%2F", "/"));
            if (ind == -1 && address.equals(path + "/")) {
                path = path + "/";
                ind = 0;
            }
            if (ind == 0) {
                path = path.substring(ind + address.length());
            }
            if (addSlash && !path.startsWith("/")) {
                path = "/" + path;
            }
        }
        String string = path;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getPathToMatch", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getOriginalAddress(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getOriginalAddress", new Object[]{m});
        }
        Destination d = m.getDestination();
        String string = d == null ? "/" : d.getAddress().getAddress().getValue();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getOriginalAddress", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String fromPathSegment(PathSegment ps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "fromPathSegment", new Object[]{ps});
        }
        if (PathSegmentImpl.class.isAssignableFrom(ps.getClass())) {
            String string = ((PathSegmentImpl)ps).getOriginalPath();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "fromPathSegment", string);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ps.getPath());
        for (Map.Entry entry : ps.getMatrixParameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                sb.append(';').append((String)entry.getKey());
                if (value == null) continue;
                sb.append('=').append(value);
            }
        }
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "fromPathSegment", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Response.Status getParameterFailureStatus(ParameterType pType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getParameterFailureStatus", new Object[]{pType});
        }
        if (pType == ParameterType.MATRIX || pType == ParameterType.PATH || pType == ParameterType.QUERY) {
            Response.Status status = Response.Status.NOT_FOUND;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                status = status;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getParameterFailureStatus", status);
            }
            return status;
        }
        Response.Status status = Response.Status.BAD_REQUEST;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            status = status;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getParameterFailureStatus", status);
        }
        return status;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getSetEncoding(MediaType mt, MultivaluedMap<String, Object> headers, String defaultEncoding) {
        String string;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getSetEncoding", new Object[]{mt, headers, defaultEncoding});
            }
            String enc = (String)mt.getParameters().get(CHARSET_PARAMETER);
            if (enc == null) {
                String string2 = defaultEncoding;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string2 = string2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getSetEncoding", string2);
                }
                return string2;
            }
            try {
                "0".getBytes(enc);
                string = enc;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"org.apache.cxf.jaxrs.utils.HttpUtils", (String)"552", null, (Object[])new Object[]{mt, headers, defaultEncoding});
                String message = new org.apache.cxf.common.i18n.Message("UNSUPPORTED_ENCODING", BUNDLE, new Object[]{enc, defaultEncoding}).toString();
                LOG.warning(message);
                headers.putSingle((Object)"Content-Type", (Object)(JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[]{CHARSET_PARAMETER}) + ';' + CHARSET_PARAMETER + "=" + (defaultEncoding == null ? "UTF-8" : defaultEncoding)));
                String string3 = defaultEncoding;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string3 = string3;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getSetEncoding", string3);
                }
                return string3;
            }
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getSetEncoding", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getEncoding(MediaType mt, String defaultEncoding) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "getEncoding", new Object[]{mt, defaultEncoding});
        }
        String charset = mt == null ? defaultEncoding : (String)mt.getParameters().get(CHARSET_PARAMETER);
        String string = charset == null ? defaultEncoding : charset;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "getEncoding", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URI resolve(UriBuilder baseBuilder, URI uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "resolve", new Object[]{baseBuilder, uri});
        }
        if (!uri.isAbsolute()) {
            URI uRI = baseBuilder.build(new Object[0]).resolve(uri);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRI = uRI;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "resolve", uRI);
            }
            return uRI;
        }
        URI uRI = uri;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "resolve", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URI relativize(URI base, URI uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "relativize", new Object[]{base, uri});
        }
        if (!base.isAbsolute() || !uri.isAbsolute()) {
            URI uRI = uri;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRI = uRI;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "relativize", uRI);
            }
            return uRI;
        }
        if (base.isOpaque() || uri.isOpaque()) {
            URI uRI = uri;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRI = uRI;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "relativize", uRI);
            }
            return uRI;
        }
        URI root = base.resolve("/");
        if (!root.equals(uri.resolve("/"))) {
            URI uRI = uri;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRI = uRI;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "relativize", uRI);
            }
            return uRI;
        }
        URI baseRel = URI.create("/").resolve(root.relativize(base));
        URI uriRel = URI.create("/").resolve(root.relativize(uri));
        if (baseRel.getPath().equals(uriRel.getPath())) {
            URI uRI = baseRel.relativize(uriRel);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRI = uRI;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "relativize", uRI);
            }
            return uRI;
        }
        URI commonBase = baseRel.resolve("./");
        if (commonBase.equals(uriRel.resolve("./"))) {
            URI uRI = commonBase.relativize(uriRel);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRI = uRI;
                LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "relativize", uRI);
            }
            return uRI;
        }
        URI relative = URI.create("");
        while (!uriRel.getPath().startsWith(commonBase.getPath()) && !commonBase.getPath().equals("/")) {
            commonBase = commonBase.resolve("../");
            relative = relative.resolve("../");
        }
        URI relToCommon = commonBase.relativize(uriRel);
        URI uRI = relative.resolve(relToCommon);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "relativize", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toHttpLanguage(Locale locale) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.HttpUtils", "toHttpLanguage", new Object[]{locale});
        }
        String string = Headers.toHttpLanguage((Locale)locale);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.HttpUtils", "toHttpLanguage", string);
        }
        return string;
    }
}

