/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.cache.LibertyJaxRsProviderCache;
import com.ibm.ws.jaxrs20.component.LibertyJaxRsThreadPoolAdapter;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.providers.jsonp.JsonPProvider;
import com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingService;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.ws.rs.Produces;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorMBR;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.ClassPair;
import org.apache.cxf.jaxrs.provider.DataSourceProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementSubProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.provider.StringProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProviderWrapper;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class ProviderFactory {
    public static final String DEFAULT_FILTER_NAME_BINDING = "org.apache.cxf.filter.binding";
    public static final String PROVIDER_SELECTION_PROPERTY_CHANGED = "provider.selection.property.changed";
    public static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    protected static final String SERVER_FACTORY_NAME = "org.apache.cxf.jaxrs.provider.ServerProviderFactory";
    protected static final String CLIENT_FACTORY_NAME = "org.apache.cxf.jaxrs.client.ClientProviderFactory";
    protected static final String IGNORE_TYPE_VARIABLES = "org.apache.cxf.jaxrs.providers.ignore.typevars";
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private static final String JAXB_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JAXBElementProvider";
    private static final String JSON_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.json.JSONProvider";
    private static final String BUS_PROVIDERS_ALL = "org.apache.cxf.jaxrs.bus.providers";
    private static final String JSONPCLASS = "javax.json.Json";
    protected Map<NameKey, ProviderInfo<ReaderInterceptor>> readerInterceptors;
    protected Map<NameKey, ProviderInfo<WriterInterceptor>> writerInterceptors;
    private final List<ProviderInfo<MessageBodyReader<?>>> messageReaders;
    private final List<ProviderInfo<MessageBodyWriter<?>>> messageWriters;
    private final List<ProviderInfo<ContextResolver<?>>> contextResolvers;
    private final List<ProviderInfo<ContextProvider<?>>> contextProviders;
    private List<ProviderInfo<ParamConverterProvider>> newParamConverters;
    private final Collection<ProviderInfo<?>> injectedProviders;
    private final Bus bus;
    private final ProviderFactory baseFactory;
    private Comparator<?> providerComparator;
    private static final ConcurrentHashMap<ClassPair, Type[]> genericInterfacesCache = new ConcurrentHashMap();
    private static final Type[] emptyType = new Type[0];
    private static final String[] jsonpClasses = new String[]{"javax.json.JsonArray", "javax.json.JsonObject", "javax.json.JsonStructure"};
    static final long serialVersionUID = -1244349001011715647L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ProviderFactory(ProviderFactory baseFactory, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "<init>", new Object[]{baseFactory, bus});
        }
        this.readerInterceptors = new NameKeyMap<ProviderInfo<ReaderInterceptor>>(true);
        this.writerInterceptors = new NameKeyMap<ProviderInfo<WriterInterceptor>>(true);
        this.messageReaders = new ArrayList();
        this.messageWriters = new ArrayList();
        this.contextResolvers = new ArrayList(1);
        this.contextProviders = new ArrayList(1);
        this.newParamConverters = new ArrayList<ProviderInfo<ParamConverterProvider>>(1);
        this.injectedProviders = new LinkedList();
        this.baseFactory = baseFactory;
        this.bus = bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Bus getBus() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getBus", new Object[0]);
        }
        Bus bus = this.bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bus = bus;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getBus", bus);
        }
        return bus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ProviderFactory getBaseFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getBaseFactory", new Object[0]);
        }
        ProviderFactory providerFactory = this.baseFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerFactory = providerFactory;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getBaseFactory", providerFactory);
        }
        return providerFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isBaseFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "isBaseFactory", new Object[0]);
        }
        boolean bl = this.baseFactory == null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "isBaseFactory", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void initBaseFactory(ProviderFactory factory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "initBaseFactory", new Object[]{factory});
        }
        factory.setProviders(new Object[]{new BinaryDataProvider(), new SourceProvider(), new DataSourceProvider(), new FormEncodingProvider(), new PrimitiveTextProvider(), new StringProvider(), new JAXBElementSubProvider(), ProviderFactory.createProvider(JAXB_PROVIDER_NAME), ProviderFactory.createProvider(JSON_PROVIDER_NAME), ProviderFactory.createJsonpProvider(), ProviderFactory.createJacksonProvider(), new IBMMultipartProvider(), new MultipartProvider()});
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "initBaseFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Throwable.class})
    protected static Object createProvider(String className) {
        Object t;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createProvider", new Object[]{className});
            }
            try {
                t = ClassLoaderUtils.loadClass((String)className, ProviderFactory.class).newInstance();
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable ex) {
                String message = "Problem with creating the default provider " + className;
                message = ex.getMessage() != null ? message + ": " + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
                LOG.fine(message);
                Object v1 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    v1 = v1;
                    LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createProvider", v1);
                }
                return v1;
            }
            t = t;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createProvider", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object createJsonpProvider() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createJsonpProvider", new Object[0]);
        }
        JsonPProvider provider = null;
        ClassLoader cl = ((ClassLoadingService)LibertyJaxRsThreadPoolAdapter.getClassLoadingServiceref().getServiceWithException()).createThreadContextClassLoader(ProviderFactory.class.getClassLoader());
        Class<?> c = ProviderFactory.loadClass(cl, JSONPCLASS);
        ((ClassLoadingService)LibertyJaxRsThreadPoolAdapter.getClassLoadingServiceref().getServiceWithException()).destroyThreadContextClassLoader(cl);
        if (c != null) {
            provider = new JsonPProvider();
        }
        JsonPProvider jsonPProvider = provider;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jsonPProvider = jsonPProvider;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createJsonpProvider", jsonPProvider);
        }
        return jsonPProvider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={ClassNotFoundException.class})
    public static Class<?> loadClass(ClassLoader cl, String className) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "loadClass", new Object[]{cl, className});
        }
        if (cl == null) {
            Class<?> clazz = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "loadClass", clazz);
            }
            return clazz;
        }
        Class<?> c = null;
        try {
            c = cl.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Class<?> clazz = c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "loadClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object createJacksonProvider() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createJacksonProvider", new Object[0]);
        }
        JacksonJaxbJsonProviderWrapper jacksonjaxbprovider = new JacksonJaxbJsonProviderWrapper();
        jacksonjaxbprovider.addUntouchable(DataSource.class);
        jacksonjaxbprovider.addUntouchable(File.class);
        ClassLoader cl = ((ClassLoadingService)LibertyJaxRsThreadPoolAdapter.getClassLoadingServiceref().getServiceWithException()).createThreadContextClassLoader(ProviderFactory.class.getClassLoader());
        for (String clsName : jsonpClasses) {
            Class<?> c = ProviderFactory.loadClass(cl, clsName);
            if (c == null) continue;
            jacksonjaxbprovider.addUntouchable(c);
        }
        ((ClassLoadingService)LibertyJaxRsThreadPoolAdapter.getClassLoadingServiceref().getServiceWithException()).destroyThreadContextClassLoader(cl);
        ObjectMapper mapperObject = new ObjectMapper();
        AnnotationIntrospector.Pair annotationIntrospectorPairObject = new AnnotationIntrospector.Pair((AnnotationIntrospector)new JaxbAnnotationIntrospector(), (AnnotationIntrospector)new JacksonAnnotationIntrospector());
        SerializationConfig serializationConfig = mapperObject.getSerializationConfig();
        serializationConfig.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        serializationConfig.setAnnotationIntrospector((AnnotationIntrospector)annotationIntrospectorPairObject);
        DeserializationConfig deserializationConfig = mapperObject.getDeserializationConfig();
        deserializationConfig.setAnnotationIntrospector((AnnotationIntrospector)annotationIntrospectorPairObject);
        jacksonjaxbprovider.setMapper(mapperObject);
        JacksonJaxbJsonProviderWrapper jacksonJaxbJsonProviderWrapper = jacksonjaxbprovider;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jacksonJaxbJsonProviderWrapper = jacksonJaxbJsonProviderWrapper;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createJacksonProvider", (Object)jacksonJaxbJsonProviderWrapper);
        }
        return jacksonJaxbJsonProviderWrapper;
    }

    public abstract Configuration getConfiguration(Message var1);

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextResolver", new Object[]{contextType, m});
        }
        boolean isRequestor = MessageUtils.isRequestor((Message)m);
        Message requestMessage = isRequestor ? m.getExchange().getOutMessage() : m.getExchange().getInMessage();
        Message responseMessage = isRequestor ? m.getExchange().getInMessage() : m.getExchange().getOutMessage();
        Object ctProperty = null;
        ctProperty = responseMessage != null ? responseMessage.get((Object)"Content-Type") : requestMessage.get((Object)"Content-Type");
        MediaType mt = ctProperty != null ? JAXRSUtils.toMediaType((String)ctProperty.toString()) : MediaType.WILDCARD_TYPE;
        ContextResolver<T> contextResolver = this.createContextResolver(contextType, m, mt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            contextResolver = contextResolver;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextResolver", contextResolver);
        }
        return contextResolver;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextResolver", new Object[]{contextType, m, type});
        }
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            ContextResolver<T> contextResolver = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                contextResolver = contextResolver;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextResolver", contextResolver);
            }
            return contextResolver;
        }
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ContextResolver<?>> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = ((ContextResolver)cr.getProvider()).getClass().getGenericInterfaces()) {
                List mTypes;
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls) || JAXRSUtils.intersectMimeTypes((List)(mTypes = JAXRSUtils.getProduceTypes((Produces)((ContextResolver)cr.getProvider()).getClass().getAnnotation(Produces.class))), (MediaType)type).size() <= 0) continue;
                this.injectContextValues(cr, m);
                candidates.add((ContextResolver)cr.getProvider());
            }
        }
        if (candidates.size() == 0) {
            ContextResolver<T> contextResolver = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                contextResolver = contextResolver;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextResolver", contextResolver);
            }
            return contextResolver;
        }
        if (candidates.size() == 1) {
            ContextResolver contextResolver = (ContextResolver)candidates.get(0);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                contextResolver = contextResolver;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextResolver", contextResolver);
            }
            return contextResolver;
        }
        Collections.sort(candidates, new ClassComparator());
        ContextResolverProxy contextResolverProxy = new ContextResolverProxy(candidates);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            contextResolverProxy = contextResolverProxy;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextResolver", contextResolverProxy);
        }
        return contextResolverProxy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> ContextProvider<T> createContextProvider(Type contextType, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextProvider", new Object[]{contextType, m});
        }
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            ContextProvider<T> contextProvider = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                contextProvider = contextProvider;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextProvider", contextProvider);
            }
            return contextProvider;
        }
        for (ProviderInfo<ContextProvider<?>> cr : this.contextProviders) {
            Type[] types;
            for (Type t : types = ((ContextProvider)cr.getProvider()).getClass().getGenericInterfaces()) {
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls)) continue;
                ContextProvider contextProvider = (ContextProvider)cr.getProvider();
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    contextProvider = contextProvider;
                    LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextProvider", contextProvider);
                }
                return contextProvider;
            }
        }
        ContextProvider<T> contextProvider = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            contextProvider = contextProvider;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createContextProvider", contextProvider);
        }
        return contextProvider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> ParamConverter<T> createParameterHandler(Class<T> paramType, Type genericType, Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createParameterHandler", new Object[]{paramType, genericType, anns});
        }
        if (this.newParamConverters != null) {
            anns = anns != null ? anns : new Annotation[]{};
            for (ProviderInfo<ParamConverterProvider> newParamConverter : this.newParamConverters) {
                ParamConverter converter = ((ParamConverterProvider)newParamConverter.getProvider()).getConverter(paramType, genericType, anns);
                if (converter == null) continue;
                ParamConverter paramConverter = converter;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    paramConverter = paramConverter;
                    LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createParameterHandler", paramConverter);
                }
                return paramConverter;
            }
        }
        ParamConverter<T> paramConverter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            paramConverter = paramConverter;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createParameterHandler", paramConverter);
        }
        return paramConverter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> ParamConverter<T> createParameterHandler(Class<T> paramType, Type genericType, Annotation[] anns, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createParameterHandler", new Object[]{paramType, genericType, anns, m});
        }
        if (this.newParamConverters != null) {
            anns = anns != null ? anns : new Annotation[]{};
            for (ProviderInfo<ParamConverterProvider> newParamConverter : this.newParamConverters) {
                this.injectContextValues(newParamConverter, m);
                ParamConverter converter = ((ParamConverterProvider)newParamConverter.getProvider()).getConverter(paramType, genericType, anns);
                if (converter == null) continue;
                ParamConverter paramConverter = converter;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    paramConverter = paramConverter;
                    LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createParameterHandler", paramConverter);
                }
                return paramConverter;
            }
        }
        ParamConverter<T> paramConverter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            paramConverter = paramConverter;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createParameterHandler", paramConverter);
        }
        return paramConverter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> boolean handleRWMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleRWMapper", new Object[]{em, expectedType, m, providerClass});
        }
        Class mapperClass = ClassHelper.getRealClass((Bus)this.bus, (Object)em.getOldProvider());
        Type[] types = null;
        types = m != null && MessageUtils.isTrue((Object)m.getContextualProperty(IGNORE_TYPE_VARIABLES)) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            boolean bl = false;
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                bl = bl;
                                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleRWMapper", bl);
                            }
                            return bl;
                        }
                        boolean bl = true;
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            bl = bl;
                            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleRWMapper", bl);
                        }
                        return bl;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    boolean bl = true;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        bl = bl;
                        LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleRWMapper", bl);
                    }
                    return bl;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleRWMapper", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleRWMapper", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> void handleMapper(List<T> candidates, ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, boolean injectContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleMapper", new Object[]{candidates, em, expectedType, m, providerClass, injectContext});
        }
        Class mapperClass = ClassHelper.getRealClass((Bus)this.bus, (Object)em.getOldProvider());
        Type[] types = null;
        types = m != null && MessageUtils.isTrue((Object)m.getContextualProperty(IGNORE_TYPE_VARIABLES)) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleMapper");
                            }
                            return;
                        }
                        if (injectContext) {
                            this.injectContextValues(em, m);
                        }
                        candidates.add(em.getProvider());
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleMapper");
                        }
                        return;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    if (injectContext) {
                        this.injectContextValues(em, m);
                    }
                    candidates.add(em.getProvider());
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleMapper");
                    }
                    return;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            if (injectContext) {
                this.injectContextValues(em, m);
            }
            candidates.add(em.getProvider());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "handleMapper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> List<ReaderInterceptor> createMessageBodyReaderInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, boolean checkMbrNow, Set<String> names) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyReaderInterceptor", new Object[]{bodyType, parameterType, parameterAnnotations, mediaType, m, checkMbrNow, names});
        }
        MessageBodyReader<T> mr = !checkMbrNow ? null : this.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.readerInterceptors.size();
        if (mr != null || size > 0) {
            ReaderInterceptorMBR mbrReader = new ReaderInterceptorMBR(mr, m.getExchange().getInMessage());
            List<ReaderInterceptorMBR> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<ReaderInterceptorMBR>(size + 1);
                List<ProviderInfo<T>> readers = ProviderFactory.getBoundFilters(this.readerInterceptors, names);
                for (ProviderInfo<T> p : readers) {
                    InjectionUtils.injectContexts(p.getProvider(), p, m);
                    interceptors.add((ReaderInterceptorMBR)p.getProvider());
                }
                interceptors.add(mbrReader);
            } else {
                interceptors = Collections.singletonList(mbrReader);
            }
            List<ReaderInterceptorMBR> list = interceptors;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyReaderInterceptor", list);
            }
            return list;
        }
        List<ReaderInterceptor> list = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyReaderInterceptor", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> List<WriterInterceptor> createMessageBodyWriterInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, Set<String> names) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyWriterInterceptor", new Object[]{bodyType, parameterType, parameterAnnotations, mediaType, m, names});
        }
        MessageBodyWriter<T> mw = this.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.writerInterceptors.size();
        if (mw != null || size > 0) {
            WriterInterceptorMBW mbwWriter = new WriterInterceptorMBW(mw, m);
            List<WriterInterceptorMBW> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<WriterInterceptorMBW>(size + 1);
                List<ProviderInfo<T>> writers = ProviderFactory.getBoundFilters(this.writerInterceptors, names);
                for (ProviderInfo<T> p : writers) {
                    InjectionUtils.injectContexts(p.getProvider(), p, m);
                    interceptors.add((WriterInterceptorMBW)p.getProvider());
                }
                interceptors.add(mbwWriter);
            } else {
                interceptors = Collections.singletonList(mbwWriter);
            }
            List<WriterInterceptorMBW> list = interceptors;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyWriterInterceptor", list);
            }
            return list;
        }
        List<WriterInterceptor> list = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyWriterInterceptor", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        List<List<ProviderInfo<?>>> pis_pair;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyReader", new Object[]{bodyType, parameterType, parameterAnnotations, mediaType, m});
        }
        ProviderInfo<MessageBodyReader<?>> candidate_pi = null;
        Object mr = null;
        Object baseMr = null;
        LibertyJaxRsProviderCache providerCache = (LibertyJaxRsProviderCache)this.bus.getExtension(LibertyJaxRsProviderCache.class);
        if (providerCache != null && (pis_pair = providerCache.getReader(bodyType, mediaType)) != null && pis_pair.size() > 0 && null != (candidate_pi = this.compareMessageBodyReaderInfoCandidates((ProviderInfo<MessageBodyReader<?>>)(mr = this.getMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m, pis_pair.get(0), true)), (ProviderInfo<MessageBodyReader<?>>)(baseMr = this.getMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m, pis_pair.get(1), true))))) {
            MessageBodyReader messageBodyReader = (MessageBodyReader)candidate_pi.getProvider();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                messageBodyReader = messageBodyReader;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyReader", messageBodyReader);
            }
            return messageBodyReader;
        }
        LinkedList candidateProviderInfos = new LinkedList();
        LinkedList candidateProviderInfos_base = new LinkedList();
        LinkedList candidateProviderInfos_pair = new LinkedList();
        mr = this.chooseMessageReader(bodyType, parameterType, parameterAnnotations, mediaType, m, candidateProviderInfos);
        candidate_pi = this.compareMessageBodyReaderInfoCandidates((ProviderInfo<MessageBodyReader<?>>)mr, (ProviderInfo<MessageBodyReader<?>>)(baseMr = this.baseFactory.chooseMessageReader(bodyType, parameterType, parameterAnnotations, mediaType, m, candidateProviderInfos_base)));
        if (null != candidate_pi) {
            if (providerCache != null) {
                candidateProviderInfos_pair.add(candidateProviderInfos);
                candidateProviderInfos_pair.add(candidateProviderInfos_base);
                providerCache.putReader(bodyType, mediaType, candidateProviderInfos_pair);
            }
            MessageBodyReader messageBodyReader = (MessageBodyReader)candidate_pi.getProvider();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                messageBodyReader = messageBodyReader;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyReader", messageBodyReader);
            }
            return messageBodyReader;
        }
        MessageBodyReader<T> messageBodyReader = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageBodyReader = messageBodyReader;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyReader", messageBodyReader);
        }
        return messageBodyReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> ProviderInfo<MessageBodyReader<?>> getMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, List<ProviderInfo<?>> pis, boolean doInjection) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageBodyReader", new Object[]{bodyType, parameterType, parameterAnnotations, mediaType, m, pis, doInjection});
        }
        ProviderInfo<?> mr = null;
        if (pis == null || pis.size() == 0) {
            ProviderInfo<?> providerInfo = mr;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                providerInfo = providerInfo;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageBodyReader", providerInfo);
            }
            return providerInfo;
        }
        for (ProviderInfo<?> pi : pis) {
            MessageBodyReader r;
            Object pInst = pi.getProvider();
            if (!MessageBodyReader.class.isAssignableFrom(pInst.getClass())) continue;
            if (doInjection) {
                this.injectContextValues(pi, m);
            }
            if (!(r = (MessageBodyReader)pi.getProvider()).isReadable(bodyType, parameterType, parameterAnnotations, mediaType)) continue;
            mr = pi;
            break;
        }
        ProviderInfo<?> providerInfo = mr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerInfo = providerInfo;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageBodyReader", providerInfo);
        }
        return providerInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ProviderInfo<MessageBodyReader<?>> compareMessageBodyReaderInfoCandidates(ProviderInfo<MessageBodyReader<?>> mr, ProviderInfo<MessageBodyReader<?>> baseMr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareMessageBodyReaderInfoCandidates", new Object[]{mr, baseMr});
        }
        ProviderInfo<MessageBodyReader<?>> pi = null;
        if (mr != null && baseMr != null) {
            MessageBodyReaderComparator comparator = new MessageBodyReaderComparator();
            int res = comparator.compare(mr, baseMr);
            pi = res > 0 ? baseMr : mr;
        } else if (mr != null) {
            pi = mr;
        } else if (baseMr != null) {
            pi = baseMr;
        }
        ProviderInfo<MessageBodyReader<?>> providerInfo = pi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerInfo = providerInfo;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareMessageBodyReaderInfoCandidates", providerInfo);
        }
        return providerInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ProviderInfo<MessageBodyWriter<?>> compareMessageBodyWriterInfoCandidates(ProviderInfo<MessageBodyWriter<?>> mr, ProviderInfo<MessageBodyWriter<?>> baseMr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareMessageBodyWriterInfoCandidates", new Object[]{mr, baseMr});
        }
        ProviderInfo<MessageBodyWriter<?>> pi = null;
        if (mr != null && baseMr != null) {
            MessageBodyWriterComparator comparator = new MessageBodyWriterComparator();
            int res = comparator.compare(mr, baseMr);
            pi = res > 0 ? baseMr : mr;
        } else if (mr != null) {
            pi = mr;
        } else if (baseMr != null) {
            pi = baseMr;
        }
        ProviderInfo<MessageBodyWriter<?>> providerInfo = pi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerInfo = providerInfo;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareMessageBodyWriterInfoCandidates", providerInfo);
        }
        return providerInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        List<List<ProviderInfo<?>>> pis_pair;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyWriter", new Object[]{bodyType, parameterType, parameterAnnotations, mediaType, m});
        }
        ProviderInfo<MessageBodyWriter<?>> candidate_pi = null;
        Object mw = null;
        Object baseMw = null;
        LibertyJaxRsProviderCache providerCache = (LibertyJaxRsProviderCache)this.bus.getExtension(LibertyJaxRsProviderCache.class);
        if (providerCache != null && (pis_pair = providerCache.getWriter(bodyType, mediaType)) != null && pis_pair.size() > 0 && null != (candidate_pi = this.compareMessageBodyWriterInfoCandidates((ProviderInfo<MessageBodyWriter<?>>)(mw = this.getMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m, pis_pair.get(0), true)), (ProviderInfo<MessageBodyWriter<?>>)(baseMw = this.getMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m, pis_pair.get(1), true))))) {
            MessageBodyWriter messageBodyWriter = (MessageBodyWriter)candidate_pi.getProvider();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                messageBodyWriter = messageBodyWriter;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyWriter", messageBodyWriter);
            }
            return messageBodyWriter;
        }
        LinkedList candidateProviderInfos = new LinkedList();
        LinkedList candidateProviderInfos_base = new LinkedList();
        LinkedList candidateProviderInfos_pair = new LinkedList();
        mw = this.chooseMessageWriter(bodyType, parameterType, parameterAnnotations, mediaType, m, candidateProviderInfos);
        candidate_pi = this.compareMessageBodyWriterInfoCandidates((ProviderInfo<MessageBodyWriter<?>>)mw, (ProviderInfo<MessageBodyWriter<?>>)(baseMw = this.baseFactory.chooseMessageWriter(bodyType, parameterType, parameterAnnotations, mediaType, m, candidateProviderInfos_base)));
        if (null != candidate_pi) {
            if (providerCache != null) {
                candidateProviderInfos_pair.add(candidateProviderInfos);
                candidateProviderInfos_pair.add(candidateProviderInfos_base);
                providerCache.putWriter(bodyType, mediaType, candidateProviderInfos_pair);
            }
            MessageBodyWriter messageBodyWriter = (MessageBodyWriter)candidate_pi.getProvider();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                messageBodyWriter = messageBodyWriter;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyWriter", messageBodyWriter);
            }
            return messageBodyWriter;
        }
        MessageBodyWriter<T> messageBodyWriter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageBodyWriter = messageBodyWriter;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createMessageBodyWriter", messageBodyWriter);
        }
        return messageBodyWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> ProviderInfo<MessageBodyWriter<?>> getMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, List<ProviderInfo<?>> pis, boolean doInjection) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageBodyWriter", new Object[]{bodyType, parameterType, parameterAnnotations, mediaType, m, pis, doInjection});
        }
        ProviderInfo<?> mw = null;
        if (pis == null || pis.size() == 0) {
            ProviderInfo<?> providerInfo = mw;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                providerInfo = providerInfo;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageBodyWriter", providerInfo);
            }
            return providerInfo;
        }
        for (ProviderInfo<?> pi : pis) {
            MessageBodyWriter r;
            Object pInst = pi.getProvider();
            if (!MessageBodyWriter.class.isAssignableFrom(pInst.getClass())) continue;
            if (doInjection) {
                this.injectContextValues(pi, m);
            }
            if (!(r = (MessageBodyWriter)pi.getProvider()).isWriteable(bodyType, parameterType, parameterAnnotations, mediaType)) continue;
            mw = pi;
            break;
        }
        ProviderInfo<?> providerInfo = mw;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerInfo = providerInfo;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageBodyWriter", providerInfo);
        }
        return providerInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setBusProviders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "setBusProviders", new Object[0]);
        }
        LinkedList<Object> extensions = new LinkedList<Object>();
        String alreadySetProp = "bus.providers.set";
        if (this.bus.getProperty("bus.providers.set") == null) {
            this.addBusExtension(extensions, MessageBodyReader.class, MessageBodyWriter.class, ExceptionMapper.class);
            if (!extensions.isEmpty()) {
                this.setProviders(extensions.toArray());
                this.bus.setProperty("bus.providers.set", (Object)"");
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "setBusProviders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addBusExtension(List<Object> extensions, Class<?> ... extClasses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "addBusExtension", new Object[]{extensions, extClasses});
        }
        for (Class<?> extClass : extClasses) {
            Object ext = this.bus.getProperty(extClass.getName());
            if (!extClass.isInstance(ext)) continue;
            extensions.add(ext);
        }
        Object allProp = this.bus.getProperty(BUS_PROVIDERS_ALL);
        if (allProp instanceof List) {
            List all = (List)allProp;
            extensions.addAll(all);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "addBusExtension");
        }
    }

    protected abstract void setProviders(Object ... var1);

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setCommonProviders(List<ProviderInfo<? extends Object>> theProviders) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "setCommonProviders", new Object[]{theProviders});
        }
        LinkedList readInts = new LinkedList();
        LinkedList writeInts = new LinkedList();
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class providerCls = ClassHelper.getRealClass((Bus)this.bus, (Object)provider.getProvider());
            if (MessageBodyReader.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.messageReaders, provider);
            }
            if (MessageBodyWriter.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.messageWriters, provider);
            }
            if (ContextResolver.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.contextResolvers, provider);
            }
            if (ContextProvider.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.contextProviders, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, ReaderInterceptor.class)) {
                readInts.add(provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, WriterInterceptor.class)) {
                writeInts.add(provider);
            }
            if (!ParamConverterProvider.class.isAssignableFrom(providerCls)) continue;
            Object converter = provider.getProvider();
            if (this.newParamConverters == null) {
                this.newParamConverters = new LinkedList<ProviderInfo<ParamConverterProvider>>();
            }
            this.newParamConverters.add(provider);
        }
        this.sortReaders();
        this.sortWriters();
        this.sortContextResolvers();
        ProviderFactory.mapInterceptorFilters(this.readerInterceptors, readInts, ReaderInterceptor.class, true);
        ProviderFactory.mapInterceptorFilters(this.writerInterceptors, writeInts, WriterInterceptor.class, true);
        this.injectContextProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.readerInterceptors.values(), this.writerInterceptors.values());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "setCommonProviders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextValues", new Object[]{pi, m});
        }
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextValues");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addProviderToList(List<?> list, ProviderInfo<?> provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "addProviderToList", new Object[]{list, provider});
        }
        List list2 = CastUtils.cast(list);
        for (ProviderInfo pi : list2) {
            if (pi.getProvider() != provider.getProvider()) continue;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "addProviderToList");
            }
            return;
        }
        list2.add(provider);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "addProviderToList");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void injectContextProxies(Collection<?> ... providerLists) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextProxies", new Object[]{providerLists});
        }
        for (Collection<?> list : providerLists) {
            Collection l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                this.injectContextProxiesIntoProvider(pi);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextProxies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextProxiesIntoProvider", new Object[]{pi});
        }
        this.injectContextProxiesIntoProvider(pi, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextProxiesIntoProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void injectContextProxiesIntoProvider(ProviderInfo<?> pi, Application app) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextProxiesIntoProvider", new Object[]{pi, app});
        }
        if (pi.contextsAvailable()) {
            InjectionUtils.injectContextProxiesAndApplication(pi, pi.getProvider(), app);
            this.injectedProviders.add(pi);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectContextProxiesIntoProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void sortReaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "sortReaders", new Object[0]);
        }
        if (this.providerComparator == null) {
            Collections.sort(this.messageReaders, new MessageBodyReaderComparator());
        } else {
            this.doCustomSort(this.messageReaders);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "sortReaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> void sortWriters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "sortWriters", new Object[0]);
        }
        if (this.providerComparator == null) {
            Collections.sort(this.messageWriters, new MessageBodyWriterComparator());
        } else {
            this.doCustomSort(this.messageWriters);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "sortWriters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> void doCustomSort(List<?> listOfProviders) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "doCustomSort", new Object[]{listOfProviders});
        }
        List<ProviderInfo<MessageBodyReader<?>>> theProviders = this.messageReaders;
        Comparator<?> theComparator = this.providerComparator;
        Collections.sort(theProviders, theComparator);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "doCustomSort");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void sortContextResolvers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "sortContextResolvers", new Object[0]);
        }
        Collections.sort(this.contextResolvers, new ContextResolverComparator());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "sortContextResolvers");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> ProviderInfo<?> chooseMessageReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m, List<ProviderInfo<?>> candidateProviderInfos) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "chooseMessageReader", new Object[]{type, genericType, annotations, mediaType, m, candidateProviderInfos});
        }
        ProviderInfo<MessageBodyReader<?>> pi = null;
        for (ProviderInfo<MessageBodyReader<?>> ep : this.messageReaders) {
            if (!this.matchesReaderCriterias(ep, type, genericType, annotations, mediaType, m) || !this.isBaseFactory() && !this.handleRWMapper(ep, type, m, MessageBodyReader.class)) continue;
            if (this.isBaseFactory()) {
                ProviderInfo<MessageBodyReader<?>> temp = this.getMessageBodyReader(type, genericType, annotations, mediaType, m, Collections.singletonList(ep), true);
                if (temp == null) continue;
                candidateProviderInfos.add(ep);
                if (pi != null) continue;
                pi = temp;
                continue;
            }
            candidateProviderInfos.add(ep);
            if (pi != null) continue;
            pi = this.getMessageBodyReader(type, genericType, annotations, mediaType, m, Collections.singletonList(ep), true);
        }
        ProviderInfo<MessageBodyReader<?>> providerInfo = pi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerInfo = providerInfo;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "chooseMessageReader", providerInfo);
        }
        return providerInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> boolean matchesReaderCriterias(ProviderInfo<MessageBodyReader<?>> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "matchesReaderCriterias", new Object[]{pi, type, genericType, annotations, mediaType, m});
        }
        MessageBodyReader ep = (MessageBodyReader)pi.getProvider();
        List supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes((MessageBodyReader)ep);
        List availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), (List)supportedMediaTypes, (boolean)false);
        if (availableMimeTypes.size() == 0) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "matchesReaderCriterias", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "matchesReaderCriterias", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> ProviderInfo<?> chooseMessageWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m, List<ProviderInfo<?>> candidateProviderInfos) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "chooseMessageWriter", new Object[]{type, genericType, annotations, mediaType, m, candidateProviderInfos});
        }
        ProviderInfo<MessageBodyWriter<?>> pi = null;
        for (ProviderInfo<MessageBodyWriter<?>> ep : this.messageWriters) {
            if (!this.matchesWriterCriterias(ep, type, genericType, annotations, mediaType, m) || !this.isBaseFactory() && !this.handleRWMapper(ep, type, m, MessageBodyWriter.class)) continue;
            if (this.isBaseFactory()) {
                ProviderInfo<MessageBodyWriter<?>> temp = this.getMessageBodyWriter(type, genericType, annotations, mediaType, m, Collections.singletonList(ep), true);
                if (temp == null) continue;
                candidateProviderInfos.add(ep);
                if (pi != null) continue;
                pi = temp;
                continue;
            }
            candidateProviderInfos.add(ep);
            if (pi != null) continue;
            pi = this.getMessageBodyWriter(type, genericType, annotations, mediaType, m, Collections.singletonList(ep), true);
        }
        ProviderInfo<MessageBodyWriter<?>> providerInfo = pi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerInfo = providerInfo;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "chooseMessageWriter", providerInfo);
        }
        return providerInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> boolean matchesWriterCriterias(ProviderInfo<MessageBodyWriter<?>> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "matchesWriterCriterias", new Object[]{pi, type, genericType, annotations, mediaType, m});
        }
        MessageBodyWriter ep = (MessageBodyWriter)pi.getProvider();
        List supportedMediaTypes = JAXRSUtils.getProviderProduceTypes((MessageBodyWriter)ep);
        List availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), (List)supportedMediaTypes, (boolean)false);
        if (availableMimeTypes.size() == 0) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "matchesWriterCriterias", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "matchesWriterCriterias", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<ProviderInfo<MessageBodyReader<?>>> getMessageReaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageReaders", new Object[0]);
        }
        List<ProviderInfo<MessageBodyReader<?>>> list = Collections.unmodifiableList(this.messageReaders);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageReaders", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<ProviderInfo<MessageBodyWriter<?>>> getMessageWriters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageWriters", new Object[0]);
        }
        List<ProviderInfo<MessageBodyWriter<?>>> list = Collections.unmodifiableList(this.messageWriters);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getMessageWriters", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<ProviderInfo<ContextResolver<?>>> getContextResolvers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getContextResolvers", new Object[0]);
        }
        List<ProviderInfo<ContextResolver<?>>> list = Collections.unmodifiableList(this.contextResolvers);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getContextResolvers", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerUserProvider(Object provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "registerUserProvider", new Object[]{provider});
        }
        this.setUserProviders(Collections.singletonList(provider));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "registerUserProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUserProviders(List<?> userProviders) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "setUserProviders", new Object[]{userProviders});
        }
        this.setProviders(userProviders.toArray());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "setUserProviders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void clearThreadLocalProxies() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "clearThreadLocalProxies", new Object[0]);
        }
        this.clearProxies(this.injectedProviders);
        if (this.baseFactory != null) {
            this.baseFactory.clearThreadLocalProxies();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "clearThreadLocalProxies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void clearProxies(Collection<?> ... lists) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "clearProxies", new Object[]{lists});
        }
        for (Collection<?> list : lists) {
            Collection l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                pi.clearThreadLocalProxies();
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "clearProxies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void clearProviders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "clearProviders", new Object[0]);
        }
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.contextProviders.clear();
        this.readerInterceptors.clear();
        this.writerInterceptors.clear();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "clearProviders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBus(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "setBus", new Object[]{bus});
        }
        if (bus == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "setBus");
            }
            return;
        }
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setBus", Bus.class, bus);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "setBus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Exception.class})
    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        boolean bl;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectProviderProperty", new Object[]{provider, mName, pClass, pValue});
            }
            try {
                Method m = provider.getClass().getMethod(mName, pClass);
                m.invoke(provider, pValue);
                bl = true;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Exception ex) {
                boolean bl2 = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl2 = bl2;
                    LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectProviderProperty", bl2);
                }
                return bl2;
            }
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "injectProviderProperty", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSchemaLocations(List<String> schemas) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "setSchemaLocations", new Object[]{schemas});
        }
        boolean schemasMethodAvailable = false;
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            schemasMethodAvailable = this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
        }
        if (!schemasMethodAvailable) {
            this.setProviders(ProviderFactory.createProvider(JAXB_PROVIDER_NAME), ProviderFactory.createProvider(JSON_PROVIDER_NAME));
            for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
                this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "setSchemaLocations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static <T> List<ProviderInfo<T>> getBoundFilters(Map<NameKey, ProviderInfo<T>> boundFilters, Set<String> names) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getBoundFilters", new Object[]{boundFilters, names});
        }
        if (boundFilters.isEmpty()) {
            List<ProviderInfo<T>> list = Collections.emptyList();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getBoundFilters", list);
            }
            return list;
        }
        names = names == null ? Collections.emptySet() : names;
        MetadataMap map = new MetadataMap();
        for (Map.Entry<NameKey, ProviderInfo<T>> entry : boundFilters.entrySet()) {
            FilterProviderInfo fpi;
            String entryName = entry.getKey().getName();
            ProviderInfo<T> provider = entry.getValue();
            if (entryName.equals(DEFAULT_FILTER_NAME_BINDING)) {
                map.put(provider, Collections.emptyList());
                continue;
            }
            if (provider instanceof FilterProviderInfo && (fpi = (FilterProviderInfo)provider).isDynamic() && !names.containsAll(fpi.getNameBinding())) continue;
            map.add(provider, (Object)entryName);
        }
        LinkedList<ProviderInfo<T>> list = new LinkedList<ProviderInfo<T>>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            if (!names.containsAll(values)) continue;
            ProviderInfo provider = (ProviderInfo)entry.getKey();
            list.add(provider);
        }
        LinkedList<ProviderInfo<T>> linkedList = list;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedList = linkedList;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getBoundFilters", linkedList);
        }
        return linkedList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initProviders(List<ClassResourceInfo> cris) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "initProviders", new Object[]{cris});
        }
        Set<Object> set = this.getReadersWriters();
        for (Object o : set) {
            Object provider = ((ProviderInfo)o).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
        if (!this.isBaseFactory()) {
            this.baseFactory.initProviders(cris);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "initProviders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Set<Object> getReadersWriters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getReadersWriters", new Object[0]);
        }
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.messageReaders);
        set.addAll(this.messageWriters);
        HashSet<Object> hashSet = set;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getReadersWriters", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ProviderFactory getInstance(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getInstance", new Object[]{m});
        }
        Endpoint e = (Endpoint)m.getExchange().get(Endpoint.class);
        Message outM = m.getExchange().getOutMessage();
        boolean isClient = outM != null && MessageUtils.isRequestor((Message)outM);
        String name = isClient ? CLIENT_FACTORY_NAME : SERVER_FACTORY_NAME;
        ProviderFactory providerFactory = (ProviderFactory)e.get((Object)name);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerFactory = providerFactory;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getInstance", providerFactory);
        }
        return providerFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static int compareClasses(Object o1, Object o2) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", new Object[]{o1, o2});
        }
        int n = ProviderFactory.compareClasses(null, o1, o2);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static int compareClasses(Class<?> expectedCls, Object o1, Object o2) {
        Class<?> realClass2;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", new Object[]{expectedCls, o1, o2});
        }
        Class cl1 = ClassHelper.getRealClass((Object)o1);
        Class cl2 = ClassHelper.getRealClass((Object)o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1, expectedCls);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2, expectedCls);
        if (types1.length == 0 && types2.length == 0) {
            int n = 0;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", n);
            }
            return n;
        }
        if (types1.length == 0 && types2.length > 0) {
            int n = 1;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", n);
            }
            return n;
        }
        if (types1.length > 0 && types2.length == 0) {
            int n = -1;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", n);
            }
            return n;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            int n = 0;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", n);
            }
            return n;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            int n = 1;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", n);
            }
            return n;
        }
        int n = -1;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "compareClasses", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass) {
        Type[] types;
        Type genericSuperType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getGenericInterfaces", new Object[]{cls, expectedClass});
        }
        if (Object.class == cls) {
            Type[] typeArray = emptyType;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                typeArray = typeArray;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getGenericInterfaces", typeArray);
            }
            return typeArray;
        }
        ClassPair classPair = new ClassPair(cls, expectedClass);
        Type[] cachedTypes = genericInterfacesCache.get(classPair);
        if (cachedTypes != null) {
            Type[] typeArray = cachedTypes;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                typeArray = typeArray;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getGenericInterfaces", typeArray);
            }
            return typeArray;
        }
        if (expectedClass != null && (genericSuperType = cls.getGenericSuperclass()) instanceof ParameterizedType) {
            Class<?> actualType = InjectionUtils.getActualType(genericSuperType);
            if (actualType != null && actualType.isAssignableFrom(expectedClass)) {
                Type[] tempTypes = new Type[]{genericSuperType};
                genericInterfacesCache.put(classPair, tempTypes);
                Type[] typeArray = tempTypes;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    typeArray = typeArray;
                    LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getGenericInterfaces", typeArray);
                }
                return typeArray;
            }
            if (expectedClass.isAssignableFrom(actualType)) {
                genericInterfacesCache.put(classPair, emptyType);
                Type[] typeArray = emptyType;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    typeArray = typeArray;
                    LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getGenericInterfaces", typeArray);
                }
                return typeArray;
            }
        }
        if ((types = cls.getGenericInterfaces()).length > 0) {
            genericInterfacesCache.put(classPair, types);
            Type[] typeArray = types;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                typeArray = typeArray;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getGenericInterfaces", typeArray);
            }
            return typeArray;
        }
        Type[] superGenericTypes = ProviderFactory.getGenericInterfaces(cls.getSuperclass(), expectedClass);
        genericInterfacesCache.put(classPair, superGenericTypes);
        Type[] typeArray = superGenericTypes;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            typeArray = typeArray;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getGenericInterfaces", typeArray);
        }
        return typeArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ProviderInfo<? extends Object> createProviderFromConstructor(Constructor<?> c, Map<Class<?>, Object> values, Bus theBus, boolean checkContexts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "createProviderFromConstructor", new Object[]{c, values, theBus, checkContexts});
        }
        Map proxiesMap = CastUtils.cast((Map)((Map)theBus.getProperty("jaxrs-constructor-proxy-map")));
        Map existingProxies = null;
        if (proxiesMap != null) {
            existingProxies = (Map)proxiesMap.get(c.getDeclaringClass());
        }
        Class<?>[] paramTypes = c.getParameterTypes();
        Object[] cArgs = ResourceUtils.createConstructorArguments(c, null, (boolean)false, values);
        if (existingProxies != null && existingProxies.size() <= paramTypes.length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
                cArgs[i] = existingProxies.get(paramTypes[i]);
            }
        }
        Object instance = null;
        try {
            instance = c.newInstance(cArgs);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.provider.ProviderFactory", (String)"1532", null, (Object[])new Object[]{c, values, theBus, checkContexts});
            throw new RuntimeException("Resource or provider class " + c.getDeclaringClass().getName() + " can not be instantiated");
        }
        LinkedHashMap proxies = new LinkedHashMap();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
            ThreadLocalProxy proxy = (ThreadLocalProxy)cArgs[i];
            proxies.put(paramTypes[i], proxy);
        }
        boolean isApplication = Application.class.isAssignableFrom(c.getDeclaringClass());
        if (isApplication) {
            ApplicationInfo applicationInfo = new ApplicationInfo((Application)instance, proxies, theBus);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                applicationInfo = applicationInfo;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createProviderFromConstructor", applicationInfo);
            }
            return applicationInfo;
        }
        ProviderInfo providerInfo = new ProviderInfo(instance, proxies, theBus, checkContexts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            providerInfo = providerInfo;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "createProviderFromConstructor", providerInfo);
        }
        return providerInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static <T> void mapInterceptorFilters(Map<NameKey, ProviderInfo<T>> map, List<ProviderInfo<T>> filters, Class<?> providerCls, boolean ascending) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "mapInterceptorFilters", new Object[]{map, filters, providerCls, ascending});
        }
        for (ProviderInfo<T> p : filters) {
            Set<String> names = ProviderFactory.getFilterNameBindings(p);
            int priority = ProviderFactory.getFilterPriority(p, providerCls);
            for (String name : names) {
                map.put(new NameKey(name, priority, p.getClass()), p);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "mapInterceptorFilters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static Set<String> getFilterNameBindings(ProviderInfo<?> p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getFilterNameBindings", new Object[]{p});
        }
        Set<String> names = null;
        if (p instanceof FilterProviderInfo) {
            names = ((FilterProviderInfo)p).getNameBinding();
        }
        if (names == null) {
            names = AnnotationUtils.getNameBindings((Annotation[])p.getProvider().getClass().getAnnotations());
        }
        if (names.isEmpty()) {
            names = Collections.singleton(DEFAULT_FILTER_NAME_BINDING);
        }
        Set<String> set = names;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getFilterNameBindings", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static int getFilterPriority(ProviderInfo<?> p, Class<?> providerCls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getFilterPriority", new Object[]{p, providerCls});
        }
        int n = p instanceof FilterProviderInfo ? ((FilterProviderInfo)p).getPriority(providerCls) : AnnotationUtils.getBindingPriority(p.getProvider().getClass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getFilterPriority", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static boolean filterContractSupported(ProviderInfo<?> provider, Class<?> providerCls, Class<?> contract) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "filterContractSupported", new Object[]{provider, providerCls, contract});
        }
        boolean result = false;
        if (contract.isAssignableFrom(providerCls)) {
            Set actualContracts = null;
            if (provider instanceof FilterProviderInfo) {
                actualContracts = ((FilterProviderInfo)provider).getSupportedContracts();
            }
            result = actualContracts != null ? actualContracts.contains(contract) : true;
        }
        boolean bl = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "filterContractSupported", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<ProviderInfo<? extends Object>> prepareProviders(Object[] providers, ProviderInfo<Application> application) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "prepareProviders", new Object[]{providers, application});
        }
        ArrayList<ProviderInfo<? extends Object>> theProviders = new ArrayList<ProviderInfo<? extends Object>>(providers.length);
        Map beanCustomizerContexts = (Map)this.getBus().getProperty("ENDPOINT_BEANCUSTOMIZER_CONTEXTOBJ");
        for (Object o : providers) {
            Object newProviderInstance;
            Object proxyObject;
            if (o == null) continue;
            Object pi = null;
            if (o instanceof Constructor) {
                Map values = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
                pi = ProviderFactory.createProviderFromConstructor((Constructor)o, values, this.getBus(), true);
            } else {
                pi = o instanceof ProviderInfo ? (ProviderInfo<? extends Object>)o : new ProviderInfo(o, this.getBus());
            }
            JaxRsFactoryBeanCustomizer beanCustomizer = InjectionRuntimeContextHelper.findBeanCustomizer(o.getClass(), this.getBus());
            if (!(beanCustomizer == null || (proxyObject = beanCustomizer.onSetupProviderProxy(o, beanCustomizerContexts.get(Integer.toString(beanCustomizer.hashCode())))) == null || proxyObject == o && proxyObject.equals(o))) {
                pi.setProvider(proxyObject);
            }
            if (beanCustomizer != null && DynamicFeature.class.isAssignableFrom(pi.getProvider().getClass()) && (newProviderInstance = beanCustomizer.onSingletonProviderInit(pi.getProvider(), beanCustomizerContexts.get(Integer.toString(beanCustomizer.hashCode())), null)) != null) {
                pi.setProvider(newProviderInstance);
            }
            theProviders.add((ProviderInfo<? extends Object>)pi);
        }
        ArrayList<ProviderInfo<? extends Object>> arrayList = theProviders;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "prepareProviders", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageBodyWriter<?> getRegisteredJaxbWriter() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getRegisteredJaxbWriter", new Object[0]);
        }
        for (ProviderInfo<MessageBodyWriter<?>> pi : this.messageWriters) {
            Class<?> cls = ((MessageBodyWriter)pi.getProvider()).getClass();
            if (!cls.getName().equals(JAXB_PROVIDER_NAME) && !cls.getSuperclass().getName().equals(JAXB_PROVIDER_NAME)) continue;
            MessageBodyWriter messageBodyWriter = (MessageBodyWriter)pi.getProvider();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                messageBodyWriter = messageBodyWriter;
                LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getRegisteredJaxbWriter", messageBodyWriter);
            }
            return messageBodyWriter;
        }
        MessageBodyWriter<?> messageBodyWriter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageBodyWriter = messageBodyWriter;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getRegisteredJaxbWriter", messageBodyWriter);
        }
        return messageBodyWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Comparator<?> getProviderComparator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "getProviderComparator", new Object[0]);
        }
        Comparator<?> comparator = this.providerComparator;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            comparator = comparator;
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "getProviderComparator", comparator);
        }
        return comparator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProviderComparator(Comparator<?> providerComparator) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.ProviderFactory", "setProviderComparator", new Object[]{providerComparator});
        }
        this.providerComparator = providerComparator;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.ProviderFactory", "setProviderComparator");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class NameKeyMap<T>
    extends TreeMap<NameKey, T> {
        private static final long serialVersionUID = -4352258671270502204L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKeyMap(boolean ascending) {
            super(new NameKeyComparator(ascending));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NameKeyMap.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class NameKeyComparator
    extends AbstractPriorityComparator
    implements Comparator<NameKey> {
        static final long serialVersionUID = -156933271485292699L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKeyComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(NameKey key1, NameKey key2) {
            int result = this.compare(key1.getPriority(), key2.getPriority());
            if (result != 0) {
                return result;
            }
            return this.compare(key1.hashCode(), key2.hashCode());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NameKeyComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class NameKey {
        private final String name;
        private final Integer priority;
        private final Class<?> providerCls;
        static final long serialVersionUID = -7444072820502076106L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameKey(String name, int priority, Class<?> providerCls) {
            this.name = name;
            this.priority = priority;
            this.providerCls = providerCls;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NameKey)) {
                return false;
            }
            NameKey other = (NameKey)o;
            return this.name.equals(other.name) && this.priority.equals(other.priority) && this.providerCls == other.providerCls;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name + ":" + this.priority;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NameKey.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ContextResolverProxy<T>
    implements ContextResolver<T> {
        private final List<ContextResolver<T>> candidates;
        static final long serialVersionUID = 3979578241282564359L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContextResolverProxy(List<ContextResolver<T>> candidates) {
            this.candidates = candidates;
        }

        public T getContext(Class<?> cls) {
            for (ContextResolver<T> resolver : this.candidates) {
                Object context = resolver.getContext(cls);
                if (context == null) continue;
                return (T)context;
            }
            return null;
        }

        public List<ContextResolver<T>> getResolvers() {
            return this.candidates;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ContextResolverProxy.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class BindingPriorityComparator
    extends AbstractPriorityComparator
    implements Comparator<ProviderInfo<?>> {
        private final Class<?> providerCls;
        static final long serialVersionUID = 4133762782533825089L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BindingPriorityComparator(Class<?> providerCls, boolean ascending) {
            super(ascending);
            this.providerCls = providerCls;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            return this.compare(ProviderFactory.getFilterPriority(p1, this.providerCls), ProviderFactory.getFilterPriority(p2, this.providerCls));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BindingPriorityComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class AbstractPriorityComparator {
        private final boolean ascending;
        static final long serialVersionUID = 2930255358206049304L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected AbstractPriorityComparator(boolean ascending) {
            this.ascending = ascending;
        }

        protected int compare(Integer b1Value, Integer b2Value) {
            int result = b1Value.compareTo(b2Value);
            return this.ascending ? result : result * -1;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AbstractPriorityComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ClassComparator
    implements Comparator<Object> {
        private Class<?> expectedCls;
        static final long serialVersionUID = -9159606144959439425L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassComparator() {
        }

        public ClassComparator(Class<?> expectedCls) {
            this.expectedCls = expectedCls;
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(this.expectedCls, em1, em2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClassComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ContextResolverComparator
    implements Comparator<ProviderInfo<ContextResolver<?>>> {
        static final long serialVersionUID = 5038808953357812851L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ContextResolverComparator() {
        }

        @Override
        public int compare(ProviderInfo<ContextResolver<?>> p1, ProviderInfo<ContextResolver<?>> p2) {
            ContextResolver e1 = (ContextResolver)p1.getOldProvider();
            ContextResolver e2 = (ContextResolver)p2.getOldProvider();
            List types1 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProduceTypes((Produces)e1.getClass().getAnnotation(Produces.class)), (String)"qs");
            List types2 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProduceTypes((Produces)e2.getClass().getAnnotation(Produces.class)), (String)"qs");
            return JAXRSUtils.compareSortedMediaTypes((List)types1, (List)types2, (String)"qs");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ContextResolverComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter<?>>> {
        static final long serialVersionUID = 5516174515265752866L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter<?>> p1, ProviderInfo<MessageBodyWriter<?>> p2) {
            MessageBodyWriter e2;
            MessageBodyWriter e1 = (MessageBodyWriter)p1.getOldProvider();
            int result = ProviderFactory.compareClasses(e1, e2 = (MessageBodyWriter)p2.getOldProvider());
            if (result != 0) {
                return result;
            }
            List types1 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProviderProduceTypes((MessageBodyWriter)e1), (String)"qs");
            List types2 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProviderProduceTypes((MessageBodyWriter)e2), (String)"qs");
            return JAXRSUtils.compareSortedMediaTypes((List)types1, (List)types2, (String)"qs");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MessageBodyWriterComparator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader<?>>> {
        static final long serialVersionUID = 5523895186534455322L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader<?>> p1, ProviderInfo<MessageBodyReader<?>> p2) {
            MessageBodyReader e1 = (MessageBodyReader)p1.getOldProvider();
            MessageBodyReader e2 = (MessageBodyReader)p2.getOldProvider();
            List types1 = JAXRSUtils.getProviderConsumeTypes((MessageBodyReader)e1);
            types1 = JAXRSUtils.sortMediaTypes((List)types1, null);
            List types2 = JAXRSUtils.getProviderConsumeTypes((MessageBodyReader)e2);
            int result = JAXRSUtils.compareSortedMediaTypes((List)types1, (List)(types2 = JAXRSUtils.sortMediaTypes((List)types2, null)), null);
            if (result != 0) {
                return result;
            }
            return ProviderFactory.compareClasses(e1, e2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MessageBodyReaderComparator.class);
        }
    }
}

