/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.JaxRsConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.interceptor.CachedTime;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);
    static final long serialVersionUID = -4350422302552971165L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXRSOutInterceptor() {
        super("marshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "handleMessage", new Object[]{message});
        }
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance((Message)message);
        try {
            this.processResponse(providerFactory, message);
        }
        finally {
            ServerProviderFactory.releaseRequestState((ServerProviderFactory)providerFactory, (Message)message);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void processResponse(ServerProviderFactory providerFactory, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "processResponse", new Object[]{providerFactory, message});
        }
        if (this.isResponseAlreadyHandled(message)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "processResponse");
            }
            return;
        }
        MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
        if (objs == null || objs.size() == 0) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "processResponse");
            }
            return;
        }
        Object responseObj = objs.get(0);
        Response response = null;
        if (responseObj instanceof Response) {
            response = (Response)responseObj;
            if (response.getStatus() == 500 && message.getExchange().get((Object)"exception.from.mapper") != null) {
                message.put((Object)Message.RESPONSE_CODE, (Object)500);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "processResponse");
                }
                return;
            }
        } else {
            int status = this.getStatus(message, responseObj != null ? 200 : 204);
            response = Response.status((int)status).entity(responseObj).build();
        }
        Exchange exchange = message.getExchange();
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get((Object)OperationResourceInfo.class.getName());
        this.serializeMessage(providerFactory, message, response, ori, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "processResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int getStatus(Message message, int defaultValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "getStatus", new Object[]{message, defaultValue});
        }
        Object customStatus = message.getExchange().get((Object)Message.RESPONSE_CODE);
        int n = customStatus == null ? defaultValue : (Integer)customStatus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "getStatus", n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void serializeMessage(ServerProviderFactory providerFactory, Message message, Response theResponse, OperationResourceInfo ori, boolean firstTry) {
        boolean ignoreWriters;
        String initialResponseContentType2222;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage", new Object[]{providerFactory, message, theResponse, ori, firstTry});
        }
        ResponseImpl response = (ResponseImpl)JAXRSUtils.copyResponseIfNeeded((Response)theResponse);
        Exchange exchange = message.getExchange();
        boolean headResponse = response.getStatus() == 200 && firstTry && ori != null && "HEAD".equals(ori.getHttpMethod());
        Object entity = response.getActualEntity();
        if (headResponse && entity != null) {
            LOG.info(new org.apache.cxf.common.i18n.Message("HEAD_WITHOUT_ENTITY", BUNDLE, new Object[0]).toString());
            entity = null;
        }
        Method invoked = ori == null ? null : (ori.getAnnotatedMethod() != null ? ori.getAnnotatedMethod() : ori.getMethodToInvoke());
        Annotation[] annotations = null;
        Annotation[] staticAnns = ori != null ? ori.getOutAnnotations() : new Annotation[]{};
        Annotation[] responseAnns = response.getEntityAnnotations();
        if (responseAnns != null) {
            annotations = new Annotation[staticAnns.length + responseAnns.length];
            System.arraycopy(staticAnns, 0, annotations, 0, staticAnns.length);
            System.arraycopy(responseAnns, 0, annotations, staticAnns.length, responseAnns.length);
        } else {
            annotations = staticAnns;
        }
        response.setStatus(this.getActualStatus(response.getStatus(), entity));
        response.setEntity(entity, annotations);
        MultivaluedMap responseHeaders = response.getMetadata();
        Map userHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (firstTry && userHeaders != null) {
            responseHeaders.putAll(userHeaders);
        }
        if (entity != null && (initialResponseContentType2222 = (String)message.get((Object)"Content-Type")) != null && !responseHeaders.containsKey((Object)"Content-Type")) {
            responseHeaders.putSingle((Object)"Content-Type", (Object)initialResponseContentType2222);
        }
        message.put((Object)Message.PROTOCOL_HEADERS, (Object)responseHeaders);
        this.setResponseDate((MultivaluedMap<String, Object>)responseHeaders, firstTry);
        if (!JaxRsConstants.JAXRS_CONTAINER_FILTER_DISABLED.booleanValue()) {
            try {
                JAXRSUtils.runContainerResponseFilters((ServerProviderFactory)providerFactory, (ResponseImpl)response, (Message)message, (OperationResourceInfo)ori, (Method)invoked);
            }
            catch (Throwable initialResponseContentType2222) {
                void ex;
                FFDCFilter.processException((Throwable)initialResponseContentType2222, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"187", (Object)((Object)this), (Object[])new Object[]{providerFactory, message, theResponse, ori, firstTry});
                this.handleWriteException(providerFactory, message, (Throwable)ex, firstTry);
                if (LOG == null) return;
                if (!LOG.isLoggable(Level.FINER)) return;
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage");
                return;
            }
        }
        entity = InjectionUtils.getEntity(response.getActualEntity());
        this.setResponseStatus(message, this.getActualStatus(response.getStatus(), entity));
        if (entity == null) {
            if (!headResponse) {
                responseHeaders.putSingle((Object)"Content-Length", (Object)"0");
                if (MessageUtils.getContextualBoolean((Message)message, (String)"remove.content.type.for.empty.response", (boolean)false)) {
                    responseHeaders.remove((Object)"Content-Type");
                    message.remove((Object)"Content-Type");
                }
            }
            HttpUtils.convertHeaderValuesToString((Map<String, List<Object>>)responseHeaders, true);
            if (LOG == null) return;
            if (!LOG.isLoggable(Level.FINER)) return;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage");
            return;
        }
        Object ignoreWritersProp = exchange.get((Object)"ignore.message.writers");
        boolean bl = ignoreWriters = ignoreWritersProp == null ? false : Boolean.valueOf(ignoreWritersProp.toString());
        if (ignoreWriters) {
            this.writeResponseToStream((OutputStream)message.getContent(OutputStream.class), entity);
            if (LOG == null) return;
            if (!LOG.isLoggable(Level.FINER)) return;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage");
            return;
        }
        MediaType responseMediaType = this.getResponseMediaType(responseHeaders.getFirst((Object)"Content-Type"));
        Class serviceCls = invoked != null ? ori.getClassResourceInfo().getServiceClass() : null;
        Class<?> targetType = InjectionUtils.getRawResponseClass(entity);
        Type genericType = InjectionUtils.getGenericResponseType(invoked, serviceCls, response.getActualEntity(), targetType, exchange);
        targetType = InjectionUtils.updateParamClassToTypeIfNeeded(targetType, genericType);
        annotations = response.getEntityAnnotations();
        List writers = providerFactory.createMessageBodyWriterInterceptor(targetType, genericType, annotations, responseMediaType, message, ori == null ? null : ori.getNameBindings());
        OutputStream outOriginal = (OutputStream)message.getContent(OutputStream.class);
        if (writers == null || writers.isEmpty()) {
            this.writeResponseErrorMessage(message, outOriginal, "NO_MSG_WRITER", targetType, responseMediaType);
            if (LOG == null) return;
            if (!LOG.isLoggable(Level.FINER)) return;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage");
            return;
        }
        try {
            Produces pM = (Produces)AnnotationUtils.getMethodAnnotation((Method)(ori == null ? null : ori.getAnnotatedMethod()), Produces.class);
            Produces pC = (Produces)AnnotationUtils.getClassAnnotation((Class)serviceCls, Produces.class);
            responseMediaType = this.checkFinalContentType(responseMediaType, writers, pM == null && pC == null);
        }
        catch (Throwable pM) {
            void ex;
            FFDCFilter.processException((Throwable)pM, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"240", (Object)((Object)this), (Object[])new Object[]{providerFactory, message, theResponse, ori, firstTry});
            this.handleWriteException(providerFactory, message, (Throwable)ex, firstTry);
            if (LOG == null) return;
            if (!LOG.isLoggable(Level.FINER)) return;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage");
            return;
        }
        String finalResponseContentType = JAXRSUtils.mediaTypeToString((MediaType)responseMediaType, (String[])new String[0]);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Response content type is: " + finalResponseContentType);
        }
        responseHeaders.putSingle((Object)"Content-Type", (Object)finalResponseContentType);
        message.put((Object)"Content-Type", (Object)finalResponseContentType);
        boolean enabled = this.checkBufferingMode(message, writers, firstTry);
        try {
            block25: {
                block26: {
                    JAXRSUtils.writeMessageBody((List)writers, (Object)entity, targetType, (Type)genericType, (Annotation[])annotations, (MediaType)responseMediaType, (MultivaluedMap)responseHeaders, (Message)message);
                    if (!this.isResponseRedirected(message)) break block25;
                    if (!enabled) break block26;
                    message.setContent(OutputStream.class, (Object)outOriginal);
                    message.put((Object)XMLStreamWriter.class.getName(), null);
                }
                if (LOG == null) return;
                if (!LOG.isLoggable(Level.FINER)) return;
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage");
                return;
            }
            try {
                this.checkCachedStream(message, outOriginal, enabled);
            }
            finally {
                if (enabled) {
                    message.setContent(OutputStream.class, (Object)outOriginal);
                    message.put((Object)XMLStreamWriter.class.getName(), null);
                }
            }
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"275", (Object)((Object)this), (Object[])new Object[]{providerFactory, message, theResponse, ori, firstTry});
            this.logWriteError(firstTry, targetType, responseMediaType);
            this.handleWriteException(providerFactory, message, (Throwable)ex, firstTry);
        }
        if (LOG == null) return;
        if (!LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "serializeMessage");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MediaType getResponseMediaType(Object mediaTypeHeader) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "getResponseMediaType", new Object[]{mediaTypeHeader});
        }
        MediaType responseMediaType = mediaTypeHeader instanceof MediaType ? (MediaType)mediaTypeHeader : (mediaTypeHeader == null ? MediaType.WILDCARD_TYPE : JAXRSUtils.toMediaType((String)mediaTypeHeader.toString()));
        MediaType mediaType = responseMediaType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            mediaType = mediaType;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "getResponseMediaType", mediaType);
        }
        return mediaType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int getActualStatus(int status, Object responseObj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "getActualStatus", new Object[]{status, responseObj});
        }
        if (status == -1) {
            int n = responseObj == null ? 204 : 200;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "getActualStatus", n);
            }
            return n;
        }
        int n = status;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "getActualStatus", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean checkBufferingMode(Message m, List<WriterInterceptor> writers, boolean firstTry) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkBufferingMode", new Object[]{m, writers, firstTry});
        }
        if (!firstTry) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkBufferingMode", bl);
            }
            return bl;
        }
        WriterInterceptor last = writers.get(writers.size() - 1);
        MessageBodyWriter w = ((WriterInterceptorMBW)last).getMBW();
        Object outBuf = m.getContextualProperty("org.apache.cxf.output.buffering");
        boolean enabled = MessageUtils.isTrue((Object)outBuf);
        boolean configurableProvider = w instanceof AbstractConfigurableProvider;
        if (!enabled && outBuf == null && configurableProvider) {
            enabled = ((AbstractConfigurableProvider)w).getEnableBuffering();
        }
        if (enabled) {
            boolean streamingOn;
            boolean bl = streamingOn = configurableProvider ? ((AbstractConfigurableProvider)w).getEnableStreaming() : false;
            if (streamingOn) {
                m.setContent(XMLStreamWriter.class, (Object)new CachingXmlEventWriter());
            } else {
                m.setContent(OutputStream.class, (Object)new CachedOutputStream());
            }
        }
        boolean bl = enabled;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkBufferingMode", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkCachedStream(Message m, OutputStream osOriginal, boolean enabled) throws Exception {
        CachedOutputStream cos;
        OutputStream os;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkCachedStream", new Object[]{m, osOriginal, enabled});
        }
        XMLStreamWriter writer = null;
        writer = enabled ? (XMLStreamWriter)m.getContent(XMLStreamWriter.class) : (XMLStreamWriter)m.get((Object)XMLStreamWriter.class.getName());
        if (writer instanceof CachingXmlEventWriter) {
            CachingXmlEventWriter cache = (CachingXmlEventWriter)writer;
            if (cache.getEvents().size() != 0) {
                XMLStreamWriter origWriter = null;
                try {
                    origWriter = StaxUtils.createXMLStreamWriter((OutputStream)osOriginal);
                    for (XMLEvent event : cache.getEvents()) {
                        StaxUtils.writeEvent((XMLEvent)event, (XMLStreamWriter)origWriter);
                    }
                }
                finally {
                    StaxUtils.close((XMLStreamWriter)origWriter);
                }
            }
            m.setContent(XMLStreamWriter.class, null);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkCachedStream");
            }
            return;
        }
        if (enabled && (os = (OutputStream)m.getContent(OutputStream.class)) != osOriginal && os instanceof CachedOutputStream && (cos = (CachedOutputStream)os).size() != 0L) {
            cos.writeCacheTo(osOriginal);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkCachedStream");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logWriteError(boolean firstTry, Class<?> cls, MediaType ct) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "logWriteError", new Object[]{firstTry, cls, ct});
        }
        if (firstTry) {
            JAXRSUtils.logMessageHandlerProblem((String)"MSG_WRITER_PROBLEM", cls, (MediaType)ct);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "logWriteError");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleWriteException(ServerProviderFactory pf, Message message, Throwable ex, boolean firstTry) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "handleWriteException", new Object[]{pf, message, ex, firstTry});
        }
        Response excResponse = null;
        if (firstTry) {
            excResponse = JAXRSUtils.convertFaultToResponse((Throwable)ex, (Message)message);
        } else {
            message.getExchange().put((Object)"second.jaxrs.exception", (Object)Boolean.TRUE);
        }
        if (excResponse == null) {
            this.setResponseStatus(message, 500);
            throw new Fault(ex);
        }
        this.serializeMessage(pf, message, excResponse, null, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "handleWriteException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void writeResponseErrorMessage(Message message, OutputStream out, String name, Class<?> cls, MediaType ct) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "writeResponseErrorMessage", new Object[]{message, out, name, cls, ct});
        }
        message.put((Object)"Content-Type", (Object)"text/plain");
        message.put((Object)Message.RESPONSE_CODE, (Object)500);
        try {
            String errorMessage = JAXRSUtils.logMessageHandlerProblem((String)name, cls, (MediaType)ct);
            if (out != null) {
                out.write(errorMessage.getBytes("UTF-8"));
            }
        }
        catch (IOException errorMessage) {
            FFDCFilter.processException((Throwable)errorMessage, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"395", (Object)((Object)this), (Object[])new Object[]{message, out, name, cls, ct});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "writeResponseErrorMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MediaType checkFinalContentType(MediaType mt, List<WriterInterceptor> writers, boolean checkWriter) {
        int mbwIndex;
        MessageBodyWriter writer;
        Produces pm;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkFinalContentType", new Object[]{mt, writers, checkWriter});
        }
        if (mt.isWildcardSubtype() && checkWriter && (pm = (writer = ((WriterInterceptorMBW)writers.get(mbwIndex = writers.size() == 1 ? 0 : writers.size() - 1)).getMBW()).getClass().getAnnotation(Produces.class)) != null) {
            List sorted = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getMediaTypes((String[])pm.value()), (String)"qs");
            mt = (MediaType)JAXRSUtils.intersectMimeTypes((List)sorted, (MediaType)mt).get(0);
        }
        if (mt.isWildcardType() || mt.isWildcardSubtype()) {
            if ("application".equals(mt.getType()) || mt.isWildcardType()) {
                mt = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            } else {
                throw new NotAcceptableException();
            }
        }
        MediaType mediaType = mt;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            mediaType = mediaType;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "checkFinalContentType", mediaType);
        }
        return mediaType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setResponseDate(MultivaluedMap<String, Object> headers, boolean firstTry) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "setResponseDate", new Object[]{headers, firstTry});
        }
        if (!firstTry || headers.containsKey((Object)"Date")) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "setResponseDate");
            }
            return;
        }
        headers.putSingle((Object)"Date", (Object)CachedTime.getCachedTime().getTimeAsString(-1L));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "setResponseDate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isResponseAlreadyHandled(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseAlreadyHandled", new Object[]{m});
        }
        boolean bl = this.isResponseAlreadyCommited(m) || this.isResponseRedirected(m);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseAlreadyHandled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isResponseAlreadyCommited(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseAlreadyCommited", new Object[]{m});
        }
        boolean bl = Boolean.TRUE.equals(m.getExchange().get((Object)"http.response.done"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseAlreadyCommited", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isResponseRedirected(Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseRedirected", new Object[]{outMessage});
        }
        boolean bl = Boolean.TRUE.equals(outMessage.get((Object)"http.request.redirected"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseRedirected", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void writeResponseToStream(OutputStream os, Object responseObj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "writeResponseToStream", new Object[]{os, responseObj});
        }
        try {
            byte[] bytes = responseObj.toString().getBytes("UTF-8");
            os.write(bytes, 0, bytes.length);
        }
        catch (Exception bytes) {
            void ex;
            FFDCFilter.processException((Throwable)bytes, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"447", (Object)((Object)this), (Object[])new Object[]{os, responseObj});
            LOG.severe("Problem with writing the data to the output stream");
            ex.printStackTrace();
            throw new RuntimeException((Throwable)ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "writeResponseToStream");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setResponseStatus(Message message, int status) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "setResponseStatus", new Object[]{message, status});
        }
        message.put((Object)Message.RESPONSE_CODE, (Object)status);
        boolean responseHeadersCopied = this.isResponseHeadersCopied(message);
        if (responseHeadersCopied) {
            HttpServletResponse response = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            response.setStatus(status);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "setResponseStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isResponseHeadersCopied(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseHeadersCopied", new Object[]{message});
        }
        boolean bl = MessageUtils.isTrue((Object)message.get((Object)"http.headers.copied"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "isResponseHeadersCopied", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleFault(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "handleFault", new Object[]{message});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", "handleFault");
        }
    }
}

