/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.model.ProviderInfo;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsProviderCache {
    private final ConcurrentHashMap<Class<?>, SoftReference<ConcurrentHashMap<MediaType, List<List<ProviderInfo<?>>>>>> readerProviderCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, SoftReference<ConcurrentHashMap<MediaType, List<List<ProviderInfo<?>>>>>> writerProviderCache = new ConcurrentHashMap();
    static final long serialVersionUID = 3475780935146097898L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public List<List<ProviderInfo<?>>> getReader(Class<?> type, MediaType mt) {
        if (type == null || mt == null) {
            return Collections.emptyList();
        }
        SoftReference<ConcurrentHashMap<MediaType, List<List<ProviderInfo<?>>>>> mediaTypeToProviderCacheRef = this.readerProviderCache.get(type);
        if (mediaTypeToProviderCacheRef == null || mediaTypeToProviderCacheRef.get() == null) {
            return Collections.emptyList();
        }
        ConcurrentHashMap<MediaType, List<List<ProviderInfo<?>>>> mediaTypeToProviderCache = mediaTypeToProviderCacheRef.get();
        if (mediaTypeToProviderCache == null) {
            return Collections.emptyList();
        }
        if (mediaTypeToProviderCache.containsKey(mt)) {
            return mediaTypeToProviderCache.get(mt);
        }
        return Collections.emptyList();
    }

    public List<List<ProviderInfo<?>>> getWriter(Class<?> type, MediaType mt) {
        if (type == null || mt == null) {
            return Collections.emptyList();
        }
        SoftReference<ConcurrentHashMap<MediaType, List<List<ProviderInfo<?>>>>> mediaTypeToProviderCacheRef = this.writerProviderCache.get(type);
        if (mediaTypeToProviderCacheRef == null || mediaTypeToProviderCacheRef.get() == null) {
            return Collections.emptyList();
        }
        ConcurrentHashMap<MediaType, List<List<ProviderInfo<?>>>> mediaTypeToProviderCache = mediaTypeToProviderCacheRef.get();
        if (mediaTypeToProviderCache == null) {
            return Collections.emptyList();
        }
        if (mediaTypeToProviderCache.containsKey(mt)) {
            return mediaTypeToProviderCache.get(mt);
        }
        return Collections.emptyList();
    }

    public void putReader(Class<?> type, MediaType mt, List<List<ProviderInfo<?>>> candidates) {
        ConcurrentHashMap<Object, Object> mediaTypeToProviderCache;
        if (type == null || mt == null || candidates == null || candidates.size() == 0) {
            return;
        }
        SoftReference<ConcurrentHashMap<Object, List<List<Object>>>> mediaTypeToProviderCacheRef = this.readerProviderCache.get(type);
        if (mediaTypeToProviderCacheRef == null || mediaTypeToProviderCacheRef.get() == null) {
            mediaTypeToProviderCache = new ConcurrentHashMap();
            mediaTypeToProviderCacheRef = new SoftReference(mediaTypeToProviderCache);
            this.readerProviderCache.put(type, mediaTypeToProviderCacheRef);
        }
        if (mediaTypeToProviderCacheRef != null && (mediaTypeToProviderCache = mediaTypeToProviderCacheRef.get()) != null) {
            mediaTypeToProviderCache.put(mt, candidates);
        }
    }

    public void putWriter(Class<?> type, MediaType mt, List<List<ProviderInfo<?>>> candidates) {
        ConcurrentHashMap<Object, Object> mediaTypeToProviderCache;
        if (type == null || mt == null || candidates == null || candidates.size() == 0) {
            return;
        }
        SoftReference<ConcurrentHashMap<Object, List<List<Object>>>> mediaTypeToProviderCacheRef = this.writerProviderCache.get(type);
        if (mediaTypeToProviderCacheRef == null || mediaTypeToProviderCacheRef.get() == null) {
            mediaTypeToProviderCache = new ConcurrentHashMap();
            mediaTypeToProviderCacheRef = new SoftReference(mediaTypeToProviderCache);
            this.writerProviderCache.put(type, mediaTypeToProviderCacheRef);
        }
        if (mediaTypeToProviderCacheRef != null && (mediaTypeToProviderCache = mediaTypeToProviderCacheRef.get()) != null) {
            mediaTypeToProviderCache.put(mt, candidates);
        }
    }

    public void destroy() {
        this.readerProviderCache.clear();
        this.writerProviderCache.clear();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LibertyJaxRsProviderCache.class);
    }
}

