/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Collection;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassRedefiner {
    private static final TraceComponent tc = Tr.register(ClassRedefiner.class);
    private static final String LS = System.getProperty("line.separator");
    private final Instrumentation inst;
    static final long serialVersionUID = 2420101865139508526L;

    public ClassRedefiner(Instrumentation inst) {
        this.inst = inst;
    }

    public boolean canRedefine() {
        return this.inst != null && this.inst.isRedefineClassesSupported();
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={UnsupportedOperationException.class})
    public boolean redefineClasses(Set<ClassDefinition> classDefinitions) {
        boolean b = false;
        if (this.canRedefine()) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("About to redefine classes: " + ClassRedefiner.toString(classDefinitions)), (Object[])new Object[0]);
                }
                this.inst.redefineClasses(classDefinitions.toArray(new ClassDefinition[classDefinitions.size()]));
                b = true;
            }
            catch (UnsupportedOperationException uoe) {
            }
            catch (UnmodifiableClassException uoe) {
                FFDCFilter.processException((Throwable)uoe, (String)"com.ibm.ws.classloading.internal.util.ClassRedefiner", (String)"60", (Object)this, (Object[])new Object[]{classDefinitions});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void uce;
                    Tr.debug((TraceComponent)tc, (String)"redefineClasses caught unexpected exception ", (Object[])new Object[]{uce});
                }
            }
            catch (LinkageError uce) {
                FFDCFilter.processException((Throwable)uce, (String)"com.ibm.ws.classloading.internal.util.ClassRedefiner", (String)"66", (Object)this, (Object[])new Object[]{classDefinitions});
            }
            catch (Exception le) {
                FFDCFilter.processException((Throwable)le, (String)"com.ibm.ws.classloading.internal.util.ClassRedefiner", (String)"69", (Object)this, (Object[])new Object[]{classDefinitions});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"redefineClasses ", (Object[])new Object[]{b});
        }
        return b;
    }

    @Trivial
    private static String toString(Collection<ClassDefinition> classDefinitions) {
        StringBuilder sb = new StringBuilder();
        for (ClassDefinition def : classDefinitions) {
            sb.append(LS + "  ").append(def.getDefinitionClass()).append(" size: " + def.getDefinitionClassFile().length);
        }
        return sb.toString();
    }
}

