/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.routing.member.VHostChangeListener;
import com.ibm.ws.collective.routing.member.VHostRoutingInfoManager;
import com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfo;
import com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoMBeanImpl;
import com.ibm.ws.collective.routing.member.internal.WebModuleRoutingInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleMetaDataListener.class, AllServiceListener.class, ApplicationStateListener.class}, property={"service.vendor=IBM"})
public class ApplicationRoutingInfoPublisher
implements ModuleMetaDataListener,
ApplicationStateListener,
AllServiceListener,
NotificationListener,
VHostChangeListener {
    private static final TraceComponent tc = Tr.register(ApplicationRoutingInfoPublisher.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    private VHostRoutingInfoManager vhostRoutingInfoManager;
    private final ConcurrentHashMap<String, ApplicationRoutingInfo> applicationsOnServer = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ApplicationRoutingInfoMBeanImpl> ariMBeans = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<J2EEName, WebModuleMetaData>> webModulesInStartingApps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<J2EEName, WebModuleMetaData>> webModulesInStartedApps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<J2EEName, WebModuleMetaData>> webModulesInStoppedApps = new ConcurrentHashMap();
    private final Object webModulesInStartingApps_lock = new Object(){
        static final long serialVersionUID = 6778557605091141864L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private final Object ariUpdatedOrCreated_lock = new Object(){
        static final long serialVersionUID = 3056484847511813614L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class);
        }
    };
    private final ConcurrentHashMap<J2EEName, Container> webApplicationModuleContainers = new ConcurrentHashMap();
    private final ConcurrentHashMap<J2EEName, WebModuleRoutingInfo> webModuleInfos = new ConcurrentHashMap();
    static final long serialVersionUID = 7168018363982706643L;

    @Reference
    protected void setVHostRoutingInfoManager(VHostRoutingInfoManager service) {
        this.vhostRoutingInfoManager = service;
    }

    protected void unsetVHostRoutingInfoManager(VHostRoutingInfoManager service) {
        this.vhostRoutingInfoManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) throws MetaDataException {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            boolean firstModule;
            String appName = ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication();
            Object object = this.webModulesInStartingApps_lock;
            synchronized (object) {
                if (this.webModulesInStartingApps.containsKey(appName)) {
                    this.webModulesInStartingApps.get(appName).put(((ModuleMetaData)event.getMetaData()).getJ2EEName(), (WebModuleMetaData)event.getMetaData());
                    this.webApplicationModuleContainers.put(((ModuleMetaData)event.getMetaData()).getJ2EEName(), event.getContainer());
                    firstModule = false;
                } else {
                    ConcurrentHashMap<J2EEName, WebModuleMetaData> moduleMetadatas = new ConcurrentHashMap<J2EEName, WebModuleMetaData>();
                    moduleMetadatas.put(((ModuleMetaData)event.getMetaData()).getJ2EEName(), (WebModuleMetaData)event.getMetaData());
                    this.webApplicationModuleContainers.put(((ModuleMetaData)event.getMetaData()).getJ2EEName(), event.getContainer());
                    this.webModulesInStartingApps.put(appName, moduleMetadatas);
                    firstModule = true;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (firstModule) {
                    Tr.debug((TraceComponent)tc, (String)("WebModule metadata found for first module in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName()), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("WebModule metadata found for additional module in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName()), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        String appName = appInfo.getDeploymentName();
        if (null == appName) {
            return;
        }
        ConcurrentHashMap<J2EEName, WebModuleMetaData> modules = this.webModulesInStartingApps.remove(appName);
        if (null == modules) return;
        ConcurrentHashMap<J2EEName, WebModuleMetaData> modulesinStoppedApp = this.webModulesInStoppedApps.remove(appName);
        this.webModulesInStartedApps.put(appName, modules);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating ApplicationRoutingInfo MBean for " + appName), (Object[])new Object[0]);
        }
        ArrayList<WebModuleRoutingInfo> modulesInThisApp = new ArrayList<WebModuleRoutingInfo>();
        int numModulesInThisApp = 0;
        for (Map.Entry<J2EEName, WebModuleMetaData> entry : modules.entrySet()) {
            WebModuleRoutingInfo wmInfo;
            WebModuleMetaData wmmd = entry.getValue();
            if (null != modulesinStoppedApp) {
                modulesinStoppedApp.remove(entry.getKey());
            }
            if (null != (wmInfo = this.webModuleInfos.get(wmmd.getJ2EEName()))) {
                wmInfo.update(wmmd, this.webApplicationModuleContainers.get(wmmd.getJ2EEName()), this.vhostRoutingInfoManager.getVirtualHosts());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Updated WebModuleInfo for " + wmmd.getJ2EEName()), (Object[])new Object[0]);
                }
            } else {
                wmInfo = new WebModuleRoutingInfo(wmmd, this.webApplicationModuleContainers.get(wmmd.getJ2EEName()), this.vhostRoutingInfoManager.getVirtualHosts());
                this.webModuleInfos.put(wmmd.getJ2EEName(), wmInfo);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created WebModuleInfo for " + wmmd.getJ2EEName()), (Object[])new Object[0]);
                }
            }
            modulesInThisApp.add(wmInfo);
            numModulesInThisApp += wmInfo.getJsonRepresentation().size();
        }
        if (null != modulesinStoppedApp) {
            for (WebModuleMetaData wmmd : modulesinStoppedApp.values()) {
                this.webApplicationModuleContainers.remove(wmmd.getJ2EEName());
                this.webModuleInfos.remove(wmmd.getJ2EEName());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Removeded WebModuleInfo for " + wmmd.getJ2EEName()), (Object[])new Object[0]);
            }
        }
        Object object = this.ariUpdatedOrCreated_lock;
        synchronized (object) {
            ApplicationRoutingInfoMBeanImpl ariMBean;
            ApplicationRoutingInfo ari = this.applicationsOnServer.get(appName);
            if (null == ari) {
                ari = new ApplicationRoutingInfo(((ExtendedApplicationInfo)appInfo).getMetaData().getJ2EEName(), modulesInThisApp);
                this.applicationsOnServer.put(appName, ari);
                try {
                    if (false >= numModulesInThisApp) return;
                    ariMBean = new ApplicationRoutingInfoMBeanImpl(ari);
                    this.ariMBeans.put(ari.getApplicationName(), ariMBean);
                    ariMBean.register();
                    if (!TraceComponent.isAnyTracingEnabled()) return;
                    if (!tc.isDebugEnabled()) return;
                    Tr.debug((TraceComponent)tc, (String)("Creating new MBean for ApplicationRoutingInfo =  " + ari), (Object[])new Object[0]);
                }
                catch (NotCompliantMBeanException wmInfo) {
                    void e;
                    FFDCFilter.processException((Throwable)wmInfo, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher", (String)"242", (Object)this, (Object[])new Object[]{appInfo});
                    if (!TraceComponent.isAnyTracingEnabled()) return;
                    if (!tc.isDebugEnabled()) return;
                    Tr.debug((TraceComponent)tc, (String)("Error registering ApplicationRoutingInfoMBean " + e.getMessage()), (Object[])new Object[0]);
                }
            } else {
                ari.update(modulesInThisApp);
                if (ari.getDigest().equals(ari.getPrevDigest())) return;
                if (0 < numModulesInThisApp) {
                    ariMBean = this.ariMBeans.get(ari.getApplicationName());
                    if (ariMBean != null) {
                        ariMBean.update(ari);
                        if (!TraceComponent.isAnyTracingEnabled()) return;
                        if (!tc.isDebugEnabled()) return;
                        Tr.debug((TraceComponent)tc, (String)("Updating MBean for ApplicationRoutingInfo =  " + ari), (Object[])new Object[0]);
                    } else {
                        try {
                            ariMBean = new ApplicationRoutingInfoMBeanImpl(ari);
                            this.ariMBeans.put(ari.getApplicationName(), ariMBean);
                            ariMBean.register();
                            if (!TraceComponent.isAnyTracingEnabled()) return;
                            if (!tc.isDebugEnabled()) return;
                            Tr.debug((TraceComponent)tc, (String)("Creating new MBean for ApplicationRoutingInfo after restart of the application =  " + ari), (Object[])new Object[0]);
                        }
                        catch (NotCompliantMBeanException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher", (String)"274", (Object)this, (Object[])new Object[]{appInfo});
                            if (!TraceComponent.isAnyTracingEnabled()) return;
                            if (!tc.isDebugEnabled()) return;
                            Tr.debug((TraceComponent)tc, (String)("Error registering ApplicationRoutingInfoMBean on application restart " + e.getMessage()), (Object[])new Object[0]);
                        }
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("No modules enabled for routing in app =  " + ari.getApplicationName() + " ... unregister MBean"), (Object[])new Object[0]);
                    }
                    if ((ariMBean = this.ariMBeans.remove(ari.getApplicationName())) == null) return;
                    ariMBean.unregister();
                    if (!TraceComponent.isAnyTracingEnabled()) return;
                    if (!tc.isDebugEnabled()) return;
                    Tr.debug((TraceComponent)tc, (String)("MBean associated with " + ari.getApplicationName() + " unregistered successfully due to application restart with no routable modules"), (Object[])new Object[0]);
                }
            }
            return;
        }
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        if (null == appName) {
            return;
        }
        if (this.webModulesInStartingApps.containsKey(appName)) {
            ConcurrentHashMap<J2EEName, WebModuleMetaData> modules = this.webModulesInStartingApps.remove(appName);
            for (WebModuleMetaData wmmd : modules.values()) {
                this.webApplicationModuleContainers.remove(wmmd.getJ2EEName());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Web application " + appName + " stopped due to error"), (Object[])new Object[0]);
            }
        } else if (this.webModulesInStartedApps.containsKey(appName)) {
            ConcurrentHashMap<J2EEName, WebModuleMetaData> modules = this.webModulesInStartedApps.remove(appName);
            this.webModulesInStoppedApps.put(appName, modules);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Web application " + appName + " stopped"), (Object[])new Object[0]);
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (4 == event.getType()) {
            ServiceReference sr = event.getServiceReference();
            String appName = (String)sr.getProperty("name");
            this.uninstallApplication(appName);
        }
    }

    private void uninstallApplication(String appName) {
        ConcurrentHashMap<J2EEName, WebModuleMetaData> modules = this.webModulesInStoppedApps.remove(appName);
        if (null == modules) {
            modules = this.webModulesInStartedApps.remove(appName);
        }
        if (null == modules) {
            modules = this.webModulesInStartingApps.remove(appName);
        }
        if (null != modules) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Web application " + appName + " unregistered"), (Object[])new Object[0]);
            }
            for (WebModuleMetaData wmmd : modules.values()) {
                this.webApplicationModuleContainers.remove(wmmd.getJ2EEName());
                this.webModuleInfos.remove(wmmd.getJ2EEName());
            }
            ApplicationRoutingInfo ari = this.applicationsOnServer.remove(appName);
            if (ari != null) {
                ApplicationRoutingInfoMBeanImpl ariMBean = this.ariMBeans.remove(ari.getApplicationName());
                ariMBean.unregister();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("MBean associated with " + ari.getApplicationName() + " unregistered successfully due to application uninstall"), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onVhostChange(String vhostName, String[] oldAliases, String[] newAliases) {
        if (null == vhostName) {
            return;
        }
        if (FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Skipping update of vhost data due to server in stopping state", (Object[])new Object[0]);
            }
            return;
        }
        this.updateApplicationReferences(vhostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateApplicationReferences(String virtualHost) {
        Object object = this.ariUpdatedOrCreated_lock;
        synchronized (object) {
            if (this.applicationsOnServer != null && !this.applicationsOnServer.isEmpty()) {
                for (Map.Entry<String, ApplicationRoutingInfo> app : this.applicationsOnServer.entrySet()) {
                    ApplicationRoutingInfoMBeanImpl ariMBean;
                    ApplicationRoutingInfo ari = app.getValue();
                    boolean ariAffected = false;
                    int numModulesInThisApp = 0;
                    for (WebModuleRoutingInfo wmri : ari.getWMRIs()) {
                        if (wmri.getVirtualHostName().equals(virtualHost)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Updating VirtualHosts for " + wmri.j2eeName.toString()), (Object[])new Object[0]);
                            }
                            wmri.updateVhosts(this.vhostRoutingInfoManager.getVirtualHosts());
                            ariAffected = true;
                        }
                        numModulesInThisApp += wmri.getJsonRepresentation().size();
                    }
                    if (!ariAffected) continue;
                    ari.update();
                    if (ari.getDigest().equals(ari.getPrevDigest())) continue;
                    if (0 < numModulesInThisApp) {
                        ariMBean = this.ariMBeans.get(ari.getApplicationName());
                        if (ariMBean != null) {
                            ariMBean.update(ari);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Updating MBean for ApplicationRoutingInfo due to vHost update =  " + ari), (Object[])new Object[0]);
                            continue;
                        }
                        try {
                            ariMBean = new ApplicationRoutingInfoMBeanImpl(ari);
                            this.ariMBeans.put(ari.getApplicationName(), ariMBean);
                            ariMBean.register();
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Creating new MBean for ApplicationRoutingInfo due to vhost update =  " + ari), (Object[])new Object[0]);
                        }
                        catch (NotCompliantMBeanException wmri) {
                            void e;
                            FFDCFilter.processException((Throwable)wmri, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher", (String)"456", (Object)this, (Object[])new Object[]{virtualHost});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Error registering ApplicationRoutingInfoMBean on vhost update " + e.getMessage()), (Object[])new Object[0]);
                        }
                        continue;
                    }
                    ariMBean = this.ariMBeans.remove(ari.getApplicationName());
                    if (ariMBean == null) continue;
                    ariMBean.unregister();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("MBean associated with " + ari.getApplicationName() + " unregistered successfully after vhost update"), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(ComponentContext context) {
        block2: {
            BundleContext bundleContext = context.getBundleContext();
            try {
                bundleContext.addServiceListener((ServiceListener)this, "(jmx.objectname=*com.ibm.websphere.application.ApplicationMBean*)");
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher", (String)"487", (Object)this, (Object[])new Object[]{context});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("activate error " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        this.vhostRoutingInfoManager.addVHostChangeListener(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        BundleContext bundleContext = context.getBundleContext();
        bundleContext.removeServiceListener((ServiceListener)this);
        this.vhostRoutingInfoManager.removeVHostChangeListener(this);
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
    }
}

