/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthenticationResult {
    private final AuthResult status;
    private int taiChallengeCode = 401;
    public String realm = null;
    public String username = null;
    public String password = null;
    public String certdn = null;
    private Subject subject = null;
    private String reason;
    private String redirectURL;
    private final List<Cookie> cookieList = new ArrayList<Cookie>();
    static final long serialVersionUID = -6474473680828516041L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AuthenticationResult(AuthResult status, Subject _subject) {
        this.status = status;
        this.subject = _subject;
    }

    public AuthenticationResult(AuthResult status, String str) {
        this.status = status;
        this.subject = null;
        switch (status) {
            case FAILURE: {
                this.reason = str;
                break;
            }
            case SEND_401: {
                this.realm = str;
                break;
            }
            case REDIRECT: {
                this.redirectURL = str;
                break;
            }
            case OAUTH_CHALLENGE: {
                this.reason = str;
                break;
            }
        }
    }

    public AuthenticationResult(AuthResult status, String str, int taiChallengeCode) {
        this(status, str);
        this.taiChallengeCode = taiChallengeCode;
    }

    public int getTAIChallengeCode() {
        return this.taiChallengeCode;
    }

    public AuthResult getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        return "DEFAULT";
    }

    public String getUserName() {
        if (this.username != null) {
            return this.username;
        }
        return null;
    }

    public String getCertificateDN() {
        return this.certdn;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void clearCookieList() {
        this.cookieList.clear();
    }

    public void setCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public List<Cookie> getCookies() {
        return this.cookieList;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("AuthenticationResult status=");
        str.append(this.status.toString());
        switch (this.status) {
            case FAILURE: {
                str.append(" reason=");
                str.append(this.reason);
                break;
            }
            case SEND_401: {
                str.append(" realm=");
                str.append(this.realm);
                break;
            }
            case REDIRECT: {
                str.append(" redirectURL=");
                str.append(this.redirectURL);
                break;
            }
            case OAUTH_CHALLENGE: {
                str.append(" reason=");
                str.append(this.reason);
                break;
            }
        }
        return str.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AuthenticationResult.class);
    }
}

