/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wlp.ant;

import com.ibm.websphere.wlp.ant.ServerTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractTask
extends Task {
    protected File installDir;
    protected File userDir;
    protected File outputDir;
    protected File serverConfigRoot = null;
    protected File serverOutputDir = null;
    protected String serverName;
    protected String ref;
    protected static String osName;
    protected static boolean isWindows;
    protected ProcessBuilder processBuilder;
    protected static final String DEFAULT_SERVER = "defaultServer";
    protected static final String DEFAULT_LOG_FILE = "logs/console.log";
    protected static final String WLP_USER_DIR_VAR = "WLP_USER_DIR";
    protected static final String WLP_OUTPUT_DIR_VAR = "WLP_OUTPUT_DIR";
    protected static final String START_MESSAGE_CODE = "CWWKF0011I";
    protected static final String STOP_MESSAGE_CODE = "CWWKE0036I";
    protected static final String START_APP_MESSAGE_CODE_REG = "CWWKZ0001I.*";
    protected static final String STOP_APP_MESSAGE_CODE_REG = "CWWKZ0009I.*";
    protected static final ResourceBundle messages;

    protected void initTask() {
        Object serverRef;
        if (this.ref != null && (serverRef = this.getProject().getReference(this.ref)) != null && serverRef instanceof ServerTask) {
            this.setInstallDir(((ServerTask)((Object)serverRef)).getInstallDir());
            this.setServerName(((ServerTask)((Object)serverRef)).getServerName());
            this.setUserDir(((ServerTask)((Object)serverRef)).getUserDir());
            this.setOutputDir(((ServerTask)((Object)serverRef)).getOutputDir());
        }
        try {
            if (this.installDir != null) {
                this.installDir = this.installDir.getCanonicalFile();
                File file = new File(this.installDir, "lib/ws-launch.jar");
                if (!file.exists()) {
                    throw new BuildException(messages.getString("error.installDir.set"));
                }
            } else {
                throw new BuildException(messages.getString("error.installDir.validate"));
            }
            this.log(MessageFormat.format(messages.getString("info.variable"), "installDir", this.installDir));
            if (this.serverName == null) {
                this.setServerName(DEFAULT_SERVER);
            }
            this.processBuilder = new ProcessBuilder(new String[0]);
            if (this.userDir != null && this.userDir.isDirectory()) {
                this.log(MessageFormat.format(messages.getString("info.variable"), WLP_USER_DIR_VAR, this.userDir.getCanonicalPath()), 3);
                this.processBuilder.environment().put(WLP_USER_DIR_VAR, this.userDir.getCanonicalPath());
                this.serverConfigRoot = new File(this.userDir, "servers/" + this.serverName);
            } else {
                this.serverConfigRoot = new File(this.installDir, "usr/servers/" + this.serverName);
            }
            this.log(MessageFormat.format(messages.getString("info.variable"), "ConfigDir", this.serverConfigRoot.getCanonicalPath()));
            if (this.outputDir != null && this.outputDir.isDirectory()) {
                this.log(MessageFormat.format(messages.getString("info.variable"), WLP_OUTPUT_DIR_VAR, this.outputDir.getCanonicalPath()), 3);
                this.processBuilder.environment().put(WLP_OUTPUT_DIR_VAR, this.outputDir.getCanonicalPath());
                this.serverOutputDir = new File(this.outputDir, this.serverName);
            } else {
                this.serverOutputDir = this.serverConfigRoot;
            }
            this.log(MessageFormat.format(messages.getString("info.variable"), "OutputDir", this.serverOutputDir.getCanonicalPath()));
        }
        catch (BuildException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        osName = System.getProperty("os.name", "unknown").toLowerCase();
        isWindows = osName.indexOf("windows") >= 0;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(File installDir) {
        this.installDir = installDir;
    }

    public File getUserDir() {
        return this.userDir;
    }

    public void setUserDir(File userDir) {
        this.userDir = userDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public File getLogFile() {
        return new File(this.serverOutputDir, DEFAULT_LOG_FILE);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void checkReturnCode(Process p, String commandLine, int expected) throws InterruptedException {
        this.log(MessageFormat.format(messages.getString("info.variable"), "Invoke command", commandLine, 3));
        StreamCopier copier = new StreamCopier(p.getInputStream());
        copier.start();
        int exitVal = p.waitFor();
        copier.doJoin();
        if (exitVal != expected) {
            throw new BuildException(MessageFormat.format(messages.getString("error.invoke.command"), commandLine, exitVal, expected));
        }
    }

    protected void validateServerStarted(File outputFile, long startTimeout) throws Exception {
        boolean serverStarted = false;
        this.log("Waiting up to " + startTimeout / 1000L + " seconds for server confirmation:  " + START_MESSAGE_CODE.toString() + " to be found in " + outputFile);
        try {
            String startMessage = this.waitForStringInLog(START_MESSAGE_CODE, startTimeout, outputFile);
            serverStarted = startMessage != null;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (!serverStarted) {
            throw new BuildException(messages.getString("error.server.fail"));
        }
    }

    public String waitForStringInLog(String regexp, long timeout, File outputFile) {
        int waited = 0;
        int waitIncrement = 500;
        this.log(MessageFormat.format(messages.getString("info.search.string"), regexp, outputFile.getAbsolutePath(), timeout / 1000L));
        try {
            while ((long)waited <= timeout) {
                String string = this.findStringInFile(regexp, outputFile);
                if (string == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    waited += 500;
                    continue;
                }
                return string;
            }
            this.log(MessageFormat.format(messages.getString("error.serch.string.timeout"), regexp, outputFile.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return null;
    }

    protected String findStringInFile(String regexp, File fileToSearch) throws Exception {
        String foundString = null;
        List<String> matches = this.findStringsInFileCommon(regexp, true, -1, fileToSearch);
        if (matches != null && !matches.isEmpty()) {
            foundString = matches.get(0);
        }
        return foundString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> findStringsInFileCommon(String regexp, boolean stopOnFirst, int searchLimit, File fileToSearch) throws Exception {
        if (fileToSearch == null) {
            this.log(messages.getString("info.file.validated"));
            return null;
        }
        if (!fileToSearch.exists()) {
            this.log(MessageFormat.format(messages.getString("info.file.validate.noexist"), fileToSearch.getCanonicalPath()));
            return null;
        }
        FileInputStream serverOutput = null;
        InputStreamReader in = null;
        Scanner s = null;
        ArrayList<String> matches = null;
        try {
            serverOutput = new FileInputStream(fileToSearch);
            in = new InputStreamReader(serverOutput);
            s = new Scanner(in);
            this.log(MessageFormat.format(messages.getString("info.look.string.infile"), regexp, fileToSearch.getName()), 3);
            String foundString = null;
            Pattern pattern = Pattern.compile(regexp);
            matches = new ArrayList<String>();
            while (s.hasNextLine()) {
                if (foundString != null && stopOnFirst) {
                    break;
                }
                if (searchLimit <= 0 && searchLimit >= matches.size()) {
                    break;
                }
                String line = s.nextLine();
                if (!pattern.matcher(line).find()) continue;
                foundString = line;
                matches.add(line);
                this.log(MessageFormat.format(messages.getString("info.match.string"), matches.size(), line));
            }
        }
        catch (Exception e) {
            this.log(e.toString());
        }
        finally {
            try {
                s.close();
            }
            catch (Exception e) {}
            try {
                ((InputStream)serverOutput).close();
            }
            catch (Exception e) {}
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return matches;
    }

    protected void stopServer(String timeout) {
        ServerTask st = new ServerTask();
        st.setProject(this.getProject());
        st.setInstallDir(this.getInstallDir());
        st.setUserDir(this.getUserDir());
        st.setOutputDir(this.getOutputDir());
        st.setServerName(this.getServerName());
        st.setTimeout(timeout);
        st.setOperation("stop");
        st.execute();
    }

    static {
        messages = ResourceBundle.getBundle("com.ibm.websphere.wlp.ant.AntMessages");
    }

    private class StreamCopier
    extends Thread {
        private final BufferedReader reader;
        private boolean joined;
        private boolean terminated;

        StreamCopier(InputStream input) {
            this.reader = new BufferedReader(new InputStreamReader(input));
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Object line;
                while ((line = this.reader.readLine()) != null) {
                    StreamCopier streamCopier = this;
                    synchronized (streamCopier) {
                        if (this.joined) {
                            return;
                        }
                        AbstractTask.this.log((String)line);
                    }
                }
                return;
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            finally {
                if (isWindows) {
                    StreamCopier streamCopier = this;
                    synchronized (streamCopier) {
                        this.terminated = true;
                        this.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doJoin() throws InterruptedException {
            if (isWindows) {
                StreamCopier streamCopier = this;
                synchronized (streamCopier) {
                    long begin = System.nanoTime();
                    long end = begin + TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
                    long duration = end - begin;
                    while (!this.terminated && duration > 0L) {
                        TimeUnit.NANOSECONDS.timedWait(this, duration);
                        duration = end - System.nanoTime();
                    }
                    this.joined = true;
                }
            } else {
                super.join();
            }
        }
    }

    public static enum ReturnCode {
        OK(0),
        REDUNDANT_ACTION_STATUS(1),
        SERVER_NOT_EXIST_STATUS(2),
        SERVER_ACTIVE_STATUS(3),
        SERVER_INACTIVE_STATUS(4),
        BAD_ARGUMENT(20),
        ERROR_SERVER_STOP(21),
        ERROR_SERVER_START(22),
        LOCATION_EXCEPTION(23),
        LAUNCH_EXCEPTION(24),
        RUNTIME_EXCEPTION(25),
        UNKNOWN_EXCEPTION(26),
        PROCESS_CLIENT_EXCEPTION(27),
        ERROR_SERVER_PACKAGE(28),
        ERROR_SERVER_DUMP(29),
        ERROR_SERVER_ATTACH(30);

        final int val;

        private ReturnCode(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

