/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.quiesce.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.quiesce.impl.DestroyCallback;

class EntityManagerProxyFactory {
    EntityManagerProxyFactory() {
    }

    static EntityManager create(EntityManager delegate, DestroyCallback destroyCallback) {
        ClassLoader cl = delegate.getClass().getClassLoader();
        Class[] ifAr = new Class[]{EntityManager.class};
        return (EntityManager)Proxy.newProxyInstance(cl, ifAr, (InvocationHandler)new EMHandler(delegate, destroyCallback));
    }

    static class EMHandler
    implements InvocationHandler {
        private EntityManager delegate;
        private DestroyCallback destroyCallback;

        public EMHandler(EntityManager delegate, DestroyCallback destroyCallback) {
            this.delegate = delegate;
            this.destroyCallback = destroyCallback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object res = null;
            try {
                res = method.invoke((Object)this.delegate, args);
            }
            catch (IllegalArgumentException e) {
                new PersistenceException(NLS.MESSAGES.getMessage("wrong.JPA.version", new Object[]{method.getName(), this.delegate}), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if ("close".equals(method.getName())) {
                this.destroyCallback.callback();
            }
            return res;
        }
    }
}

