/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfoFactory;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.unit.impl.ManagedPersistenceUnitInfoFactoryImpl;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedPersistenceUnitFactoryFactory {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");

    public static ManagedPersistenceUnitInfoFactory create(Bundle bundle) {
        String className;
        Properties config = new Properties();
        URL u = bundle.getResource("org.apache.aries.jpa.container.properties");
        if (u != null) {
            if (_logger.isInfoEnabled()) {
                _logger.info(NLS.MESSAGES.getMessage("aries.jpa.config.file.found", new Object[]{"org.apache.aries.jpa.container.properties", bundle.getSymbolicName(), bundle.getVersion(), config}));
            }
            try {
                config.load(u.openStream());
            }
            catch (IOException e) {
                _logger.error(NLS.MESSAGES.getMessage("aries.jpa.config.file.read.error", new Object[]{"org.apache.aries.jpa.container.properties", bundle.getSymbolicName(), bundle.getVersion()}), (Throwable)e);
            }
        } else if (_logger.isInfoEnabled()) {
            _logger.info(NLS.MESSAGES.getMessage("aries.jpa.config.file.not.found", new Object[]{"org.apache.aries.jpa.container.properties", bundle.getSymbolicName(), bundle.getVersion(), config}));
        }
        if ((className = config.getProperty("org.apache.aries.jpa.container.ManagedPersistenceUnitInfoFactory")) != null) {
            try {
                Class clazz = bundle.loadClass(className);
                return (ManagedPersistenceUnitInfoFactory)clazz.newInstance();
            }
            catch (Exception e) {
                _logger.error(NLS.MESSAGES.getMessage("unable.to.create.mpuif", new Object[]{className}), (Throwable)e);
            }
        }
        return new ManagedPersistenceUnitInfoFactoryImpl();
    }
}

