/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rest.handler.helper;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.plugins.CollectivePlugin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.webcontainer.util.RequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.net.ssl.HttpsURLConnection;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DefaultRoutingHelper.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class DefaultRoutingHelper {
    private static final TraceComponent tc = Tr.register(DefaultRoutingHelper.class);
    private static final String KEY_COLLECTIVE_PLUGIN = "collectivePlugin";
    private final AtomicServiceReference<CollectivePlugin> collectivePluginRef = new AtomicServiceReference("collectivePlugin");
    static final long serialVersionUID = 1145786037091541963L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.collectivePluginRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.collectivePluginRef.deactivate(cc);
    }

    @Reference(name="collectivePlugin", service=CollectivePlugin.class)
    protected void setCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        this.collectivePluginRef.setReference(ref);
    }

    protected void unsetCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        this.collectivePluginRef.unsetReference(ref);
    }

    private CollectivePlugin getCollectivePlugin() {
        CollectivePlugin plugin = (CollectivePlugin)this.collectivePluginRef.getService();
        if (plugin == null) {
            throw new RuntimeException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"CollectivePlugin"}, (String)"CWWKO1001E: OSGi service {0} is not available."));
        }
        return plugin;
    }

    public void routeRequest(RESTRequest request, RESTResponse response) throws IOException {
        this.routeRequest(request, response, false);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSuchElementException.class})
    public void routeRequest(RESTRequest request, RESTResponse response, boolean legacyURI) throws IOException {
        List<RoutingContext> routingContexts = null;
        try {
            routingContexts = DefaultRoutingHelper.getRoutingContext(request);
            if (routingContexts == null) {
                routingContexts = Collections.singletonList(DefaultRoutingHelper.getLegacyRoutingContext(request));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void iae;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"157", (Object)this, (Object[])new Object[]{request, response, legacyURI});
            response.sendError(400, iae.getMessage());
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (RoutingContext context : routingContexts) {
                Tr.debug((Object)"routeRequest", (TraceComponent)tc, (String)("Host: " + context.hostName + " | ServerUsrDir: " + context.serverUserDir + " | ServerName: " + context.serverName), (Object[])new Object[0]);
            }
        }
        for (RoutingContext context : routingContexts) {
            String queryString;
            String[] hostPort;
            if (context.serverUserDir == null || context.serverName == null) {
                throw new IllegalArgumentException("This RESTHandler endpoint does not support host-level routing!");
            }
            try {
                hostPort = this.getHostPortTuple(context.hostName, context.serverUserDir, context.serverName);
            }
            catch (NoSuchElementException e) {
                response.sendError(400, e.getMessage());
                return;
            }
            String uri = request.getURI();
            if (legacyURI) {
                uri = uri.replaceFirst("IBMJMXConnectorREST/router", "IBMJMXConnectorREST");
            }
            if ((queryString = request.getQueryString()) != null && !queryString.isEmpty()) {
                uri = uri + "?" + queryString;
            }
            URL url = new URL("https://" + hostPort[0] + ":" + hostPort[1] + uri);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            boolean doOutput = request.getMethod().equalsIgnoreCase("PUT") || request.getMethod().equalsIgnoreCase("POST");
            connection.setDoInput(true);
            connection.setDoOutput(doOutput);
            connection.setUseCaches(false);
            connection.setRequestMethod(request.getMethod());
            String originalContentType = request.getHeader("Content-Type");
            if (originalContentType != null) {
                connection.setRequestProperty("Content-Type", originalContentType);
            }
            try {
                connection.setSSLSocketFactory(this.getCollectivePlugin().getSSLContent("memberConnectionConfig").getSocketFactory());
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"217", (Object)this, (Object[])new Object[]{request, response, legacyURI});
                throw new RuntimeException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages", (String)"SSL_CONTEXT_NOT_AVAILABLE", (Object[])new Object[]{e.getMessage()}, (String)"CWWKO1002E: Encountered the following exception while resolving a collective member's SSL context: {0}"));
            }
            if (doOutput) {
                this.copyStream(request.getInputStream(), connection.getOutputStream());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Routing to target URL: " + url.toString()), (Object[])new Object[0]);
            }
            int responseCode = connection.getResponseCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Received responseCode: " + responseCode), (Object[])new Object[0]);
            }
            response.setStatus(responseCode);
            this.copyResponseHeaders(connection, response);
            response.setContentType(connection.getContentType());
            if (connection.getErrorStream() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)"Copying input stream", (Object[])new Object[0]);
                }
                this.copyStream(connection.getInputStream(), response.getOutputStream());
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)"Copying error stream", (Object[])new Object[0]);
            }
            this.copyStream(connection.getErrorStream(), response.getOutputStream());
        }
    }

    private void copyResponseHeaders(HttpsURLConnection connection, RESTResponse response) {
        boolean hasMoreFields = true;
        int i = 0;
        while (hasMoreFields) {
            String headerName = connection.getHeaderFieldKey(i);
            String headerValue = connection.getHeaderField(i);
            if (headerName == null) {
                hasMoreFields = false;
                continue;
            }
            response.setResponseHeader(headerName, headerValue);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyStream(InputStream input, OutputStream output) throws IOException {
        if (input != null) {
            long l;
            ReadableByteChannel inputChannel;
            block15: {
                inputChannel = null;
                WritableByteChannel outputChannel = null;
                try {
                    inputChannel = Channels.newChannel(input);
                    outputChannel = Channels.newChannel(output);
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    long size = 0L;
                    buffer.clear();
                    while (inputChannel.read(buffer) >= 0 || buffer.position() != 0) {
                        buffer.flip();
                        size += (long)outputChannel.write(buffer);
                        buffer.compact();
                    }
                    l = size;
                    if (outputChannel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (outputChannel != null) {
                        try {
                            outputChannel.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"301", (Object)this, (Object[])new Object[]{input, output});
                        }
                    }
                    if (inputChannel != null) {
                        try {
                            inputChannel.close();
                        }
                        catch (IOException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"307", (Object)this, (Object[])new Object[]{input, output});
                        }
                    }
                    throw throwable;
                }
                try {
                    outputChannel.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"301", (Object)this, (Object[])new Object[]{input, output});
                }
            }
            if (inputChannel != null) {
                try {
                    inputChannel.close();
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"307", (Object)this, (Object[])new Object[]{input, output});
                }
            }
            return l;
        }
        return 0L;
    }

    private String[] getHostPortTuple(String host, String userDir, String serverName) throws IllegalArgumentException, IOException {
        Map mapJMXAuth = (Map)this.getCollectivePlugin().getPrivateServerNode(host, userDir, serverName, "sys.jmx.auth.info");
        String[] hostPort = new String[2];
        Object o = mapJMXAuth.get("jmxHost");
        if (o != null) {
            hostPort[0] = (String)o;
        }
        if ((o = mapJMXAuth.get("jmxPort")) != null) {
            hostPort[1] = (String)o;
        }
        if (hostPort[0] == null || hostPort[1] == null) {
            throw new RuntimeException("Could not fetch the target host and port for server: {" + host + ", " + userDir + ", " + serverName + "}");
        }
        return hostPort;
    }

    public static boolean containsLegacyRoutingContext(RESTRequest request) {
        return request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.hostName") != null;
    }

    public static boolean containsRoutingContext(RESTRequest request) {
        if (request.getHeader("collective.hostNames") != null) {
            return true;
        }
        return DefaultRoutingHelper.getQueryParameterValue(request, "collective.hostNames") != null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getQueryParameterValue(RESTRequest request, String name) {
        if (!"post".equalsIgnoreCase(request.getMethod())) {
            return request.getParameter(name);
        }
        if (request.getQueryString() == null) {
            return null;
        }
        Hashtable params = null;
        try {
            params = RequestUtils.parseQueryString((String)request.getQueryString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"369", null, (Object[])new Object[]{request, name});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Failed to parse the query string:\n Exception: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        String[] values = (String[])params.get(name);
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getQueryParameterValues(RESTRequest request, String name) {
        if (!"post".equalsIgnoreCase(request.getMethod())) {
            return request.getParameterValues(name);
        }
        if (request.getQueryString() == null) {
            return null;
        }
        Hashtable params = null;
        try {
            params = RequestUtils.parseQueryString((String)request.getQueryString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"400", null, (Object[])new Object[]{request, name});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Failed to parse the query string:\n Exception: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        return (String[])params.get(name);
    }

    public static RoutingContext getLegacyRoutingContext(RESTRequest request) {
        String targetHost = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.hostName");
        if (targetHost != null) {
            String targetUserDir = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir");
            String targetServer = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.serverName");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Found routing context in headers.  Host:" + targetHost + " | UserDir:" + targetUserDir + " | Server:" + targetServer), (Object[])new Object[0]);
            }
            targetHost = DefaultRoutingHelper.URLDecoder(targetHost);
            targetUserDir = targetUserDir == null ? null : DefaultRoutingHelper.URLDecoder(targetUserDir);
            targetServer = targetServer == null ? null : DefaultRoutingHelper.URLDecoder(targetServer);
            return new RoutingContext(targetHost, null, targetUserDir, targetServer);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String URLDecoder(String name) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"439", null, (Object[])new Object[]{name});
            throw new IllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static List<RoutingContext> getRoutingContext(RESTRequest request) {
        String targetHosts = request.getHeader("collective.hostNames");
        if (targetHosts != null) {
            String targetInstallDirs = request.getHeader("collective.installDirs");
            String targetUserDirs = request.getHeader("collective.serverUserDirs");
            String targetServers = request.getHeader("collective.serverNames");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Found routing context in headers.  Hosts:" + targetHosts + " | InstallDirs" + targetInstallDirs + " | UserDirs:" + targetUserDirs + " | Servers:" + targetServers), (Object[])new Object[0]);
            }
            String[] hosts = targetHosts.split(",");
            String[] installDirs = targetInstallDirs == null ? null : targetInstallDirs.split(",");
            String[] userDirs = targetUserDirs == null ? null : targetUserDirs.split(",");
            String[] servers = targetServers == null ? null : targetServers.split(",");
            return DefaultRoutingHelper.assembleRoutingContext(hosts, installDirs, userDirs, servers);
        }
        if (DefaultRoutingHelper.getQueryParameterValue(request, "collective.hostNames") != null) {
            return DefaultRoutingHelper.assembleRoutingContext(DefaultRoutingHelper.getQueryParameterValues(request, "collective.hostNames"), DefaultRoutingHelper.getQueryParameterValues(request, "collective.installDirs"), DefaultRoutingHelper.getQueryParameterValues(request, "collective.serverUserDirs"), DefaultRoutingHelper.getQueryParameterValues(request, "collective.serverNames"));
        }
        return null;
    }

    private static List<RoutingContext> assembleRoutingContext(String[] hosts, String[] installDirs, String[] userDirs, String[] servers) {
        int serversLength;
        int userDirsLength = userDirs == null ? 0 : userDirs.length;
        int n = serversLength = servers == null ? 0 : servers.length;
        if (userDirs != null && hosts.length != userDirsLength || userDirsLength != serversLength) {
            throw new IllegalArgumentException("The length of the routing context parameters did not match: Hosts:" + hosts.length + " | UserDirs:" + userDirsLength + " | Servers:" + serversLength);
        }
        ArrayList<RoutingContext> contexts = new ArrayList<RoutingContext>(hosts.length);
        for (int i = 0; i < hosts.length; ++i) {
            String installDir = installDirs == null ? null : installDirs[i].trim();
            String userDir = userDirs == null ? null : userDirs[i].trim();
            String serverName = servers == null ? null : servers[i].trim();
            contexts.add(new RoutingContext(hosts[i].trim(), installDir, userDir, serverName));
        }
        return contexts;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class RoutingContext {
        public final String hostName;
        public final String serverInstallDir;
        public final String serverUserDir;
        public final String serverName;
        static final long serialVersionUID = -1314477724594346763L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RoutingContext(String hostName, String serverUserDir, String serverName) {
            this(hostName, null, serverUserDir, serverName);
        }

        public RoutingContext(String hostName, String serverInstallDir, String serverUserDir, String serverName) {
            this.hostName = hostName;
            this.serverInstallDir = serverInstallDir;
            this.serverUserDir = serverUserDir;
            this.serverName = serverName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RoutingContext.class);
        }
    }

    public static interface LegacyJMX {
        public static final String CONNECTOR_URI = "IBMJMXConnectorREST";
        public static final String ROUTER_URI = "IBMJMXConnectorREST/router";
        public static final String ROUTING_KEY_HOST_NAME = "com.ibm.websphere.jmx.connector.rest.routing.hostName";
        public static final String ROUTING_KEY_SERVER_NAME = "com.ibm.websphere.jmx.connector.rest.routing.serverName";
        public static final String ROUTING_KEY_SERVER_USER_DIR = "com.ibm.websphere.jmx.connector.rest.routing.serverUserDir";
    }
}

