/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.collective.repository.CollectiveRepositoryMBean;
import com.ibm.websphere.collective.singleton.ElectorFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.MemberJMXEndpoint;
import com.ibm.ws.collective.singleton.ServiceEndpointIdentityImpl;
import com.ibm.ws.collective.singleton.internal.MessengerImpl;
import com.ibm.ws.collective.singleton.internal.SingletonServiceImpl;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.RepositoryConnectionFactory;
import com.ibm.wsspi.collective.repository.RepositoryMember;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.SingletonService;
import com.ibm.wsspi.collective.singleton.extender.Elector;
import com.ibm.wsspi.collective.singleton.extender.SingletonServiceExtender;
import com.ibm.wsspi.collective.singleton.extender.exceptions.ElectorException;
import com.ibm.wsspi.collective.singleton.provider.SingletonServiceManagerProvider;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.ssl.SSLConfiguration;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EventHandler.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "event.topics=com/ibm/ws/management/repository/member/MemberJMXEndpoint/updated"})
public class SingletonServiceManagerImpl
implements SingletonServiceManagerProvider,
EventHandler {
    private static final TraceComponent tc = Tr.register(SingletonServiceManagerImpl.class);
    private BundleContext bundleContext;
    private volatile ServiceRegistration<?> serviceReg = null;
    private Set<SingletonServiceExtender> hostServices;
    private Set<SingletonServiceExtender> collectiveServices;
    private volatile boolean isDeactivated = false;
    private boolean inController = false;
    private RepositoryMember member = null;
    private String memberHost = null;
    private String userDir = null;
    private String serverName = null;
    private int memberPort = 0;
    protected static final String KEY_COLLECTIVE_REPOSITORY_MBEAN = "collectiveRepositoryMBean";
    protected CollectiveRepositoryMBean collectiveRepositoryMBean;
    protected static final String KEY_SSL_SUPPORT = "sslSupport";
    protected SSLSupport sslSupport;
    static final String KEY_MEMBER_JMX_ENDPOINT = "memberJMXEndpoint";
    private MemberJMXEndpoint memberJMXEndpoint;
    static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private WsLocationAdmin locationAdmin;
    static final String KEY_REPOSITORY_CONNECTION_FACTORY_REF = "repositoryConnectionFactory";
    private RepositoryConnectionFactory repositoryConnectionFactory;
    protected static final String KEY_HOST_ELECTOR_FACTORY_REF = "hostElectorFactory";
    protected ElectorFactory hostElectorFactory;
    protected volatile ElectorFactory collectiveElectorFactory;
    static final String KEY_SCHEDULED_EXECUTOR_SERVICE_REF = "scheduledExecutorService";
    protected ScheduledExecutorService scheduledExecutorService;
    private FeatureProvisioner provisionerService;
    protected final Runnable getJMXEndpoint = new Runnable(){
        static final long serialVersionUID = -2233772072539826323L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public void run() {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Getting JMXEndpoint synchronously.", (Object[])new Object[0]);
            }
            SingletonServiceManagerImpl.this.getJMXEndpoint();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = 2892946548017220711L;

    @Reference(name="collectiveRepositoryMBean", service=CollectiveRepositoryMBean.class, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCollectiveRepositoryMBean(CollectiveRepositoryMBean ref) {
        this.collectiveRepositoryMBean = ref;
    }

    protected void unsetCollectiveRepositoryMBean() {
        this.collectiveRepositoryMBean = null;
    }

    @Reference(name="sslSupport", service=SSLSupport.class)
    protected void setSSLSupport(SSLSupport ref) {
        this.sslSupport = ref;
    }

    protected void unsetSSLSupport() {
        this.sslSupport = null;
    }

    @Reference(service=SSLConfiguration.class, target="(id=controllerConnectionConfig)")
    protected void setSSLConfiguration(SSLConfiguration ref) {
    }

    protected void unsetSSLConfiguration() {
    }

    @Reference(name="memberJMXEndpoint", service=MemberJMXEndpoint.class)
    protected void setMemberJMXEndpoint(MemberJMXEndpoint ref) {
        this.memberJMXEndpoint = ref;
    }

    protected void unsetMemberJMXEndpoint() {
        this.memberJMXEndpoint = null;
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin ref) {
        this.locationAdmin = ref;
    }

    protected void unsetLocationAdmin() {
        this.locationAdmin = null;
    }

    @Reference(name="repositoryConnectionFactory", service=RepositoryConnectionFactory.class)
    protected void setRepositoryConnectionFactory(RepositoryConnectionFactory ref) {
        this.repositoryConnectionFactory = ref;
    }

    protected void unsetRepositoryConnectionFactory() {
        this.repositoryConnectionFactory = null;
    }

    @Reference(name="hostElectorFactory", service=ElectorFactory.class, target="(scope=host)")
    protected void setHostElectorFactory(ElectorFactory ref) {
        this.hostElectorFactory = ref;
    }

    protected void unsetHostElectorFactory() {
        this.hostElectorFactory = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(scope=collective)")
    protected void setCollectiveElectorFactory(ElectorFactory ref) {
        this.collectiveElectorFactory = ref;
        this.registerService();
    }

    protected void unsetCollectiveElectorFactory(ElectorFactory ref) {
        if (ref == this.collectiveElectorFactory) {
            this.collectiveElectorFactory = null;
        }
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class)
    protected void setScheduledExecutorService(ScheduledExecutorService svc) {
        this.scheduledExecutorService = svc;
    }

    protected void unsetScheduledExecutorService() {
        this.scheduledExecutorService = null;
    }

    @Reference(service=FeatureProvisioner.class)
    protected void setKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = provisionerService;
    }

    protected void unsetKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = null;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.bundleContext = cc.getBundleContext();
        this.member = this.repositoryConnectionFactory.obtainRepositoryMember();
        this.serverName = this.locationAdmin.getServerName();
        this.userDir = this.locationAdmin.resolveString("${wlp.user.dir}");
        this.hostServices = new CopyOnWriteArraySet<SingletonServiceExtender>();
        this.collectiveServices = new CopyOnWriteArraySet<SingletonServiceExtender>();
        Set installedFeatures = this.provisionerService.getInstalledFeatures();
        if (installedFeatures.contains("collectiveController-1.0")) {
            this.inController = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.inController ? "Running in controller" : "Running in member"), (Object[])new Object[0]);
        }
        this.performAction(this.getJMXEndpoint);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"SingletonServiceManager activated", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"SingletonServiceManager deactivated", (Object[])new Object[0]);
        }
        this.isDeactivated = true;
        this.unregisterService();
        this.hostServices = null;
        this.collectiveServices = null;
        this.bundleContext = null;
    }

    private synchronized void getJMXEndpoint() {
        this.memberHost = this.memberJMXEndpoint.getHostName();
        if (this.memberHost != null) {
            this.memberPort = Integer.parseInt(this.memberJMXEndpoint.getHTTPSPort());
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SingletonServiceManager received new JMX endpoint " + this.memberHost + ":" + this.memberPort), (Object[])new Object[0]);
            }
            this.registerService();
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"JMXEndpoint is not available", (Object[])new Object[0]);
            }
            this.unregisterService();
        }
    }

    private SingletonServiceExtender find(String service, SingletonService.SingletonScope scope) {
        this.validateServiceName(service);
        SingletonServiceExtender result = null;
        for (SingletonServiceExtender s : this.getServicesForScope(scope)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SingletonService.find: check=" + s.getName()), (Object[])new Object[0]);
            }
            if (!s.getName().equals(service)) continue;
            result = s;
            break;
        }
        return result;
    }

    private SingletonServiceExtender create(String service, SingletonService.SingletonScope scope) throws ElectorException {
        SingletonServiceImpl singleton = new SingletonServiceImpl(service, scope, this.scheduledExecutorService);
        singleton.setSingletonServiceManager(this);
        ElectorFactory electorFactory = scope.equals((Object)SingletonService.SingletonScope.COLLECTIVE) ? this.collectiveElectorFactory : this.hostElectorFactory;
        Elector elector = electorFactory.getElector(service);
        elector.setSingletonService((SingletonServiceExtender)singleton);
        singleton.setRepositoryMember(this.member);
        singleton.setElector(elector);
        MessengerImpl messenger = new MessengerImpl();
        messenger.setSingletonServiceManager(this);
        singleton.setMessenger(messenger);
        this.getServicesForScope(scope).add(singleton);
        Tr.info((TraceComponent)tc, (String)"SINGLETON_SERVICE_CREATED", (Object[])new Object[]{service, scope});
        return singleton;
    }

    private void validateServiceName(String service) {
        if (service == null) {
            throw new IllegalArgumentException("Service name cannot be null");
        }
        if (service.isEmpty()) {
            throw new IllegalArgumentException("Service name cannot be empty");
        }
    }

    private Set<SingletonServiceExtender> getServicesForScope(SingletonService.SingletonScope scope) {
        Set<SingletonServiceExtender> services = scope == SingletonService.SingletonScope.HOST ? this.hostServices : this.collectiveServices;
        return services;
    }

    public Set<SingletonServiceExtender> getServices(SingletonService.SingletonScope scope) {
        return this.getServicesForScope(scope);
    }

    public SingletonServiceExtender getService(String service, SingletonService.SingletonScope scope) throws ElectorException {
        SingletonServiceExtender s = this.find(service, scope);
        if (s == null) {
            s = this.create(service, scope);
        }
        return s;
    }

    public void removeService(String service, SingletonService.SingletonScope scope) {
        if (this.isDeactivated) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Not removing service: " + service + " because the SingletonServiceManager is deactivated."), (Object[])new Object[0]);
            }
        } else {
            SingletonServiceExtender s = this.find(service, scope);
            if (s == null) {
                throw new IllegalArgumentException("Service does not exist");
            }
            this.getServicesForScope(scope).remove(s);
            Tr.info((TraceComponent)tc, (String)"SINGLETON_SERVICE_REMOVED", (Object[])new Object[]{service, scope});
        }
    }

    public ServiceEndpointIdentity createServiceEndpointIdentity(String serviceName, SingletonService.SingletonScope scope) {
        return new ServiceEndpointIdentityImpl(this.memberHost, this.userDir, this.serverName, this.memberPort, serviceName, scope);
    }

    public SSLSupport getSSLSupport() {
        return this.sslSupport;
    }

    public void handleEvent(Event event) {
        if (event != null && !this.isDeactivated) {
            if ("com/ibm/ws/management/repository/member/MemberJMXEndpoint/updated".equals(event.getTopic())) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"SingletonServiceManager handling change of JMX endpoint", (Object[])new Object[0]);
                }
                this.getJMXEndpoint();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received unexpected event.", (Object[])new Object[]{event});
            }
        }
    }

    protected synchronized void registerService() {
        if (this.serviceReg == null) {
            if (this.haveServicePrereqs()) {
                if (!this.isDeactivated) {
                    this.serviceReg = this.bundleContext.registerService(new String[]{SingletonServiceManagerProvider.class.getName()}, (Object)this, null);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Registered SingletonServiceManagerProvider", (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Can't register since we're not active", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Can't register since we don't have all prereqs", (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"We're already registered", (Object[])new Object[0]);
        }
    }

    private boolean haveServicePrereqs() {
        boolean result = false;
        if (!(this.memberJMXEndpoint == null || this.memberJMXEndpoint.getHostName() == null || this.inController && this.collectiveElectorFactory == null)) {
            result = true;
        }
        return result;
    }

    protected synchronized void unregisterService() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
            this.serviceReg = null;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unregistered SingletonServiceManagerProvider", (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    @FFDCIgnore(value={NullPointerException.class})
    private void performAction(Runnable action) {
        try {
            this.scheduledExecutorService.submit(action);
        }
        catch (NullPointerException npe) {
            IllegalStateException ise = new IllegalStateException("The action could not be performed - it was likely accessed after the ExecutorService was deactivated.");
            ise.fillInStackTrace();
            throw ise;
        }
    }

    protected void setInController(boolean value) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("inController has been explicitly set to " + value), (Object[])new Object[0]);
        }
        this.inController = value;
    }
}

