/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.config.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.config.internal.Parser;
import com.ibm.ws.security.jaas.config.internal.ParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigFile
extends Parser {
    private static final TraceComponent tc = Tr.register(ConfigFile.class);
    private static final String AUTHPROP = "java.security.auth.login.config";
    private HashMap _fileMap;
    private String _loginFile;
    private boolean singleLogInFile = false;
    private PrivilegedExceptionAction openLoginFileAction = null;
    static final long serialVersionUID = 614026313735955300L;

    ConfigFile(String fn) {
        this._loginFile = fn;
        if (this._loginFile.charAt(0) == '=') {
            this.singleLogInFile = true;
            this._loginFile = this._loginFile.substring(1);
        }
        this.openLoginFileAction = new OpenFileAction(this._loginFile);
        this.buildFileEntry();
    }

    public Map<String, List<AppConfigurationEntry>> getFileMap() {
        return this._fileMap;
    }

    AppConfigurationEntry[] getAppConfigurationEntry(String config) {
        Vector entry = null;
        if (this._fileMap != null && this._fileMap.size() != 0) {
            entry = (Vector)this._fileMap.get(config);
        }
        if (entry == null || entry.size() == 0) {
            return null;
        }
        int appSize = entry.size();
        AppConfigurationEntry[] appConfig = new AppConfigurationEntry[appSize];
        Iterator it = entry.iterator();
        int i = 0;
        while (it.hasNext()) {
            AppConfigurationEntry appCfg = (AppConfigurationEntry)it.next();
            appConfig[i] = new AppConfigurationEntry(appCfg.getLoginModuleName(), appCfg.getControlFlag(), appCfg.getOptions());
            ++i;
        }
        return appConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void buildFileEntry() {
        final HashMap<String, List<AppConfigurationEntry>> result = new HashMap<String, List<AppConfigurationEntry>>();
        Reader reader = null;
        boolean error1 = false;
        try {
            if (this.openLoginFileAction != null) {
                Map<String, List<AppConfigurationEntry>> mapresult;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JAAS login configuration file: " + this._loginFile + " singleLogInFile: " + this.singleLogInFile), (Object[])new Object[0]);
                }
                if ((mapresult = this.parse(reader = (Reader)AccessController.doPrivileged(this.openLoginFileAction))) != null) {
                    result.putAll(mapresult);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JAAS login configuration file: " + this._loginFile + " processed"), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No JAAS login configuration file specified as java.security.auth.login.config property", (Object[])new Object[0]);
            }
        }
        catch (PrivilegedActionException e) {
            void pae;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaas.config.internal.ConfigFile", (String)"142", (Object)this, (Object[])new Object[0]);
            Exception e2 = pae.getException();
            if (e2 instanceof MalformedURLException) {
                Tr.error((TraceComponent)tc, (String)"security.jaas.open.URL", (Object[])new Object[]{this._loginFile, e2});
            } else if (e2 instanceof IOException) {
                Tr.error((TraceComponent)tc, (String)"security.jaas.create.URL", (Object[])new Object[]{this._loginFile, e2});
            }
            error1 = true;
        }
        catch (IOException e) {
            void ioe;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaas.config.internal.ConfigFile", (String)"150", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.jaas.create.URL", (Object[])new Object[]{this._loginFile, ioe});
            error1 = true;
        }
        catch (ParserException e) {
            void pe;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaas.config.internal.ConfigFile", (String)"153", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.jaas.parser.URL", (Object[])new Object[]{this._loginFile, pe});
            error1 = true;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException pae) {
                    FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ws.security.jaas.config.internal.ConfigFile", (String)"160", (Object)this, (Object[])new Object[0]);
                }
            }
        }
        Boolean error2 = Boolean.FALSE;
        if (!this.singleLogInFile) {
            error2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){
                static final long serialVersionUID = -71779614485895446L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                public Object run() {
                    int i = 1;
                    String iLoginFile2 = null;
                    URL myUrl2 = null;
                    BufferedReader retrdr2 = null;
                    boolean error = false;
                    while ((iLoginFile2 = Security.getProperty("login.url." + i)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("JAAS login configuration file (" + i + "): " + iLoginFile2), (Object[])new Object[0]);
                        }
                        try {
                            myUrl2 = new URL(iLoginFile2);
                            retrdr2 = new BufferedReader(new InputStreamReader(myUrl2.openStream()));
                            Map<String, List<AppConfigurationEntry>> tmpMap = ConfigFile.this.parse(retrdr2);
                            if (tmpMap != null) {
                                result.putAll(tmpMap);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("JAAS login configuration file (" + i + "): " + iLoginFile2 + " processed"), (Object[])new Object[0]);
                            }
                        }
                        catch (MalformedURLException tmpMap) {
                            void mue;
                            FFDCFilter.processException((Throwable)tmpMap, (String)"com.ibm.ws.security.jaas.config.internal.ConfigFile$1", (String)"206", (Object)this, (Object[])new Object[0]);
                            Tr.error((TraceComponent)tc, (String)"security.jaas.open.URL", (Object[])new Object[]{iLoginFile2, mue});
                            error = true;
                        }
                        catch (IOException mue) {
                            void ioe;
                            FFDCFilter.processException((Throwable)mue, (String)"com.ibm.ws.security.jaas.config.internal.ConfigFile$1", (String)"209", (Object)this, (Object[])new Object[0]);
                            Tr.error((TraceComponent)tc, (String)"security.jaas.create.URL", (Object[])new Object[]{iLoginFile2, ioe});
                            error = true;
                        }
                        catch (ParserException ioe) {
                            void pe;
                            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.security.jaas.config.internal.ConfigFile$1", (String)"212", (Object)this, (Object[])new Object[0]);
                            Tr.error((TraceComponent)tc, (String)"security.jaas.parser.URL", (Object[])new Object[]{iLoginFile2, pe});
                            error = true;
                        }
                        ++i;
                    }
                    return error;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        if (!error1 && !error2.booleanValue()) {
            this._fileMap = result;
        }
    }

    void refresh() {
        this.clearFileEntry();
        this.buildFileEntry();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class OpenFileAction
    implements PrivilegedExceptionAction {
        private final String filename;
        static final long serialVersionUID = -354815670940240642L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        OpenFileAction(String name) {
            this.filename = "file:///" + name;
        }

        public Object run() throws MalformedURLException, IOException {
            URL url = new URL(this.filename);
            return new BufferedReader(new InputStreamReader(url.openStream()));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OpenFileAction.class);
        }
    }
}

