/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.callback;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.jaas.common.callback.TokenCallback;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthenticationDataCallbackHandler
implements CallbackHandler {
    private final AuthenticationData authenticationData;
    static final long serialVersionUID = 2506413936667138927L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AuthenticationDataCallbackHandler(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                String name = (String)this.authenticationData.get("USERNAME");
                ((NameCallback)callback).setName(name);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                char[] password = (char[])this.authenticationData.get("PASSWORD");
                ((PasswordCallback)callback).setPassword(password);
                continue;
            }
            if (callback instanceof TokenCallback) {
                byte[] token = null;
                String token64 = (String)this.authenticationData.get("TOKEN64");
                token = token64 != null ? Base64Coder.base64DecodeString(token64) : (byte[])this.authenticationData.get("TOKEN");
                ((TokenCallback)callback).setToken(token);
                continue;
            }
            if (callback instanceof WSX509CertificateChainCallback) {
                X509Certificate[] certChain = (X509Certificate[])this.authenticationData.get("CERTCHAIN");
                ((WSX509CertificateChainCallback)callback).setX509CertificateChain(certChain);
                continue;
            }
            if (callback instanceof WSRealmNameCallbackImpl) {
                String realmName = (String)this.authenticationData.get("REALM");
                ((WSRealmNameCallbackImpl)callback).setRealmName(realmName);
                continue;
            }
            if (callback instanceof WSServletRequestCallback) {
                HttpServletRequest request = (HttpServletRequest)this.authenticationData.get("HTTP_SERVLET_REQUEST");
                ((WSServletRequestCallback)callback).setHttpServletRequest(request);
                continue;
            }
            if (callback instanceof WSServletResponseCallback) {
                HttpServletResponse response = (HttpServletResponse)this.authenticationData.get("HTTP_SERVLET_RESPONSE");
                ((WSServletResponseCallback)callback).setHttpServletResponse(response);
                continue;
            }
            if (callback instanceof WSAppContextCallback) {
                Map context = (Map)this.authenticationData.get("APPLICATION_CONTEXT");
                ((WSAppContextCallback)callback).setContext(context);
                continue;
            }
            if (callback instanceof WSCredTokenCallbackImpl) {
                byte[] credToken = (byte[])this.authenticationData.get("TOKEN");
                ((WSCredTokenCallbackImpl)callback).setCredToken(credToken);
                continue;
            }
            if (!(callback instanceof WSAuthMechOidCallbackImpl)) continue;
            String authMechOID = (String)this.authenticationData.get(AuthenticationData.AUTHENTICATION_MECH_OID);
            ((WSAuthMechOidCallbackImpl)callback).setAuthMechOid(authMechOID);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AuthenticationDataCallbackHandler.class);
    }
}

