/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.monitor;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.HashMap;

class ServletPmiModule
implements StatisticActionListener,
PmiConstants {
    private static final long serialVersionUID = 3692271975902012581L;
    CountStatisticImpl numErrors = null;
    CountStatisticImpl totalRequests = null;
    RangeStatisticImpl currentRequests = null;
    TimeStatisticImpl responseTime = null;
    String subinstanceName = "";
    private StatsGroup uriStatsGroup = null;
    private StatsInstance servletStatsInstance = null;
    private HashMap uriData = null;
    private String webAppFullName = null;
    private String servletName = null;
    private static final String URL_MODULE = "webAppModule.servlets.urls";
    private static final boolean alwaysCreateURLObjects = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.runtimeuristatenablement"));
    TimeStatisticImpl asyncContextResponseTime;

    public ServletPmiModule(String webAppFullName, String servletName, StatsInstance statsInstance, StatsGroup servletStatsGroup) {
        this.webAppFullName = webAppFullName;
        this.servletName = servletName;
        try {
            this.servletStatsInstance = StatsFactory.createStatsInstance((String)servletName, (StatsGroup)servletStatsGroup, null, (StatisticActionListener)this);
        }
        catch (StatsFactoryException sfe) {
            // empty catch block
        }
    }

    public final void decRequests(long execTime, String url) {
        long lst = 0L;
        if (this.responseTime != null && execTime >= 0L) {
            lst = System.currentTimeMillis();
            this.responseTime.add(lst, execTime);
        }
        if (this.currentRequests != null) {
            if (lst <= 0L) {
                lst = System.currentTimeMillis();
            }
            this.currentRequests.decrement(lst, 1L);
        }
    }

    public final void incRequests(String url) {
        long lst = 0L;
        if (this.totalRequests != null) {
            lst = System.currentTimeMillis();
            this.totalRequests.increment(lst, 1L);
        }
        if (this.currentRequests != null) {
            if (lst <= 0L) {
                lst = System.currentTimeMillis();
            }
            this.currentRequests.increment(lst, 1L);
        }
    }

    public void destroy() {
        try {
            StatsFactory.removeStatsInstance((StatsInstance)this.servletStatsInstance);
        }
        catch (StatsFactoryException statsFactoryException) {
            // empty catch block
        }
    }

    public void incNumErrors() {
        if (this.numErrors != null) {
            this.numErrors.increment();
        }
    }

    public void statisticCreated(SPIStatistic data) {
        switch (data.getId()) {
            case 11: {
                this.totalRequests = (CountStatisticImpl)data;
                break;
            }
            case 14: {
                this.numErrors = (CountStatisticImpl)data;
                break;
            }
            case 13: {
                this.responseTime = (TimeStatisticImpl)data;
                break;
            }
            case 12: {
                this.currentRequests = (RangeStatisticImpl)data;
                break;
            }
            case 18: {
                this.asyncContextResponseTime = (TimeStatisticImpl)data;
                break;
            }
        }
    }

    public void updateStatisticOnRequest(int dataId) {
    }

    public String getWebAppFullName() {
        return this.webAppFullName;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void onAsyncContextComplete(long responseTime, String url) {
        long lastUpdated = 0L;
        if (this.asyncContextResponseTime != null && responseTime >= 0L) {
            lastUpdated = System.currentTimeMillis();
            this.asyncContextResponseTime.add(lastUpdated, responseTime);
        }
    }
}

