/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPAPuScope;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public abstract class JPAPXml {
    private static final String CLASS_NAME = JPAPXml.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final JPAApplInfo ivApplInfo;
    private String ivArchiveName;
    private JPAPuScope ivPuScope;
    private ClassLoader ivClassLoader;
    private URL ivRootUrl;

    protected JPAPXml(JPAApplInfo applInfo, String archiveName, JPAPuScope scope, URL puRoot, ClassLoader classloader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init> : " + applInfo.getApplName() + ", " + archiveName + ", " + (Object)((Object)scope) + ", " + puRoot));
        }
        this.ivApplInfo = applInfo;
        this.ivArchiveName = archiveName;
        this.ivPuScope = scope;
        this.ivClassLoader = classloader;
        this.ivRootUrl = puRoot;
    }

    JPAApplInfo getApplInfo() {
        return this.ivApplInfo;
    }

    String getArchiveName() {
        return this.ivArchiveName;
    }

    JPAPuScope getPuScope() {
        return this.ivPuScope;
    }

    public ClassLoader getClassLoader() {
        return this.ivClassLoader;
    }

    URL getRootURL() {
        return this.ivRootUrl;
    }

    protected abstract InputStream openStream() throws IOException;

    protected abstract Schema newSchema(String var1) throws SAXException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('[').append(this.ivApplInfo.getApplName());
        sb.append(", ").append(this.ivArchiveName);
        sb.append(", ").append((Object)this.ivPuScope);
        sb.append(']');
        return sb.toString();
    }
}

