/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.javaee.dd.common.InjectionTarget;
import com.ibm.ws.javaee.dd.common.PersistenceContextRef;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.AbstractJPAInjectionBinding;
import com.ibm.ws.jpa.management.JPAPCtxtAttributeAccessor;
import com.ibm.ws.jpa.management.JPAPCtxtInjectionBinding;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import java.lang.reflect.Member;
import java.util.List;
import javax.naming.Reference;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;

public class JPAPCtxtProcessor
extends InjectionProcessor<PersistenceContext, PersistenceContexts> {
    private static final TraceComponent tc = Tr.register(JPAPCtxtProcessor.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final JPAPCtxtAttributeAccessor ivAttributeAccessor;

    public JPAPCtxtProcessor(JPAPCtxtAttributeAccessor attributeAccessor) {
        super(PersistenceContext.class, PersistenceContexts.class);
        this.ivAttributeAccessor = attributeAccessor;
    }

    public void processXML() throws InjectionException {
        List pCtxtRefs;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processXML : " + this.ivNameSpaceConfig.getPersistenceContextRefs()));
        }
        if ((pCtxtRefs = this.ivNameSpaceConfig.getPersistenceContextRefs()) != null && pCtxtRefs.size() > 0) {
            for (PersistenceContextRef pCtxtRef : pCtxtRefs) {
                String jndiName;
                InjectionBinding injectionBinding;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" pCtxtRef = " + pCtxtRef));
                }
                if ((injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = pCtxtRef.getName())) != null) {
                    ((JPAPCtxtInjectionBinding)injectionBinding).merge(pCtxtRef);
                } else {
                    injectionBinding = new JPAPCtxtInjectionBinding(pCtxtRef, this.ivNameSpaceConfig, this.ivAttributeAccessor);
                    this.addInjectionBinding(injectionBinding);
                }
                ((AbstractJPAInjectionBinding)injectionBinding).addRefComponents(jndiName);
                List targets = pCtxtRef.getInjectionTargets();
                if (targets == null || targets.isEmpty()) continue;
                for (InjectionTarget target : targets) {
                    String injectionClassName = target.getInjectionTargetClassName();
                    String injectionName = target.getInjectionTargetName();
                    injectionBinding.addInjectionTarget(EntityManager.class, injectionName, injectionClassName);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processXML : " + this.ivAllAnnotationsCollection.size()));
        }
    }

    public InjectionBinding<PersistenceContext> createInjectionBinding(PersistenceContext annotation, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
        return new JPAPCtxtInjectionBinding(annotation, this.ivNameSpaceConfig, this.ivAttributeAccessor);
    }

    public void resolve(InjectionBinding<PersistenceContext> binding) throws InjectionException {
        JPAPCtxtInjectionBinding pCtxtBinding = (JPAPCtxtInjectionBinding)binding;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve : " + (Object)((Object)pCtxtBinding)));
        }
        String applName = pCtxtBinding.getApplName();
        String modJarName = pCtxtBinding.getModJarName();
        String puName = pCtxtBinding.getPuName();
        boolean isEJBinWar = this.ivNameSpaceConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.HYBRID;
        JPAPuId puId = new JPAPuId(applName, modJarName, puName);
        AbstractJPAComponent jpaComponent = (AbstractJPAComponent)JPAAccessor.getJPAComponent();
        Reference ref = jpaComponent.createPersistenceContextReference(isEJBinWar, puId, this.ivNameSpaceConfig.getJ2EEName(), pCtxtBinding.getJndiName(), pCtxtBinding.isExtendedType(), this.ivNameSpaceConfig.isSFSB(), pCtxtBinding.getProperties(), pCtxtBinding.isUnsynchronized());
        pCtxtBinding.setObjects(null, ref);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolve : " + (Object)((Object)pCtxtBinding)));
        }
    }

    public String getJndiName(PersistenceContext annotation) {
        return annotation.name();
    }

    public PersistenceContext[] getAnnotations(PersistenceContexts annotation) {
        return annotation.value();
    }
}

