/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.GenericDatabaseMetaData;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class GenericConnection
implements Connection {
    private static final String CLASS_NAME = GenericConnection.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private JPAPuId ivPuId;
    private String ivDataSourceName = null;
    private boolean ivAutoCommit = false;
    private boolean ivIsClosed = false;
    private boolean ivReadOnly = false;
    private int ivTransactionIsolation = 0;

    GenericConnection(JPAPuId puId, String dataSourceName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + puId + ", dataSourceName = " + dataSourceName));
        }
        this.ivPuId = puId;
        this.ivDataSourceName = dataSourceName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public String toString() {
        String identity = Integer.toHexString(System.identityHashCode(this));
        return "GenericConnection@" + identity + "[" + this.ivPuId + ", " + this.ivDataSourceName + "]";
    }

    @Override
    public Statement createStatement() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAutoCommit : " + this + ", " + autoCommit));
        }
        this.ivAutoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAutoCommit : " + this + ", " + this.ivAutoCommit));
        }
        return this.ivAutoCommit;
    }

    @Override
    public void commit() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void rollback() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void close() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close : " + this));
        }
        this.ivIsClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isClosed : " + this + ", " + this.ivIsClosed));
        }
        return this.ivIsClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        GenericDatabaseMetaData result = new GenericDatabaseMetaData(this, this.ivDataSourceName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMetaData : " + this + ", " + result));
        }
        return result;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setReadOnly : " + this + ", " + readOnly));
        }
        this.ivReadOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isReadOnly : " + this + ", " + this.ivReadOnly));
        }
        return this.ivReadOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCatalog : " + this + ", " + catalog));
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCatalog : " + this + ", null"));
        }
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation : " + this + ", " + level));
        }
        this.ivTransactionIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTransactionIsolation : " + this + ", " + this.ivTransactionIsolation));
        }
        return this.ivTransactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getWarnings : " + this + ", null"));
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clearWarnings : " + this));
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setClientInfo : " + this + ", " + name + ", " + value));
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setClientInfo : " + this + ", " + properties));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getClientInfo : " + this + ", null"));
        }
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw this.unsupportedUseSQLException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isWrapperFor : " + this.ivPuId + ", iface = " + iface));
        }
        boolean result = false;
        if (iface != null && iface.isInstance(this)) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isWrapperFor : " + result));
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unwrap : PUID = " + this.ivPuId + " iface = " + iface));
        }
        T result = null;
        try {
            result = iface.cast(this);
        }
        catch (Throwable ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("unwrap : SQLException: " + this.getClass().getName() + " does not implement " + iface));
            }
            throw new SQLException(this.getClass().getName() + " does not implement " + iface);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unwrap : " + result));
        }
        return result;
    }

    private SQLException unsupportedUseSQLException() {
        return new SQLException("Unsupported use of GenericConnection.  A GenericConnection is provided during application start when creating an EntityManagerFactory for a persistence unit which has configured one of its datasource to be in the component naming context; java:comp/env. During application start, the component naming context will not exist, and the correct datasource cannot be determined. When the persistence unit is used, the proper datasource and connection will be obtained and used.");
    }
}

