/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.persistence.spi.ClassTransformer;

public class CapturingClassTransformer
implements ClassTransformer {
    private static final TraceComponent tc = Tr.register(CapturingClassTransformer.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final ClassTransformer providerClassTransformer;
    private File captureRootDir = null;
    private boolean captureEnabled = false;

    CapturingClassTransformer(ClassTransformer providerClassTransformer, String aaplName, File logDirectory) {
        if (providerClassTransformer == null) {
            throw new NullPointerException("A ClassTransformer instance must be provided.");
        }
        this.providerClassTransformer = providerClassTransformer;
        this.initialize(logDirectory, aaplName);
        if (this.captureEnabled && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CapturingClassTransformer creation successful for ClassTransformer " + providerClassTransformer));
        }
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] transformedBytes;
        block7: {
            transformedBytes = this.providerClassTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            try {
                if (this.captureEnabled && transformedBytes != null) {
                    File saveFile = new File(this.captureRootDir, className.replace('.', '/') + ".class");
                    File targetDir = saveFile.getParentFile();
                    if (CapturingClassTransformer.mkdirs(targetDir)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Capturing enhanced Entity Class bytecode to " + saveFile.getAbsolutePath()));
                        }
                        CapturingClassTransformer.writeCapturedEnhancedBytecode(saveFile, transformedBytes);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Failed to create capture directory " + targetDir.getAbsolutePath()));
                    }
                }
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("Caught unexpected Exception while capturing " + className + "."), (Object)t);
            }
        }
        return transformedBytes;
    }

    public String toString() {
        return "CapturingClassTransformer [providerClassTransformer=" + this.providerClassTransformer + "]";
    }

    private void initialize(final File logDirectory, final String aaplName) {
        if (logDirectory == null) {
            this.captureEnabled = false;
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String captureDirStr = "JPATransform/" + (aaplName != null ? aaplName : "unknownapp");
                CapturingClassTransformer.this.captureRootDir = new File(logDirectory, captureDirStr);
                CapturingClassTransformer.this.captureEnabled = CapturingClassTransformer.this.captureRootDir.mkdirs() || CapturingClassTransformer.this.captureRootDir.isDirectory();
                if (!CapturingClassTransformer.this.captureEnabled) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cannot create server instance capture directory, so enhanced entity bytecode will not be captured.");
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Capturing enhanced bytecode for JPA entities to " + CapturingClassTransformer.this.captureRootDir.getAbsolutePath()));
                }
                return null;
            }
        });
    }

    private static final boolean mkdirs(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdirs() || file.isDirectory();
            }
        });
    }

    private static final void writeCapturedEnhancedBytecode(final File file, final byte[] data) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    fos.write(data);
                }
                catch (Throwable t) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Failed to save captured enhanced Entity Class bytecode.  Reason: " + t));
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                return null;
            }
        });
    }
}

