/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractJPAInjectionBinding<A extends Annotation>
extends InjectionBinding<A> {
    private static final String CLASS_NAME = AbstractJPAInjectionBinding.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private boolean ivMultipleComponents;
    private Set<String> ivComponents;
    JPAPuId ivPuId;

    AbstractJPAInjectionBinding(A annotation, String name, String unitName, ComponentNameSpaceConfiguration nameSpaceConfig) throws InjectionConfigurationException {
        super(annotation, nameSpaceConfig);
        if (name.startsWith("java:global/")) {
            Tr.error((TraceComponent)tc, (String)"INVALID_JAVA_GLOBAL_REF_CWWJP0043E", (Object)new Object[]{name, nameSpaceConfig.getDisplayName(), nameSpaceConfig.getModuleName(), nameSpaceConfig.getApplicationName()});
            throw new InjectionConfigurationException("The " + name + " persistence reference is declared by the " + nameSpaceConfig.getDisplayName() + " component in the " + nameSpaceConfig.getModuleName() + " module of the " + nameSpaceConfig.getApplicationName() + " application, but java:global persistence references are not valid.");
        }
        this.setJndiName(name);
        J2EEName j2eeName = this.ivNameSpaceConfig.getJ2EEName();
        this.ivPuId = new JPAPuId(j2eeName.getApplication(), j2eeName.getModule(), unitName);
    }

    final String getApplName() {
        return this.ivPuId.getApplName();
    }

    final String getModJarName() {
        return this.ivPuId.getModJarName();
    }

    final void setPuName(String puName) {
        this.ivPuId.setPuName(puName);
    }

    final String getPuName() {
        return this.ivPuId.getPuName();
    }

    public void addInjectionClass(Class<?> klass) {
        Map classesToComponents;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addInjectionClass: " + this.getJndiName() + ": " + klass));
        }
        if ((classesToComponents = this.ivNameSpaceConfig.getClassesToComponents()) != null) {
            this.addComponents((Collection)classesToComponents.get(klass));
        }
    }

    public void addInjectionTarget(Member member) throws InjectionException {
        super.addInjectionTarget(member);
        this.addInjectionClass(member.getDeclaringClass());
    }

    protected void addRefComponents(String jndiName) {
        Map refsToComponents = this.ivNameSpaceConfig.getPersistenceRefsToComponents();
        if (refsToComponents != null) {
            this.addComponents((Collection)refsToComponents.get(jndiName));
        }
    }

    private void addComponents(Collection<String> components) {
        this.ivMultipleComponents = true;
        if (components != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addComponents: " + this.getJndiName() + ": " + components));
            }
            if (this.ivComponents == null) {
                this.ivComponents = new HashSet<String>();
            }
            this.ivComponents.addAll(components);
        }
    }

    public boolean containsComponent(String compName) {
        return !this.ivMultipleComponents || this.ivComponents != null && this.ivComponents.contains(compName);
    }
}

