/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.internal.url;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.url.WSJarURLConnection;
import com.ibm.ws.jpa.container.osgi.internal.url.FilterZipFileInputStream;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JPAWSJarURLConnection
extends URLConnection {
    private File urlTargetFile = null;
    private String archivePath = null;
    private InputStream inputStream = null;
    static final long serialVersionUID = -6997205026838045349L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JPAWSJarURLConnection(URL url, WSJarURLConnection wsJarUrlConnection) throws MalformedURLException {
        super(url);
        if (url == null || wsJarUrlConnection == null) {
            throw new IllegalArgumentException("JPAWSJarURLConnection ctor cannot take any null arguments.");
        }
        this.urlTargetFile = wsJarUrlConnection.getFile();
        this.archivePath = wsJarUrlConnection.getEntry();
        if (this.archivePath == null || this.archivePath.isEmpty()) {
            this.archivePath = "";
        }
    }

    @Override
    @Trivial
    public void connect() throws IOException {
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        Object token = ThreadIdentityManager.runAsServer();
        try {
            if (this.inputStream == null) {
                this.inputStream = "".equals(this.archivePath) ? new FileInputStream(this.urlTargetFile) : new FilterZipFileInputStream(this.urlTargetFile, this.archivePath);
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return this.inputStream;
    }

    @Override
    public long getLastModified() {
        return this.urlTargetFile.lastModified();
    }

    @Override
    public Permission getPermission() throws IOException {
        return new FilePermission(this.urlTargetFile.getAbsolutePath(), "read");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JPAWSJarURLConnection.class);
    }
}

