/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.futures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.esa.internal.futures.BlueprintFuture;
import com.ibm.ws.app.manager.esa.internal.futures.ESAAggregateFuture;
import com.ibm.ws.app.manager.esa.internal.futures.WABDeployedFuture;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import java.util.concurrent.Future;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.subsystem.Subsystem;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ESAStartFuture
extends ESAAggregateFuture {
    static final long serialVersionUID = 515836333992055167L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ESAStartFuture(Future<Boolean> initialFuture, Subsystem subsystem, BundleContext context, FutureMonitor monitor) {
        super(initialFuture, subsystem, context, monitor);
        this.createFuturesForSusbsystem(subsystem);
    }

    @Override
    protected ESAAggregateFuture.AppStateCheck applicationStateCheck() {
        if (this.initialFuture.isDone()) {
            try {
                Boolean result = (Boolean)this.initialFuture.get();
                if (result != null && result.booleanValue()) {
                    return ESAAggregateFuture.AppStateCheck.FUTURES;
                }
                return ESAAggregateFuture.AppStateCheck.COMPLETE;
            }
            catch (Exception result) {
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.app.manager.esa.internal.futures.ESAStartFuture", (String)"48", (Object)this, (Object[])new Object[0]);
                return ESAAggregateFuture.AppStateCheck.COMPLETE;
            }
        }
        return ESAAggregateFuture.AppStateCheck.INCOMPLETE;
    }

    private void createFuturesForSusbsystem(Subsystem subsystem) {
        BundleContext context = subsystem.getBundleContext();
        if (context == null) {
            return;
        }
        Bundle[] bundlesNeedingFuture = subsystem.getType().equals("osgi.subsystem.feature") ? ESAStartFuture.getBundleConstituentsFromFeature(subsystem) : context.getBundles();
        this.createFuturesForBundles(bundlesNeedingFuture);
    }

    private void createFuturesForBundles(Bundle[] bundles) {
        for (Bundle bundle : bundles) {
            this.createWabDeployedFutureForBundle(bundle);
        }
        if (ESAStartFuture.isBlueprintAvailable()) {
            this.futuresForThisEsa.add(new BlueprintFuture.BlueprintStartFuture(this.context, bundles, this));
        }
    }

    private void createWabDeployedFutureForBundle(Bundle bundle) {
        String webContextPath = (String)bundle.getHeaders("").get("Web-ContextPath");
        if (webContextPath == null) {
            return;
        }
        this.futuresForThisEsa.add(new WABDeployedFuture(this, bundle.getBundleId(), webContextPath));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ESAStartFuture.class);
    }
}

