/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.featuremanager;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.esa.internal.featuremanager.Service;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class Feature {
    private final String name;
    private final Version osgiVersion;
    private final Collection<Service> services = new ArrayList<Service>();
    static final long serialVersionUID = 8614458950841346003L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={IllegalArgumentException.class})
    Feature(String feature, String apiServiceAttributes) {
        String[] featureNameParts = feature.split("-", 2);
        Version featureVersion = null;
        try {
            if (featureNameParts.length == 2) {
                featureVersion = Version.parseVersion((String)featureNameParts[1]);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.name = featureVersion == null ? feature : featureNameParts[0];
        this.osgiVersion = featureVersion == null ? Version.emptyVersion : featureVersion;
        List nvpList = ManifestHeaderProcessor.parseExportString((String)apiServiceAttributes);
        if (apiServiceAttributes != null && !nvpList.isEmpty()) {
            this.processApiServices(nvpList);
        }
    }

    private void processApiServices(List<ManifestHeaderProcessor.NameValuePair> nvpList) {
        for (ManifestHeaderProcessor.NameValuePair nvp : nvpList) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("objectClass", nvp.getName());
            Map attributes = nvp.getAttributes();
            for (Map.Entry attribute : attributes.entrySet()) {
                props.put((String)attribute.getKey(), (String)attribute.getValue());
            }
            Service s = new Service(props);
            this.services.add(s);
        }
    }

    @Trivial
    String getName() {
        return this.name;
    }

    @Trivial
    Version getOsgiVersion() {
        return this.osgiVersion;
    }

    @Trivial
    public String toString() {
        return this.getName() + (Version.emptyVersion.equals((Object)this.getOsgiVersion()) ? "" : "-" + this.getOsgiVersion().toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.osgiVersion == null ? 0 : this.osgiVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.osgiVersion == null ? other.osgiVersion != null : !this.osgiVersion.equals((Object)other.osgiVersion));
    }

    Collection<Service> getServices() {
        return this.services;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Feature.class);
    }
}

