/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.diagnostics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.subsystem.Subsystem;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component
public class SubsystemIntrospection
implements Introspector {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    private List<Subsystem> subsystems;
    static final long serialVersionUID = 1019044331839797198L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return "Subsystem Introspection";
    }

    public String getIntrospectorDescription() {
        return "Describes all installed Subsystems";
    }

    public void introspect(PrintWriter out) throws Exception {
        ArrayList<Subsystem> ss = new ArrayList<Subsystem>(this.subsystems);
        Collections.sort(ss, new Comparator<Subsystem>(){
            static final long serialVersionUID = 6308318658295426588L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(Subsystem o1, Subsystem o2) {
                return Long.valueOf(o1.getSubsystemId()).compareTo(o2.getSubsystemId());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        for (Subsystem s : ss) {
            this.subsystem("", s, out);
            Bundle regionBundle = s.getBundleContext().getBundle();
            out.append("  Region bundle context: ").append(regionBundle.getSymbolicName()).append(":").append(regionBundle.getVersion().toString()).append(" [").append(Long.toString(regionBundle.getBundleId())).append("]");
            out.println();
            out.println("  Children:");
            for (Subsystem c : s.getChildren()) {
                this.subsystem("    ", c, out);
            }
            out.println("  Parents: ");
            for (Subsystem p : s.getParents()) {
                this.subsystem("    ", p, out);
            }
            out.println("  Constituents:");
            for (Resource r : s.getConstituents()) {
                out.append("    ");
                out.println(r);
            }
            out.println("  Subsystem headers:");
            this.map(s.getSubsystemHeaders(null), out);
            out.println("  Deployment headers:");
            this.map(s.getDeploymentHeaders(), out);
            out.println();
        }
    }

    void map(Map<String, String> map, PrintWriter out) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            out.append("    ").append(e.getKey()).append("=").append(e.getValue());
            out.println();
        }
    }

    void subsystem(String prefix, Subsystem s, PrintWriter out) {
        out.append(prefix).append("Subsystem id: ").append(Long.toString(s.getSubsystemId())).append(" Symbolic name: ").append(s.getSymbolicName()).append(" version: ").append(s.getVersion().toString()).append(" type: ").append(s.getType()).append(" state: ").append(s.getState().toString());
        out.println();
        out.append(prefix).append("  Location: ").append(s.getLocation());
        out.println();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SubsystemIntrospection.class);
    }
}

