/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.esa.internal.SubsystemHandler;
import com.ibm.ws.app.manager.esa.internal.SubsystemInformation;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import java.util.concurrent.Future;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UninstallSubsystemAction
implements CompletionListener<Boolean> {
    private final SubsystemHandler _handler;
    private final ApplicationInformation<SubsystemInformation> _subsystemInfo;
    private static final TraceComponent _tc = Tr.register(UninstallSubsystemAction.class);
    static final long serialVersionUID = 2453133349397405228L;

    UninstallSubsystemAction(ApplicationInformation<SubsystemInformation> subsystemInfo, SubsystemHandler handler) {
        this._handler = handler;
        this._subsystemInfo = subsystemInfo;
    }

    /*
     * WARNING - void declaration
     */
    Future<Boolean> uninstall() {
        SubsystemInformation removed = (SubsystemInformation)this._handler.getApplications().remove(this._subsystemInfo.getPid());
        if (removed != null) {
            removed.unregister();
        }
        this._handler.getContainers().remove(this._subsystemInfo.getPid());
        SubsystemInformation subsystemInformation = (SubsystemInformation)this._subsystemInfo.getHandlerInfo();
        if (subsystemInformation == null) {
            return this._handler.getFutureMonitor().createFutureWithResult(Boolean.class, (Throwable)new IllegalStateException());
        }
        ApplicationInfo appInfo = subsystemInformation.getApplicationInfo();
        StateChangeService stateChange = this._handler.getStateChangeService();
        if (stateChange != null) {
            try {
                stateChange.fireApplicationStopping(appInfo);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.esa.internal.UninstallSubsystemAction", (String)"63", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopping", (Object)this);
            }
        }
        Subsystem subsystem = subsystemInformation.getSubsystem();
        try {
            this.subsystemStopIgnoringIllegalStateException(subsystem);
        }
        catch (SubsystemException subsystemException) {
            void e;
            FFDCFilter.processException((Throwable)subsystemException, (String)"com.ibm.ws.app.manager.esa.internal.UninstallSubsystemAction", (String)"71", (Object)this, (Object[])new Object[0]);
            Future result = this._handler.getFutureMonitor().createFutureWithResult(Boolean.class, (Throwable)e);
            this.successfulCompletion((Future<Boolean>)result, Boolean.FALSE);
            return result;
        }
        Future result = this._handler.getFutureMonitor().createFutureWithResult((Object)Boolean.TRUE);
        this._handler.getFutureMonitor().onCompletion(result, (CompletionListener)this);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void successfulCompletion(Future<Boolean> future, Boolean result) {
        MetaDataService metaData;
        ExtendedApplicationInfo appInfo = (ExtendedApplicationInfo)((SubsystemInformation)this._subsystemInfo.getHandlerInfo()).getApplicationInfo();
        StateChangeService stateChange = this._handler.getStateChangeService();
        if (stateChange != null) {
            try {
                stateChange.fireApplicationStopped((ApplicationInfo)appInfo);
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.esa.internal.UninstallSubsystemAction", (String)"89", (Object)this, (Object[])new Object[]{future, result});
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireApplicationStopped");
            }
        }
        if ((metaData = this._handler.getMetaDataService()) != null) {
            try {
                metaData.fireApplicationMetaDataDestroyed(appInfo.getMetaData());
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.esa.internal.UninstallSubsystemAction", (String)"97", (Object)this, (Object[])new Object[]{future, result});
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireApplicationMetaDataDestroyed");
            }
        }
        try {
            ApplicationInfoFactory appInfoFactory = ((SubsystemInformation)this._subsystemInfo.getHandlerInfo()).getApplicationInfoFactory();
            appInfoFactory.destroyApplicationInfo((ApplicationInfo)appInfo);
        }
        catch (Throwable appInfoFactory) {
            void t;
            FFDCFilter.processException((Throwable)appInfoFactory, (String)"com.ibm.ws.app.manager.esa.internal.UninstallSubsystemAction", (String)"104", (Object)this, (Object[])new Object[]{future, result});
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"destroyApplicationInfo");
        }
    }

    public void failedCompletion(Future<Boolean> future, Throwable t) {
        FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"applicationUninstallFailed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IllegalStateException.class})
    private void subsystemStopIgnoringIllegalStateException(Subsystem subsystem) {
        Object object = this._handler.getSubsystemInstallUninstallLock();
        synchronized (object) {
            block9: {
                try {
                    subsystem.stop();
                }
                catch (IllegalStateException e) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"IllegalStateException when stopping subsystem: {0}", (Object[])new Object[]{DataFormatHelper.throwableToString((Throwable)e)});
                    }
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.app.manager.esa.internal.UninstallSubsystemAction", (String)"139", (Object)this, (Object[])new Object[]{subsystem});
                }
                try {
                    subsystem.uninstall();
                }
                catch (IllegalStateException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)_tc, (String)"IllegalStateException when uninstalling subsystem: {0}", (Object[])new Object[]{DataFormatHelper.throwableToString((Throwable)e)});
                }
            }
        }
    }
}

