/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.CacheLocal;
import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.exception.DiskCacheUsingOldFormatException;
import com.ibm.websphere.cache.exception.DiskIOException;
import com.ibm.websphere.cache.exception.DynamicCacheException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.CacheStatisticsImpl;
import com.ibm.ws.cache.CacheStatisticsListenerImpl;
import com.ibm.ws.cache.DCacheBase;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.FreeLruEntryResult;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.NonSyncHashtable;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.Result;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.stat.CachePerf;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.CacheStatistics;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class Cache
extends DCacheBase
implements CacheLocal {
    private static TraceComponent tc = Tr.register(Cache.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final int LOGGING_WINDOW = 1000;
    private final long lastTimeForStatistics = 0L;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private RemoteServices remoteServices = null;
    private TimeLimitDaemon timeLimitDaemon = null;
    private InvalidationAuditDaemon invalidationAuditDaemon = null;
    private CacheEntry.CacheEntryPool cacheEntryPool = null;
    private DependencyTable dataDependencyTable = null;
    private DependencyTable templateDependencyTable = null;
    private NonSyncHashtable entryHashtable = null;
    private int defaultPriority = CacheConfig.DEFAULT_PRIORITY;
    private DynacacheOnDisk diskCache = null;
    private boolean flushToDiskComplete = false;
    private boolean enableDiskCacheSizeInBytesChecking = false;
    private int entriesInMemoryRemoved = 0;
    private int entriesInDiskRemoved = 0;
    private long diskCacheEntrySizeInMBEvictedCount = 0L;
    private long diskCacheSizeInGBEvictedCount = 0L;
    private long diskCacheSizeEvictedCount = 0L;
    private long diskCacheEntrySizeInMBEvictedLimit = 1L;
    private long diskCacheSizeInGBEvictedLimit = 1L;
    private long diskCacheSizeEvictedLimit = 1L;
    private CacheEntry.LRUHead[] lruBuckets = null;
    private int lruTop = 0;
    private int cacheSizeLimit = 0;
    private boolean displayedLRUMessage = false;
    private volatile transient Map<Object, String> refCountLeakMap = new ConcurrentHashMap<Object, String>();
    private long lastTimeCheck = 0L;
    private static long leakDetectionInterval = 300000L;
    private static String leakDetectionOutput = "ceRefCount.txt";

    public Cache(String cacheName, CacheConfig cacheConfig) {
        super(cacheName, cacheConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Cache() CTOR cacheName:" + cacheName), (Object[])new Object[0]);
        }
        this.swapToDisk = cacheConfig.enableDiskOffload;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        String disableCookieList = cacheConfig.disableStoreCookies;
        this.defaultPriority = cacheConfig.cachePriority;
        if (this.defaultPriority < 0 || this.defaultPriority > CacheConfig.MAX_PRIORITY) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.defaultPriority), "cachePriority", this.cacheName, new Integer(0), new Integer(CacheConfig.MAX_PRIORITY), new Integer(CacheConfig.DEFAULT_PRIORITY)});
            this.defaultPriority = CacheConfig.DEFAULT_PRIORITY;
        }
        this.cacheStatisticsListener = new CacheStatisticsListenerImpl(this.cacheName);
        boolean cacheInstanceStoreCookies = true;
        if (disableCookieList.equalsIgnoreCase("All")) {
            cacheInstanceStoreCookies = false;
        } else {
            StringTokenizer tokens = new StringTokenizer(disableCookieList, ":");
            while (tokens.hasMoreElements()) {
                String name = (String)tokens.nextElement();
                if (!name.equals(cacheName) && !name.equalsIgnoreCase("All")) continue;
                cacheInstanceStoreCookies = false;
                break;
            }
        }
        cacheConfig.setCacheInstanceStoreCookies(cacheInstanceStoreCookies);
        if (!cacheInstanceStoreCookies && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" Store_Cookies property disabled for cacheName:" + cacheName), (Object[])new Object[0]);
        }
        int poolSize = Math.min(1000, cacheConfig.cacheSize / 10);
        this.cacheEntryPool = CacheEntry.createCacheEntryPool(this, poolSize);
        this.lruBuckets = new CacheEntry.LRUHead[CacheConfig.MAX_PRIORITY + 1];
        for (int i = 0; i < this.lruBuckets.length; ++i) {
            this.lruBuckets[i] = new CacheEntry.LRUHead();
            this.lruBuckets[i].priority = i;
        }
        this.entryHashtable = new NonSyncHashtable(cacheConfig.cacheSize);
        this.increaseCacheSizeInBytes(40L + 28L * (long)cacheConfig.cacheSize, "EHT");
        if (!cacheConfig.disableDependencyId) {
            this.dataDependencyTable = new DependencyTable(0, cacheConfig.cacheSize / 3);
        }
        if (!cacheConfig.disableTemplatesSupport) {
            this.templateDependencyTable = new DependencyTable(0, cacheConfig.cacheSize / 10);
        }
        int lruToDiskTriggerPercent = cacheConfig.lruToDiskTriggerPercent;
        this.cacheSizeLimit = cacheConfig.cacheSize;
        if (this.swapToDisk) {
            this.diskCache = new CacheOnDisk(cacheConfig, this);
            if (!this.swapToDisk) {
                this.diskCache = null;
                lruToDiskTriggerPercent = 0;
            } else {
                lruToDiskTriggerPercent = 0;
                if (cacheConfig.lruToDiskTriggerPercent > 100 || cacheConfig.lruToDiskTriggerPercent < 0) {
                    Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(cacheConfig.lruToDiskTriggerPercent), "lruToDiskTriggerPercent", cacheName, new Integer(0), new Integer(100), new Integer(0)});
                } else {
                    lruToDiskTriggerPercent = cacheConfig.lruToDiskTriggerPercent;
                }
                if (cacheConfig.lruToDiskTriggerPercent > 0) {
                    this.cacheSizeLimit = cacheConfig.cacheSize + cacheConfig.cacheSize * cacheConfig.lruToDiskTriggerPercent / 100;
                }
            }
        } else {
            lruToDiskTriggerPercent = 0;
        }
        cacheConfig.lruToDiskTriggerPercent = lruToDiskTriggerPercent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Cache() CTOR cacheName=" + cacheName + " cache=" + this + " useServerClassLoader:" + cacheConfig.useServerClassLoader + " filterTimeOutInvalidation:" + cacheConfig.filterTimeOutInvalidation + " filterLRUInvalidation:" + cacheConfig.filterLRUInvalidation + " lruToDiskTriggerPercent=" + cacheConfig.lruToDiskTriggerPercent + " cacheSizeLimit=" + this.cacheSizeLimit + " cacheSizeInMB=" + cacheConfig.memoryCacheSizeInMB + " cascadeCachespecProperties=" + cacheConfig.cascadeCachespecProperties));
        }
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        CacheStatisticsImpl statistics = new CacheStatisticsImpl();
        statistics.setCacheHitsCount(this.cacheStatisticsListener.getCacheHitsCount());
        statistics.setCacheLruRemovesCount(this.cacheStatisticsListener.getCacheLruRemovesCount());
        statistics.setCacheMissesCount(this.cacheStatisticsListener.getCacheMissesCount());
        statistics.setCacheRemovesCount(this.cacheStatisticsListener.getCacheRemovesCount());
        statistics.setExplicitInvalidationsFromMemoryCount(this.cacheStatisticsListener.getExplicitInvalidationsFromMemoryCount());
        statistics.setMemoryCacheEntriesCount(this.getNumberCacheEntries());
        statistics.setMemoryCacheSizeInMBCount(this.getCurrentMemoryCacheSizeInMB());
        statistics.setTimeoutInvalidationsFromMemoryCount(this.cacheStatisticsListener.getTimeoutInvalidationsFromMemoryCount());
        TreeMap<String, Number> extendedStats = new TreeMap<String, Number>();
        extendedStats.put("OverflowEntriesFromMemory", this.cacheStatisticsListener.getOverflowEntriesFromMemoryCount());
        extendedStats.put("ExplicitInvalidationsFromDisk", this.cacheStatisticsListener.getExplicitInvalidationsFromDiskCount());
        extendedStats.put("ExplicitInvalidationsLocal", this.cacheStatisticsListener.getExplicitInvalidationsLocalCount());
        extendedStats.put("ExplicitInvalidationsRemote", this.cacheStatisticsListener.getExplicitInvalidationsRemoteCount());
        extendedStats.put("TimeoutInvalidationsFromDisk", this.cacheStatisticsListener.getTimeoutInvalidationsFromDiskCount());
        extendedStats.put("GarbageCollectorInvalidationsFromDisk", this.cacheStatisticsListener.getGarbageCollectorInvalidationsFromDiskCount());
        extendedStats.put("DependencyIdsOffloadedToDisk", this.cacheStatisticsListener.getDepIdsOffloadedToDiskCount());
        extendedStats.put("DependencyIdBasedInvalidationsFromDisk", this.cacheStatisticsListener.getDepIdBasedInvalidationsFromDiskCount());
        extendedStats.put("TemplatesOffloadedToDisk", this.cacheStatisticsListener.getTemplatesOffloadedToDiskCount());
        extendedStats.put("TemplateBasedInvalidationsFromDisk", this.cacheStatisticsListener.getTemplateBasedInvalidationsFromDiskCount());
        extendedStats.put("OverflowInvalidationsFromDisk", this.cacheStatisticsListener.getOverflowInvalidationsFromDiskCount());
        extendedStats.put("ObjectsReadFromDisk", this.cacheStatisticsListener.getObjectsReadFromDiskCount());
        extendedStats.put("ObjectsReadFromDisk4K", this.cacheStatisticsListener.getObjectsReadFromDisk4KCount());
        extendedStats.put("ObjectsReadFromDisk40K", this.cacheStatisticsListener.getObjectsReadFromDisk40KCount());
        extendedStats.put("ObjectsReadFromDisk400K", this.cacheStatisticsListener.getObjectsReadFromDisk400KCount());
        extendedStats.put("ObjectsReadFromDisk4000K", this.cacheStatisticsListener.getObjectsReadFromDisk4000KCount());
        extendedStats.put("ObjectsReadFromDiskSize", this.cacheStatisticsListener.getObjectsReadFromDiskSizeCount());
        extendedStats.put("ObjectsWriteToDisk", this.cacheStatisticsListener.getObjectsWriteToDiskCount());
        extendedStats.put("ObjectsWriteToDisk4K", this.cacheStatisticsListener.getObjectsWriteToDisk4KCount());
        extendedStats.put("ObjectsWriteToDisk40K", this.cacheStatisticsListener.getObjectsWriteToDisk40KCount());
        extendedStats.put("ObjectsWriteToDisk400K", this.cacheStatisticsListener.getObjectsWriteToDisk400KCount());
        extendedStats.put("ObjectsWriteToDisk4000K", this.cacheStatisticsListener.getObjectsWriteToDisk4000KCount());
        extendedStats.put("ObjectsWriteToDiskSize", this.cacheStatisticsListener.getObjectsWriteToDiskSizeCount());
        extendedStats.put("ObjectsDeleteFromDisk", this.cacheStatisticsListener.getObjectsDeleteFromDiskCount());
        extendedStats.put("ObjectsDeleteFromDisk4K", this.cacheStatisticsListener.getObjectsDeleteFromDisk4KCount());
        extendedStats.put("ObjectsDeleteFromDisk40K", this.cacheStatisticsListener.getObjectsDeleteFromDisk40KCount());
        extendedStats.put("ObjectsDeleteFromDisk400K", this.cacheStatisticsListener.getObjectsDeleteFromDisk400KCount());
        extendedStats.put("ObjectsDeleteFromDisk4000K", this.cacheStatisticsListener.getObjectsDeleteFromDisk4000KCount());
        extendedStats.put("ObjectsDeleteFromDiskSize", this.cacheStatisticsListener.getObjectsDeleteFromDiskSizeCount());
        extendedStats.put("RemoteInvalidationNotifications", this.cacheStatisticsListener.getRemoteInvalidationNotificationsCount());
        extendedStats.put("RemoteUpdateNotifications", this.cacheStatisticsListener.getRemoteUpdateNotificationsCount());
        extendedStats.put("RemoteObjectUpdates", this.cacheStatisticsListener.getRemoteObjectUpdatesCount());
        extendedStats.put("RemoteObjectUpdateSize", this.cacheStatisticsListener.getRemoteObjectUpdateSizeCount());
        extendedStats.put("RemoteObjectHits", this.cacheStatisticsListener.getRemoteObjectHitsCount());
        extendedStats.put("RemoteObjectFetchSize", this.cacheStatisticsListener.getRemoteObjectFetchSizeCount());
        extendedStats.put("RemoteObjectMisses", this.cacheStatisticsListener.getRemoteObjectMissesCount());
        extendedStats.put("ObjectsAsyncLruToDisk", this.cacheStatisticsListener.getObjectsAsyncLruToDiskCount());
        extendedStats.put("ObjectsOnDisk", Long.valueOf(this.getIdsSizeDisk()));
        extendedStats.put("DiskCacheSizeInMB", Float.valueOf(this.getDiskCacheSizeInMBs()));
        extendedStats.put("DependencyIdsOnDisk", Long.valueOf(this.getDepIdsSizeDisk()));
        extendedStats.put("TemplatesOnDisk", Long.valueOf(this.getTemplatesSizeDisk()));
        extendedStats.put("PendingRemovalFromDisk", Long.valueOf(this.getPendingRemovalSizeDisk()));
        extendedStats.put("DependencyIdsBufferedForDisk", Long.valueOf(this.getDepIdsBufferedSizeDisk()));
        extendedStats.put("TemplatesBufferedForDisk", Long.valueOf(this.getTemplatesBufferedSizeDisk()));
        extendedStats.put("PushPullTableSize", Long.valueOf(this.getPushPullTableSize()));
        statistics.setExtendedStats(extendedStats);
        return statistics;
    }

    @Override
    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    @Override
    public void setTimeLimitDaemon(TimeLimitDaemon timeLimitDaemon) {
        this.timeLimitDaemon = timeLimitDaemon;
    }

    @Override
    public void setInvalidationAuditDaemon(InvalidationAuditDaemon iad) {
        this.invalidationAuditDaemon = iad;
    }

    @Override
    public void setRemoteServices(RemoteServices remoteServices) {
        this.remoteServices = remoteServices;
    }

    @Override
    public RemoteServices getRemoteServices() {
        return this.remoteServices;
    }

    @Override
    public void start() {
        if (this.timeLimitDaemon == null || this.batchUpdateDaemon == null || this.cacheStatisticsListener == null || this.remoteServices == null) {
            throw new IllegalStateException("batchUpdateDaemon, cacheStatisticsListener, remoteServices, and timeLimitDaemon must all be set before start()");
        }
        this.timeLimitDaemon.createExpirationMetaData(this);
        this.flushToDiskComplete = false;
        if (this.swapToDisk) {
            if (this.diskCache.getStartState() == 1 || this.diskCache.shouldPopulateEvictionTable()) {
                this.diskCache.invokeDiskCleanup(true);
            } else if (this.diskCache.getStartState() == 2) {
                this.diskCache.invokeDiskCleanup(false);
            }
        }
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry, int source, boolean ignoreCounting, boolean coordinate, boolean incRefcount) {
        CachePerf cachePerf;
        CacheEntry cacheEntryOut = null;
        if (!ignoreCounting && (cachePerf = (CachePerf)this.cachePerfRef.get()) != null && source == 5 && cachePerf.isPMIEnabled()) {
            cachePerf.onRequest(cacheEntry.getTemplate(), source);
        }
        Object id = cacheEntry.getIdObject();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setEntry() cacheName=" + this.cacheName + " id=" + id + " sharing policy=" + cacheEntry.getSharingPolicy() + " timeToLive=" + cacheEntry.getTimeLimit()), (Object[])new Object[0]);
        }
        cacheEntryOut = this._syncSetEntry(cacheEntry, source, ignoreCounting, incRefcount);
        if (!(cacheEntryOut.skipMemoryAndWriteToDisk || cacheEntryOut.timeLimit <= 0 && cacheEntryOut.inactivity <= 0)) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntryOut.id, cacheEntryOut.expirationTime, cacheEntryOut.inactivity);
        }
        if (cacheEntryOut.getSharingPolicy() == 1 || cacheEntryOut.skipMemoryAndWriteToDiskErrorCode != 0) {
            cacheEntryOut.finish();
            return cacheEntryOut;
        }
        if (source == 2 && cacheEntry.getSharingPolicy() == 2) {
            byte[] serializedValue = cacheEntry.getSerializedValue();
            int valueSize = 0;
            if (serializedValue != null) {
                valueSize = serializedValue.length;
            }
            this.cacheStatisticsListener.remoteObjectUpdates(id, valueSize);
        }
        if (coordinate) {
            this.updatePeerCaches(cacheEntryOut);
        } else {
            cacheEntryOut.finish();
        }
        return cacheEntryOut;
    }

    private CacheEntry getCacheEntry(Object id, boolean askPermission, boolean ignoreCounting, String _missTemplate, boolean incRefCount) {
        CacheEntry cacheEntry;
        CachePerf cachePerf = null;
        if (!ignoreCounting) {
            cachePerf = (CachePerf)this.cachePerfRef.get();
        }
        if (incRefCount) {
            cacheEntry = this.getCacheEntry(id, incRefCount);
        } else {
            cacheEntry = (CacheEntry)this.entryHashtable.get(id);
            if (null != cacheEntry && incRefCount) {
                cacheEntry.incRefCount();
            }
        }
        if (cacheEntry != null) {
            if (!ignoreCounting) {
                if (!cacheEntry.isInvalid()) {
                    this.cacheStatisticsListener.localCacheHit(id, 1);
                    if (cachePerf != null && (cacheEntry.value != null || cacheEntry.serializedValue != null) && cachePerf.isPMIEnabled()) {
                        cachePerf.onCacheHit(cacheEntry.getTemplate(), 1);
                    }
                } else {
                    cacheEntry.setVBCSource(1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getCacheEntry() cacheName=" + this.cacheName + " found in memory invalid VBC for id " + id + " vbcSource=" + 1), (Object[])new Object[0]);
                    }
                }
            }
            return cacheEntry;
        }
        if (cacheEntry == null && this.swapToDisk && (cacheEntry = this.diskCache.readCacheEntry(id)) != null) {
            if (incRefCount) {
                cacheEntry.incRefCount();
            }
            cacheEntry.loadedFromDisk = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (!cacheEntry.isInvalid()) {
                    Tr.debug((TraceComponent)tc, (String)("getCacheEntry() cacheName=" + this.cacheName + " found on disk for id " + id + ", ignoreCounting=" + ignoreCounting + " skipMemoryAndWriteToDisk=" + cacheEntry.skipMemoryAndWriteToDisk), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("getCacheEntry() cacheName=" + this.cacheName + " found on disk invalid VBC for id " + id + " vbcSource=" + 2), (Object[])new Object[0]);
                }
            }
            if (!ignoreCounting) {
                if (!cacheEntry.isInvalid()) {
                    this.cacheStatisticsListener.localCacheHit(id, 3);
                    if (cachePerf != null && cachePerf.isPMIEnabled()) {
                        cachePerf.onCacheHit(cacheEntry.getTemplate(), 3);
                    }
                } else {
                    cacheEntry.setVBCSource(2);
                }
            }
            if (cacheEntry.skipMemoryAndWriteToDisk) {
                return cacheEntry;
            }
            cacheEntry = (CacheEntry)this.setEntry(cacheEntry, 3, ignoreCounting, false, false);
            return cacheEntry;
        }
        if (cacheEntry == null && askPermission) {
            cacheEntry = this.remoteServices.getEntry(id);
            if (cacheEntry != null) {
                if (incRefCount) {
                    cacheEntry.incRefCount();
                }
                if (!ignoreCounting) {
                    int valueSize = 0;
                    byte[] serializedValue = cacheEntry.getSerializedValue();
                    if (serializedValue != null) {
                        valueSize = serializedValue.length;
                    }
                    if (!cacheEntry.isInvalid()) {
                        this.cacheStatisticsListener.remoteObjectHits(cacheEntry.id, valueSize);
                        if (cachePerf != null && cachePerf.isPMIEnabled()) {
                            cachePerf.onCacheHit(cacheEntry.getTemplate(), 2);
                        }
                    } else {
                        cacheEntry.setVBCSource(3);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getCacheEntry() cacheName=" + this.cacheName + " found from remote invalid VBC for id " + id + " vbcSource=" + 3), (Object[])new Object[0]);
                        }
                    }
                }
                cacheEntry = (CacheEntry)this.setEntry(cacheEntry, 2, ignoreCounting, false, false);
            } else if (!ignoreCounting) {
                this.cacheStatisticsListener.remoteObjectMisses(id);
                if (cachePerf != null && cachePerf.isPMIEnabled()) {
                    cachePerf.onCacheMiss(_missTemplate, 5);
                }
            }
        } else if (!ignoreCounting) {
            this.cacheStatisticsListener.cacheMiss(id);
            if (cachePerf != null && cachePerf.isPMIEnabled()) {
                cachePerf.onCacheMiss(_missTemplate, 5);
            }
        }
        return cacheEntry;
    }

    private CacheEntry getCacheEntry(Object id, boolean incRefCount) {
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(id);
        if (null != cacheEntry && incRefCount) {
            cacheEntry.incRefCount();
        }
        if (cacheEntry != null && !cacheEntry.pendingRemoval && !cacheEntry.removeWhenUnpinned) {
            this.updateLruLocation(cacheEntry);
            if (cacheEntry.inactivity > 0) {
                this.timeLimitDaemon.valueWasAccessed(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
            }
        }
        return cacheEntry;
    }

    private synchronized CacheEntry _syncSetEntry(CacheEntry cacheEntry, int source, boolean ignoreCounting, boolean incRefCount) {
        Object alias;
        Enumeration e;
        CachePerf cachePerf;
        int cause = -1;
        if (!(this.hasPushPullEntries || cacheEntry.sharingPolicy != 4 && cacheEntry.sharingPolicy != 3)) {
            this.hasPushPullEntries = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_syncSetEntry() Entry uses Push-Pull or Pull mode cacheName=" + this.cacheName + " id=" + cacheEntry.id), (Object[])new Object[0]);
            }
        }
        CacheEntry oldEntry = (CacheEntry)this.entryHashtable.get(cacheEntry.id);
        if (!ignoreCounting && (cachePerf = (CachePerf)this.cachePerfRef.get()) != null && source != 3 && cachePerf.isPMIEnabled() && (cacheEntry.getSharingPolicy() != 3 && cacheEntry.getSharingPolicy() != 4 || source != 2) && oldEntry == null) {
            cachePerf.onEntryCreation(cacheEntry.getTemplate(), source);
        }
        CacheEntry newEntry = null;
        if (oldEntry == null) {
            cause = 2;
            if (this.swapToDisk && cacheEntry.skipMemoryAndWriteToDisk) {
                this.writeToDiskDirectly(cacheEntry, cause, source);
                return cacheEntry;
            }
            newEntry = this.getFreeLruEntry();
            this.entryHashtable.put(cacheEntry.id, newEntry);
            if (this.swapToDisk && !cacheEntry.loadedFromDisk && this.diskCache.containsKey(cacheEntry.id)) {
                this.diskCache.delCacheEntry(cacheEntry, 1, source, false);
                cause = 1;
            }
        } else {
            cause = 1;
            if (this.swapToDisk && cacheEntry.skipMemoryAndWriteToDisk) {
                this.entryHashtable.remove(oldEntry.id);
                this.decreaseCacheSizeInBytes(oldEntry);
                if (oldEntry.timeLimit > 0 || oldEntry.inactivity > 0) {
                    this.timeLimitDaemon.valueWasRemoved(this, oldEntry.id);
                }
                this.removeInvalidationInfo(oldEntry);
                for (int i = 0; i < cacheEntry.aliasList.length; ++i) {
                    this.entryHashtable.remove(oldEntry.aliasList[i]);
                    this.decreaseCacheSizeInBytes(80L, "ALIAS");
                }
                if (oldEntry.getRefCount() <= 0) {
                    oldEntry.returnToPool();
                } else if (!oldEntry.removeWhenUnpinned) {
                    oldEntry.removeWhenUnpinned = true;
                    oldEntry.lruHead.remove(oldEntry);
                }
                this.writeToDiskDirectly(cacheEntry, cause, source);
                return cacheEntry;
            }
            if (cacheEntry.loadedFromDisk && oldEntry.loadedFromDisk) {
                if (cacheEntry.getRefCount() > 0 && oldEntry != cacheEntry) {
                    oldEntry.incRefCount();
                    oldEntry.incRefCount();
                }
                return oldEntry;
            }
            this.decreaseCacheSizeInBytes(oldEntry);
            if (oldEntry.timeStamp > cacheEntry.timeStamp) {
                Tr.debug((TraceComponent)tc, (String)("_syncSetEntry() cacheName=" + this.cacheName + " ERROR: attempting to overwrite " + "cacheEntry with older cacheEntry: " + cacheEntry.id), (Object[])new Object[0]);
            }
            if (this.swapToDisk && oldEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(oldEntry, 1, source, false);
                oldEntry.loadedFromDisk = false;
            }
            if (oldEntry.getRefCount() == 0) {
                newEntry = oldEntry;
            } else {
                newEntry = this.getFreeLruEntry();
                this.entryHashtable.put(cacheEntry.id, newEntry);
                if (!oldEntry.removeWhenUnpinned) {
                    oldEntry.removeWhenUnpinned = true;
                    oldEntry.lruHead.remove(oldEntry);
                }
            }
            this.removeInvalidationInfo(oldEntry);
            e = oldEntry.getAliasList();
            while (e.hasMoreElements()) {
                alias = e.nextElement();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_syncSetEntry() cacheName=" + this.cacheName + " removing alias from EHT id=" + cacheEntry.id + " alias=" + alias), (Object[])new Object[0]);
                }
                this.entryHashtable.remove(alias);
                this.decreaseCacheSizeInBytes(80L, "ALIAS");
            }
        }
        this.updateInvalidationHashtable(cacheEntry);
        newEntry.copy(cacheEntry);
        this.updateLruLocation(newEntry);
        this.increaseCacheSizeInBytes(newEntry);
        e = newEntry.getAliasList();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_syncSetEntry() cacheName=" + this.cacheName + " adding alias to EHT id=" + cacheEntry.id + " alias=" + alias), (Object[])new Object[0]);
            }
            this.entryHashtable.put(alias, newEntry);
            this.increaseCacheSizeInBytes(80L, "ALIAS");
        }
        newEntry.incRefCount();
        if (incRefCount) {
            newEntry.incRefCount();
        }
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0 && source != 3) {
            int src = 1;
            if (source == 2) {
                src = 2;
            }
            Object value = null;
            value = newEntry.serializedValue != null ? newEntry.serializedValue : (Object)newEntry.getValue();
            ChangeEvent event = new ChangeEvent(newEntry.id, value, cause, src, this.cacheName);
            this.eventSource.cacheEntryChanged(event);
        }
        return newEntry;
    }

    private void writeToDiskDirectly(CacheEntry cacheEntry, int cause, int source) {
        cacheEntry.incRefCount();
        LruToDiskResult toDiskResult = this.lruToDisk(cacheEntry);
        if (toDiskResult.entryOverwritten) {
            cause = 1;
        }
        if (cacheEntry.skipMemoryAndWriteToDiskErrorCode == 0 && this.bEnableListener && this.eventSource.getChangeListenerCount() > 0) {
            int src = 1;
            if (source == 2) {
                src = 2;
            }
            Object value = null;
            value = cacheEntry.serializedValue != null ? cacheEntry.serializedValue : (Object)cacheEntry.getValue();
            ChangeEvent event = new ChangeEvent(cacheEntry.id, value, cause, src, this.cacheName);
            this.eventSource.cacheEntryChanged(event);
        }
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo ei, boolean checkAskPermission) {
        Object id = ei.getIdObject();
        if (id == null) {
            return null;
        }
        boolean askPermission = this.getPermission(ei, checkAskPermission, id);
        CacheEntry cacheEntry = this.getCacheEntry(id, askPermission, false, ei.getTemplate(), true);
        cacheEntry = this.checkExpired(cacheEntry);
        return cacheEntry;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo ei, boolean checkPermission, boolean ignoreCounting) {
        Object id = ei.getIdObject();
        if (id == null) {
            return null;
        }
        boolean askPermission = this.getPermission(ei, checkPermission, id);
        CacheEntry cacheEntry = this.getCacheEntry(id, askPermission, ignoreCounting, ei.getTemplate(), true);
        cacheEntry = this.checkExpired(cacheEntry);
        return cacheEntry;
    }

    private CacheEntry checkExpired(CacheEntry cacheEntry) {
        if (cacheEntry != null && cacheEntry.getExpirationTime() > 0L && cacheEntry.getExpirationTime() < System.currentTimeMillis()) {
            cacheEntry.finish();
            cacheEntry = null;
        }
        return cacheEntry;
    }

    private boolean getPermission(com.ibm.websphere.cache.EntryInfo ei, boolean checkAskPermission, Object id) {
        boolean askPermission = false;
        CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
        if (cachePerf != null && cachePerf.isPMIEnabled()) {
            cachePerf.onRequest(ei.getTemplate(), 5);
        }
        if (checkAskPermission) {
            askPermission = this.shouldPull(ei.getSharingPolicy(), id);
        }
        return askPermission;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntry(Object id, int source, boolean ignoreCounting, boolean incrementRefCount) {
        CachePerf cachePerf;
        if (id == null) {
            return null;
        }
        CacheEntry cacheEntry = this.getCacheEntry(id, false, ignoreCounting, null, incrementRefCount);
        if (!ignoreCounting && cacheEntry != null && source == 2 && (cachePerf = (CachePerf)this.cachePerfRef.get()) != null && cachePerf.isPMIEnabled()) {
            cachePerf.onRequest(cacheEntry.getTemplate(), 2);
        }
        if (cacheEntry != null && cacheEntry.getExpirationTime() > 0L && cacheEntry.getExpirationTime() < System.currentTimeMillis()) {
            if (incrementRefCount) {
                cacheEntry.finish();
            }
            cacheEntry = null;
        }
        return cacheEntry;
    }

    @Override
    public synchronized void refreshEntry(com.ibm.websphere.cache.CacheEntry cacheEntry) {
        CacheEntry ce = (CacheEntry)cacheEntry;
        this.updateLruLocation(ce);
    }

    private final synchronized void updateLruLocation(CacheEntry cacheEntry) {
        if (cacheEntry.lruHead == null) {
            int lruBucket = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[lruBucket];
            cacheEntry.lruHead.addLast(cacheEntry);
        } else if (cacheEntry.lruHead.priority != cacheEntry.priority || cacheEntry.lruHead.priority == cacheEntry.priority && !cacheEntry.lruHead.isLast(cacheEntry)) {
            cacheEntry.lruHead.remove(cacheEntry);
            int lruBucket = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[lruBucket];
            cacheEntry.lruHead.addLast(cacheEntry);
        }
    }

    @Override
    public void updateStatisticsForVBC(com.ibm.websphere.cache.CacheEntry ce, boolean directive) {
        CacheEntry cacheEntry = (CacheEntry)ce;
        Object id = cacheEntry.getIdObject();
        int vbcSource = cacheEntry.getVBCSource();
        String template = cacheEntry.getTemplate();
        long valueSize = cacheEntry.getCacheValueSize();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateStatisticsForVBC() cacheName=" + this.cacheName + " useCachedContent=" + directive + " id=" + id + " vbcSource=" + vbcSource), (Object[])new Object[0]);
        }
        CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
        if (!directive) {
            if (vbcSource == 1 || vbcSource == 2) {
                this.cacheStatisticsListener.cacheMiss(id);
            } else if (vbcSource == 3) {
                this.cacheStatisticsListener.remoteObjectMisses(id);
            }
            if (cachePerf != null && cachePerf.isPMIEnabled()) {
                cachePerf.onCacheMiss(template, 5);
            }
        } else if (vbcSource == 1) {
            this.cacheStatisticsListener.localCacheHit(id, 1);
            if (cachePerf != null && cachePerf.isPMIEnabled()) {
                cachePerf.onCacheHit(template, 1);
            }
        } else if (vbcSource == 2) {
            this.cacheStatisticsListener.localCacheHit(id, 3);
            if (cachePerf != null && cachePerf.isPMIEnabled()) {
                cachePerf.onCacheHit(template, 3);
            }
        } else if (vbcSource == 3) {
            this.cacheStatisticsListener.remoteObjectHits(id, (int)valueSize);
            if (cachePerf != null && cachePerf.isPMIEnabled()) {
                cachePerf.onCacheHit(template, 2);
            }
        }
    }

    @Override
    public void setValue(EntryInfo entryInfo, Object value, boolean coordinate, boolean directive) {
        if (entryInfo == null) {
            throw new NullPointerException("input parameter entryInfo is null.");
        }
        if (entryInfo.getIdObject() == null) {
            throw new NullPointerException("entryInfo.getIdObject() is null.");
        }
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        if (entryInfo.getSharingPolicy() == 4 && entryInfo.getValidatorExpirationTime() != -1L) {
            this.invalidateById(entryInfo.id, 1, 5, true, false, false);
        }
        CacheEntry cacheEntry = this._syncSetValue(entryInfo, value, directive);
        if (cacheEntry.timeLimit > 0 || cacheEntry.inactivity > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
        }
        if (entryInfo.isNotShared()) {
            cacheEntry.finish();
            return;
        }
        if (coordinate) {
            this.updatePeerCaches(cacheEntry);
        } else {
            cacheEntry.finish();
        }
    }

    private synchronized CacheEntry _syncSetValue(EntryInfo entryInfo, Object value, boolean directive) {
        Enumeration e;
        int cause = -1;
        if (!(this.hasPushPullEntries || entryInfo.sharingPolicy != 4 && entryInfo.sharingPolicy != 3)) {
            this.hasPushPullEntries = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_syncSetValue() Entry uses Push-Pull or Pull mode cacheName=" + this.cacheName + " id=" + entryInfo.id), (Object[])new Object[0]);
            }
        }
        boolean updateLru = true;
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(entryInfo.getIdObject());
        if (cacheEntry == null) {
            cause = 2;
            cacheEntry = this.getFreeLruEntry();
            this.entryHashtable.put(entryInfo.getIdObject(), cacheEntry);
            boolean found = false;
            if (this.swapToDisk && this.diskCache.containsKey(entryInfo.getIdObject())) {
                if (!directive) {
                    cacheEntry.id = entryInfo.getIdObject();
                    this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
                    cause = 1;
                } else {
                    CacheEntry tempCE;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("_syncSetValue(): cacheName=" + this.cacheName + " this entry is found in the disk but not in memory for USE_CACHED_CONTENT. id=" + entryInfo.id), (Object[])new Object[0]);
                    }
                    if ((tempCE = this.diskCache.readCacheEntry(entryInfo.getIdObject())) != null) {
                        found = true;
                        this.diskCache.updateExpirationTime(entryInfo.getIdObject(), tempCE.expirationTime, (int)tempCE.getCacheValueSize(), entryInfo.expirationTime, entryInfo.validatorExpirationTime);
                        cacheEntry.copy(tempCE);
                        cacheEntry.setValidatorExpirationTime(entryInfo.validatorExpirationTime);
                        cacheEntry.loadedFromDisk = true;
                        cause = 3;
                        updateLru = false;
                    }
                }
            }
            if (!found && directive) {
                directive = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_syncSetValue(): cacheName=" + this.cacheName + " could not find cache entry from memory/disk for USE_CACHED_CONTENT. id=" + entryInfo.id), (Object[])new Object[0]);
                }
            }
        } else {
            cause = 1;
            if (!directive) {
                this.decreaseCacheSizeInBytes(cacheEntry);
            }
            if (this.swapToDisk && cacheEntry.loadedFromDisk) {
                if (!directive) {
                    this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
                    this.removeInvalidationInfo(cacheEntry);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("_syncSetValue(): cacheName=" + this.cacheName + " this entry is found in memory/disk for USE_CACHED_CONTENT. id=" + entryInfo.id), (Object[])new Object[0]);
                    }
                    this.diskCache.updateExpirationTime(entryInfo.getIdObject(), cacheEntry.expirationTime, (int)cacheEntry.getCacheValueSize(), entryInfo.expirationTime, entryInfo.validatorExpirationTime);
                    cacheEntry.setValidatorExpirationTime(entryInfo.validatorExpirationTime);
                }
            } else if (!directive) {
                this.removeInvalidationInfo(cacheEntry);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_syncSetValue(): cacheName=" + this.cacheName + " this entry is found in memory for USE_CACHED_CONTENT. id=" + entryInfo.id), (Object[])new Object[0]);
                }
                cacheEntry.setValidatorExpirationTime(entryInfo.validatorExpirationTime);
            }
        }
        CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
        if (cachePerf != null && cause == 2 && !directive && cachePerf.isPMIEnabled()) {
            cachePerf.onEntryCreation(entryInfo.getTemplate(), 5);
        }
        if (!directive) {
            cacheEntry.copyMetaData(entryInfo);
            this.updateInvalidationHashtable(cacheEntry);
            cacheEntry.setValue(value);
            this.increaseCacheSizeInBytes(cacheEntry);
        }
        if (updateLru) {
            this.updateLruLocation(cacheEntry);
        }
        if ((e = cacheEntry.getAliasList()) != null) {
            while (e.hasMoreElements()) {
                Object alias = e.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_syncSetValue() adding alias=" + alias), (Object[])new Object[0]);
                }
                entryInfo.addAlias(alias);
            }
        }
        cacheEntry.timeStamp = System.currentTimeMillis();
        cacheEntry.incRefCount();
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0) {
            ChangeEvent event = new ChangeEvent(cacheEntry.id, cacheEntry.getValue(), cause, 1, this.cacheName);
            this.eventSource.cacheEntryChanged(event);
        }
        return cacheEntry;
    }

    private void updateInvalidationHashtable(CacheEntry cacheEntry) {
        int i;
        Object id = cacheEntry.id;
        if (!this.cacheConfig.disableDependencyId) {
            for (i = 0; i < cacheEntry._dataIds.length; ++i) {
                this.dataDependencyTable.add(cacheEntry._dataIds[i], id);
            }
        }
        if (!this.cacheConfig.disableTemplatesSupport) {
            for (i = 0; i < cacheEntry._templates.length; ++i) {
                this.templateDependencyTable.add((Object)cacheEntry._templates[i], id);
            }
        }
    }

    private void removeInvalidationInfo(CacheEntry cacheEntry) {
        int i;
        Object id = cacheEntry.id;
        if (!this.cacheConfig.disableDependencyId) {
            for (i = 0; i < cacheEntry._dataIds.length; ++i) {
                this.dataDependencyTable.removeEntry(cacheEntry._dataIds[i], id);
            }
        }
        if (!this.cacheConfig.disableTemplatesSupport) {
            for (i = 0; i < cacheEntry._templates.length; ++i) {
                this.templateDependencyTable.removeEntry(cacheEntry._templates[i], id);
            }
        }
    }

    @Override
    public boolean isValid(String id) {
        CacheEntry cacheEntry = this.getCacheEntry(id, false, true, null, false);
        if (cacheEntry == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isValid() cacheName=" + this.cacheName + " id=" + id + " cacheEntry == null"), (Object[])new Object[0]);
            }
            return false;
        }
        if (cacheEntry.pendingRemoval) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isValid() cacheName=" + this.cacheName + " id=" + id + " cacheEntry.invalid"), (Object[])new Object[0]);
            }
            return false;
        }
        return !cacheEntry.removeWhenUnpinned;
    }

    @Override
    public Object invalidateAndSet(EntryInfo ei, Object value, boolean coordinate) {
        CacheEntry ce;
        String methodName = "invalidateAndSet()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invalidateAndSet() cacheName=" + this.cacheName + " id=" + ei.getIdObject() + " coordinate=" + coordinate), (Object[])new Object[0]);
        }
        Object oldValue = null;
        if (ei == null) {
            return null;
        }
        Object id = ei.getIdObject();
        CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
        if (cachePerf != null && cachePerf.isPMIEnabled()) {
            cachePerf.onRequest(ei.getTemplate(), 5);
        }
        if ((ce = this.getCacheEntry(id, false, true, null, true)) != null) {
            oldValue = ce.getValue();
            ce.finish();
        } else {
            oldValue = null;
        }
        if (ei.isSharedPull() || this.cacheConfig.propogateInvalidationsNotShared && ei.isNotShared()) {
            this.invalidateById(id, 1, 5, false, false, false);
        }
        if (!ei.wasPrioritySet()) {
            ei.setPriority(this.defaultPriority);
        }
        CacheEntry cacheEntry = this._syncSetValue(ei, value, false);
        if (cacheEntry.timeLimit > 0 || cacheEntry.inactivity > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invalidateAndSet() sharingPolicy=" + ei.sharingPolicy + " timeToLive=" + ei.timeLimit + " inactivity=" + ei.inactivity), (Object[])new Object[0]);
        }
        if (ei.isNotShared()) {
            cacheEntry.finish();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("invalidateAndSet() id=" + id));
            }
            return oldValue;
        }
        if (coordinate) {
            this.updatePeerCaches(cacheEntry);
        } else {
            cacheEntry.finish();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("invalidateAndSet() id=" + id));
        }
        return oldValue;
    }

    @Override
    public Object getValue(Object id, String template, boolean askPermission, boolean ignoreCounting) {
        CacheEntry cacheEntry;
        CachePerf cachePerf = null;
        if (!ignoreCounting) {
            cachePerf = (CachePerf)this.cachePerfRef.get();
        }
        if (cachePerf != null && cachePerf.isPMIEnabled()) {
            cachePerf.onRequest(template, 5);
        }
        Object value = null;
        if (id != null && (cacheEntry = this.getCacheEntry(id, askPermission, ignoreCounting, template, true)) != null) {
            value = cacheEntry.getValue();
            cacheEntry.finish();
        }
        return value;
    }

    @Override
    public void invalidateById(Object id, int causeOfInvalidation, boolean waitOnInvalidation, boolean checkPreInvalidationListener) {
        if (id != null) {
            this.batchUpdateDaemon.invalidateById(id, causeOfInvalidation, waitOnInvalidation, this, checkPreInvalidationListener);
        }
    }

    @Override
    public void invalidateById(Object id, int causeOfInvalidation, int sourceOfInvalidation, boolean waitOnInvalidation, boolean invokeInternalInvalidateById, boolean invokeDRSRenounce) {
        if (id != null) {
            this.batchUpdateDaemon.invalidateById(id, causeOfInvalidation, sourceOfInvalidation, waitOnInvalidation, invokeInternalInvalidateById, invokeDRSRenounce, this, true);
        }
    }

    @Override
    public void invalidateByTemplate(String template, boolean waitOnInvalidation) {
        if (template != null) {
            this.batchUpdateDaemon.invalidateByTemplate(template, waitOnInvalidation, this);
        }
    }

    @Override
    public void batchUpdate(HashMap invalidateIdEvents, HashMap invalidateTemplateEvents, ArrayList pushEntryEvents) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("batchUpdate cacheName=" + this.cacheName), (Object[])new Object[]{invalidateIdEvents, invalidateTemplateEvents, pushEntryEvents});
        }
        for (InvalidateByIdEvent idEvent : invalidateIdEvents.values()) {
            if (this.isEnableListener() && this.getEventSource().getPreInvalidationListenerCount() > 0 && idEvent.source == 2 && !this.getEventSource().shouldInvalidate(idEvent.getId(), idEvent.source, idEvent.causeOfInvalidation)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("invalidateById() cacheName=" + this.getCacheName() + " skip invalidation of id=" + idEvent.getId() + " because PreInvalidationListener.shouldInvalidate() returned false."), (Object[])new Object[0]);
                continue;
            }
            if (!idEvent.isInvokeInternalInvalidateById()) continue;
            this.internalInvalidateById(idEvent.getId(), idEvent.causeOfInvalidation, idEvent.source, true);
        }
        for (InvalidateByTemplateEvent invalidateByTemplateEvent : invalidateTemplateEvents.values()) {
            if (invalidateByTemplateEvent.isCacheCommand_Clear()) {
                this.clearLocal(invalidateByTemplateEvent.source);
                continue;
            }
            if (invalidateByTemplateEvent.isCacheCommand_InvalidateByTemplate()) {
                this.internalInvalidateByTemplate(invalidateByTemplateEvent);
                continue;
            }
            throw new IllegalStateException("Program check - cache command unknown.");
        }
        for (CacheEntry cacheEntry : pushEntryEvents) {
            this.setEntry(cacheEntry, 2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("batchUpdate cacheName=" + this.cacheName));
        }
    }

    private synchronized void internalInvalidateByTemplate(InvalidateByTemplateEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("internalInvalidateByTemplate() cacheName=" + this.cacheName + " template=[" + event.getTemplate() + "]"), (Object[])new Object[0]);
        }
        long start = System.nanoTime();
        String template = event.getTemplate().trim();
        int source = event.source;
        if (!this.cacheConfig.disableTemplatesSupport) {
            ValueSet valueSet = this.templateDependencyTable.removeDependency(template);
            if (this.swapToDisk) {
                ValueSet vs = this.diskCache.readTemplate(template, true);
                if (valueSet == null) {
                    valueSet = vs;
                } else {
                    valueSet.union(vs);
                    vs.clear();
                }
            }
            if (valueSet != null && valueSet.size() > 0) {
                event.addRemovedIds(valueSet);
                this.entriesInMemoryRemoved = 0;
                this.entriesInDiskRemoved = 0;
                this.loopRemove(valueSet, 1, source, true);
                if (this.entriesInDiskRemoved > 0) {
                    this.cacheStatisticsListener.templateBasedInvalidationsFromDisk(template);
                }
                valueSet.clear();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    String msg = "internalInvalidateByTemplate() cacheName=" + this.cacheName + " template=" + template + " numOfMemoryEntries=" + this.entriesInMemoryRemoved + " numOfDiskEntries=" + this.entriesInDiskRemoved + " cause=" + 1 + " source=" + this.source2Text(source) + " elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " listenerEnabled=" + this.bEnableListener;
                    Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("internalInvalidateByTemplate() template=" + template));
        }
    }

    private synchronized boolean internalInvalidateById(Object id, int causeOfInvalidation, int source, boolean bFireIL) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("internalInvalidateById() cacheName=" + this.cacheName + " id=" + id), (Object[])new Object[0]);
        }
        boolean rc = this.remove(id, causeOfInvalidation, source, bFireIL, false);
        this.internalInvalidateByDepId(id, causeOfInvalidation, source, bFireIL);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("internalInvalidateById: cacheName=" + this.cacheName + " id=" + id + " rc=" + rc));
        }
        return rc;
    }

    @Override
    public synchronized void internalInvalidateByDepId(Object id, int causeOfInvalidation, int source, boolean bFireIL) {
        if (!this.cacheConfig.disableDependencyId) {
            long start = System.nanoTime();
            this.entriesInMemoryRemoved = 0;
            this.entriesInDiskRemoved = 0;
            ValueSet valueSet = this.dataDependencyTable.removeDependency(id);
            if (this.swapToDisk) {
                if (valueSet == null) {
                    valueSet = this.diskCache.readDependency(id, true);
                } else {
                    valueSet.union(this.diskCache.readDependency(id, true));
                }
            }
            if (valueSet != null && valueSet.size() > 0) {
                this.loopRemove(valueSet, causeOfInvalidation, source, bFireIL);
                valueSet.clear();
                valueSet = null;
                if (this.entriesInDiskRemoved > 0) {
                    this.cacheStatisticsListener.depIdBasedInvalidationsFromDisk(id);
                }
                if (TraceComponent.isAnyTracingEnabled()) {
                    CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
                    boolean pmiEnabled = cachePerf != null ? cachePerf.isPMIEnabled() : false;
                    String msg = "internalInvalidateByDepId() cacheName=" + this.cacheName + " dep-id=" + id + " numOfMemoryEntries=" + this.entriesInMemoryRemoved + " numOfDiskEntries=" + this.entriesInDiskRemoved + " cause=" + this.cause2Text(causeOfInvalidation) + " source=" + this.source2Text(source) + " elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " listenerEnabled=" + this.bEnableListener + " PMIEnabled=" + pmiEnabled;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                    } else if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    private void loopRemove(ValueSet valueSet, int causeOfInvalidation, int source, boolean bFireIL) {
        if (valueSet != null && !valueSet.isEmpty()) {
            for (Object entryId : valueSet) {
                this.remove(entryId, causeOfInvalidation, source, bFireIL, true);
            }
        }
    }

    private final synchronized boolean remove(Object id, int causeOfInvalidation, int source, boolean bFireIL, boolean fromDepIdTemplateInvalidation) {
        int i;
        CachePerf cachePerf;
        if (id == null) {
            throw new NullPointerException("input parameter id is null.");
        }
        boolean foundOnDisk = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Cache.remove() cacheName=" + this.cacheName + " id=" + id + " cause=" + this.cause2Text(causeOfInvalidation) + " source=" + this.source2Text(source)), (Object[])new Object[0]);
        }
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(id);
        boolean allocateCE = false;
        if (cacheEntry == null && this.swapToDisk) {
            if (!fromDepIdTemplateInvalidation) {
                if (this.bEnableListener && bFireIL && this.eventSource.getInvalidationListenerCount() > 0 && !this.ignoreValueInInvalidationEvent) {
                    cacheEntry = this.diskCache.readCacheEntry(id, true);
                } else if (this.diskCache.isCacheIdInAuxDepIdTable(id)) {
                    allocateCE = true;
                } else if (this.diskCache.containsKey(id)) {
                    allocateCE = true;
                }
            } else if (this.bEnableListener && bFireIL && this.eventSource.getInvalidationListenerCount() > 0 && !this.ignoreValueInInvalidationEvent) {
                cacheEntry = this.diskCache.readCacheEntry(id, true);
            } else {
                allocateCE = true;
            }
            if (allocateCE) {
                cacheEntry = this.cacheEntryPool.allocate();
                cacheEntry.id = id;
            }
            if (cacheEntry != null) {
                foundOnDisk = true;
            }
        }
        if (!foundOnDisk) {
            if (cacheEntry != null && cacheEntry.timeLimit > 0) {
                this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
            }
        } else if (allocateCE && this.cacheConfig.diskCachePerformanceLevel == 3) {
            this.timeLimitDaemon.valueWasRemoved(this, id);
        } else if (cacheEntry != null && this.cacheConfig.diskCachePerformanceLevel == 3 && cacheEntry.timeLimit > 0) {
            this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
        }
        if (cacheEntry == null || cacheEntry.pendingRemoval || cacheEntry.removeWhenUnpinned) {
            return false;
        }
        if (!foundOnDisk && causeOfInvalidation != -1 && !cacheEntry.loadedFromDisk && (cachePerf = (CachePerf)this.cachePerfRef.get()) != null && cachePerf.isPMIEnabled()) {
            cachePerf.onInvalidate(cacheEntry.getTemplate(), causeOfInvalidation, 1, source);
        }
        if (!foundOnDisk) {
            this.cacheStatisticsListener.remove(id, causeOfInvalidation, 1, source);
        }
        cacheEntry.pendingRemoval = true;
        Object value = null;
        value = cacheEntry.serializedValue != null ? cacheEntry.serializedValue : (Object)cacheEntry.getValue();
        if (!foundOnDisk && !this.cacheConfig.disableDependencyId) {
            for (i = 0; i < cacheEntry._dataIds.length; ++i) {
                boolean found = this.dataDependencyTable.removeEntry(cacheEntry._dataIds[i], id);
                if (found || !this.swapToDisk || cacheEntry.loadedFromDisk) continue;
                this.diskCache.delDependencyEntry(cacheEntry._dataIds[i], id);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("**** Cache.remove: did=" + cacheEntry._dataIds[i] + " id=" + id), (Object[])new Object[0]);
            }
        }
        if (!foundOnDisk && !this.cacheConfig.disableTemplatesSupport) {
            for (i = 0; i < cacheEntry._templates.length; ++i) {
                this.templateDependencyTable.removeEntry(cacheEntry._templates[i], id);
            }
        }
        if (!foundOnDisk) {
            this.entryHashtable.remove(cacheEntry.id);
            this.decreaseCacheSizeInBytes(cacheEntry);
            ++this.entriesInMemoryRemoved;
            if (fromDepIdTemplateInvalidation && source != 2 && (cacheEntry.sharingPolicy == 4 || cacheEntry.sharingPolicy == 3)) {
                this.invalidateById(cacheEntry.id, causeOfInvalidation, source, false, false);
            }
            if (cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry, causeOfInvalidation, source, fromDepIdTemplateInvalidation);
            }
        } else {
            this.diskCache.delCacheEntry(cacheEntry, causeOfInvalidation, source, fromDepIdTemplateInvalidation);
            ++this.entriesInDiskRemoved;
        }
        if (this.bEnableListener && bFireIL && this.eventSource.getInvalidationListenerCount() > 0 && causeOfInvalidation > 0) {
            int src = 1;
            if (source == 2) {
                src = 2;
            }
            if (this.ignoreValueInInvalidationEvent) {
                value = null;
            }
            InvalidationEvent ie = new InvalidationEvent(cacheEntry.id, value, causeOfInvalidation, src, this.cacheName);
            this.eventSource.fireEvent(ie);
        }
        if (!foundOnDisk) {
            for (i = 0; i < cacheEntry.aliasList.length; ++i) {
                this.entryHashtable.remove(cacheEntry.aliasList[i]);
                this.decreaseCacheSizeInBytes(80L, "ALIAS");
            }
            if (cacheEntry.getRefCount() <= 0) {
                cacheEntry.returnToPool();
            } else if (!cacheEntry.removeWhenUnpinned) {
                cacheEntry.removeWhenUnpinned = true;
                cacheEntry.lruHead.remove(cacheEntry);
            }
        }
        if (allocateCE) {
            cacheEntry.returnToPool();
        }
        return true;
    }

    private String cause2Text(int cause) {
        String causeText = null;
        switch (cause) {
            case 1: {
                causeText = "DIRECT";
                break;
            }
            case 2: {
                causeText = "LRU";
                break;
            }
            case 3: {
                causeText = "TIMEOUT";
                break;
            }
            case 6: {
                causeText = "INACIVE";
                break;
            }
            case 7: {
                causeText = "Disk Garbage Collector";
                break;
            }
            case 8: {
                causeText = "Disk Overflow";
                break;
            }
            default: {
                causeText = "unknown";
            }
        }
        return causeText;
    }

    private String source2Text(int source) {
        String sourceText = null;
        switch (source) {
            case 1: {
                sourceText = "MEMORY";
                break;
            }
            case 2: {
                sourceText = "REMOTE";
                break;
            }
            case 3: {
                sourceText = "DISK";
                break;
            }
            case 4: {
                sourceText = "NOOP";
                break;
            }
            case 5: {
                sourceText = "LOCAL";
                break;
            }
            default: {
                sourceText = "unknown";
            }
        }
        return sourceText;
    }

    @Override
    public void clear(boolean waitOnInvalidation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clear() cacheName=" + this.cacheName + " waitOnInvalidation=" + waitOnInvalidation), (Object[])new Object[0]);
        }
        if (this.bEnableListener && this.eventSource.getPreInvalidationListenerCount() > 0 && !this.eventSource.shouldInvalidate("*", 1, 5)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("clear() cacheName=" + this.cacheName + " skip clearing cache because PreInvalidationListener.shouldInvalidate() returns false."), (Object[])new Object[0]);
            }
            return;
        }
        this.batchUpdateDaemon.cacheCommand_Clear(waitOnInvalidation, this);
    }

    private synchronized void clearLocal(int source) {
        CachePerf cachePerf;
        int cause = 1;
        if (this.swapToDisk) {
            this.diskCache.clearDiskCache();
        }
        boolean savedSwapToDisk = this.swapToDisk;
        this.swapToDisk = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clearLocal() cacheName=" + this.cacheName + " invalidating " + this.entryHashtable.size() + " entries"), (Object[])new Object[0]);
        }
        Enumeration e = this.entryHashtable.keys();
        while (e.hasMoreElements()) {
            Object id = e.nextElement();
            this.internalInvalidateById(id, cause, source, false);
        }
        this.swapToDisk = savedSwapToDisk;
        if (this.swapToDisk) {
            this.diskCache.clearInvalidationBuffers();
        }
        if (this.bEnableListener) {
            int src = 1;
            if (source == 2) {
                src = 2;
            }
            InvalidationEvent ie = new InvalidationEvent("*", null, 5, src, this.cacheName);
            this.eventSource.fireEvent(ie);
        }
        this.timeLimitDaemon.cacheCleared(this);
        this.invalidationAuditDaemon.cacheCleared(this.cacheName);
        if (this.isCacheSizeInMBEnabled()) {
            this.currentMemoryCacheSizeInBytes = 0L;
            this.increaseCacheSizeInBytes(40L + 28L * (long)this.cacheConfig.cacheSize, "EHT");
        }
        if ((cachePerf = (CachePerf)this.cachePerfRef.get()) != null && cachePerf.isPMIEnabled()) {
            cachePerf.onCacheClear(true, this.swapToDisk);
        }
    }

    @Override
    public synchronized Enumeration getAllIds() {
        return this.entryHashtable.keys();
    }

    @Override
    public Set getCacheIds() {
        return new ValueSet(this.getAllIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMemoryCacheHashcode(boolean debug, boolean includeValue) {
        int totalHashcode = 0;
        StringBuffer sb = new StringBuffer();
        int count = 0;
        int totalCount = 0;
        Cache cache = this;
        synchronized (cache) {
            Enumeration e = this.entryHashtable.elements();
            while (e.hasMoreElements()) {
                CacheEntry ce = (CacheEntry)e.nextElement();
                int id_hc = ce.id.hashCode();
                if (!ce.loadedFromDisk) {
                    totalHashcode += id_hc;
                }
                if (includeValue && !ce.loadedFromDisk) {
                    if (ce.valueHashcode == 0 && null != ce.value) {
                        ce.valueHashcode = ce.value.hashCode();
                    }
                    totalHashcode += ce.valueHashcode;
                }
                ++totalCount;
                if (!debug) continue;
                sb.append("\nid=");
                sb.append(ce.id);
                sb.append(" id_hashcode=");
                sb.append(id_hc);
                if (includeValue) {
                    sb.append(" value_hashcode=");
                    sb.append(ce.valueHashcode);
                }
                if (this.swapToDisk) {
                    sb.append(" existOnDisk=");
                    sb.append(ce.loadedFromDisk);
                }
                if (++count != 100) continue;
                Tr.info((TraceComponent)tc, (String)"DYNA1035I", (Object[])new Object[]{String.valueOf(count), this.cacheName, sb.toString()});
                sb.setLength(0);
                count = 0;
            }
        }
        if (debug && count > 0) {
            Tr.info((TraceComponent)tc, (String)"DYNA1035I", (Object[])new Object[]{String.valueOf(count), this.cacheName, sb.toString()});
        }
        Tr.info((TraceComponent)tc, (String)"DYNA1038I", (Object[])new Object[]{String.valueOf(totalCount), this.cacheName});
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMemoryCacheHashcode(): cacheName=" + this.cacheName + " totalCount=" + totalCount + " totalHashcode=" + totalHashcode), (Object[])new Object[0]);
        }
        return totalHashcode;
    }

    @Override
    public int getDiskCacheHashcode(boolean debug, boolean includeValue) throws DynamicCacheException {
        int totalHashcode = 0;
        int totalCount = 0;
        if (this.swapToDisk) {
            if (this.getIdsSizeDisk() > 0) {
                int index = 0;
                boolean more = false;
                StringBuffer sb = new StringBuffer();
                ArrayList aList = new ArrayList(100);
                do {
                    Result result = this.diskCache.readHashcodeByRange(index, 100, debug, includeValue);
                    if (result.returnCode == 1) {
                        throw new DiskIOException("The disk IO exception has occurred when reading entries from disk cache. " + result.diskException.getMessage());
                    }
                    if (result.returnCode == 8) {
                        throw new DiskCacheUsingOldFormatException("Getting hashcode for disk cache failed because the disk cache is using the old format. The new format includes hashcode for cache value in the disk header.");
                    }
                    totalHashcode += result.totalHashcode;
                    int count = result.dataSize;
                    totalCount += count;
                    more = result.bMore;
                    if (debug && count > 0) {
                        List list = (List)result.data;
                        aList.addAll(list);
                        if (aList.size() >= 100 || !more) {
                            Object[] sa = aList.toArray();
                            count = more ? 100 : aList.size();
                            for (int i = 0; i < count; ++i) {
                                Object o = sa[i];
                                String s = (String)o;
                                sb.append(s);
                                aList.remove(o);
                            }
                            Tr.info((TraceComponent)tc, (String)"DYNA1036I", (Object[])new Object[]{String.valueOf(count), this.cacheName, sb.toString()});
                            sb.setLength(0);
                        }
                    }
                    index = 1;
                } while (more);
                Tr.info((TraceComponent)tc, (String)"DYNA1039I", (Object[])new Object[]{String.valueOf(totalCount), this.cacheName});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDiskCacheHashcode(): cacheName=" + this.cacheName + " diskOffloadEnabled=" + this.swapToDisk + " totalCount=" + totalCount + " totalHashcode=" + totalHashcode), (Object[])new Object[0]);
            }
        }
        return totalHashcode;
    }

    @Override
    public int getCacheIdsHashcodeInPushPullTable(boolean debug) {
        return this.remoteServices.getCacheIdsHashcodeInPushPullTable(debug);
    }

    @Override
    public boolean containsCacheId(Object cacheId) {
        return this.entryHashtable.containsKey(cacheId);
    }

    @Override
    public boolean containsKeyDisk(Object key) {
        if (this.swapToDisk) {
            return this.diskCache.containsKey(key);
        }
        return false;
    }

    @Override
    public Collection getAllDependencyIds() {
        return this.getDependencyIds();
    }

    public synchronized Set getDependencyIds() {
        Iterator<Object> e;
        ValueSet ids = null;
        if (!this.cacheConfig.disableDependencyId && (e = this.dataDependencyTable.getKeys()) != null) {
            ids = new ValueSet(e);
        }
        if (ids == null) {
            ids = new ValueSet(0);
        }
        return ids;
    }

    @Override
    public synchronized Set getCacheIdsByDependency(Object dependency) {
        ValueSet ids = null;
        if (!this.cacheConfig.disableDependencyId) {
            ids = this.dataDependencyTable.getEntries(dependency);
        }
        if (ids == null) {
            ids = new ValueSet(0);
        }
        return ids;
    }

    @Override
    public synchronized Set getCacheIdsByTemplate(String template) {
        ValueSet ids = null;
        if (!this.cacheConfig.disableTemplatesSupport) {
            ids = this.templateDependencyTable.getEntries(template);
        }
        if (ids == null) {
            ids = new ValueSet(0);
        }
        return ids;
    }

    private boolean canAllocate() {
        boolean allocate = false;
        int currentCacheEntries = this.getNumberCacheEntries();
        if (currentCacheEntries < this.cacheSizeLimit) {
            if (this.isCacheSizeInMBEnabled()) {
                if (this.currentMemoryCacheSizeInBytes < this.maxMemoryCacheSizeInBytes) {
                    allocate = true;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("canAllocate() cacheName=" + this.cacheName + " currentMemoryCacheSizeInBytes=" + this.currentMemoryCacheSizeInBytes + " maxMemoryCacheSizeInBytes=" + this.maxMemoryCacheSizeInBytes + " diff=" + (this.currentMemoryCacheSizeInBytes - this.maxMemoryCacheSizeInBytes)), (Object[])new Object[0]);
                }
            } else {
                allocate = true;
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("canAllocate() cacheName=" + this.cacheName + " currentCacheEntries=" + currentCacheEntries + " cacheSizelimit=" + this.cacheSizeLimit + " diff=" + (currentCacheEntries - this.cacheSizeLimit)), (Object[])new Object[0]);
        }
        return allocate;
    }

    private synchronized CacheEntry getFreeLruEntry() {
        CacheEntry cacheEntry = null;
        if (this.canAllocate()) {
            return this.cacheEntryPool.allocate();
        }
        try {
            FreeLruEntryResult result = this.freeLruEntry();
            if (result.success) {
                return this.getFreeLruEntry();
            }
            this.cacheStatisticsListener.overflowEntriesFromMemory();
            cacheEntry = this.cacheEntryPool.allocate();
            return cacheEntry;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.Cache.getFreeLruEntry", (String)"1181", (Object)this);
            return null;
        }
    }

    @Override
    @Trivial
    public void trimCache() {
        int size;
        if (((CacheConfig)this.getCacheConfig()).isRefCountTrackingEnabled()) {
            this.lookForLeaks();
        }
        if ((size = this.getNumberCacheEntriesUnsynchronized() - this.cacheConfig.cacheSize) > 0) {
            int entriesRemoved = 0;
            for (int i = 0; i < size; ++i) {
                FreeLruEntryResult result = this.freeLruEntry();
                if (!result.success) break;
                if (this.swapToDisk) {
                    this.cacheStatisticsListener.objectsAsyncLruToDisk();
                }
                ++entriesRemoved;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("trimCache(): cacheName=" + this.cacheName + " entriesToRemove=" + size + " entriesRemoved=" + entriesRemoved + " ObjectsAsyncLruToDisk=" + this.cacheStatisticsListener.getObjectsAsyncLruToDiskCount()), (Object[])new Object[0]);
            }
        }
        long cacheSizeInBytes = this.currentMemoryCacheSizeInBytes;
        if (this.isCacheSizeInMBEnabled() && cacheSizeInBytes >= this.upperLimitMemoryCacheSizeInBytes) {
            long bytesToRemove;
            long savedBytesToRemove = bytesToRemove = cacheSizeInBytes - this.lowerLimitMemoryCacheSizeInBytes;
            long bytesRemoved = 0L;
            int entriesRemoved = 0;
            while (bytesToRemove > 0L && this.currentMemoryCacheSizeInBytes > this.lowerLimitMemoryCacheSizeInBytes) {
                FreeLruEntryResult result = this.freeLruEntry();
                if (!result.success) break;
                bytesToRemove -= result.bytesRemoved;
                bytesRemoved += result.bytesRemoved;
                if (this.swapToDisk) {
                    this.cacheStatisticsListener.objectsAsyncLruToDisk();
                }
                ++entriesRemoved;
            }
            if (savedBytesToRemove > 0L && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("trimCache(): cacheName=" + this.cacheName + " bytesToRemove=" + savedBytesToRemove + " bytesRemoved=" + bytesRemoved + " entriesRemoved=" + entriesRemoved + " ObjectsAsyncLruToDisk=" + this.cacheStatisticsListener.getObjectsAsyncLruToDiskCount()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public synchronized FreeLruEntryResult freeLruEntry() {
        FreeLruEntryResult result = new FreeLruEntryResult();
        CacheEntry cacheEntry = null;
        int endTop = (this.lruTop + this.lruBuckets.length - 1) % this.lruBuckets.length;
        while (cacheEntry == null && this.lruTop != endTop) {
            if (!this.lruBuckets[this.lruTop].isEmpty()) {
                Iterator it = this.lruBuckets[this.lruTop].iterator();
                while (it.hasNext()) {
                    Object id;
                    cacheEntry = (CacheEntry)it.next();
                    if (cacheEntry.getRefCount() != 0 || (id = cacheEntry.id) == null) continue;
                    result.success = false;
                    if (this.isCacheSizeInMBEnabled()) {
                        result.bytesRemoved = cacheEntry.getObjectSize();
                    }
                    if (this.swapToDisk && cacheEntry.persistToDisk) {
                        LruToDiskResult toDiskResult = this.lruToDisk(cacheEntry);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)toDiskResult.toString(), (Object[])new Object[0]);
                        }
                        if (toDiskResult.result != 1 && toDiskResult.result != 3 && toDiskResult.result != 4) {
                            result.success = true;
                        }
                    } else {
                        if (!this.swapToDisk && !this.displayedLRUMessage) {
                            Tr.audit((TraceComponent)tc, (String)"DYNA1070I", (Object[])new Object[]{this.cacheName, new Integer(this.cacheConfig.cacheSize)});
                            this.displayedLRUMessage = true;
                        }
                        if (this.shouldInvalidate(id)) {
                            result.success = this.internalInvalidateById(id, 2, 5, true);
                        }
                        if (!this.cacheConfig.filterLRUInvalidation && result.success) {
                            this.invalidateById(id, 2, 5, false, false);
                        }
                    }
                    if (!result.success) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"return freeLruEntry() true");
                    }
                    return result;
                }
            }
            int newTop = (this.lruTop + 1) % this.lruBuckets.length;
            CacheEntry.LRUHead lruBucket = this.lruBuckets[this.lruTop];
            while (!lruBucket.isEmpty()) {
                CacheEntry updateEntry = lruBucket.removeFirst();
                updateEntry.lruHead = this.lruBuckets[newTop];
                this.lruBuckets[newTop].addFirst(updateEntry);
            }
            this.lruTop = newTop;
            if (this.cacheConfig.isRefCountTrackingEnabled()) {
                Tr.warning((TraceComponent)tc, (String)(this.getCacheName() + " Empty or eveything was pinned, need to combine... " + this.lruTop), (Object[])new Object[0]);
            }
            for (int i = 0; i < this.lruBuckets.length; ++i) {
                this.lruBuckets[(this.lruTop + i) % this.lruBuckets.length].priority = i;
            }
        }
        return result;
    }

    private boolean shouldInvalidate(Object id) {
        boolean shouldInvalidate = true;
        if (this.isEnableListener() && this.getEventSource().getPreInvalidationListenerCount() > 0 && !(shouldInvalidate = this.getEventSource().shouldInvalidate(id, 2, 5)) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("freeLruEntry() cacheName=" + this.getCacheName() + " skip invalidation of id=" + id + " because PreInvalidationListener.shouldInvalidate() returns false."), (Object[])new Object[0]);
        }
        return shouldInvalidate;
    }

    private synchronized LruToDiskResult lruToDisk(CacheEntry cacheEntry) {
        int i;
        int cause;
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lruToDisk", (Object[])new Object[]{cacheEntry});
        }
        LruToDiskResult toDiskResult = new LruToDiskResult();
        toDiskResult.entryOverwritten = false;
        if (cacheEntry.id == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lruToDisk.1");
            }
            return toDiskResult;
        }
        boolean discard = false;
        int overLimitType = 0;
        if (!cacheEntry.loadedFromDisk) {
            ((CacheOnDisk)this.diskCache).htod.diskCacheException = null;
            if (!cacheEntry.prepareForSerialization()) {
                discard = true;
                toDiskResult.result = 4;
            }
            if (!discard && cacheEntry.serializedValue == null) {
                discard = true;
                toDiskResult.result = 4;
            }
            int diskCacheSizeLimit = this.diskCache.getDiskCacheSizeLimit();
            if (!discard && diskCacheSizeLimit > 0 && this.getIdsSizeDisk() >= diskCacheSizeLimit) {
                ++this.diskCacheSizeEvictedCount;
                if (this.diskCacheSizeEvictedCount == this.diskCacheSizeEvictedLimit) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0065W", (Object[])new Object[]{new Integer(diskCacheSizeLimit), this.cacheName, this.diskCacheSizeEvictedCount});
                    this.diskCacheSizeEvictedLimit = this.diskCacheSizeEvictedLimit == 1L ? 1000L : (this.diskCacheSizeEvictedLimit += 1000L);
                }
                overLimitType = 1;
                discard = true;
                toDiskResult.result = 5;
            }
            long diskCacheEntrySizeInBytesLimit = this.diskCache.getDiskCacheEntrySizeInBytesLimit();
            if (!discard && diskCacheEntrySizeInBytesLimit > 0L && (long)cacheEntry.serializedValue.length >= diskCacheEntrySizeInBytesLimit) {
                ++this.diskCacheEntrySizeInMBEvictedCount;
                if (this.diskCacheEntrySizeInMBEvictedCount == this.diskCacheEntrySizeInMBEvictedLimit) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0064W", (Object[])new Object[]{new Long(diskCacheEntrySizeInBytesLimit / 0x100000L), this.cacheName, new Long(this.diskCacheEntrySizeInMBEvictedCount)});
                    this.diskCacheEntrySizeInMBEvictedLimit = this.diskCacheEntrySizeInMBEvictedLimit == 1L ? 1000L : (this.diskCacheEntrySizeInMBEvictedLimit += 1000L);
                }
                discard = true;
                toDiskResult.result = 6;
            }
            if (this.enableDiskCacheSizeInBytesChecking && !discard) {
                long diskCacheSizeInBytesLimit;
                int dataSize = cacheEntry.serializedId.length;
                if (cacheEntry._templates != null && cacheEntry._templates.length > 0) {
                    dataSize += cacheEntry._templates[0].length();
                }
                if (cacheEntry._serializedDataIds != null) {
                    dataSize += cacheEntry._serializedDataIds.length;
                }
                if ((diskCacheSizeInBytesLimit = this.diskCache.getDiskCacheSizeInBytesLimit()) > 0L && this.diskCache.getCacheSizeInBytes() + (long)(dataSize += cacheEntry.serializedValue.length) >= diskCacheSizeInBytesLimit) {
                    ++this.diskCacheSizeInGBEvictedCount;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("lruToDisk(): cacheName=" + this.cacheName + " diskCacheSizeInGBEvictedCount=" + this.diskCacheSizeInGBEvictedCount + " diskCache.getCacheSizeInBytes()=" + this.diskCache.getCacheSizeInBytes() + " dataSize=" + dataSize + " diskCacheSizeInBytesLimit=" + diskCacheSizeInBytesLimit), (Object[])new Object[0]);
                    }
                    if (this.diskCacheSizeInGBEvictedCount == this.diskCacheSizeInGBEvictedLimit) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0063W", (Object[])new Object[]{new Integer(this.diskCache.getDiskCacheSizeInGBLimit()), this.cacheName, new Long(this.diskCacheSizeInGBEvictedCount)});
                        this.diskCacheSizeInGBEvictedLimit = this.diskCacheSizeInGBEvictedLimit == 1L ? 1000L : (this.diskCacheSizeInGBEvictedLimit += 1000L);
                    }
                    overLimitType = 2;
                    discard = true;
                    toDiskResult.result = 2;
                }
            }
        }
        if (discard) {
            if (overLimitType > 0 && this.cacheConfig.getDiskCacheEvictionPolicy() != 0) {
                this.diskCache.invokeDiskCacheGarbageCollector(overLimitType);
            }
            cause = 2;
            if (overLimitType > 0) {
                cause = 8;
            }
            if (cacheEntry.skipMemoryAndWriteToDisk) {
                cacheEntry.skipMemoryAndWriteToDiskErrorCode = toDiskResult.result;
                CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
                if (cachePerf != null && !cacheEntry.loadedFromDisk && cachePerf.isPMIEnabled()) {
                    cachePerf.onInvalidate(cacheEntry.getTemplate(), cause, 1, 5);
                }
                this.cacheStatisticsListener.remove(cacheEntry.id, cause, 1, 5);
            } else {
                this.internalInvalidateById(cacheEntry.id, cause, 5, true);
                this.invalidateById(cacheEntry.id, cause, 5, false, false);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lruToDisk.2");
            }
            return toDiskResult;
        }
        if (!(cacheEntry.skipMemoryAndWriteToDisk || this.cacheConfig.diskCachePerformanceLevel == 3 || cacheEntry.timeLimit <= 0 && cacheEntry.inactivity <= 0)) {
            this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
        }
        if (cacheEntry.loadedFromDisk) {
            this.removeInvalidationInfo(cacheEntry);
        } else {
            this.invokeGCIfNecessary();
            toDiskResult.result = this.diskCache.writeCacheEntry(cacheEntry);
            if (toDiskResult.result == 7) {
                toDiskResult.entryOverwritten = true;
                toDiskResult.result = 0;
            }
            if (toDiskResult.result != 0) {
                cause = 2;
                if (toDiskResult.result == 2) {
                    cause = 8;
                }
                if (cacheEntry.skipMemoryAndWriteToDisk) {
                    cacheEntry.skipMemoryAndWriteToDiskErrorCode = toDiskResult.result;
                    CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
                    if (cachePerf != null && !cacheEntry.loadedFromDisk && cachePerf.isPMIEnabled()) {
                        cachePerf.onInvalidate(cacheEntry.getTemplate(), cause, 1, 5);
                    }
                    this.cacheStatisticsListener.remove(cacheEntry.id, cause, 1, 5);
                } else {
                    this.internalInvalidateById(cacheEntry.id, cause, 5, true);
                    this.invalidateById(cacheEntry.id, cause, 5, false, false);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lruToDisk.3");
                }
                return toDiskResult;
            }
            if (!this.cacheConfig.disableDependencyId) {
                for (i = 0; i < cacheEntry._dataIds.length; ++i) {
                    if (toDiskResult.result != 0) continue;
                    toDiskResult.result = this.diskCache.writeDependencyEntry(cacheEntry._dataIds[i], cacheEntry.id);
                    if (toDiskResult.result != 0 || cacheEntry.skipMemoryAndWriteToDisk) continue;
                    this.dataDependencyTable.removeEntry(cacheEntry._dataIds[i], cacheEntry.id);
                }
            }
            if (!this.cacheConfig.disableTemplatesSupport) {
                for (i = 0; i < cacheEntry._templates.length; ++i) {
                    if (toDiskResult.result != 0) continue;
                    toDiskResult.result = this.diskCache.writeTemplateEntry(cacheEntry._templates[i], cacheEntry.id);
                    if (toDiskResult.result != 0 || cacheEntry.skipMemoryAndWriteToDisk) continue;
                    this.templateDependencyTable.removeEntry(cacheEntry._templates[i], cacheEntry.id);
                }
            }
            if (toDiskResult.result != 0) {
                cause = 2;
                if (toDiskResult.result == 2) {
                    cause = 8;
                }
                if (toDiskResult.result != 1) {
                    ValueSet valueSet = new ValueSet(1);
                    valueSet.add(cacheEntry.id);
                    this.diskCache.delCacheEntry(valueSet, cause, 5, false, false);
                }
                if (cacheEntry.skipMemoryAndWriteToDisk) {
                    cacheEntry.skipMemoryAndWriteToDiskErrorCode = toDiskResult.result;
                    CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
                    if (cachePerf != null && !cacheEntry.loadedFromDisk && cachePerf.isPMIEnabled()) {
                        cachePerf.onInvalidate(cacheEntry.getTemplate(), cause, 1, 5);
                    }
                    this.cacheStatisticsListener.remove(cacheEntry.id, cause, 1, 5);
                } else {
                    this.internalInvalidateById(cacheEntry.id, cause, 5, true);
                    this.invalidateById(cacheEntry.id, cause, 5, false, false);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lruToDisk.4");
                }
                return toDiskResult;
            }
        }
        if (!cacheEntry.skipMemoryAndWriteToDisk) {
            this.entryHashtable.remove(cacheEntry.id);
            this.decreaseCacheSizeInBytes(cacheEntry);
            for (i = 0; i < cacheEntry.aliasList.length; ++i) {
                this.entryHashtable.remove(cacheEntry.aliasList[i]);
                this.decreaseCacheSizeInBytes(80L, "ALIAS");
            }
        }
        if (!this.cacheConfig.disableDependencyId) {
            ValueSet valueSet = this.dataDependencyTable.removeDependency(cacheEntry.id);
            if (valueSet != null && !cacheEntry.loadedFromDisk) {
                ValueSet valueSetClone = (ValueSet)valueSet.clone();
                toDiskResult.result = this.diskCache.writeDependency(cacheEntry.id, valueSetClone);
            }
            if (toDiskResult.result != 0) {
                this.dataDependencyTable.add(cacheEntry.id, valueSet);
                int cause2 = 2;
                if (toDiskResult.result == 2) {
                    cause2 = 8;
                }
                if (toDiskResult.result != 1) {
                    ValueSet valueSet1 = new ValueSet(1);
                    valueSet1.add(cacheEntry.id);
                    this.diskCache.delCacheEntry(valueSet1, cause2, 5, false, false);
                }
                this.internalInvalidateById(cacheEntry.id, cause2, 5, true);
                this.invalidateById(cacheEntry.id, cause2, 5, false, false);
                if (cacheEntry.skipMemoryAndWriteToDisk) {
                    cacheEntry.skipMemoryAndWriteToDiskErrorCode = toDiskResult.result;
                    CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
                    if (cachePerf != null && !cacheEntry.loadedFromDisk && cachePerf.isPMIEnabled()) {
                        cachePerf.onInvalidate(cacheEntry.getTemplate(), cause2, 1, 5);
                    }
                    this.cacheStatisticsListener.remove(cacheEntry.id, cause2, 1, 5);
                } else {
                    cacheEntry.returnToPool();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lruToDisk.5");
                }
                return toDiskResult;
            }
        }
        if (cacheEntry.skipMemoryAndWriteToDisk) {
            if (this.cacheConfig.diskCachePerformanceLevel == 3 && (cacheEntry.timeLimit > 0 || cacheEntry.inactivity > 0)) {
                this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
            }
        } else {
            CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
            if (cachePerf != null && !cacheEntry.loadedFromDisk && cachePerf.isPMIEnabled()) {
                cachePerf.onInvalidate(cacheEntry.getTemplate(), 2, 3, 5);
            }
            this.cacheStatisticsListener.remove(cacheEntry.id, 2, 3, 5);
            cacheEntry.returnToPool();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lruToDisk");
        }
        return toDiskResult;
    }

    private void invokeGCIfNecessary() {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invokeGCIfNecessary SIZE LIMIT " + this.diskCache.getDiskCacheSizeHighLimit() + " ACTUAL " + this.getIdsSizeDisk() + "BYTES LIMIT " + this.diskCache.getDiskCacheSizeInBytesHighLimit() + " ACTUAL " + this.diskCache.getCacheSizeInBytes()), (Object[])new Object[0]);
        }
        boolean invokeGC = false;
        boolean invokedGC = false;
        if (this.cacheConfig.getDiskCacheEvictionPolicy() != 0) {
            invokeGC = false;
            if (this.diskCache.getDiskCacheSizeLimit() > 0 && this.getIdsSizeDisk() > this.diskCache.getDiskCacheSizeHighLimit()) {
                invokeGC = true;
                invokedGC = this.diskCache.invokeDiskCacheGarbageCollector(1);
            }
            if (!invokeGC && this.diskCache.getDiskCacheSizeInBytesLimit() > 0L && this.diskCache.getCacheSizeInBytes() > this.diskCache.getDiskCacheSizeInBytesHighLimit()) {
                invokeGC = true;
                invokedGC = this.diskCache.invokeDiskCacheGarbageCollector(2);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("invokeGCIfNecessary " + invokeGC + " invokedGC " + invokedGC));
        }
    }

    @Override
    public synchronized void stop() {
        CachePerf cachePerf;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" Stopping cache: " + this.cacheName), (Object[])new Object[0]);
        }
        if (this.swapToDisk && !this.flushToDiskComplete) {
            this.flushToDisk();
        }
        if ((cachePerf = (CachePerf)this.cachePerfRef.get()) != null) {
            cachePerf.removePMICounters();
        }
    }

    private void flushToDisk() {
        boolean flushToDisk = this.cacheConfig.flushToDiskOnStop;
        if (this.cacheName != null) {
            String systemProperty;
            if (this.cacheName.equals("baseCache") && (systemProperty = System.getProperty("com.ibm.ws.cache.flushToDiskOnStop")) != null && systemProperty.equalsIgnoreCase("true")) {
                flushToDisk = true;
            }
            if (flushToDisk) {
                Tr.info((TraceComponent)tc, (String)"DYNA0060I", (Object[])new Object[]{this.cacheName});
                this.swapToDisk = false;
                this.diskCache.stop(false);
                Enumeration e = this.entryHashtable.elements();
                long timeoutAdjustment = 120000L;
                int numOffload = 0;
                long lastWriteObjectSize = this.cacheStatisticsListener.getObjectsWriteToDiskSizeCount();
                long time1 = System.nanoTime();
                while (e.hasMoreElements()) {
                    CacheEntry ce = (CacheEntry)e.nextElement();
                    if (!ce.persistToDisk || ce.timeLimit > 0 && (ce.timeLimit <= 0 || System.currentTimeMillis() + timeoutAdjustment >= ce.expirationTime)) continue;
                    ++numOffload;
                    this.lruToDisk(ce);
                }
                long time2 = System.nanoTime();
                if (this.diskCache.writeAuxiliaryDepTables() == 1) {
                    return;
                }
                StringBuffer message = new StringBuffer();
                CacheOnDisk cacheOnDisk = (CacheOnDisk)this.diskCache;
                message.append(" numOfEntriesFlushToDisk=");
                message.append(numOffload);
                message.append(" numOfBytesFlushToDisk=");
                message.append(this.cacheStatisticsListener.getObjectsWriteToDiskSizeCount() - lastWriteObjectSize);
                message.append(" timeElapsedEntriesFlushToDisk=");
                message.append(TimeUnit.NANOSECONDS.toMillis(time2 - time1));
                message.append(" numDepIdsInAuxTable=");
                message.append(cacheOnDisk.htod.numDepIdsInAuxTable);
                message.append(" numCacheIdsInDepIdAuxTable=");
                message.append(cacheOnDisk.htod.numCacheIdsInDepIdAuxTable);
                message.append(" numTemplatesInAuxTable=");
                message.append(cacheOnDisk.htod.numTemplatesInAuxTable);
                message.append(" numCacheIdsInTemplateAuxTable=");
                message.append(cacheOnDisk.htod.numCacheIdsInTemplateAuxTable);
                message.append(" timeElapsedWriteAuxTables=");
                message.append(cacheOnDisk.htod.timeElapsedWriteAuxTables);
                int numExplicitBufferFlushToDisk = cacheOnDisk.htod.numExplicitBufferLimitOnStop;
                if (numExplicitBufferFlushToDisk > 0) {
                    message.append(" numExplicitBufferFlushToDisk=");
                    message.append(numExplicitBufferFlushToDisk);
                    message.append(" explicitBufferLimitOnStop=");
                    message.append(cacheOnDisk.explicitBufferLimitOnStop);
                }
                Tr.info((TraceComponent)tc, (String)"DYNA0073I", (Object[])new Object[]{this.cacheName, message.toString()});
                this.diskCache.close(true);
            } else {
                Tr.info((TraceComponent)tc, (String)"DYNA0061I", (Object[])new Object[]{this.cacheName});
                this.swapToDisk = false;
                this.diskCache.stop(true);
                this.diskCache.close(true);
                this.diskCache.deleteDiskCacheFiles();
            }
            this.flushToDiskComplete = true;
        }
    }

    @Override
    public synchronized int getNumberCacheEntries() {
        return this.entryHashtable.size();
    }

    @Override
    @Trivial
    public int getNumberCacheEntriesUnsynchronized() {
        return this.entryHashtable.size();
    }

    @Override
    public boolean shouldPull(int share, Object id) {
        return this.remoteServices.shouldPull(share, id);
    }

    @Override
    public void setSwapToDisk(boolean enable) {
        this.swapToDisk = enable;
        this.cacheConfig.enableDiskOffload = enable;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getEntryFromMemory(Object id) {
        return (com.ibm.websphere.cache.CacheEntry)this.entryHashtable.get(id);
    }

    @Override
    public void addAlias(Object key, Object[] aliasArray, boolean askPermission, boolean coordinate) {
        CacheEntry cacheEntry = this._syncAddAlias(key, aliasArray, askPermission);
        if (cacheEntry == null) {
            throw new IllegalArgumentException("The cache id is not found in the cache's mapping table when adding alias");
        }
        cacheEntry.finish();
        if (cacheEntry.sharingPolicy != 1 && coordinate) {
            AliasEntry aliasEntry = new AliasEntry(key, "AddAlias", cacheEntry.sharingPolicy, aliasArray);
            this.batchUpdateDaemon.pushAliasEntry(aliasEntry, this);
        }
    }

    private synchronized CacheEntry _syncAddAlias(Object key, Object[] aliasArray, boolean askPermission) {
        CacheEntry cacheEntry = this.getCacheEntry(key, askPermission, true, null, true);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.loadedFromDisk) {
            this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
            cacheEntry.loadedFromDisk = false;
        }
        if (cacheEntry.getExpirationTime() > 0L && cacheEntry.getExpirationTime() < System.currentTimeMillis()) {
            cacheEntry.finish();
            return null;
        }
        for (int i = 0; i < aliasArray.length; ++i) {
            CacheEntry oldAlias;
            if (aliasArray[i] == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_syncAddAlias() cacheName=" + this.cacheName + " adding alias to EHT key=" + key + " alias=" + aliasArray[i]), (Object[])new Object[0]);
            }
            if ((oldAlias = (CacheEntry)this.entryHashtable.get(aliasArray[i])) != null) {
                this.removeAlias(aliasArray[i], askPermission, false);
            }
            cacheEntry.addAlias(aliasArray[i]);
            this.entryHashtable.put(aliasArray[i], cacheEntry);
            this.increaseCacheSizeInBytes(80L, "ALIAS");
        }
        return cacheEntry;
    }

    @Override
    public void removeAlias(Object alias, boolean askPermission, boolean coordinate) {
        CacheEntry cacheEntry = this._syncRemoveAlias(alias, askPermission);
        if (cacheEntry == null) {
            throw new IllegalArgumentException("The alias is not found in the cache's mapping table when removing alias");
        }
        cacheEntry.finish();
        if (cacheEntry.sharingPolicy == 1) {
            return;
        }
        if (coordinate) {
            AliasEntry aliasEntry = new AliasEntry(cacheEntry.getIdObject(), "RemoveAlias", cacheEntry.sharingPolicy, CacheEntry.EMPTY_OBJECT_ARRAY);
            aliasEntry.addAlias(alias);
            this.batchUpdateDaemon.pushAliasEntry(aliasEntry, this);
        }
    }

    private synchronized CacheEntry _syncRemoveAlias(Object alias, boolean askPermission) {
        CacheEntry cacheEntry = this.getCacheEntry(alias, askPermission, true, null, true);
        if (cacheEntry != null) {
            if (cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
                cacheEntry.loadedFromDisk = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_syncRemoveAlias() cacheName=" + this.cacheName + " removing alias from EHT " + alias), (Object[])new Object[0]);
            }
            cacheEntry.removeAlias(alias);
            this.entryHashtable.remove(alias);
            this.decreaseCacheSizeInBytes(80L, "ALIAS");
        }
        return cacheEntry;
    }

    @Override
    public synchronized Set getIdsByRangeDisk(int index, int length) {
        ValueSet ids = null;
        if (this.swapToDisk) {
            ids = this.diskCache.readCacheIdsByRange(index, length);
        }
        if (ids == null) {
            ids = new ValueSet(0);
        }
        return ids;
    }

    @Override
    public synchronized Set getDepIdsByRangeDisk(int index, int length) {
        ValueSet depids = null;
        if (this.swapToDisk) {
            depids = this.diskCache.readDependencyByRange(index, length);
        }
        if (depids == null) {
            depids = new ValueSet(0);
        }
        return depids;
    }

    @Override
    public synchronized Set getTemplatesByRangeDisk(int index, int length) {
        ValueSet templates = null;
        if (this.swapToDisk) {
            templates = this.diskCache.readTemplatesByRange(index, length);
        }
        if (templates == null) {
            templates = new ValueSet(0);
        }
        return templates;
    }

    @Override
    public synchronized com.ibm.websphere.cache.CacheEntry getEntryDisk(Object cacheId) {
        CacheEntry ce = null;
        if (this.swapToDisk) {
            ce = this.diskCache.readCacheEntry(cacheId);
        }
        return ce;
    }

    @Override
    public synchronized Set getCacheIdsByDependencyDisk(Object depId) {
        ValueSet ids = null;
        if (this.swapToDisk) {
            ids = this.diskCache.readDependency(depId, false);
        }
        if (ids == null) {
            ids = new ValueSet(0);
        }
        return ids;
    }

    @Override
    public synchronized Set getCacheIdsByTemplateDisk(String template) {
        ValueSet ids = null;
        if (this.swapToDisk) {
            ids = this.diskCache.readTemplate(template, false);
        }
        if (ids == null) {
            ids = new ValueSet(0);
        }
        return ids;
    }

    @Override
    public int getIdsSizeDisk() {
        if (this.swapToDisk) {
            int size = this.diskCache.getCacheIdsSize(true);
            return size > 0 ? size : 0;
        }
        return 0;
    }

    @Override
    public int getActualIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getCacheIdsSize(false);
        }
        return 0;
    }

    @Override
    public int getDepIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getDepIdsSize();
        }
        return 0;
    }

    @Override
    public int getTemplatesSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getTemplatesSize();
        }
        return 0;
    }

    @Override
    public int getPendingRemovalSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getPendingRemovalSize();
        }
        return 0;
    }

    @Override
    public int getDepIdsBufferedSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getDepIdsBufferedSize();
        }
        return 0;
    }

    @Override
    public int getTemplatesBufferedSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getTemplatesBufferedSize();
        }
        return 0;
    }

    @Override
    public long getCacheSizeInBytesDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getCacheSizeInBytes();
        }
        return 0L;
    }

    @Override
    public synchronized void clearDisk() {
        if (this.swapToDisk) {
            if (this.bEnableListener && this.eventSource.getPreInvalidationListenerCount() > 0 && !this.eventSource.shouldInvalidate("*", 1, 5)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("clearDisk() cacheName=" + this.cacheName + " skip clearing cache because PreInvalidationListener.shouldInvalidate() returns false."), (Object[])new Object[0]);
                }
                return;
            }
            this.diskCache.clearDiskCache();
            CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
            if (cachePerf != null && cachePerf.isPMIEnabled()) {
                cachePerf.onCacheClear(false, true);
            }
        }
    }

    @Override
    @Trivial
    public void invokeDiskCleanup(boolean scan) {
        if (this.swapToDisk) {
            this.diskCache.invokeDiskCleanup(scan);
        }
    }

    @Override
    public boolean isDiskCleanupRunning() {
        if (this.swapToDisk) {
            return this.diskCache.isCleanupRunning();
        }
        return false;
    }

    @Override
    @Trivial
    public boolean isDiskInvalidationBufferFull() {
        if (this.swapToDisk) {
            return this.diskCache.isInvalidationBuffersFull();
        }
        return false;
    }

    @Override
    public Exception getDiskCacheException() {
        return this.diskCache.getDiskCacheException();
    }

    @Override
    public float getDiskCacheSizeInMBs() {
        if (this.swapToDisk) {
            float size = (float)this.diskCache.getCacheSizeInBytes() / 1048576.0f;
            return size > 0.0f ? size : 0.0f;
        }
        return 0.0f;
    }

    @Override
    public void releaseDiskCacheUnusedPools() {
        if (this.swapToDisk && this.diskCache != null) {
            this.diskCache.releaseUnusedPools();
        }
    }

    @Override
    public int getPushPullTableSize() {
        return this.remoteServices.getPushPullTableSize();
    }

    @Override
    public List getCacheIdsInPushPullTable() {
        return this.remoteServices.getCacheIdsInPushPullTable();
    }

    @Override
    public void addToTimeLimitDaemon(Object id, long expirationTime, int inactivity) {
        this.timeLimitDaemon.valueHasChanged(this, id, expirationTime, inactivity);
    }

    @Override
    @Trivial
    public void refreshCachePerf() {
        CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
        if (cachePerf != null && cachePerf.isPMIEnabled()) {
            cachePerf.updateCacheSizes(this.cacheConfig.cacheSize, this.entryHashtable.size());
            if (this.swapToDisk && System.currentTimeMillis() - this.lastTimeForStatistics > 1000L) {
                cachePerf.updateDiskCacheStatistics(this.getActualIdsSizeDisk(), this.getPendingRemovalSizeDisk(), this.getDepIdsSizeDisk(), this.getDepIdsBufferedSizeDisk(), this.cacheStatisticsListener.getDepIdsOffloadedToDiskCount(), this.cacheStatisticsListener.getDepIdBasedInvalidationsFromDiskCount(), this.getTemplatesSizeDisk(), this.getTemplatesBufferedSizeDisk(), this.cacheStatisticsListener.getTemplatesOffloadedToDiskCount(), this.cacheStatisticsListener.getTemplateBasedInvalidationsFromDiskCount());
            }
        }
    }

    private void updatePeerCaches(CacheEntry cacheEntry) {
        String methodName = "updatePeerCaches()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatePeerCaches() Entry cacheName=" + this.cacheName + " isDRSReady=" + this.remoteServices.isDRSReady() + " id=" + cacheEntry.id + " refCount=" + cacheEntry.getRefCount()), (Object[])new Object[0]);
        }
        if (this.remoteServices.isDRSReady() && !this.cacheConfig.isDrsDisabled()) {
            this.batchUpdateDaemon.pushCacheEntry(cacheEntry, this);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updatePeerCaches() DRS is not ready!! - CE will be sent during bootstrap CE=" + cacheEntry), (Object[])new Object[0]);
            }
            cacheEntry.finish();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatePeerCaches() Exit cacheName=" + this.cacheName + " id=" + cacheEntry.id + " refCount=" + cacheEntry.getRefCount()), (Object[])new Object[0]);
        }
    }

    @Override
    public synchronized void setEnableDiskCacheSizeInBytesChecking(boolean enableDiskCacheSizeInBytesChecking) {
        this.enableDiskCacheSizeInBytesChecking = enableDiskCacheSizeInBytesChecking;
    }

    private void increaseCacheSizeInBytes(CacheEntry cacheEntry) {
        if (this.memoryCacheSizeInMBEnabled) {
            long size = cacheEntry.getObjectSize();
            if (size != -1L) {
                this.currentMemoryCacheSizeInBytes += (size += 64L);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("increaseCacheSizeInBytes() cacheName=" + this.cacheName + " id=" + cacheEntry.id + " size=" + size + " currentMemoryCacheSizeInBytes=" + this.currentMemoryCacheSizeInBytes), (Object[])new Object[0]);
                }
            } else {
                this.disableCacheSizeInMB();
            }
        }
    }

    private void decreaseCacheSizeInBytes(CacheEntry cacheEntry) {
        if (this.memoryCacheSizeInMBEnabled) {
            long size = cacheEntry.getObjectSize();
            if (size != -1L) {
                this.currentMemoryCacheSizeInBytes -= (size += 64L);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("decreaseCacheSizeInBytes() cacheName=" + this.cacheName + " id=" + cacheEntry.id + " size=" + size + " currentMemoryCacheSizeInBytes=" + this.currentMemoryCacheSizeInBytes), (Object[])new Object[0]);
                }
            } else {
                this.disableCacheSizeInMB();
            }
        }
    }

    public void pinLocal(Object key) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pinLocal", (Object[])new Object[]{key});
        }
        com.ibm.websphere.cache.CacheEntry ce = this.getEntry(key, 5, true, true);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pinLocal", (Object)ce);
        }
    }

    public void unpinLocal(Object key) {
        com.ibm.websphere.cache.CacheEntry ce;
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unpinLocal", (Object[])new Object[]{key});
        }
        if (null != (ce = this.getEntry(key, 5, true, false))) {
            ce.finish();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unpinLocal", (Object)key);
        }
    }

    public Map<Object, String> getRefCountLeakMap() {
        return this.refCountLeakMap;
    }

    public static final String extractStackTrace(CacheEntry ce) {
        StringBuffer stackTrace = new StringBuffer();
        if (null == ce.id) {
            stackTrace.append(" extractStackTrace: received  null id");
        } else {
            stackTrace.append("\n" + ce.id.toString() + " -->" + ce.getRefCount() + " pendingRemoval: " + ce.pendingRemoval + " removeWhenUnpinned: " + ce.removeWhenUnpinned + " age(seconds): " + (int)((System.currentTimeMillis() - ce.getTimeStamp()) / 1000L));
        }
        Throwable t = new Throwable();
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < 10 && i < ste.length; ++i) {
            stackTrace.append("\n" + ste[i].toString());
        }
        return stackTrace.toString();
    }

    public void lookForLeaks() {
        long now = System.currentTimeMillis();
        if (this.lastTimeCheck == 0L) {
            this.lastTimeCheck = now;
            return;
        }
        if (now - this.lastTimeCheck < leakDetectionInterval) {
            return;
        }
        this.lastTimeCheck = now;
        try {
            FileWriter outFile = new FileWriter(leakDetectionOutput, true);
            outFile.write("\n\n\n****  " + new Date() + "  ***\n");
            for (Map.Entry<Object, String> entry : this.refCountLeakMap.entrySet()) {
                outFile.write(entry.getValue());
                outFile.write("\n");
            }
            outFile.write("\n----------\n");
            outFile.close();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.Cache.lookForLeaks", (String)"3500", (Object)this);
        }
    }

    @Override
    public void clearMemory(boolean clearDisk) {
        CachePerf cachePerf;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + " clearDisk" + clearDisk), (Object[])new Object[0]);
        }
        if (this.swapToDisk && !clearDisk) {
            this.flushToDisk();
        } else if (clearDisk) {
            this.diskCache.clearDiskCache();
            this.diskCache.clearInvalidationBuffers();
        }
        Enumeration e = this.entryHashtable.keys();
        while (e.hasMoreElements()) {
            Object id = e.nextElement();
            this.internalInvalidateById(id, 1, 5, false);
        }
        if (this.bEnableListener) {
            InvalidationEvent ie = new InvalidationEvent("*", null, 5, 1, this.cacheName);
            this.eventSource.fireEvent(ie);
        }
        this.timeLimitDaemon.cacheCleared(this);
        this.invalidationAuditDaemon.cacheCleared(this.cacheName);
        if (this.isCacheSizeInMBEnabled()) {
            this.currentMemoryCacheSizeInBytes = 0L;
            this.increaseCacheSizeInBytes(40L + 28L * (long)this.cacheConfig.cacheSize, "EHT");
        }
        if ((cachePerf = (CachePerf)this.cachePerfRef.get()) != null && cachePerf.isPMIEnabled()) {
            cachePerf.onCacheClear(true, this.swapToDisk);
        }
    }

    @Override
    public void resetPMICounters() {
        CachePerf cachePerf = (CachePerf)this.cachePerfRef.get();
        if (cachePerf != null) {
            cachePerf.resetPMICounters();
        }
    }

    public class LruToDiskResult {
        public int result = 0;
        public boolean entryOverwritten = false;

        public String toString() {
            return "LruToDiskResult [entryOverwritten=" + this.entryOverwritten + ", result=" + this.result + "]";
        }
    }
}

