/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.subsystem.AriesSubsystem;
import org.apache.aries.subsystem.core.capabilityset.CapabilitySetRepository;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleRevisionResource;
import org.apache.aries.subsystem.core.internal.ThreadLocalBundleRevision;
import org.apache.aries.subsystem.core.internal.ThreadLocalSubsystem;
import org.apache.aries.subsystem.core.repository.Repository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SystemRepository
implements Repository,
BundleTrackerCustomizer<AtomicReference<BundleRevisionResource>>,
ServiceTrackerCustomizer<AriesSubsystem, BasicSubsystem> {
    private final BundleContext bundleContext;
    private final CapabilitySetRepository repository;

    public SystemRepository(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.repository = new CapabilitySetRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicReference<BundleRevisionResource> addingBundle(Bundle bundle, BundleEvent event) {
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        BundleRevisionResource resource = new BundleRevisionResource(revision);
        if (ThreadLocalSubsystem.get() == null) {
            ThreadLocalBundleRevision.set(revision);
            try {
                this.repository.addResource(resource);
            }
            finally {
                ThreadLocalBundleRevision.remove();
            }
        } else {
            this.repository.addResource(resource);
        }
        return new AtomicReference<BundleRevisionResource>(resource);
    }

    public BasicSubsystem addingService(ServiceReference<AriesSubsystem> reference) {
        BasicSubsystem subsystem = (BasicSubsystem)this.bundleContext.getService(reference);
        this.repository.addResource(subsystem);
        return subsystem;
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return this.repository.findProviders(requirements);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, AtomicReference<BundleRevisionResource> object) {
        if (8 == event.getType()) {
            BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            BundleRevisionResource resource = new BundleRevisionResource(revision);
            this.repository.removeResource(object.getAndSet(resource));
            this.repository.addResource(resource);
        }
    }

    public void modifiedService(ServiceReference<AriesSubsystem> reference, BasicSubsystem service) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, AtomicReference<BundleRevisionResource> object) {
        this.repository.removeResource(object.get());
    }

    public void removedService(ServiceReference<AriesSubsystem> reference, BasicSubsystem service) {
        this.repository.removeResource(service);
    }
}

