/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.archive.ExportPackageCapability;
import org.apache.aries.subsystem.core.archive.ExportPackageHeader;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityCapability;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceCapability;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceHeader;
import org.apache.aries.subsystem.core.internal.AbstractAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.CustomResources;
import org.apache.aries.subsystem.core.internal.InstallDependencies;
import org.apache.aries.subsystem.core.internal.LockingStrategy;
import org.apache.aries.subsystem.core.internal.RegionUpdater;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.StartResourceComparator;
import org.apache.aries.subsystem.core.internal.StopAction;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.apache.aries.subsystem.core.internal.Utils;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(StartAction.class);
    private final Coordination coordination;
    private final BasicSubsystem instigator;
    private final Restriction restriction;

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target) {
        this(instigator, requestor, target, Restriction.NONE);
    }

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target, Restriction restriction) {
        this(instigator, requestor, target, null, restriction);
    }

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target, Coordination coordination) {
        this(instigator, requestor, target, coordination, Restriction.NONE);
    }

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target, Coordination coordination, Restriction restriction) {
        super(requestor, target, false);
        this.instigator = instigator;
        this.coordination = coordination;
        this.restriction = restriction;
    }

    private static boolean isTargetStartable(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target) {
        Subsystem.State state = target.getState();
        if (EnumSet.of(Subsystem.State.INSTALL_FAILED, Subsystem.State.UNINSTALLED).contains(state)) {
            throw new SubsystemException("Cannot start from state " + state);
        }
        if (Subsystem.State.ACTIVE.equals((Object)state)) {
            return false;
        }
        return Utils.isContent(requestor, target) || Utils.isDependency(requestor, target) || instigator.equals(target) || !instigator.isRoot() || target.isReadyToStart();
    }

    private void installDependencies(BasicSubsystem target, Coordination coordination) throws Exception {
        for (Subsystem parent : target.getParents()) {
            AccessController.doPrivileged(new StartAction(this.instigator, target, (BasicSubsystem)parent, coordination, Restriction.INSTALL_ONLY));
        }
        StartAction.installDependencies(Collections.singletonList(target), coordination);
        for (Subsystem child : Activator.getInstance().getSubsystems().getChildren(target)) {
            AccessController.doPrivileged(new StartAction(this.instigator, target, (BasicSubsystem)child, coordination, Restriction.INSTALL_ONLY));
        }
    }

    private static void installDependencies(Collection<Subsystem> subsystems, Coordination coordination) throws Exception {
        for (Subsystem subsystem : subsystems) {
            if (!Subsystem.State.INSTALLING.equals((Object)subsystem.getState())) continue;
            BasicSubsystem bs = (BasicSubsystem)subsystem;
            bs.computeDependenciesPostInstallation(coordination);
            new InstallDependencies().install(bs, null, coordination);
            bs.setState(Subsystem.State.INSTALLED);
        }
    }

    private Coordination createCoordination() {
        Coordination coordination = this.coordination;
        if (coordination == null) {
            coordination = Utils.createCoordination(this.target);
        }
        return coordination;
    }

    private static AffectedResources computeAffectedResources(BasicSubsystem target) {
        return new AffectedResources(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object run() {
        if (!LockingStrategy.set(Subsystem.State.STARTING, this.target)) {
            return null;
        }
        try {
            AffectedResources affectedResources;
            Coordination c;
            if (Subsystem.State.INSTALLING.equals((Object)this.target.getState()) && !Utils.isProvisionDependenciesInstall(this.target)) {
                LockingStrategy.writeLock();
                try {
                    c = Utils.createCoordination(this.target);
                    try {
                        this.installDependencies(this.target, c);
                        affectedResources = StartAction.computeAffectedResources(this.target);
                        for (BasicSubsystem subsystem : affectedResources.subsystems()) {
                            if (!Subsystem.State.INSTALLING.equals((Object)subsystem.getState()) || Utils.isProvisionDependenciesInstall(subsystem)) continue;
                            this.installDependencies(subsystem, c);
                        }
                        LockingStrategy.readLock();
                    }
                    catch (Throwable t) {
                        try {
                            c.fail(t);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            c.end();
                        }
                    }
                    c.end();
                }
                finally {
                    LockingStrategy.writeUnlock();
                }
            } else {
                LockingStrategy.readLock();
            }
            try {
                if (Restriction.INSTALL_ONLY.equals((Object)this.restriction)) {
                    c = null;
                    return c;
                }
                affectedResources = StartAction.computeAffectedResources(this.target);
                LockingStrategy.lock();
                try {
                    LockingStrategy.lock(affectedResources.subsystems());
                }
                finally {
                    LockingStrategy.unlock();
                }
                Coordination coordination = this.coordination;
                try {
                    Object t;
                    coordination = this.createCoordination();
                    if (!StartAction.isTargetStartable(this.instigator, this.requestor, this.target)) {
                        t = null;
                        return t;
                    }
                    if (Subsystem.State.INSTALLED.equals((Object)this.target.getState())) {
                        StartAction.resolve(this.instigator, this.target, this.target, coordination, affectedResources.subsystems());
                    }
                    if (Restriction.RESOLVE_ONLY.equals((Object)this.restriction)) {
                        t = null;
                        return t;
                    }
                    this.target.setState(Subsystem.State.STARTING);
                    coordination.addParticipant(new Participant(){

                        public void ended(Coordination coordination) throws Exception {
                        }

                        public void failed(Coordination coordination) throws Exception {
                            StartAction.this.target.setState(Subsystem.State.RESOLVED);
                        }
                    });
                    SubsystemContentHeader header = this.target.getSubsystemManifest().getSubsystemContentHeader();
                    if (header != null) {
                        Collections.sort(affectedResources.resources(), new StartResourceComparator(header));
                    }
                    for (Resource resource : affectedResources.resources()) {
                        this.startResource(resource, coordination);
                    }
                    this.target.setState(Subsystem.State.ACTIVE);
                    return null;
                }
                catch (Throwable t) {
                    coordination.fail(t);
                    return null;
                }
                finally {
                    try {
                        if (coordination.getName().equals(Utils.computeCoordinationName((Subsystem)this.target))) {
                            coordination.end();
                        }
                    }
                    finally {
                        LockingStrategy.unlock(affectedResources.subsystems());
                    }
                }
            }
            finally {
                LockingStrategy.readUnlock();
            }
        }
        catch (CoordinationException e) {
            Throwable t = e.getCause();
            if (t == null) {
                throw new SubsystemException((Throwable)e);
            }
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (!(t instanceof SubsystemException)) throw new SubsystemException(t);
            throw (SubsystemException)t;
        }
        finally {
            LockingStrategy.unset(Subsystem.State.STARTING, this.target);
        }
    }

    private static Collection<Bundle> getBundles(BasicSubsystem subsystem) {
        Collection<Resource> constituents = Activator.getInstance().getSubsystems().getConstituents(subsystem);
        ArrayList<Bundle> result = new ArrayList<Bundle>(constituents.size());
        for (Resource resource : constituents) {
            if (!(resource instanceof BundleRevision)) continue;
            result.add(((BundleRevision)resource).getBundle());
        }
        result.trimToSize();
        return result;
    }

    private static void emitResolvingEvent(BasicSubsystem subsystem) {
        if (Subsystem.State.INSTALLED.equals((Object)subsystem.getState())) {
            subsystem.setState(Subsystem.State.RESOLVING);
        }
    }

    private static void emitResolvedEvent(BasicSubsystem subsystem) {
        if (Subsystem.State.RESOLVING.equals((Object)subsystem.getState())) {
            subsystem.setState(Subsystem.State.RESOLVED);
        }
    }

    private static void resolveSubsystems(BasicSubsystem instigator, BasicSubsystem target, Coordination coordination, Collection<BasicSubsystem> subsystems) throws Exception {
        for (BasicSubsystem subsystem : subsystems) {
            StartAction.resolveSubsystem(instigator, target, subsystem, coordination);
        }
    }

    private static void resolveSubsystem(BasicSubsystem instigator, BasicSubsystem target, BasicSubsystem subsystem, Coordination coordination) throws Exception {
        Subsystem.State state = subsystem.getState();
        if (Subsystem.State.INSTALLED.equals((Object)state)) {
            if (target.equals(subsystem)) {
                StartAction.resolve(instigator, target, subsystem, coordination, Collections.<BasicSubsystem>emptyList());
            } else {
                AccessController.doPrivileged(new StartAction(instigator, target, subsystem, coordination, Restriction.RESOLVE_ONLY));
            }
        }
    }

    private static void resolveBundles(BasicSubsystem subsystem) {
        Collection<Bundle> bundles;
        FrameworkWiring frameworkWiring = (FrameworkWiring)Activator.getInstance().getBundleContext().getBundle(0L).adapt(FrameworkWiring.class);
        if (!frameworkWiring.resolveBundles(bundles = StartAction.getBundles(subsystem))) {
            StartAction.handleFailedResolution(subsystem, bundles, frameworkWiring);
        }
    }

    private static void resolve(BasicSubsystem instigator, BasicSubsystem target, BasicSubsystem subsystem, Coordination coordination, Collection<BasicSubsystem> subsystems) {
        StartAction.emitResolvingEvent(subsystem);
        try {
            if (!subsystem.isRoot()) {
                StartAction.setExportIsolationPolicy(subsystem, coordination);
                StartAction.resolveSubsystems(instigator, target, coordination, subsystems);
                StartAction.resolveBundles(subsystem);
            }
            StartAction.emitResolvedEvent(subsystem);
        }
        catch (Throwable t) {
            subsystem.setState(Subsystem.State.INSTALLED);
            if (t instanceof SubsystemException) {
                throw (SubsystemException)t;
            }
            throw new SubsystemException(t);
        }
    }

    private static void setExportIsolationPolicy(final BasicSubsystem subsystem, Coordination coordination) throws InvalidSyntaxException {
        if (!subsystem.isComposite()) {
            return;
        }
        final Region from = ((BasicSubsystem)subsystem.getParents().iterator().next()).getRegion();
        final Region to = subsystem.getRegion();
        RegionFilterBuilder builder = from.getRegionDigraph().createRegionFilterBuilder();
        StartAction.setExportIsolationPolicy(builder, subsystem.getDeploymentManifest().getExportPackageHeader(), subsystem);
        StartAction.setExportIsolationPolicy(builder, subsystem.getDeploymentManifest().getProvideCapabilityHeader(), subsystem);
        StartAction.setExportIsolationPolicy(builder, subsystem.getDeploymentManifest().getSubsystemExportServiceHeader(), subsystem);
        RegionFilter regionFilter = builder.build();
        if (regionFilter.getSharingPolicy().isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Establishing region connection: from=" + from + ", to=" + to + ", filter=" + regionFilter);
        }
        try {
            from.connectRegion(to, regionFilter);
        }
        catch (BundleException e) {
            return;
        }
        coordination.addParticipant(new Participant(){

            public void ended(Coordination coordination) throws Exception {
                this.unsetExportIsolationPolicyIfNecessary();
            }

            public void failed(Coordination coordination) throws Exception {
            }

            private void unsetExportIsolationPolicyIfNecessary() throws BundleException, InvalidSyntaxException {
                if (!EnumSet.of(Subsystem.State.INSTALLING, Subsystem.State.INSTALLED).contains(subsystem.getState())) {
                    return;
                }
                RegionUpdater updater = new RegionUpdater(from, to);
                updater.addRequirements(null);
            }
        });
    }

    private static void setExportIsolationPolicy(RegionFilterBuilder builder, ExportPackageHeader header, BasicSubsystem subsystem) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        String policy = "osgi.wiring.package";
        for (ExportPackageCapability capability : header.toCapabilities(subsystem)) {
            StringBuilder filter = new StringBuilder("(&");
            for (Map.Entry<String, Object> attribute : capability.getAttributes().entrySet()) {
                filter.append('(').append(attribute.getKey()).append('=').append(attribute.getValue()).append(')');
            }
            filter.append(')');
            if (logger.isDebugEnabled()) {
                logger.debug("Allowing " + policy + " of " + filter);
            }
            builder.allow(policy, filter.toString());
        }
    }

    private static void setExportIsolationPolicy(RegionFilterBuilder builder, ProvideCapabilityHeader header, BasicSubsystem subsystem) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (ProvideCapabilityHeader.Clause clause : header.getClauses()) {
            ProvideCapabilityCapability capability = new ProvideCapabilityCapability(clause, subsystem);
            String policy = capability.getNamespace();
            Set<Map.Entry<String, Object>> entrySet = capability.getAttributes().entrySet();
            StringBuilder filter = new StringBuilder();
            if (entrySet.size() > 1) {
                filter.append("(&");
            }
            for (Map.Entry<String, Object> attribute : capability.getAttributes().entrySet()) {
                filter.append('(').append(attribute.getKey()).append('=').append(attribute.getValue()).append(')');
            }
            if (entrySet.size() > 1) {
                filter.append(')');
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Allowing policy {} with filter {}", (Object)policy, (Object)filter);
            }
            if (filter.length() == 0) {
                builder.allowAll(policy);
                continue;
            }
            builder.allow(policy, filter.toString());
        }
    }

    private static void setExportIsolationPolicy(RegionFilterBuilder builder, SubsystemExportServiceHeader header, BasicSubsystem subsystem) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        String policy = "org.eclipse.equinox.allow.service";
        for (SubsystemExportServiceHeader.Clause clause : header.getClauses()) {
            SubsystemExportServiceCapability capability = new SubsystemExportServiceCapability(clause, subsystem);
            String filter = capability.getDirectives().get("filter");
            if (logger.isDebugEnabled()) {
                logger.debug("Allowing " + policy + " of " + filter);
            }
            builder.allow(policy, filter);
        }
    }

    private void startBundleResource(Resource resource, Coordination coordination) throws BundleException {
        if (this.target.isRoot()) {
            return;
        }
        if (Utils.isRegionContextBundle(resource)) {
            return;
        }
        final Bundle bundle = ((BundleRevision)resource).getBundle();
        if ((bundle.getState() & 0x28) != 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            int bundleStartLevel = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            Bundle systemBundle = Activator.getInstance().getBundleContext().getBundle(0L);
            int fwStartLevel = ((FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class)).getStartLevel();
            logger.debug("StartAction: starting bundle " + bundle.getSymbolicName() + " " + bundle.getVersion().toString() + " bundleStartLevel=" + bundleStartLevel + " frameworkStartLevel=" + fwStartLevel);
        }
        bundle.start(3);
        if (logger.isDebugEnabled()) {
            logger.debug("StartAction: bundle " + bundle.getSymbolicName() + " " + bundle.getVersion().toString() + " started correctly");
        }
        if (coordination == null) {
            return;
        }
        coordination.addParticipant(new Participant(){

            public void ended(Coordination coordination) throws Exception {
            }

            public void failed(Coordination coordination) throws Exception {
                bundle.stop();
            }
        });
    }

    private void startResource(Resource resource, Coordination coordination) throws BundleException, IOException {
        String type = ResourceHelper.getTypeAttribute(resource);
        if ("osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type)) {
            this.startSubsystemResource(resource, coordination);
        } else if ("osgi.bundle".equals(type)) {
            this.startBundleResource(resource, coordination);
        } else if (!"osgi.fragment".equals(type) && !this.startCustomHandler(resource, type, coordination)) {
            throw new SubsystemException("Unsupported resource type: " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCustomHandler(Resource resource, String type, Coordination coordination) {
        ContentHandler customHandler;
        ServiceReference<ContentHandler> customHandlerRef = CustomResources.getCustomContentHandler(this.target, type);
        if (customHandlerRef != null && (customHandler = (ContentHandler)this.target.getBundleContext().getService(customHandlerRef)) != null) {
            try {
                customHandler.start(ResourceHelper.getSymbolicNameAttribute(resource), type, (Subsystem)this.target, coordination);
                boolean bl = true;
                return bl;
            }
            finally {
                this.target.getBundleContext().ungetService(customHandlerRef);
            }
        }
        return false;
    }

    private void startSubsystemResource(Resource resource, Coordination coordination) throws IOException {
        final BasicSubsystem subsystem = (BasicSubsystem)resource;
        if (!StartAction.isTargetStartable(this.instigator, this.target, subsystem)) {
            return;
        }
        if (Utils.isContent(this.target, subsystem)) {
            subsystem.setAutostart(true);
        }
        new StartAction(this.instigator, this.target, subsystem, coordination).run();
        if (coordination == null) {
            return;
        }
        coordination.addParticipant(new Participant(){

            public void ended(Coordination coordination) throws Exception {
            }

            public void failed(Coordination coordination) throws Exception {
                new StopAction(StartAction.this.target, subsystem, !subsystem.isRoot()).run();
            }
        });
    }

    private static void handleFailedResolution(BasicSubsystem subsystem, Collection<Bundle> bundles, FrameworkWiring wiring) {
        StartAction.logFailedResolution(subsystem, bundles);
        throw new SubsystemException("Framework could not resolve the bundles: " + bundles);
    }

    private static void logFailedResolution(BasicSubsystem subsystem, Collection<Bundle> bundles) {
        ArrayList<Bundle> unresolved = new ArrayList<Bundle>();
        StringBuilder diagnostics = new StringBuilder();
        diagnostics.append(String.format("Unable to resolve bundles for subsystem/version/id %s/%s/%s:\n", subsystem.getSymbolicName(), subsystem.getVersion(), subsystem.getSubsystemId()));
        String fmt = "%d : STATE %s : %s : %s : %s";
        for (Bundle bundle : bundles) {
            if ((bundle.getState() & 4) != 4) {
                unresolved.add(bundle);
            }
            String state = null;
            switch (bundle.getState()) {
                case 32: {
                    state = "ACTIVE";
                    break;
                }
                case 2: {
                    state = "INSTALLED";
                    break;
                }
                case 4: {
                    state = "RESOLVED";
                    break;
                }
                case 8: {
                    state = "STARTING";
                    break;
                }
                case 16: {
                    state = "STOPPING";
                    break;
                }
                case 1: {
                    state = "UNINSTALLED";
                    break;
                }
                default: {
                    state = "[" + Integer.toString(bundle.getState()) + "]";
                }
            }
            diagnostics.append(String.format(fmt, bundle.getBundleId(), state, bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getLocation()));
            diagnostics.append("\n");
        }
        logger.error(diagnostics.toString());
    }

    static void setExportPolicyOfAllInstallingSubsystemsWithProvisionDependenciesResolve(Coordination coordination) throws InvalidSyntaxException {
        for (BasicSubsystem subsystem : Activator.getInstance().getSubsystems().getSubsystems()) {
            if (!Subsystem.State.INSTALLING.equals((Object)subsystem.getState()) || Utils.isProvisionDependenciesInstall(subsystem)) continue;
            StartAction.setExportIsolationPolicy(subsystem, coordination);
        }
    }

    private static class AffectedResources {
        private final List<Resource> resources;
        private final Collection<BasicSubsystem> subsystemResources;

        AffectedResources(BasicSubsystem target) {
            LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
            LinkedHashSet<BasicSubsystem> subsystemResources = new LinkedHashSet<BasicSubsystem>();
            Subsystems subsystems = Activator.getInstance().getSubsystems();
            for (Resource dep : subsystems.getResourcesReferencedBy(target)) {
                if (dep instanceof BasicSubsystem && !subsystems.getChildren(target).contains(dep)) {
                    subsystemResources.add((BasicSubsystem)dep);
                } else if (dep instanceof BundleRevision) {
                    BundleResourceInstaller.BundleConstituent constituent = new BundleResourceInstaller.BundleConstituent(null, (BundleRevision)dep);
                    if (!target.getConstituents().contains(constituent)) {
                        for (BasicSubsystem constituentOf : subsystems.getSubsystemsByConstituent((Resource)new BundleResourceInstaller.BundleConstituent(null, (BundleRevision)dep))) {
                            subsystemResources.add(constituentOf);
                        }
                    }
                }
                resources.add(dep);
            }
            for (Subsystem child : subsystems.getChildren(target)) {
                subsystemResources.add((BasicSubsystem)child);
                resources.add((BasicSubsystem)child);
            }
            for (Resource resource : target.getResource().getSharedContent()) {
                for (BasicSubsystem constituentOf : subsystems.getSubsystemsByConstituent((Resource)(resource instanceof BundleRevision ? new BundleResourceInstaller.BundleConstituent(null, (BundleRevision)resource) : resource))) {
                    subsystemResources.add(constituentOf);
                }
                resources.add(resource);
            }
            subsystemResources.add(target);
            this.resources = new ArrayList<Resource>(resources);
            this.subsystemResources = subsystemResources;
        }

        List<Resource> resources() {
            return this.resources;
        }

        Collection<BasicSubsystem> subsystems() {
            return this.subsystemResources;
        }
    }

    public static enum Restriction {
        NONE,
        INSTALL_ONLY,
        RESOLVE_ONLY;

    }
}

