/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.BundleManifest;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.archive.SymbolicNameHeader;
import org.apache.aries.subsystem.core.archive.VersionHeader;
import org.apache.aries.subsystem.core.internal.AbstractCapability;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class OsgiIdentityCapability
extends AbstractCapability {
    private final Map<String, Object> attributes;
    private final Resource resource;

    public OsgiIdentityCapability(Resource resource, String symbolicName) {
        this(resource, symbolicName, Version.emptyVersion);
    }

    public OsgiIdentityCapability(Resource resource, String symbolicName, Version version) {
        this(resource, symbolicName, version, "osgi.bundle");
    }

    public OsgiIdentityCapability(Resource resource, String symbolicName, Version version, String identityType) {
        this(resource, symbolicName, version, identityType, new HashMap<String, Object>());
    }

    public OsgiIdentityCapability(Resource resource, String symbolicName, Version version, String identityType, Map<String, Object> attrs) {
        this.resource = resource;
        this.attributes = attrs;
        this.attributes.put("osgi.identity", symbolicName);
        this.attributes.put("version", version);
        this.attributes.put("type", identityType);
    }

    public OsgiIdentityCapability(Resource resource, SubsystemManifest manifest) {
        this(resource, manifest.getSubsystemSymbolicNameHeader().getSymbolicName(), manifest.getSubsystemVersionHeader().getVersion(), manifest.getSubsystemTypeHeader().getType());
    }

    public OsgiIdentityCapability(Resource resource, BundleManifest manifest) {
        this(resource, ((SymbolicNameHeader)manifest.getHeader("Bundle-SymbolicName")).getSymbolicName(), ((VersionHeader)manifest.getHeader("Bundle-Version")).getVersion(), manifest.getHeader("Fragment-Host") == null ? "osgi.bundle" : "osgi.fragment");
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Map<String, String> getDirectives() {
        return Collections.emptyMap();
    }

    public String getNamespace() {
        return "osgi.identity";
    }

    public Resource getResource() {
        return this.resource;
    }
}

