/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.aries.subsystem.core.archive.AbstractAttribute;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.osgi.framework.Version;

public class TypedAttribute
extends AbstractAttribute {
    private static final String DOUBLE = "Double";
    private static final String LIST = "List";
    private static final String LIST_DOUBLE = "List<Double>";
    private static final String LIST_LONG = "List<Long>";
    private static final String LIST_STRING = "List<String>";
    private static final String LIST_VERSION = "List<Version>";
    private static final String LONG = "Long";
    private static final String STRING = "String";
    private static final String VERSION = "Version";
    private final String type;

    private static Object parseScalar(String value, String type) {
        if (STRING.equals(type)) {
            return value;
        }
        if (VERSION.equals(type)) {
            return Version.parseVersion((String)value);
        }
        if (LONG.equals(type)) {
            return Long.valueOf(value);
        }
        if (DOUBLE.equals(type)) {
            return Double.valueOf(value);
        }
        return null;
    }

    private static Object parseList(String value, String type) {
        String scalar;
        if (!type.startsWith(LIST)) {
            return null;
        }
        if (type.length() == LIST.length()) {
            scalar = STRING;
        } else {
            Matcher matcher = Patterns.SCALAR_LIST.matcher(type);
            if (!matcher.matches()) {
                return null;
            }
            scalar = matcher.group(1);
        }
        String[] values = value.split(",");
        ArrayList<Object> result = new ArrayList<Object>(values.length);
        for (String s : values) {
            result.add(TypedAttribute.parseScalar(s, scalar));
        }
        return result;
    }

    private static Object parseValue(String value, String type) {
        if (type == null) {
            return value;
        }
        Object result = TypedAttribute.parseScalar(value, type);
        if (result == null) {
            result = TypedAttribute.parseList(value, type);
        }
        return result;
    }

    public TypedAttribute(String name, String value, String type) {
        super(name, TypedAttribute.parseValue(value, type));
        this.type = type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypedAttribute(String name, Object value) {
        super(name, value);
        if (value instanceof String) {
            this.type = STRING;
            return;
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                this.type = LIST;
                return;
            } else {
                Object o = list.get(0);
                if (o instanceof String) {
                    this.type = LIST_STRING;
                    return;
                } else if (o instanceof Version) {
                    this.type = LIST_VERSION;
                    return;
                } else if (o instanceof Long) {
                    this.type = LIST_LONG;
                    return;
                } else {
                    if (!(o instanceof Double)) throw new IllegalArgumentException(name + '=' + value);
                    this.type = LIST_DOUBLE;
                }
            }
            return;
        } else if (value instanceof Version) {
            this.type = VERSION;
            return;
        } else if (value instanceof Long) {
            this.type = LONG;
            return;
        } else {
            if (!(value instanceof Double)) throw new IllegalArgumentException(name + '=' + value);
            this.type = DOUBLE;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getName()).append(':').append(this.type).append("=\"");
        if (this.type.startsWith(LIST)) {
            List list = (List)this.getValue();
            if (!list.isEmpty()) {
                builder.append(list.get(0));
            }
            for (int i = 1; i < list.size(); ++i) {
                builder.append(',').append(list.get(i));
            }
        } else {
            builder.append(this.getValue());
        }
        return builder.append('\"').toString();
    }
}

