/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.aries.subsystem.core.archive.Clause;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.capabilityset.SimpleFilter;
import org.osgi.framework.VersionRange;

public abstract class AbstractClauseBasedHeader<C extends Clause>
implements Header<C> {
    protected final Set<C> clauses;

    protected static VersionRange parseVersionRange(List<SimpleFilter> filters) {
        SimpleFilter floor = null;
        SimpleFilter ceiling = null;
        block10: for (SimpleFilter filter : filters) {
            switch (filter.getOperation()) {
                case 4: 
                case 6: {
                    floor = filter;
                    continue block10;
                }
                case 5: {
                    ceiling = filter;
                    continue block10;
                }
                case 3: {
                    SimpleFilter negated = (SimpleFilter)((List)filter.getValue()).get(0);
                    switch (negated.getOperation()) {
                        case 4: 
                        case 6: {
                            ceiling = filter;
                            continue block10;
                        }
                        case 5: {
                            floor = filter;
                            continue block10;
                        }
                    }
                    throw new IllegalArgumentException("Invalid filter: " + filter);
                }
                case 8: {
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
        if (ceiling == null) {
            return new VersionRange(String.valueOf(floor.getValue()));
        }
        String range = "" + (floor.getOperation() == 3 ? (char)'(' : '[') + (floor.getOperation() == 3 ? ((SimpleFilter)((List)floor.getValue()).get(0)).getValue() : floor.getValue()) + ',' + (ceiling.getOperation() == 3 ? ((SimpleFilter)((List)ceiling.getValue()).get(0)).getValue() : ceiling.getValue()) + (ceiling.getOperation() == 3 ? (char)')' : ']');
        return new VersionRange(range);
    }

    private static <C> Collection<C> computeClauses(String header, ClauseFactory<C> factory) {
        Collection<String> clauseStrs = new ClauseTokenizer(header).getClauses();
        HashSet<C> clauses = new HashSet<C>(clauseStrs.size());
        for (String clause : clauseStrs) {
            clauses.add(factory.newInstance(clause));
        }
        return clauses;
    }

    public AbstractClauseBasedHeader(Collection<C> clauses) {
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("No clauses");
        }
        this.clauses = Collections.synchronizedSet(new HashSet<C>(clauses));
    }

    public AbstractClauseBasedHeader(String header, ClauseFactory<C> factory) {
        this(AbstractClauseBasedHeader.computeClauses(header, factory));
    }

    @Override
    public final Collection<C> getClauses() {
        return Collections.unmodifiableCollection(this.clauses);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + ((Object)this.clauses).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractClauseBasedHeader)) {
            return false;
        }
        AbstractClauseBasedHeader that = (AbstractClauseBasedHeader)o;
        return that.getName().equals(this.getName()) && ((Object)that.clauses).equals(this.clauses);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static interface ClauseFactory<C> {
        public C newInstance(String var1);
    }
}

