/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipUtils {
    private static final TraceComponent tc = Tr.register(ZipUtils.class);
    private static final String WAR_EXTENSION = ".war";
    static final long serialVersionUID = -7574063014509395349L;

    public void recursiveDelete(File f) throws IOException {
        File[] subFiles = f.listFiles();
        if (subFiles != null) {
            for (File c : subFiles) {
                this.recursiveDelete(c);
            }
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete file " + f.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(File sourceZip, File targetDir) throws ZipException, IOException {
        if (!sourceZip.exists() || !targetDir.exists()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unzipping file: " + sourceZip), (Object[])new Object[0]);
        }
        ArrayList<File> warFiles = new ArrayList<File>();
        ZipFile zf = new ZipFile(sourceZip);
        try {
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String fileName = ze.getName();
                if (fileName.endsWith(WAR_EXTENSION)) {
                    File warFile = new File(targetDir, fileName);
                    warFiles.add(warFile);
                    fileName = fileName + ".tmp";
                }
                File targetFile = new File(targetDir, fileName);
                if (ze.isDirectory()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Creating directory: " + targetFile), (Object[])new Object[0]);
                    }
                    if (targetFile.exists() || targetFile.mkdirs()) continue;
                    throw new IOException("Could not create directory " + targetFile.getAbsolutePath());
                }
                if (!targetFile.getParentFile().mkdirs() && !targetFile.getParentFile().exists()) {
                    throw new IOException("Could not create directory " + targetFile.getParentFile().getAbsolutePath());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unzipping: " + ze.getName() + " (" + ze.getSize() + " bytes) into " + targetFile), (Object[])new Object[0]);
                }
                byte[] buffer = new byte[2048];
                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try {
                    int size;
                    bis = new BufferedInputStream(zf.getInputStream(ze));
                    bos = new BufferedOutputStream(new FileOutputStream(targetFile), buffer.length);
                    while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                        bos.write(buffer, 0, size);
                    }
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (bos == null) continue;
                    bos.flush();
                    bos.close();
                }
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
        }
        for (File warDirectory : warFiles) {
            if (!warDirectory.exists() && !warDirectory.mkdirs()) {
                throw new IOException("Could not create directory " + warDirectory.getAbsolutePath());
            }
            File warFile = new File(warDirectory.getParentFile(), warDirectory.getName() + ".tmp");
            this.unzip(warFile, warDirectory);
            if (warFile.delete() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Could not delete temporary war file during expansion", (Object[])new Object[0]);
        }
    }
}

