/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.ear.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppMBeanRuntime;
import com.ibm.ws.app.manager.module.internal.ContextRootUtil;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.DeployedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.container.service.annotations.ContainerAnnotations;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ClientModuleInfo;
import com.ibm.ws.container.service.app.deploy.ConnectorModuleInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.EJBModuleInfo;
import com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.AppClassLoaderFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.app.Module;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.application.handler.DefaultApplicationMonitoringInformation;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EARDeployedAppInfo
extends DeployedAppInfoBase {
    private static final TraceComponent _tc = Tr.register(EARDeployedAppInfo.class);
    private final ModuleHandler webModuleHandler;
    private final ModuleHandler ejbModuleHandler;
    private final ModuleHandler clientModuleHandler;
    private final ModuleHandler connectorModuleHandler;
    private final Map<String, ModuleMetaDataExtender> moduleMetaDataExtenders;
    private final DeployedAppMBeanRuntime appMBeanRuntime;
    private final Application applicationDD;
    private final String preferredName;
    private final EARLibDeploymentInfo earLibDeploymentInfo;
    private final ClassLoaderIdentity appClassLoaderId;
    private final boolean altDDSupportEnabled;
    private List<ContainerInfo> classpathContainerInfos;
    private ClassLoader appClassLoader;
    private ProtectionDomain protectionDomain;
    private ServiceRegistration<?> mbeanServiceReg;
    private static final String CONTEXT_ROOT = "context-root";
    private static final String DEFAULT_CLIENT_MODULE = "defaultClientModule";
    boolean initializeInOrder;
    private int connectorModuleCount;
    private int ejbModuleCount;
    private final String defaultClientModule;
    private static final List<String> EJB_ANNOTATIONS = new ArrayList<String>();
    private static final List<String> DYNAMIC_IMPORT_PACKAGE_LIST;
    static final long serialVersionUID = 8380472115166177604L;

    EARDeployedAppInfo(ApplicationInformation<DeployedAppInfo> applicationInformation, Application applicationDD, EARDeployedAppInfoFactoryImpl factory) throws UnableToAdaptException {
        super(applicationInformation, (DeployedAppInfoFactoryBase)factory);
        String appName;
        this.webModuleHandler = factory.webModuleHandler;
        this.ejbModuleHandler = factory.ejbModuleHandler;
        this.clientModuleHandler = factory.clientModuleHandler;
        this.connectorModuleHandler = factory.connectorModuleHandler;
        this.moduleMetaDataExtenders = factory.getModuleMetaDataExtenders();
        this.appMBeanRuntime = factory.appMBeanRuntime;
        this.applicationDD = applicationDD;
        this.altDDSupportEnabled = factory.platformVersion.compareTo(JavaEEVersion.VERSION_7_0) >= 0;
        String string = appName = applicationDD == null ? null : applicationDD.getApplicationName();
        if (appName == null && (appName = ModuleInfoUtils.getModuleURIFromLocation((String)applicationInformation.getLocation())).endsWith(".ear")) {
            appName = appName.substring(0, appName.length() - ".ear".length());
        }
        this.preferredName = appName;
        this.earLibDeploymentInfo = this.createEARLibDeploymentInfo();
        this.appClassLoaderId = this.classLoadingService.createIdentity("EARApplication", this.getName());
        this.defaultClientModule = (String)applicationInformation.getConfigProperty(DEFAULT_CLIENT_MODULE);
        this.findModules();
        if (applicationInformation.getConfigProperty(CONTEXT_ROOT) != null) {
            Tr.warning((TraceComponent)_tc, (String)"warning.context.root.not.used", (Object[])new Object[]{applicationInformation.getConfigProperty(CONTEXT_ROOT), this.preferredName});
        }
    }

    private EARLibDeploymentInfo createEARLibDeploymentInfo() throws UnableToAdaptException {
        Entry libDirEntry;
        String libDir;
        if (this.applicationDD != null && this.applicationDD.getLibraryDirectory() != null) {
            libDir = this.applicationDD.getLibraryDirectory();
            if (libDir.length() == 0) {
                return null;
            }
        } else {
            libDir = "lib";
        }
        if ((libDirEntry = this.getContainer().getEntry(libDir)) == null) {
            return null;
        }
        Container libDirContainer = (Container)libDirEntry.adapt(Container.class);
        return new EARLibDeploymentInfo(libDirContainer);
    }

    public List<ContainerInfo> getLibraryClassesContainerInfo() {
        List<ContainerInfo> earLibContainerInfoList;
        List<Object> containerInfoList = super.getLibraryClassesContainerInfo();
        if (this.earLibDeploymentInfo != null && !(earLibContainerInfoList = this.earLibDeploymentInfo.getClassesContainerInfo()).isEmpty()) {
            if (containerInfoList.isEmpty()) {
                containerInfoList = Collections.unmodifiableList(earLibContainerInfoList);
            } else {
                ArrayList<ContainerInfo> mergedList = new ArrayList<ContainerInfo>();
                mergedList.addAll(earLibContainerInfoList);
                mergedList.addAll(containerInfoList);
                containerInfoList = Collections.unmodifiableList(mergedList);
            }
        }
        return containerInfoList;
    }

    public List<ModuleClassesContainerInfo> getModuleClassesContainerInfo() {
        ArrayList<DeployedAppInfoBase.ModuleContainerInfoBase> moduleClassesContainerInfos = new ArrayList<DeployedAppInfoBase.ModuleContainerInfoBase>();
        for (DeployedAppInfoBase.ModuleContainerInfoBase mci : this.moduleContainerInfos) {
            moduleClassesContainerInfos.add(mci);
        }
        return Collections.unmodifiableList(moduleClassesContainerInfos);
    }

    public ClassLoader createAppClassLoader() {
        return this.getApplicationClassLoader();
    }

    public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
        if (moduleInfo instanceof WebModuleInfo) {
            return this.createModuleChildClassLoader("WebModule", moduleInfo, moduleClassesContainers);
        }
        if (moduleInfo instanceof EJBModuleInfo) {
            return this.createEJBModuleClassLoader(moduleInfo);
        }
        if (moduleInfo instanceof ClientModuleInfo) {
            return this.createModuleChildClassLoader("ClientModule", moduleInfo, moduleClassesContainers);
        }
        if (moduleInfo instanceof ConnectorModuleInfo) {
            return this.createConnectorModuleClassLoader(moduleInfo);
        }
        return null;
    }

    private ClassLoader createEJBModuleClassLoader(ModuleInfo moduleInfo) {
        return this.getApplicationClassLoader();
    }

    private ClassLoader createConnectorModuleClassLoader(ModuleInfo moduleInfo) {
        return this.getApplicationClassLoader();
    }

    private ClassLoader getApplicationClassLoader() {
        if (this.appClassLoader == null) {
            this.createApplicationClassLoader();
        }
        return this.appClassLoader;
    }

    private ClassLoaderIdentity getApplicationClassLoaderId() {
        this.getApplicationClassLoader();
        return this.appClassLoaderId;
    }

    protected ExtendedApplicationInfo createApplicationInfo() {
        Container libDirContainer = this.earLibDeploymentInfo != null ? this.earLibDeploymentInfo.getContainer() : null;
        return this.appInfoFactory.createEARApplicationInfo(this.getName(), this.preferredName, this.getContainer(), (ApplicationClassesContainerInfo)this, this.getConfigHelper(), libDirContainer, (AppClassLoaderFactory)this);
    }

    private boolean findModules() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Application [ " + this.getName() + " ]"), (Object[])new Object[0]);
        }
        if (this.applicationDD != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Modules selected according to the application descriptor", (Object[])new Object[0]);
            }
            this.initializeInOrder = this.applicationDD.isSetInitializeInOrder() && this.applicationDD.isInitializeInOrder();
            HashSet<String> uniqueModuleURIs = new HashSet<String>();
            for (Module ddModule : this.applicationDD.getModules()) {
                this.processModuleContainerInfo(ddModule, uniqueModuleURIs);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Collect modules using deployment descriptors and/or annotations", (Object[])new Object[0]);
            }
            this.searchForModules();
        }
        this.ensureUniqueModuleNames();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Application [ " + this.getName() + " ] selects [ " + Integer.valueOf(this.moduleContainerInfos.size()) + " ] modules"), (Object[])new Object[0]);
        }
        return true;
    }

    private void ensureUniqueModuleNames() {
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<DeployedAppInfoBase.ModuleContainerInfoBase> unresolvedModuleInfos = new ArrayList<DeployedAppInfoBase.ModuleContainerInfoBase>();
        for (DeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            if (modInfo instanceof DeployedAppInfoBase.EJBModuleContainerInfo && usedNames.add(modInfo.moduleName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("keeping " + modInfo.getModuleURI() + " (" + modInfo.getType() + ") as " + modInfo.moduleName), (Object[])new Object[0]);
                continue;
            }
            unresolvedModuleInfos.add(modInfo);
        }
        for (DeployedAppInfoBase.ModuleContainerInfoBase modInfo : unresolvedModuleInfos) {
            String newModuleName;
            if (usedNames.add(modInfo.moduleName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("keeping " + modInfo.getModuleURI() + " (" + modInfo.getType() + ") as " + modInfo.moduleName), (Object[])new Object[0]);
                continue;
            }
            if (usedNames.add(modInfo.getModuleURI())) {
                newModuleName = modInfo.getModuleURI();
            } else {
                int number = 2;
                do {
                    newModuleName = modInfo.moduleName + '_' + number;
                    ++number;
                } while (!usedNames.add(newModuleName));
            }
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("updating " + modInfo.getModuleURI() + " (" + modInfo.getType() + ") from " + modInfo.moduleName + " to " + newModuleName), (Object[])new Object[0]);
            }
            modInfo.setModuleName(newModuleName);
        }
    }

    public void createModuleContainerInfo(ModuleHandler moduleHandler, Container moduleContainer, Entry altDDEntry, String moduleURI, DeployedAppInfoBase.ModuleClassesInfoProvider moduleClassesInfo, String contextRoot, String mainClass, boolean checkForDDOrAnnotations) throws UnableToAdaptException {
        DeployedAppInfoBase.ConnectorModuleContainerInfo mci;
        if (moduleHandler == this.connectorModuleHandler) {
            mci = new DeployedAppInfoBase.ConnectorModuleContainerInfo(moduleHandler, this.moduleMetaDataExtenders.get("connector"), moduleContainer, altDDEntry, moduleURI, moduleClassesInfo);
            if (this.initializeInOrder) {
                this.moduleContainerInfos.add(mci);
            } else {
                this.moduleContainerInfos.add(this.connectorModuleCount, mci);
                ++this.connectorModuleCount;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Added connector module [ " + mci.moduleName + " ]" + " with module uri [ " + mci.getModuleURI() + " ]" + " at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
            }
        }
        if (moduleHandler == this.ejbModuleHandler) {
            mci = new DeployedAppInfoBase.EJBModuleContainerInfo(moduleHandler, this.moduleMetaDataExtenders.get("ejb"), moduleContainer, altDDEntry, moduleURI, moduleClassesInfo);
            if (!checkForDDOrAnnotations || mci.moduleDD != null || this.hasSpecifiedAnnotations(mci.getContainer(), EJB_ANNOTATIONS)) {
                if (this.initializeInOrder) {
                    this.moduleContainerInfos.add(mci);
                } else {
                    this.moduleContainerInfos.add(this.connectorModuleCount + this.ejbModuleCount, mci);
                    ++this.ejbModuleCount;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Added ejb module [ " + mci.moduleName + " ]" + " with module uri [ " + mci.getModuleURI() + " ]" + " at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
                }
            }
        }
        if (moduleHandler == this.clientModuleHandler) {
            String mfMainClass = mainClass;
            if (mfMainClass == null) {
                if (checkForDDOrAnnotations) {
                    throw new IllegalArgumentException();
                }
                mfMainClass = this.getMFMainClass(moduleContainer, "/META-INF/MANIFEST.MF", true);
            }
            if (mfMainClass != null) {
                DeployedAppInfoBase.ClientModuleContainerInfo mci2 = new DeployedAppInfoBase.ClientModuleContainerInfo(moduleHandler, this.moduleMetaDataExtenders.get("client"), moduleContainer, altDDEntry, moduleURI, moduleClassesInfo, mfMainClass);
                this.moduleContainerInfos.add(mci2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Added client module [ " + mci2.moduleName + " ]" + " with module uri [ " + mci2.getModuleURI() + " ]" + " at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
                }
            }
        }
        if (moduleHandler == this.webModuleHandler) {
            if (contextRoot == null) {
                contextRoot = ContextRootUtil.getContextRoot((Container)moduleContainer);
            }
            mci = new DeployedAppInfoBase.WebModuleContainerInfo(moduleHandler, this.moduleMetaDataExtenders.get("web"), moduleContainer, altDDEntry, moduleURI, moduleClassesInfo, contextRoot);
            this.moduleContainerInfos.add(mci);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Added web module [ " + mci.moduleName + " ]" + " with web-uri [ " + mci.getModuleURI() + " ] and context-root [ " + mci.contextRoot + " ]" + " at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processModuleContainerInfo(Module ddModule, Set<String> uniqueModuleURIs) {
        Container moduleContainer;
        Entry entry;
        String moduleTypeTag;
        ModuleHandler moduleHandler;
        String contextRoot;
        String modulePath = ddModule.getModulePath();
        if (ddModule.getModuleType() == 3) {
            contextRoot = ContextRootUtil.getContextRoot((String)ddModule.getContextRoot());
            moduleHandler = this.webModuleHandler;
            moduleTypeTag = "web";
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides web module with web-uri [ " + modulePath + " ] and context-root [ " + contextRoot + " ]"), (Object[])new Object[0]);
            }
        } else if (ddModule.getModuleType() == 1) {
            moduleHandler = this.ejbModuleHandler;
            moduleTypeTag = "ejb";
            contextRoot = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides ejb module with module uri [ " + modulePath + " ]"), (Object[])new Object[0]);
            }
        } else if (ddModule.getModuleType() == 2 && this.clientModuleHandler != null) {
            moduleHandler = this.clientModuleHandler;
            moduleTypeTag = "client";
            contextRoot = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides client module with module uri [ " + modulePath + " ]"), (Object[])new Object[0]);
            }
            if (this.defaultClientModule != null && !this.defaultClientModule.equals(modulePath)) {
                return;
            }
        } else if (ddModule.getModuleType() == 0) {
            moduleHandler = this.connectorModuleHandler;
            moduleTypeTag = "connector";
            contextRoot = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides connector module with module uri [ " + modulePath + " ]"), (Object[])new Object[0]);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application " + this.getName() + ": unsupported module " + modulePath + " of type " + ddModule.getModuleType()), (Object[])new Object[0]);
            }
            return;
        }
        if ((entry = this.getContainer().getEntry(modulePath)) == null) {
            Tr.error((TraceComponent)_tc, (String)"error.module.locate.failed", (Object[])new Object[]{this.getName(), modulePath, moduleTypeTag});
            return;
        }
        String entryPath = entry.getPath();
        if (!uniqueModuleURIs.add(entryPath)) {
            Tr.warning((TraceComponent)_tc, (String)"error.module.uri.duplicate", (Object[])new Object[]{this.getName(), modulePath});
            return;
        }
        try {
            moduleContainer = (Container)entry.adapt(Container.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"516", (Object)((Object)this), (Object[])new Object[]{ddModule, uniqueModuleURIs});
            Tr.error((TraceComponent)_tc, (String)"error.module.container", (Object[])new Object[]{this.getName(), modulePath, moduleTypeTag, e});
            return;
        }
        if (moduleContainer == null) {
            Tr.error((TraceComponent)_tc, (String)"error.module.container.null", (Object[])new Object[]{this.getName(), modulePath, moduleTypeTag});
            return;
        }
        if (!moduleContainer.isRoot()) {
            throw new IllegalStateException("module container should be a root");
        }
        if (moduleHandler == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("A module handler for " + moduleTypeTag + " modules was not configured."), (Object[])new Object[0]);
            }
            return;
        }
        String moduleURI = entryPath.substring(1);
        Entry altDDEntry = null;
        if (ddModule.getAltDD() != null && this.altDDSupportEnabled && (altDDEntry = this.getContainer().getEntry(ddModule.getAltDD())) == null) {
            Tr.error((TraceComponent)_tc, (String)"error.module.locate.failed", (Object[])new Object[]{this.getName(), ddModule.getAltDD(), moduleTypeTag});
            return;
        }
        try {
            this.createModuleContainerInfo(moduleHandler, moduleContainer, altDDEntry, moduleURI, this.moduleClassesInfo, contextRoot, null, false);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"556", (Object)((Object)this), (Object[])new Object[]{ddModule, uniqueModuleURIs});
            this.handleUnableToAdaptException((UnableToAdaptException)e, modulePath, moduleTypeTag);
        }
    }

    private void searchForModules() {
        String path;
        String libDir = null;
        String libDirSlash = null;
        if (this.earLibDeploymentInfo != null && (path = this.earLibDeploymentInfo.getContainer().getPath()).length() > 0) {
            libDir = path;
            if (libDir.endsWith("/")) {
                libDir = libDir.substring(0, libDir.length() - 1);
            }
            if (!libDir.startsWith("/")) {
                libDir = "/" + libDir;
            }
            libDirSlash = libDir + "/";
        }
        this.searchForModules(libDir, libDirSlash, this.getContainer());
    }

    /*
     * WARNING - void declaration
     */
    private void searchForModules(String libDir, String libDirSlash, Container container) {
        for (Entry entry : container) {
            Container entryContainer;
            String entryPath = entry.getPath();
            if (libDir != null && (entryPath.equals(libDir) || entryPath.startsWith(libDirSlash))) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("Skipping library container [ " + entryPath + " ]"), (Object[])new Object[0]);
                continue;
            }
            try {
                entryContainer = (Container)entry.adapt(Container.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"608", (Object)((Object)this), (Object[])new Object[]{libDir, libDirSlash, container});
                Tr.error((TraceComponent)_tc, (String)"error.application.library.container", (Object[])new Object[]{this.getName(), entryPath, e});
                continue;
            }
            if (entryContainer == null) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("Skipping non-container [ " + entryPath + " ]"), (Object[])new Object[0]);
                continue;
            }
            if (entryContainer.isRoot()) {
                this.createModuleContainerInfo(entry, entryPath, entryContainer);
                continue;
            }
            this.searchForModules(libDir, libDirSlash, entryContainer);
        }
    }

    private void handleUnableToAdaptException(UnableToAdaptException e, String entryPath, String moduleTypeTag) {
        Throwable cause = e.getCause();
        Object causeMessage = cause instanceof DDParser.ParseException ? cause.getMessage() : e;
        Tr.error((TraceComponent)_tc, (String)"error.module.container", (Object[])new Object[]{this.getName(), entryPath, moduleTypeTag, causeMessage});
    }

    /*
     * WARNING - void declaration
     */
    private void createModuleContainerInfo(Entry entry, String entryPath, Container moduleContainer) {
        String moduleTypeTag;
        ModuleHandler moduleHandler;
        String lowerEntryPath = entryPath.toLowerCase();
        String mainClass = null;
        if (lowerEntryPath.endsWith(".war")) {
            moduleHandler = this.webModuleHandler;
            moduleTypeTag = "web";
        } else if (lowerEntryPath.endsWith(".jar")) {
            boolean hasAppClientXML = moduleContainer.getEntry("/META-INF/application-client.xml") != null;
            mainClass = this.getMFMainClass(moduleContainer, entryPath, hasAppClientXML);
            if (mainClass != null) {
                if (this.defaultClientModule == null || this.defaultClientModule.equals(entryPath.substring(1))) {
                    moduleHandler = this.clientModuleHandler;
                    moduleTypeTag = "client";
                } else {
                    moduleHandler = null;
                    moduleTypeTag = "unknown";
                }
            } else if (hasAppClientXML) {
                moduleHandler = null;
                moduleTypeTag = "unknown";
            } else {
                moduleHandler = this.ejbModuleHandler;
                moduleTypeTag = "ejb";
            }
        } else if (lowerEntryPath.endsWith(".rar")) {
            moduleHandler = this.connectorModuleHandler;
            moduleTypeTag = "connector";
        } else {
            moduleHandler = null;
            moduleTypeTag = "unknown";
        }
        if (moduleHandler == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Skipping non-module container [ " + entryPath + " ]"), (Object[])new Object[0]);
            }
            return;
        }
        String moduleURI = entryPath.substring(1);
        try {
            this.createModuleContainerInfo(moduleHandler, moduleContainer, null, moduleURI, this.moduleClassesInfo, null, mainClass, true);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"686", (Object)((Object)this), (Object[])new Object[]{entry, entryPath, moduleContainer});
            this.handleUnableToAdaptException((UnableToAdaptException)e, entryPath, moduleTypeTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMFMainClass(Container appEntryContainer, String entryPath, boolean required) {
        String mfMainClass = null;
        try {
            block12: {
                String entry = "/META-INF/MANIFEST.MF";
                Entry manifestEntry = appEntryContainer.getEntry(entry);
                if (manifestEntry != null) {
                    InputStream is = null;
                    try {
                        is = (InputStream)manifestEntry.adapt(InputStream.class);
                        if (is == null) {
                            throw new FileNotFoundException(entry);
                        }
                        Manifest manifest = new Manifest(is);
                        mfMainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        if ("".equals(mfMainClass)) {
                            mfMainClass = null;
                        }
                        if (is == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"722", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
                        }
                        throw throwable;
                    }
                    try {
                        is.close();
                    }
                    catch (IOException manifest) {
                        FFDCFilter.processException((Throwable)manifest, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"722", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
                    }
                }
            }
            if (mfMainClass != null) return mfMainClass;
            if (!required) return mfMainClass;
            Tr.error((TraceComponent)_tc, (String)"error.module.manifest.read.no.mainclass", (Object[])new Object[]{this.getName(), entryPath});
            return mfMainClass;
        }
        catch (IOException entry) {
            void ioe;
            FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"731", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
            Tr.error((TraceComponent)_tc, (String)"error.module.manifest.read.failed", (Object[])new Object[]{this.getName(), entryPath, ioe});
            return mfMainClass;
        }
        catch (UnableToAdaptException ioe) {
            void uae;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"733", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
            Tr.error((TraceComponent)_tc, (String)"error.module.manifest.read.failed", (Object[])new Object[]{this.getName(), entryPath, uae});
        }
        return mfMainClass;
    }

    public boolean hasModules() {
        return !this.moduleContainerInfos.isEmpty();
    }

    protected void registerApplicationMBean() {
        if (this.appMBeanRuntime != null) {
            ArrayList<ModuleInfo> deployedModuleInfos = new ArrayList<ModuleInfo>();
            for (DeployedModuleInfoImpl moduleInfoImpl : this.modulesDeployed) {
                deployedModuleInfos.add(moduleInfoImpl.info);
            }
            this.mbeanServiceReg = this.appMBeanRuntime.registerApplicationMBean(this.getName(), this.getContainer(), this.applicationDD != null ? "/META-INF/application.xml" : null, deployedModuleInfos);
        }
    }

    protected void deregisterApplicationMBean() {
        if (this.mbeanServiceReg != null) {
            ServiceRegistration<?> mbeanReg = this.mbeanServiceReg;
            this.mbeanServiceReg = null;
            mbeanReg.unregister();
        }
    }

    public ApplicationMonitoringInformation createApplicationMonitoringInformation() {
        HashSet<DefaultNotification> notificationsToMonitor = new HashSet<DefaultNotification>();
        if (this.applicationDD != null) {
            notificationsToMonitor.add(new DefaultNotification(this.getContainer(), "/META-INF/application.xml"));
        }
        if (this.earLibDeploymentInfo != null) {
            String libDirectory = this.earLibDeploymentInfo.getContainer().getPath();
            if (!libDirectory.startsWith("/")) {
                libDirectory = "/" + libDirectory;
            }
            notificationsToMonitor.add(new DefaultNotification(this.getContainer(), libDirectory));
        }
        for (DeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            if (modInfo instanceof DeployedAppInfoBase.WebModuleContainerInfo) {
                notificationsToMonitor.add(new DefaultNotification(modInfo.getContainer(), "/WEB-INF"));
                continue;
            }
            if (!(modInfo instanceof DeployedAppInfoBase.ConnectorModuleContainerInfo)) continue;
            notificationsToMonitor.add(new DefaultNotification(modInfo.getContainer(), "/META-INF"));
        }
        for (ContainerInfo classpathContainerInfo : this.getClasspathContainerInfos()) {
            notificationsToMonitor.add(new DefaultNotification(classpathContainerInfo.getContainer(), "/"));
        }
        return new DefaultApplicationMonitoringInformation(notificationsToMonitor, true);
    }

    private List<ContainerInfo> getClasspathContainerInfos() {
        if (this.classpathContainerInfos == null) {
            ArrayList<ContainerInfo> classpathContainerInfos = new ArrayList<ContainerInfo>();
            this.addEJBJarContainers(classpathContainerInfos);
            this.addEARLibContainers(classpathContainerInfos);
            this.addConnectorContainers(classpathContainerInfos);
            this.checkClientJarContainers(classpathContainerInfos);
            this.classpathContainerInfos = classpathContainerInfos;
        }
        return this.classpathContainerInfos;
    }

    /*
     * WARNING - void declaration
     */
    private void addEJBJarContainers(List<ContainerInfo> classpathContainerInfos) {
        try {
            for (DeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
                if (!(modInfo instanceof DeployedAppInfoBase.EJBModuleContainerInfo)) continue;
                classpathContainerInfos.addAll(modInfo.getClassesContainerInfo());
            }
        }
        catch (Throwable i$) {
            void th;
            FFDCFilter.processException((Throwable)i$, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"831", (Object)((Object)this), (Object[])new Object[]{classpathContainerInfos});
            Tr.error((TraceComponent)_tc, (String)"error.application.libraries", (Object[])new Object[]{this.getName(), th});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkClientJarContainers(List<ContainerInfo> classpathContainerInfos) {
        boolean found = false;
        try {
            for (DeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
                if (!(modInfo instanceof DeployedAppInfoBase.ClientModuleContainerInfo)) continue;
                if (this.defaultClientModule == null) {
                    if (found) {
                        Tr.error((TraceComponent)_tc, (String)"error.module.no.defaultclient", (Object[])new Object[0]);
                    }
                    found = true;
                    continue;
                }
                if (!this.defaultClientModule.equals(modInfo.getModuleURI())) continue;
                if (found) {
                    Tr.error((TraceComponent)_tc, (String)"error.module.dup.client", (Object[])new Object[]{this.defaultClientModule});
                }
                found = true;
            }
            if (!found && this.defaultClientModule != null) {
                Tr.error((TraceComponent)_tc, (String)"error.module.client.notfound", (Object[])new Object[]{this.defaultClientModule});
            }
        }
        catch (Throwable i$) {
            void th;
            FFDCFilter.processException((Throwable)i$, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"857", (Object)((Object)this), (Object[])new Object[]{classpathContainerInfos});
            Tr.error((TraceComponent)_tc, (String)"error.application.libraries", (Object[])new Object[]{this.getName(), th});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addConnectorContainers(List<ContainerInfo> classpathContainerInfos) {
        try {
            for (DeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
                if (!(modInfo instanceof DeployedAppInfoBase.ConnectorModuleContainerInfo)) continue;
                classpathContainerInfos.addAll(modInfo.getClassesContainerInfo());
            }
        }
        catch (Throwable i$) {
            void th;
            FFDCFilter.processException((Throwable)i$, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"869", (Object)((Object)this), (Object[])new Object[]{classpathContainerInfos});
            Tr.error((TraceComponent)_tc, (String)"error.application.libraries", (Object[])new Object[]{this.getName(), th});
        }
    }

    private void addEARLibContainers(List<ContainerInfo> classpathContainerInfos) {
        if (this.earLibDeploymentInfo != null) {
            classpathContainerInfos.addAll(this.earLibDeploymentInfo.getClassesContainerInfo());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasSpecifiedAnnotations(Container moduleContainer, List<String> useAnnotationTypeNames) {
        ContainerAnnotations ca;
        block5: {
            ca = null;
            try {
                ca = (ContainerAnnotations)moduleContainer.adapt(ContainerAnnotations.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"896", (Object)((Object)this), (Object[])new Object[]{moduleContainer, useAnnotationTypeNames});
                Tr.error((TraceComponent)_tc, (String)"error.module.class.source", (Object[])new Object[]{this.getName(), moduleContainer.getPath(), "EJB", e});
                if (!_tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)_tc, (String)"Selected [ 0 ] EJB annotation cases: Error obtaining annotation targets", (Object[])new Object[0]);
            }
        }
        if (ca != null && ca.hasSpecifiedAnnotations(useAnnotationTypeNames)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Select EJB module [ " + moduleContainer.getPath() + " ]: EJB annotations were detected:"), (Object[])new Object[0]);
            }
            return true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Reject EJB module [ " + moduleContainer.getPath() + " ]: No descriptor and no EJB annotations"), (Object[])new Object[0]);
        }
        return false;
    }

    private void createApplicationClassLoader() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Application [ " + this.getName() + " ]: Class loader ID [ " + this.appClassLoaderId + " ]"), (Object[])new Object[0]);
        }
        ArrayList<Container> classLoaderContainers = new ArrayList<Container>();
        ArrayList<Container> nativeLibraryContainers = new ArrayList<Container>();
        for (ContainerInfo containerInfo : this.getClasspathContainerInfos()) {
            Container container = containerInfo.getContainer();
            classLoaderContainers.add(container);
            if (containerInfo.getType() != ContainerInfo.Type.RAR_MODULE) continue;
            nativeLibraryContainers.add(container);
        }
        GatewayConfiguration gwCfg = this.classLoadingService.createGatewayConfiguration().setApplicationName(this.getName()).setDynamicImportPackage(DYNAMIC_IMPORT_PACKAGE_LIST);
        this.protectionDomain = this.getProtectionDomain();
        ClassLoaderConfiguration clCfg = this.classLoadingService.createClassLoaderConfiguration().setId(this.appClassLoaderId).setProtectionDomain(this.protectionDomain).setNativeLibraryContainers(nativeLibraryContainers);
        ClassLoader appClassLoader = this.createTopLevelClassLoader(classLoaderContainers, gwCfg, clCfg);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Application [ " + this.getName() + " ]: Class loader [ " + appClassLoader + " ]"), (Object[])new Object[0]);
        }
        this.appClassLoader = appClassLoader;
    }

    private ClassLoader createModuleChildClassLoader(String moduleDomain, ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
        String moduleName = moduleInfo.getName();
        String j2eeModuleName = moduleInfo.getURI();
        ArrayList<Container> containers = new ArrayList<Container>();
        for (ContainerInfo containerInfo : moduleClassesContainers) {
            containers.add(containerInfo.getContainer());
        }
        ClassLoaderIdentity parentId = this.getApplicationClassLoaderId();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(moduleDomain + " [ " + moduleName + " ] uses application class loader ID [ " + parentId + " ]"), (Object[])new Object[0]);
        }
        ClassLoaderIdentity moduleClassLoaderId = this.classLoadingService.createIdentity(moduleDomain, this.getName() + "#" + j2eeModuleName);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(moduleDomain + " [ " + moduleName + " ] sets module class loader ID [ " + moduleClassLoaderId + " ]"), (Object[])new Object[0]);
        }
        ClassLoaderConfiguration clCfg = this.classLoadingService.createClassLoaderConfiguration().setId(moduleClassLoaderId).setParentId(parentId).setDelegateToParentAfterCheckingLocalClasspath(this.isDelegateLast);
        clCfg.setProtectionDomain(this.protectionDomain);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(moduleDomain + " [ " + moduleName + " ] sets isDelegateLast [ " + Boolean.valueOf(this.isDelegateLast) + " ]"), (Object[])new Object[0]);
        }
        ClassLoader moduleClassLoader = this.classLoadingService.createChildClassLoader(containers, clCfg);
        this.associateClassLoaderWithApp(moduleClassLoader);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(moduleDomain + " [ " + moduleName + " ] sets class loader [ " + moduleClassLoader + " ]"), (Object[])new Object[0]);
        }
        return moduleClassLoader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        EJB_ANNOTATIONS.add("javax.ejb.MessageDriven");
        EJB_ANNOTATIONS.add("javax.ejb.Stateless");
        EJB_ANNOTATIONS.add("javax.ejb.Stateful");
        EJB_ANNOTATIONS.add("javax.ejb.Singleton");
        DYNAMIC_IMPORT_PACKAGE_LIST = Collections.unmodifiableList(Arrays.asList("*"));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class EARLibDeploymentInfo {
        protected final Container container;
        protected final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = -8270873592681219113L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EARLibDeploymentInfo(Container libDirContainer) throws UnableToAdaptException {
            this.container = libDirContainer;
            final String libDirName = libDirContainer.getPath();
            ArrayList resolved = new ArrayList();
            for (Entry entry : libDirContainer) {
                Container jarContainer;
                final String jarEntryName = entry.getName();
                if (!jarEntryName.toLowerCase().endsWith(".jar") || (jarContainer = (Container)entry.adapt(Container.class)) == null) continue;
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = -4653914893292299044L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.EAR_LIB;
                    }

                    public String getName() {
                        return "EAR" + libDirName + jarEntryName;
                    }

                    public Container getContainer() {
                        return jarContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                };
                this.classesContainerInfo.add(containerInfo);
                ManifestClassPathUtils.addCompleteJarEntryUrls(this.classesContainerInfo, (Entry)entry, resolved);
            }
        }

        public Container getContainer() {
            return this.container;
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EARLibDeploymentInfo.class);
        }
    }
}

